# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AutoscaleNotification(msrest.serialization.Model):
    """Autoscale notification.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar operation: Required. the operation associated with the notification and its value must be
     "scale". Default value: "Scale".
    :vartype operation: str
    :param email: the email notification.
    :type email: ~$(python-base-namespace).v2015_04_01.models.EmailNotification
    :param webhooks: the collection of webhook notifications.
    :type webhooks: list[~$(python-base-namespace).v2015_04_01.models.WebhookNotification]
    """

    _validation = {
        'operation': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'operation': {'key': 'operation', 'type': 'str'},
        'email': {'key': 'email', 'type': 'EmailNotification'},
        'webhooks': {'key': 'webhooks', 'type': '[WebhookNotification]'},
    }

    operation = "Scale"

    def __init__(
        self,
        **kwargs
    ):
        super(AutoscaleNotification, self).__init__(**kwargs)
        self.email = kwargs.get('email', None)
        self.webhooks = kwargs.get('webhooks', None)


class AutoscaleProfile(msrest.serialization.Model):
    """Autoscale profile.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. the name of the profile.
    :type name: str
    :param capacity: Required. the number of instances that can be used during this profile.
    :type capacity: ~$(python-base-namespace).v2015_04_01.models.ScaleCapacity
    :param rules: Required. the collection of rules that provide the triggers and parameters for
     the scaling action. A maximum of 10 rules can be specified.
    :type rules: list[~$(python-base-namespace).v2015_04_01.models.ScaleRule]
    :param fixed_date: the specific date-time for the profile. This element is not used if the
     Recurrence element is used.
    :type fixed_date: ~$(python-base-namespace).v2015_04_01.models.TimeWindow
    :param recurrence: the repeating times at which this profile begins. This element is not used
     if the FixedDate element is used.
    :type recurrence: ~$(python-base-namespace).v2015_04_01.models.Recurrence
    """

    _validation = {
        'name': {'required': True},
        'capacity': {'required': True},
        'rules': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'ScaleCapacity'},
        'rules': {'key': 'rules', 'type': '[ScaleRule]'},
        'fixed_date': {'key': 'fixedDate', 'type': 'TimeWindow'},
        'recurrence': {'key': 'recurrence', 'type': 'Recurrence'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoscaleProfile, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.capacity = kwargs['capacity']
        self.rules = kwargs['rules']
        self.fixed_date = kwargs.get('fixed_date', None)
        self.recurrence = kwargs.get('recurrence', None)


class Resource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class AutoscaleSettingResource(Resource):
    """The autoscale setting resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param profiles: Required. the collection of automatic scaling profiles that specify different
     scaling parameters for different time periods. A maximum of 20 profiles can be specified.
    :type profiles: list[~$(python-base-namespace).v2015_04_01.models.AutoscaleProfile]
    :param notifications: the collection of notifications.
    :type notifications: list[~$(python-base-namespace).v2015_04_01.models.AutoscaleNotification]
    :param enabled: the enabled flag. Specifies whether automatic scaling is enabled for the
     resource. The default value is 'true'.
    :type enabled: bool
    :param name_properties_name: the name of the autoscale setting.
    :type name_properties_name: str
    :param target_resource_uri: the resource identifier of the resource that the autoscale setting
     should be added to.
    :type target_resource_uri: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'profiles': {'required': True, 'max_items': 20, 'min_items': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'profiles': {'key': 'properties.profiles', 'type': '[AutoscaleProfile]'},
        'notifications': {'key': 'properties.notifications', 'type': '[AutoscaleNotification]'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'target_resource_uri': {'key': 'properties.targetResourceUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoscaleSettingResource, self).__init__(**kwargs)
        self.profiles = kwargs['profiles']
        self.notifications = kwargs.get('notifications', None)
        self.enabled = kwargs.get('enabled', True)
        self.name_properties_name = kwargs.get('name_properties_name', None)
        self.target_resource_uri = kwargs.get('target_resource_uri', None)


class AutoscaleSettingResourceCollection(msrest.serialization.Model):
    """Represents a collection of autoscale setting resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. the values for the autoscale setting resources.
    :type value: list[~$(python-base-namespace).v2015_04_01.models.AutoscaleSettingResource]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AutoscaleSettingResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoscaleSettingResourceCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class AutoscaleSettingResourcePatch(msrest.serialization.Model):
    """The autoscale setting object for patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param profiles: the collection of automatic scaling profiles that specify different scaling
     parameters for different time periods. A maximum of 20 profiles can be specified.
    :type profiles: list[~$(python-base-namespace).v2015_04_01.models.AutoscaleProfile]
    :param notifications: the collection of notifications.
    :type notifications: list[~$(python-base-namespace).v2015_04_01.models.AutoscaleNotification]
    :param enabled: the enabled flag. Specifies whether automatic scaling is enabled for the
     resource. The default value is 'true'.
    :type enabled: bool
    :param name: the name of the autoscale setting.
    :type name: str
    :param target_resource_uri: the resource identifier of the resource that the autoscale setting
     should be added to.
    :type target_resource_uri: str
    """

    _validation = {
        'profiles': {'max_items': 20, 'min_items': 0},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'profiles': {'key': 'properties.profiles', 'type': '[AutoscaleProfile]'},
        'notifications': {'key': 'properties.notifications', 'type': '[AutoscaleNotification]'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'name': {'key': 'properties.name', 'type': 'str'},
        'target_resource_uri': {'key': 'properties.targetResourceUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoscaleSettingResourcePatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.profiles = kwargs.get('profiles', None)
        self.notifications = kwargs.get('notifications', None)
        self.enabled = kwargs.get('enabled', True)
        self.name = kwargs.get('name', None)
        self.target_resource_uri = kwargs.get('target_resource_uri', None)


class EmailNotification(msrest.serialization.Model):
    """Email notification of an autoscale event.

    :param send_to_subscription_administrator: a value indicating whether to send email to
     subscription administrator.
    :type send_to_subscription_administrator: bool
    :param send_to_subscription_co_administrators: a value indicating whether to send email to
     subscription co-administrators.
    :type send_to_subscription_co_administrators: bool
    :param custom_emails: the custom e-mails list. This value can be null or empty, in which case
     this attribute will be ignored.
    :type custom_emails: list[str]
    """

    _attribute_map = {
        'send_to_subscription_administrator': {'key': 'sendToSubscriptionAdministrator', 'type': 'bool'},
        'send_to_subscription_co_administrators': {'key': 'sendToSubscriptionCoAdministrators', 'type': 'bool'},
        'custom_emails': {'key': 'customEmails', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EmailNotification, self).__init__(**kwargs)
        self.send_to_subscription_administrator = kwargs.get('send_to_subscription_administrator', None)
        self.send_to_subscription_co_administrators = kwargs.get('send_to_subscription_co_administrators', None)
        self.custom_emails = kwargs.get('custom_emails', None)


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class EventCategoryCollection(msrest.serialization.Model):
    """A collection of event categories. Currently possible values are: Administrative, Security, ServiceHealth, Alert, Recommendation, Policy.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. the list that includes the Azure event categories.
    :type value: list[~$(python-base-namespace).v2015_04_01.models.LocalizableString]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[LocalizableString]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventCategoryCollection, self).__init__(**kwargs)
        self.value = kwargs['value']


class EventData(msrest.serialization.Model):
    """The Azure event log entries are of type EventData.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar authorization: The sender authorization information.
    :vartype authorization: ~$(python-base-namespace).v2015_04_01.models.SenderAuthorization
    :ivar claims: key value pairs to identify ARM permissions.
    :vartype claims: dict[str, str]
    :ivar caller: the email address of the user who has performed the operation, the UPN claim or
     SPN claim based on availability.
    :vartype caller: str
    :ivar description: the description of the event.
    :vartype description: str
    :ivar id: the Id of this event as required by ARM for RBAC. It contains the EventDataID and a
     timestamp information.
    :vartype id: str
    :ivar event_data_id: the event data Id. This is a unique identifier for an event.
    :vartype event_data_id: str
    :ivar correlation_id: the correlation Id, usually a GUID in the string format. The correlation
     Id is shared among the events that belong to the same uber operation.
    :vartype correlation_id: str
    :ivar event_name: the event name. This value should not be confused with OperationName. For
     practical purposes, OperationName might be more appealing to end users.
    :vartype event_name: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar category: the event category.
    :vartype category: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar http_request: the HTTP request info. Usually includes the 'clientRequestId',
     'clientIpAddress' (IP address of the user who initiated the event) and 'method' (HTTP method
     e.g. PUT).
    :vartype http_request: ~$(python-base-namespace).v2015_04_01.models.HttpRequestInfo
    :ivar level: the event level. Possible values include: "Critical", "Error", "Warning",
     "Informational", "Verbose".
    :vartype level: str or ~$(python-base-namespace).v2015_04_01.models.EventLevel
    :ivar resource_group_name: the resource group name of the impacted resource.
    :vartype resource_group_name: str
    :ivar resource_provider_name: the resource provider name of the impacted resource.
    :vartype resource_provider_name: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar resource_id: the resource uri that uniquely identifies the resource that caused this
     event.
    :vartype resource_id: str
    :ivar resource_type: the resource type.
    :vartype resource_type: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar operation_id: It is usually a GUID shared among the events corresponding to single
     operation. This value should not be confused with EventName.
    :vartype operation_id: str
    :ivar operation_name: the operation name.
    :vartype operation_name: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar properties: the set of <Key, Value> pairs (usually a Dictionary<String, String>) that
     includes details about the event.
    :vartype properties: dict[str, str]
    :ivar status: a string describing the status of the operation. Some typical values are:
     Started, In progress, Succeeded, Failed, Resolved.
    :vartype status: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar sub_status: the event sub status. Most of the time, when included, this captures the HTTP
     status code of the REST call. Common values are: OK (HTTP Status Code: 200), Created (HTTP
     Status Code: 201), Accepted (HTTP Status Code: 202), No Content (HTTP Status Code: 204), Bad
     Request(HTTP Status Code: 400), Not Found (HTTP Status Code: 404), Conflict (HTTP Status Code:
     409), Internal Server Error (HTTP Status Code: 500), Service Unavailable (HTTP Status
     Code:503), Gateway Timeout (HTTP Status Code: 504).
    :vartype sub_status: ~$(python-base-namespace).v2015_04_01.models.LocalizableString
    :ivar event_timestamp: the timestamp of when the event was generated by the Azure service
     processing the request corresponding the event. It in ISO 8601 format.
    :vartype event_timestamp: ~datetime.datetime
    :ivar submission_timestamp: the timestamp of when the event became available for querying via
     this API. It is in ISO 8601 format. This value should not be confused eventTimestamp. As there
     might be a delay between the occurrence time of the event, and the time that the event is
     submitted to the Azure logging infrastructure.
    :vartype submission_timestamp: ~datetime.datetime
    :ivar subscription_id: the Azure subscription Id usually a GUID.
    :vartype subscription_id: str
    :ivar tenant_id: the Azure tenant Id.
    :vartype tenant_id: str
    """

    _validation = {
        'authorization': {'readonly': True},
        'claims': {'readonly': True},
        'caller': {'readonly': True},
        'description': {'readonly': True},
        'id': {'readonly': True},
        'event_data_id': {'readonly': True},
        'correlation_id': {'readonly': True},
        'event_name': {'readonly': True},
        'category': {'readonly': True},
        'http_request': {'readonly': True},
        'level': {'readonly': True},
        'resource_group_name': {'readonly': True},
        'resource_provider_name': {'readonly': True},
        'resource_id': {'readonly': True},
        'resource_type': {'readonly': True},
        'operation_id': {'readonly': True},
        'operation_name': {'readonly': True},
        'properties': {'readonly': True},
        'status': {'readonly': True},
        'sub_status': {'readonly': True},
        'event_timestamp': {'readonly': True},
        'submission_timestamp': {'readonly': True},
        'subscription_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'authorization': {'key': 'authorization', 'type': 'SenderAuthorization'},
        'claims': {'key': 'claims', 'type': '{str}'},
        'caller': {'key': 'caller', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'event_data_id': {'key': 'eventDataId', 'type': 'str'},
        'correlation_id': {'key': 'correlationId', 'type': 'str'},
        'event_name': {'key': 'eventName', 'type': 'LocalizableString'},
        'category': {'key': 'category', 'type': 'LocalizableString'},
        'http_request': {'key': 'httpRequest', 'type': 'HttpRequestInfo'},
        'level': {'key': 'level', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'resource_provider_name': {'key': 'resourceProviderName', 'type': 'LocalizableString'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'LocalizableString'},
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'operation_name': {'key': 'operationName', 'type': 'LocalizableString'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'status': {'key': 'status', 'type': 'LocalizableString'},
        'sub_status': {'key': 'subStatus', 'type': 'LocalizableString'},
        'event_timestamp': {'key': 'eventTimestamp', 'type': 'iso-8601'},
        'submission_timestamp': {'key': 'submissionTimestamp', 'type': 'iso-8601'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventData, self).__init__(**kwargs)
        self.authorization = None
        self.claims = None
        self.caller = None
        self.description = None
        self.id = None
        self.event_data_id = None
        self.correlation_id = None
        self.event_name = None
        self.category = None
        self.http_request = None
        self.level = None
        self.resource_group_name = None
        self.resource_provider_name = None
        self.resource_id = None
        self.resource_type = None
        self.operation_id = None
        self.operation_name = None
        self.properties = None
        self.status = None
        self.sub_status = None
        self.event_timestamp = None
        self.submission_timestamp = None
        self.subscription_id = None
        self.tenant_id = None


class EventDataCollection(msrest.serialization.Model):
    """Represents collection of events.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. this list that includes the Azure audit logs.
    :type value: list[~$(python-base-namespace).v2015_04_01.models.EventData]
    :param next_link: Provides the link to retrieve the next set of events.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EventData]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventDataCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class HttpRequestInfo(msrest.serialization.Model):
    """The Http request info.

    :param client_request_id: the client request id.
    :type client_request_id: str
    :param client_ip_address: the client Ip Address.
    :type client_ip_address: str
    :param method: the Http request method.
    :type method: str
    :param uri: the Uri.
    :type uri: str
    """

    _attribute_map = {
        'client_request_id': {'key': 'clientRequestId', 'type': 'str'},
        'client_ip_address': {'key': 'clientIpAddress', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HttpRequestInfo, self).__init__(**kwargs)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.client_ip_address = kwargs.get('client_ip_address', None)
        self.method = kwargs.get('method', None)
        self.uri = kwargs.get('uri', None)


class LocalizableString(msrest.serialization.Model):
    """The localizable string class.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. the invariant value.
    :type value: str
    :param localized_value: the locale specific value.
    :type localized_value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LocalizableString, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.localized_value = kwargs.get('localized_value', None)


class MetricTrigger(msrest.serialization.Model):
    """The trigger that results in a scaling action.

    All required parameters must be populated in order to send to Azure.

    :param metric_name: Required. the name of the metric that defines what the rule monitors.
    :type metric_name: str
    :param metric_resource_uri: Required. the resource identifier of the resource the rule
     monitors.
    :type metric_resource_uri: str
    :param time_grain: Required. the granularity of metrics the rule monitors. Must be one of the
     predefined values returned from metric definitions for the metric. Must be between 12 hours and
     1 minute.
    :type time_grain: ~datetime.timedelta
    :param statistic: Required. the metric statistic type. How the metrics from multiple instances
     are combined. Possible values include: "Average", "Min", "Max", "Sum".
    :type statistic: str or ~$(python-base-namespace).v2015_04_01.models.MetricStatisticType
    :param time_window: Required. the range of time in which instance data is collected. This value
     must be greater than the delay in metric collection, which can vary from resource-to-resource.
     Must be between 12 hours and 5 minutes.
    :type time_window: ~datetime.timedelta
    :param time_aggregation: Required. time aggregation type. How the data that is collected should
     be combined over time. The default value is Average. Possible values include: "Average",
     "Minimum", "Maximum", "Total", "Count", "Last".
    :type time_aggregation: str or ~$(python-base-namespace).v2015_04_01.models.TimeAggregationType
    :param operator: Required. the operator that is used to compare the metric data and the
     threshold. Possible values include: "Equals", "NotEquals", "GreaterThan", "GreaterThanOrEqual",
     "LessThan", "LessThanOrEqual".
    :type operator: str or ~$(python-base-namespace).v2015_04_01.models.ComparisonOperationType
    :param threshold: Required. the threshold of the metric that triggers the scale action.
    :type threshold: float
    """

    _validation = {
        'metric_name': {'required': True},
        'metric_resource_uri': {'required': True},
        'time_grain': {'required': True},
        'statistic': {'required': True},
        'time_window': {'required': True},
        'time_aggregation': {'required': True},
        'operator': {'required': True},
        'threshold': {'required': True},
    }

    _attribute_map = {
        'metric_name': {'key': 'metricName', 'type': 'str'},
        'metric_resource_uri': {'key': 'metricResourceUri', 'type': 'str'},
        'time_grain': {'key': 'timeGrain', 'type': 'duration'},
        'statistic': {'key': 'statistic', 'type': 'str'},
        'time_window': {'key': 'timeWindow', 'type': 'duration'},
        'time_aggregation': {'key': 'timeAggregation', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricTrigger, self).__init__(**kwargs)
        self.metric_name = kwargs['metric_name']
        self.metric_resource_uri = kwargs['metric_resource_uri']
        self.time_grain = kwargs['time_grain']
        self.statistic = kwargs['statistic']
        self.time_window = kwargs['time_window']
        self.time_aggregation = kwargs['time_aggregation']
        self.operator = kwargs['operator']
        self.threshold = kwargs['threshold']


class Operation(msrest.serialization.Model):
    """Microsoft Insights API operation definition.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: Display metadata associated with the operation.
    :type display: ~$(python-base-namespace).v2015_04_01.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :param provider: Service provider: Microsoft.Insights.
    :type provider: str
    :param resource: Resource on which the operation is performed: AlertRules, Autoscale, etc.
    :type resource: str
    :param operation: Operation type: Read, write, delete, etc.
    :type operation: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Microsoft.Insights operations. It contains a list of operations and a URL link to get the next set of results.

    :param value: List of operations supported by the Microsoft.Insights provider.
    :type value: list[~$(python-base-namespace).v2015_04_01.models.Operation]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class Recurrence(msrest.serialization.Model):
    """The repeating times at which this profile begins. This element is not used if the FixedDate element is used.

    All required parameters must be populated in order to send to Azure.

    :param frequency: Required. the recurrence frequency. How often the schedule profile should
     take effect. This value must be Week, meaning each week will have the same set of profiles. For
     example, to set a daily schedule, set **schedule** to every day of the week. The frequency
     property specifies that the schedule is repeated weekly. Possible values include: "None",
     "Second", "Minute", "Hour", "Day", "Week", "Month", "Year".
    :type frequency: str or ~$(python-base-namespace).v2015_04_01.models.RecurrenceFrequency
    :param schedule: Required. the scheduling constraints for when the profile begins.
    :type schedule: ~$(python-base-namespace).v2015_04_01.models.RecurrentSchedule
    """

    _validation = {
        'frequency': {'required': True},
        'schedule': {'required': True},
    }

    _attribute_map = {
        'frequency': {'key': 'frequency', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'RecurrentSchedule'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Recurrence, self).__init__(**kwargs)
        self.frequency = kwargs['frequency']
        self.schedule = kwargs['schedule']


class RecurrentSchedule(msrest.serialization.Model):
    """The scheduling constraints for when the profile begins.

    All required parameters must be populated in order to send to Azure.

    :param time_zone: Required. the timezone for the hours of the profile. Some examples of valid
     time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time,
     Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain
     Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard
     Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time,
     Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard
     Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time,
     Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina
     Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time,
     Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde
     Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W.
     Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European
     Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time,
     GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E.
     Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time,
     Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time,
     Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran
     Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius
     Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West
     Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time,
     Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard
     Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia
     Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W.
     Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time,
     Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard
     Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time,
     Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10,
     Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji
     Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands
     Standard Time.
    :type time_zone: str
    :param days: Required. the collection of days that the profile takes effect on. Possible values
     are Sunday through Saturday.
    :type days: list[str]
    :param hours: Required. A collection of hours that the profile takes effect on. Values
     supported are 0 to 23 on the 24-hour clock (AM/PM times are not supported).
    :type hours: list[int]
    :param minutes: Required. A collection of minutes at which the profile takes effect at.
    :type minutes: list[int]
    """

    _validation = {
        'time_zone': {'required': True},
        'days': {'required': True},
        'hours': {'required': True},
        'minutes': {'required': True},
    }

    _attribute_map = {
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'days': {'key': 'days', 'type': '[str]'},
        'hours': {'key': 'hours', 'type': '[int]'},
        'minutes': {'key': 'minutes', 'type': '[int]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecurrentSchedule, self).__init__(**kwargs)
        self.time_zone = kwargs['time_zone']
        self.days = kwargs['days']
        self.hours = kwargs['hours']
        self.minutes = kwargs['minutes']


class ScaleAction(msrest.serialization.Model):
    """The parameters for the scaling action.

    All required parameters must be populated in order to send to Azure.

    :param direction: Required. the scale direction. Whether the scaling action increases or
     decreases the number of instances. Possible values include: "None", "Increase", "Decrease".
    :type direction: str or ~$(python-base-namespace).v2015_04_01.models.ScaleDirection
    :param type: Required. the type of action that should occur when the scale rule fires. Possible
     values include: "ChangeCount", "PercentChangeCount", "ExactCount".
    :type type: str or ~$(python-base-namespace).v2015_04_01.models.ScaleType
    :param value: the number of instances that are involved in the scaling action. This value must
     be 1 or greater. The default value is 1.
    :type value: str
    :param cooldown: Required. the amount of time to wait since the last scaling action before this
     action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
    :type cooldown: ~datetime.timedelta
    """

    _validation = {
        'direction': {'required': True},
        'type': {'required': True},
        'cooldown': {'required': True},
    }

    _attribute_map = {
        'direction': {'key': 'direction', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'cooldown': {'key': 'cooldown', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScaleAction, self).__init__(**kwargs)
        self.direction = kwargs['direction']
        self.type = kwargs['type']
        self.value = kwargs.get('value', "1")
        self.cooldown = kwargs['cooldown']


class ScaleCapacity(msrest.serialization.Model):
    """The number of instances that can be used during this profile.

    All required parameters must be populated in order to send to Azure.

    :param minimum: Required. the minimum number of instances for the resource.
    :type minimum: str
    :param maximum: Required. the maximum number of instances for the resource. The actual maximum
     number of instances is limited by the cores that are available in the subscription.
    :type maximum: str
    :param default: Required. the number of instances that will be set if metrics are not available
     for evaluation. The default is only used if the current instance count is lower than the
     default.
    :type default: str
    """

    _validation = {
        'minimum': {'required': True},
        'maximum': {'required': True},
        'default': {'required': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'str'},
        'maximum': {'key': 'maximum', 'type': 'str'},
        'default': {'key': 'default', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScaleCapacity, self).__init__(**kwargs)
        self.minimum = kwargs['minimum']
        self.maximum = kwargs['maximum']
        self.default = kwargs['default']


class ScaleRule(msrest.serialization.Model):
    """A rule that provide the triggers and parameters for the scaling action.

    All required parameters must be populated in order to send to Azure.

    :param metric_trigger: Required. the trigger that results in a scaling action.
    :type metric_trigger: ~$(python-base-namespace).v2015_04_01.models.MetricTrigger
    :param scale_action: Required. the parameters for the scaling action.
    :type scale_action: ~$(python-base-namespace).v2015_04_01.models.ScaleAction
    """

    _validation = {
        'metric_trigger': {'required': True},
        'scale_action': {'required': True},
    }

    _attribute_map = {
        'metric_trigger': {'key': 'metricTrigger', 'type': 'MetricTrigger'},
        'scale_action': {'key': 'scaleAction', 'type': 'ScaleAction'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScaleRule, self).__init__(**kwargs)
        self.metric_trigger = kwargs['metric_trigger']
        self.scale_action = kwargs['scale_action']


class SenderAuthorization(msrest.serialization.Model):
    """the authorization used by the user who has performed the operation that led to this event. This captures the RBAC properties of the event. These usually include the 'action', 'role' and the 'scope'.

    :param action: the permissible actions. For instance: microsoft.support/supporttickets/write.
    :type action: str
    :param role: the role of the user. For instance: Subscription Admin.
    :type role: str
    :param scope: the scope.
    :type scope: str
    """

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'role': {'key': 'role', 'type': 'str'},
        'scope': {'key': 'scope', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SenderAuthorization, self).__init__(**kwargs)
        self.action = kwargs.get('action', None)
        self.role = kwargs.get('role', None)
        self.scope = kwargs.get('scope', None)


class TimeWindow(msrest.serialization.Model):
    """A specific date-time for the profile.

    All required parameters must be populated in order to send to Azure.

    :param time_zone: the timezone of the start and end times for the profile. Some examples of
     valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard
     Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time,
     Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central
     Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific
     Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time,
     Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western
     Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard
     Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo
     Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time,
     Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard
     Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central
     European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard
     Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time,
     E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time,
     Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time,
     Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran
     Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius
     Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West
     Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time,
     Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard
     Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia
     Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W.
     Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time,
     Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard
     Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time,
     Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10,
     Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji
     Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands
     Standard Time.
    :type time_zone: str
    :param start: Required. the start time for the profile in ISO 8601 format.
    :type start: ~datetime.datetime
    :param end: Required. the end time for the profile in ISO 8601 format.
    :type end: ~datetime.datetime
    """

    _validation = {
        'start': {'required': True},
        'end': {'required': True},
    }

    _attribute_map = {
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'start': {'key': 'start', 'type': 'iso-8601'},
        'end': {'key': 'end', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TimeWindow, self).__init__(**kwargs)
        self.time_zone = kwargs.get('time_zone', None)
        self.start = kwargs['start']
        self.end = kwargs['end']


class WebhookNotification(msrest.serialization.Model):
    """Webhook notification of an autoscale event.

    :param service_uri: the service address to receive the notification.
    :type service_uri: str
    :param properties: a property bag of settings. This value can be empty.
    :type properties: dict[str, str]
    """

    _attribute_map = {
        'service_uri': {'key': 'serviceUri', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebhookNotification, self).__init__(**kwargs)
        self.service_uri = kwargs.get('service_uri', None)
        self.properties = kwargs.get('properties', None)
