#!/usr/bin/env python
#
# Copyright 2016 timercrack
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

try:
    import ujson as json
except ImportError:
    import json
from aiohttp import web


class JSON(web.Response):
    """Serialize response to JSON with aiohttp.web"""
    def __init__(self, data, status=200, reason=None, headers=None):
        body = json.dumps(data, ensure_ascii=False)
        super().__init__(text=body, status=status, reason=reason, headers=headers, content_type='application/json')
