# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
import uuid

from .. import models


class JobOperations(object):
    """JobOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An objec model deserializer.
    :ivar api_version: Client API Version. Constant value: "2017-05-01.5.0".
    """

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self.api_version = "2017-05-01.5.0"

        self.config = config

    def get_all_lifetime_statistics(
            self, job_get_all_lifetime_statistics_options=None, custom_headers=None, raw=False, **operation_config):
        """Gets lifetime summary statistics for all of the jobs in the specified
        account.

        Statistics are aggregated across all jobs that have ever existed in the
        account, from account creation to the last update time of the
        statistics.

        :param job_get_all_lifetime_statistics_options: Additional parameters
         for the operation
        :type job_get_all_lifetime_statistics_options:
         :class:`JobGetAllLifetimeStatisticsOptions
         <azure.batch.models.JobGetAllLifetimeStatisticsOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`JobStatistics <azure.batch.models.JobStatistics>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_get_all_lifetime_statistics_options is not None:
            timeout = job_get_all_lifetime_statistics_options.timeout
        client_request_id = None
        if job_get_all_lifetime_statistics_options is not None:
            client_request_id = job_get_all_lifetime_statistics_options.client_request_id
        return_client_request_id = None
        if job_get_all_lifetime_statistics_options is not None:
            return_client_request_id = job_get_all_lifetime_statistics_options.return_client_request_id
        ocp_date = None
        if job_get_all_lifetime_statistics_options is not None:
            ocp_date = job_get_all_lifetime_statistics_options.ocp_date

        # Construct URL
        url = '/lifetimejobstats'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('JobStatistics', response)
            header_dict = {
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized

    def delete(
            self, job_id, job_delete_options=None, custom_headers=None, raw=False, **operation_config):
        """Deletes a job.

        Deleting a job also deletes all tasks that are part of that job, and
        all job statistics. This also overrides the retention period for task
        data; that is, if the job contains tasks which are still retained on
        compute nodes, the Batch services deletes those tasks' working
        directories and all their contents.

        :param job_id: The ID of the job to delete.
        :type job_id: str
        :param job_delete_options: Additional parameters for the operation
        :type job_delete_options: :class:`JobDeleteOptions
         <azure.batch.models.JobDeleteOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_delete_options is not None:
            timeout = job_delete_options.timeout
        client_request_id = None
        if job_delete_options is not None:
            client_request_id = job_delete_options.client_request_id
        return_client_request_id = None
        if job_delete_options is not None:
            return_client_request_id = job_delete_options.return_client_request_id
        ocp_date = None
        if job_delete_options is not None:
            ocp_date = job_delete_options.ocp_date
        if_match = None
        if job_delete_options is not None:
            if_match = job_delete_options.if_match
        if_none_match = None
        if job_delete_options is not None:
            if_none_match = job_delete_options.if_none_match
        if_modified_since = None
        if job_delete_options is not None:
            if_modified_since = job_delete_options.if_modified_since
        if_unmodified_since = None
        if job_delete_options is not None:
            if_unmodified_since = job_delete_options.if_unmodified_since

        # Construct URL
        url = '/jobs/{jobId}'
        path_format_arguments = {
            'jobId': self._serialize.url("job_id", job_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.delete(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [202]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
            })
            return client_raw_response

    def get(
            self, job_id, job_get_options=None, custom_headers=None, raw=False, **operation_config):
        """Gets information about the specified job.

        :param job_id: The ID of the job.
        :type job_id: str
        :param job_get_options: Additional parameters for the operation
        :type job_get_options: :class:`JobGetOptions
         <azure.batch.models.JobGetOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`CloudJob <azure.batch.models.CloudJob>`
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        select = None
        if job_get_options is not None:
            select = job_get_options.select
        expand = None
        if job_get_options is not None:
            expand = job_get_options.expand
        timeout = None
        if job_get_options is not None:
            timeout = job_get_options.timeout
        client_request_id = None
        if job_get_options is not None:
            client_request_id = job_get_options.client_request_id
        return_client_request_id = None
        if job_get_options is not None:
            return_client_request_id = job_get_options.return_client_request_id
        ocp_date = None
        if job_get_options is not None:
            ocp_date = job_get_options.ocp_date
        if_match = None
        if job_get_options is not None:
            if_match = job_get_options.if_match
        if_none_match = None
        if job_get_options is not None:
            if_none_match = job_get_options.if_none_match
        if_modified_since = None
        if job_get_options is not None:
            if_modified_since = job_get_options.if_modified_since
        if_unmodified_since = None
        if job_get_options is not None:
            if_unmodified_since = job_get_options.if_unmodified_since

        # Construct URL
        url = '/jobs/{jobId}'
        path_format_arguments = {
            'jobId': self._serialize.url("job_id", job_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if select is not None:
            query_parameters['$select'] = self._serialize.query("select", select, 'str')
        if expand is not None:
            query_parameters['$expand'] = self._serialize.query("expand", expand, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.get(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        deserialized = None
        header_dict = {}

        if response.status_code == 200:
            deserialized = self._deserialize('CloudJob', response)
            header_dict = {
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
            }

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            client_raw_response.add_headers(header_dict)
            return client_raw_response

        return deserialized

    def patch(
            self, job_id, job_patch_parameter, job_patch_options=None, custom_headers=None, raw=False, **operation_config):
        """Updates the properties of the specified job.

        This replaces only the job properties specified in the request. For
        example, if the job has constraints, and a request does not specify the
        constraints element, then the job keeps the existing constraints.

        :param job_id: The ID of the job whose properties you want to update.
        :type job_id: str
        :param job_patch_parameter: The parameters for the request.
        :type job_patch_parameter: :class:`JobPatchParameter
         <azure.batch.models.JobPatchParameter>`
        :param job_patch_options: Additional parameters for the operation
        :type job_patch_options: :class:`JobPatchOptions
         <azure.batch.models.JobPatchOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_patch_options is not None:
            timeout = job_patch_options.timeout
        client_request_id = None
        if job_patch_options is not None:
            client_request_id = job_patch_options.client_request_id
        return_client_request_id = None
        if job_patch_options is not None:
            return_client_request_id = job_patch_options.return_client_request_id
        ocp_date = None
        if job_patch_options is not None:
            ocp_date = job_patch_options.ocp_date
        if_match = None
        if job_patch_options is not None:
            if_match = job_patch_options.if_match
        if_none_match = None
        if job_patch_options is not None:
            if_none_match = job_patch_options.if_none_match
        if_modified_since = None
        if job_patch_options is not None:
            if_modified_since = job_patch_options.if_modified_since
        if_unmodified_since = None
        if job_patch_options is not None:
            if_unmodified_since = job_patch_options.if_unmodified_since

        # Construct URL
        url = '/jobs/{jobId}'
        path_format_arguments = {
            'jobId': self._serialize.url("job_id", job_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(job_patch_parameter, 'JobPatchParameter')

        # Construct and send request
        request = self._client.patch(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def update(
            self, job_id, job_update_parameter, job_update_options=None, custom_headers=None, raw=False, **operation_config):
        """Updates the properties of the specified job.

        This fully replaces all the updateable properties of the job. For
        example, if the job has constraints associated with it and if
        constraints is not specified with this request, then the Batch service
        will remove the existing constraints.

        :param job_id: The ID of the job whose properties you want to update.
        :type job_id: str
        :param job_update_parameter: The parameters for the request.
        :type job_update_parameter: :class:`JobUpdateParameter
         <azure.batch.models.JobUpdateParameter>`
        :param job_update_options: Additional parameters for the operation
        :type job_update_options: :class:`JobUpdateOptions
         <azure.batch.models.JobUpdateOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_update_options is not None:
            timeout = job_update_options.timeout
        client_request_id = None
        if job_update_options is not None:
            client_request_id = job_update_options.client_request_id
        return_client_request_id = None
        if job_update_options is not None:
            return_client_request_id = job_update_options.return_client_request_id
        ocp_date = None
        if job_update_options is not None:
            ocp_date = job_update_options.ocp_date
        if_match = None
        if job_update_options is not None:
            if_match = job_update_options.if_match
        if_none_match = None
        if job_update_options is not None:
            if_none_match = job_update_options.if_none_match
        if_modified_since = None
        if job_update_options is not None:
            if_modified_since = job_update_options.if_modified_since
        if_unmodified_since = None
        if job_update_options is not None:
            if_unmodified_since = job_update_options.if_unmodified_since

        # Construct URL
        url = '/jobs/{jobId}'
        path_format_arguments = {
            'jobId': self._serialize.url("job_id", job_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(job_update_parameter, 'JobUpdateParameter')

        # Construct and send request
        request = self._client.put(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [200]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def disable(
            self, job_id, disable_tasks, job_disable_options=None, custom_headers=None, raw=False, **operation_config):
        """Disables the specified job, preventing new tasks from running.

        The Batch Service immediately moves the job to the disabling state.
        Batch then uses the disableTasks parameter to determine what to do with
        the currently running tasks of the job. The job remains in the
        disabling state until the disable operation is completed and all tasks
        have been dealt with according to the disableTasks option; the job then
        moves to the disabled state. No new tasks are started under the job
        until it moves back to active state. If you try to disable a job that
        is in any state other than active, disabling, or disabled, the request
        fails with status code 409.

        :param job_id: The ID of the job to disable.
        :type job_id: str
        :param disable_tasks: What to do with active tasks associated with the
         job. requeue - Terminate running tasks and requeue them. The tasks
         will run again when the job is enabled. terminate - Terminate running
         tasks. The tasks will not run again. wait - Allow currently running
         tasks to complete. Possible values include: 'requeue', 'terminate',
         'wait'
        :type disable_tasks: str or :class:`DisableJobOption
         <azure.batch.models.DisableJobOption>`
        :param job_disable_options: Additional parameters for the operation
        :type job_disable_options: :class:`JobDisableOptions
         <azure.batch.models.JobDisableOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_disable_options is not None:
            timeout = job_disable_options.timeout
        client_request_id = None
        if job_disable_options is not None:
            client_request_id = job_disable_options.client_request_id
        return_client_request_id = None
        if job_disable_options is not None:
            return_client_request_id = job_disable_options.return_client_request_id
        ocp_date = None
        if job_disable_options is not None:
            ocp_date = job_disable_options.ocp_date
        if_match = None
        if job_disable_options is not None:
            if_match = job_disable_options.if_match
        if_none_match = None
        if job_disable_options is not None:
            if_none_match = job_disable_options.if_none_match
        if_modified_since = None
        if job_disable_options is not None:
            if_modified_since = job_disable_options.if_modified_since
        if_unmodified_since = None
        if job_disable_options is not None:
            if_unmodified_since = job_disable_options.if_unmodified_since
        job_disable_parameter = models.JobDisableParameter(disable_tasks=disable_tasks)

        # Construct URL
        url = '/jobs/{jobId}/disable'
        path_format_arguments = {
            'jobId': self._serialize.url("job_id", job_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(job_disable_parameter, 'JobDisableParameter')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [202]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def enable(
            self, job_id, job_enable_options=None, custom_headers=None, raw=False, **operation_config):
        """Enables the specified job, allowing new tasks to run.

        When you call this API, the Batch service sets a disabled job to the
        enabling state. After the this operation is completed, the job moves to
        the active state, and scheduling of new tasks under the job resumes.
        The Batch service does not allow a task to remain in the active state
        for more than 7 days. Therefore, if you enable a job containing active
        tasks which were added more than 7 days ago, those tasks will not run.

        :param job_id: The ID of the job to enable.
        :type job_id: str
        :param job_enable_options: Additional parameters for the operation
        :type job_enable_options: :class:`JobEnableOptions
         <azure.batch.models.JobEnableOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_enable_options is not None:
            timeout = job_enable_options.timeout
        client_request_id = None
        if job_enable_options is not None:
            client_request_id = job_enable_options.client_request_id
        return_client_request_id = None
        if job_enable_options is not None:
            return_client_request_id = job_enable_options.return_client_request_id
        ocp_date = None
        if job_enable_options is not None:
            ocp_date = job_enable_options.ocp_date
        if_match = None
        if job_enable_options is not None:
            if_match = job_enable_options.if_match
        if_none_match = None
        if job_enable_options is not None:
            if_none_match = job_enable_options.if_none_match
        if_modified_since = None
        if job_enable_options is not None:
            if_modified_since = job_enable_options.if_modified_since
        if_unmodified_since = None
        if job_enable_options is not None:
            if_unmodified_since = job_enable_options.if_unmodified_since

        # Construct URL
        url = '/jobs/{jobId}/enable'
        path_format_arguments = {
            'jobId': self._serialize.url("job_id", job_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(request, header_parameters, **operation_config)

        if response.status_code not in [202]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def terminate(
            self, job_id, job_terminate_options=None, terminate_reason=None, custom_headers=None, raw=False, **operation_config):
        """Terminates the specified job, marking it as completed.

        When a Terminate Job request is received, the Batch service sets the
        job to the terminating state. The Batch service then terminates any
        active or running tasks associated with the job, and runs any required
        Job Release tasks. The job then moves into the completed state.

        :param job_id: The ID of the job to terminate.
        :type job_id: str
        :param job_terminate_options: Additional parameters for the operation
        :type job_terminate_options: :class:`JobTerminateOptions
         <azure.batch.models.JobTerminateOptions>`
        :param terminate_reason: The text you want to appear as the job's
         TerminateReason. The default is 'UserTerminate'.
        :type terminate_reason: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_terminate_options is not None:
            timeout = job_terminate_options.timeout
        client_request_id = None
        if job_terminate_options is not None:
            client_request_id = job_terminate_options.client_request_id
        return_client_request_id = None
        if job_terminate_options is not None:
            return_client_request_id = job_terminate_options.return_client_request_id
        ocp_date = None
        if job_terminate_options is not None:
            ocp_date = job_terminate_options.ocp_date
        if_match = None
        if job_terminate_options is not None:
            if_match = job_terminate_options.if_match
        if_none_match = None
        if job_terminate_options is not None:
            if_none_match = job_terminate_options.if_none_match
        if_modified_since = None
        if job_terminate_options is not None:
            if_modified_since = job_terminate_options.if_modified_since
        if_unmodified_since = None
        if job_terminate_options is not None:
            if_unmodified_since = job_terminate_options.if_unmodified_since
        job_terminate_parameter = None
        if terminate_reason is not None:
            job_terminate_parameter = models.JobTerminateParameter(terminate_reason=terminate_reason)

        # Construct URL
        url = '/jobs/{jobId}/terminate'
        path_format_arguments = {
            'jobId': self._serialize.url("job_id", job_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')
        if if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", if_match, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        if if_modified_since is not None:
            header_parameters['If-Modified-Since'] = self._serialize.header("if_modified_since", if_modified_since, 'rfc-1123')
        if if_unmodified_since is not None:
            header_parameters['If-Unmodified-Since'] = self._serialize.header("if_unmodified_since", if_unmodified_since, 'rfc-1123')

        # Construct body
        if job_terminate_parameter is not None:
            body_content = self._serialize.body(job_terminate_parameter, 'JobTerminateParameter')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [202]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def add(
            self, job, job_add_options=None, custom_headers=None, raw=False, **operation_config):
        """Adds a job to the specified account.

        The Batch service supports two ways to control the work done as part of
        a job. In the first approach, the user specifies a Job Manager task.
        The Batch service launches this task when it is ready to start the job.
        The Job Manager task controls all other tasks that run under this job,
        by using the Task APIs. In the second approach, the user directly
        controls the execution of tasks under an active job, by using the Task
        APIs. Also note: when naming jobs, avoid including sensitive
        information such as user names or secret project names. This
        information may appear in telemetry logs accessible to Microsoft
        Support engineers.

        :param job: The job to be added.
        :type job: :class:`JobAddParameter
         <azure.batch.models.JobAddParameter>`
        :param job_add_options: Additional parameters for the operation
        :type job_add_options: :class:`JobAddOptions
         <azure.batch.models.JobAddOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: None
        :rtype: :class:`ClientRawResponse<msrest.pipeline.ClientRawResponse>`
         if raw=true
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        timeout = None
        if job_add_options is not None:
            timeout = job_add_options.timeout
        client_request_id = None
        if job_add_options is not None:
            client_request_id = job_add_options.client_request_id
        return_client_request_id = None
        if job_add_options is not None:
            return_client_request_id = job_add_options.return_client_request_id
        ocp_date = None
        if job_add_options is not None:
            ocp_date = job_add_options.ocp_date

        # Construct URL
        url = '/jobs'

        # Construct parameters
        query_parameters = {}
        query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
        if timeout is not None:
            query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

        # Construct headers
        header_parameters = {}
        header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
        if self.config.generate_client_request_id:
            header_parameters['client-request-id'] = str(uuid.uuid1())
        if custom_headers:
            header_parameters.update(custom_headers)
        if self.config.accept_language is not None:
            header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
        if client_request_id is not None:
            header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
        if return_client_request_id is not None:
            header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
        if ocp_date is not None:
            header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

        # Construct body
        body_content = self._serialize.body(job, 'JobAddParameter')

        # Construct and send request
        request = self._client.post(url, query_parameters)
        response = self._client.send(
            request, header_parameters, body_content, **operation_config)

        if response.status_code not in [201]:
            raise models.BatchErrorException(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            client_raw_response.add_headers({
                'client-request-id': 'str',
                'request-id': 'str',
                'ETag': 'str',
                'Last-Modified': 'rfc-1123',
                'DataServiceId': 'str',
            })
            return client_raw_response

    def list(
            self, job_list_options=None, custom_headers=None, raw=False, **operation_config):
        """Lists all of the jobs in the specified account.

        :param job_list_options: Additional parameters for the operation
        :type job_list_options: :class:`JobListOptions
         <azure.batch.models.JobListOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`CloudJobPaged <azure.batch.models.CloudJobPaged>`
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        filter = None
        if job_list_options is not None:
            filter = job_list_options.filter
        select = None
        if job_list_options is not None:
            select = job_list_options.select
        expand = None
        if job_list_options is not None:
            expand = job_list_options.expand
        max_results = None
        if job_list_options is not None:
            max_results = job_list_options.max_results
        timeout = None
        if job_list_options is not None:
            timeout = job_list_options.timeout
        client_request_id = None
        if job_list_options is not None:
            client_request_id = job_list_options.client_request_id
        return_client_request_id = None
        if job_list_options is not None:
            return_client_request_id = job_list_options.return_client_request_id
        ocp_date = None
        if job_list_options is not None:
            ocp_date = job_list_options.ocp_date

        def internal_paging(next_link=None, raw=False):

            if not next_link:
                # Construct URL
                url = '/jobs'

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
                if filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
                if select is not None:
                    query_parameters['$select'] = self._serialize.query("select", select, 'str')
                if expand is not None:
                    query_parameters['$expand'] = self._serialize.query("expand", expand, 'str')
                if max_results is not None:
                    query_parameters['maxresults'] = self._serialize.query("max_results", max_results, 'int', maximum=1000, minimum=1)
                if timeout is not None:
                    query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
            if self.config.generate_client_request_id:
                header_parameters['client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
            if client_request_id is not None:
                header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
            if return_client_request_id is not None:
                header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
            if ocp_date is not None:
                header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

            # Construct and send request
            request = self._client.get(url, query_parameters)
            response = self._client.send(
                request, header_parameters, **operation_config)

            if response.status_code not in [200]:
                raise models.BatchErrorException(self._deserialize, response)

            return response

        # Deserialize response
        deserialized = models.CloudJobPaged(internal_paging, self._deserialize.dependencies)

        if raw:
            header_dict = {}
            client_raw_response = models.CloudJobPaged(internal_paging, self._deserialize.dependencies, header_dict)
            return client_raw_response

        return deserialized

    def list_from_job_schedule(
            self, job_schedule_id, job_list_from_job_schedule_options=None, custom_headers=None, raw=False, **operation_config):
        """Lists the jobs that have been created under the specified job schedule.

        :param job_schedule_id: The ID of the job schedule from which you want
         to get a list of jobs.
        :type job_schedule_id: str
        :param job_list_from_job_schedule_options: Additional parameters for
         the operation
        :type job_list_from_job_schedule_options:
         :class:`JobListFromJobScheduleOptions
         <azure.batch.models.JobListFromJobScheduleOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`CloudJobPaged <azure.batch.models.CloudJobPaged>`
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        filter = None
        if job_list_from_job_schedule_options is not None:
            filter = job_list_from_job_schedule_options.filter
        select = None
        if job_list_from_job_schedule_options is not None:
            select = job_list_from_job_schedule_options.select
        expand = None
        if job_list_from_job_schedule_options is not None:
            expand = job_list_from_job_schedule_options.expand
        max_results = None
        if job_list_from_job_schedule_options is not None:
            max_results = job_list_from_job_schedule_options.max_results
        timeout = None
        if job_list_from_job_schedule_options is not None:
            timeout = job_list_from_job_schedule_options.timeout
        client_request_id = None
        if job_list_from_job_schedule_options is not None:
            client_request_id = job_list_from_job_schedule_options.client_request_id
        return_client_request_id = None
        if job_list_from_job_schedule_options is not None:
            return_client_request_id = job_list_from_job_schedule_options.return_client_request_id
        ocp_date = None
        if job_list_from_job_schedule_options is not None:
            ocp_date = job_list_from_job_schedule_options.ocp_date

        def internal_paging(next_link=None, raw=False):

            if not next_link:
                # Construct URL
                url = '/jobschedules/{jobScheduleId}/jobs'
                path_format_arguments = {
                    'jobScheduleId': self._serialize.url("job_schedule_id", job_schedule_id, 'str')
                }
                url = self._client.format_url(url, **path_format_arguments)

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
                if filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
                if select is not None:
                    query_parameters['$select'] = self._serialize.query("select", select, 'str')
                if expand is not None:
                    query_parameters['$expand'] = self._serialize.query("expand", expand, 'str')
                if max_results is not None:
                    query_parameters['maxresults'] = self._serialize.query("max_results", max_results, 'int', maximum=1000, minimum=1)
                if timeout is not None:
                    query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
            if self.config.generate_client_request_id:
                header_parameters['client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
            if client_request_id is not None:
                header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
            if return_client_request_id is not None:
                header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
            if ocp_date is not None:
                header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

            # Construct and send request
            request = self._client.get(url, query_parameters)
            response = self._client.send(
                request, header_parameters, **operation_config)

            if response.status_code not in [200]:
                raise models.BatchErrorException(self._deserialize, response)

            return response

        # Deserialize response
        deserialized = models.CloudJobPaged(internal_paging, self._deserialize.dependencies)

        if raw:
            header_dict = {}
            client_raw_response = models.CloudJobPaged(internal_paging, self._deserialize.dependencies, header_dict)
            return client_raw_response

        return deserialized

    def list_preparation_and_release_task_status(
            self, job_id, job_list_preparation_and_release_task_status_options=None, custom_headers=None, raw=False, **operation_config):
        """Lists the execution status of the Job Preparation and Job Release task
        for the specified job across the compute nodes where the job has run.

        This API returns the Job Preparation and Job Release task status on all
        compute nodes that have run the Job Preparation or Job Release task.
        This includes nodes which have since been removed from the pool. .

        :param job_id: The ID of the job.
        :type job_id: str
        :param job_list_preparation_and_release_task_status_options:
         Additional parameters for the operation
        :type job_list_preparation_and_release_task_status_options:
         :class:`JobListPreparationAndReleaseTaskStatusOptions
         <azure.batch.models.JobListPreparationAndReleaseTaskStatusOptions>`
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :rtype: :class:`JobPreparationAndReleaseTaskExecutionInformationPaged
         <azure.batch.models.JobPreparationAndReleaseTaskExecutionInformationPaged>`
        :raises:
         :class:`BatchErrorException<azure.batch.models.BatchErrorException>`
        """
        filter = None
        if job_list_preparation_and_release_task_status_options is not None:
            filter = job_list_preparation_and_release_task_status_options.filter
        select = None
        if job_list_preparation_and_release_task_status_options is not None:
            select = job_list_preparation_and_release_task_status_options.select
        max_results = None
        if job_list_preparation_and_release_task_status_options is not None:
            max_results = job_list_preparation_and_release_task_status_options.max_results
        timeout = None
        if job_list_preparation_and_release_task_status_options is not None:
            timeout = job_list_preparation_and_release_task_status_options.timeout
        client_request_id = None
        if job_list_preparation_and_release_task_status_options is not None:
            client_request_id = job_list_preparation_and_release_task_status_options.client_request_id
        return_client_request_id = None
        if job_list_preparation_and_release_task_status_options is not None:
            return_client_request_id = job_list_preparation_and_release_task_status_options.return_client_request_id
        ocp_date = None
        if job_list_preparation_and_release_task_status_options is not None:
            ocp_date = job_list_preparation_and_release_task_status_options.ocp_date

        def internal_paging(next_link=None, raw=False):

            if not next_link:
                # Construct URL
                url = '/jobs/{jobId}/jobpreparationandreleasetaskstatus'
                path_format_arguments = {
                    'jobId': self._serialize.url("job_id", job_id, 'str')
                }
                url = self._client.format_url(url, **path_format_arguments)

                # Construct parameters
                query_parameters = {}
                query_parameters['api-version'] = self._serialize.query("self.api_version", self.api_version, 'str')
                if filter is not None:
                    query_parameters['$filter'] = self._serialize.query("filter", filter, 'str')
                if select is not None:
                    query_parameters['$select'] = self._serialize.query("select", select, 'str')
                if max_results is not None:
                    query_parameters['maxresults'] = self._serialize.query("max_results", max_results, 'int', maximum=1000, minimum=1)
                if timeout is not None:
                    query_parameters['timeout'] = self._serialize.query("timeout", timeout, 'int')

            else:
                url = next_link
                query_parameters = {}

            # Construct headers
            header_parameters = {}
            header_parameters['Content-Type'] = 'application/json; odata=minimalmetadata; charset=utf-8'
            if self.config.generate_client_request_id:
                header_parameters['client-request-id'] = str(uuid.uuid1())
            if custom_headers:
                header_parameters.update(custom_headers)
            if self.config.accept_language is not None:
                header_parameters['accept-language'] = self._serialize.header("self.config.accept_language", self.config.accept_language, 'str')
            if client_request_id is not None:
                header_parameters['client-request-id'] = self._serialize.header("client_request_id", client_request_id, 'str')
            if return_client_request_id is not None:
                header_parameters['return-client-request-id'] = self._serialize.header("return_client_request_id", return_client_request_id, 'bool')
            if ocp_date is not None:
                header_parameters['ocp-date'] = self._serialize.header("ocp_date", ocp_date, 'rfc-1123')

            # Construct and send request
            request = self._client.get(url, query_parameters)
            response = self._client.send(
                request, header_parameters, **operation_config)

            if response.status_code not in [200]:
                raise models.BatchErrorException(self._deserialize, response)

            return response

        # Deserialize response
        deserialized = models.JobPreparationAndReleaseTaskExecutionInformationPaged(internal_paging, self._deserialize.dependencies)

        if raw:
            header_dict = {}
            client_raw_response = models.JobPreparationAndReleaseTaskExecutionInformationPaged(internal_paging, self._deserialize.dependencies, header_dict)
            return client_raw_response

        return deserialized
