/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps;

import java.util.Comparator;
import org.brunel.geom.Point;

public class LabelPoint
extends Point {
    public final String label;
    public final String parent0;
    public final String parent1;
    public final int rank;
    public final int size;
    public final int type;
    public static final Comparator<LabelPoint> COMPARATOR = new Comparator<LabelPoint>(){

        @Override
        public int compare(LabelPoint a, LabelPoint b) {
            if (a.rank != b.rank) {
                return a.rank - b.rank;
            }
            if (a.type != b.type) {
                return a.type - b.type;
            }
            if (a.size != b.size) {
                return b.size - a.size;
            }
            return a.label.compareTo(b.label);
        }
    };

    public static LabelPoint parse(String line) {
        String[] p = line.split("\\|");
        return new LabelPoint(Double.parseDouble(p[1]), Double.parseDouble(p[0]), p[7], Integer.parseInt(p[2]), Integer.parseInt(p[3]), Integer.parseInt(p[4]), p[5], p[6]);
    }

    private LabelPoint(double x, double y, String label, int rank, int size, int type, String parent0, String parent1) {
        super(x, y);
        this.label = label;
        this.rank = rank;
        this.size = size;
        this.type = type;
        this.parent0 = parent0;
        this.parent1 = parent1;
    }

    @Override
    public String toString() {
        return this.label + "[" + this.rank + "," + this.size + "]";
    }
}

