/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import org.brunel.build.d3.D3LabelBuilder;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.element.ElementDefinition;
import org.brunel.build.element.ElementDetails;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Dataset;
import org.brunel.model.VisSingle;

class Cloud
extends D3Diagram {
    public Cloud(VisSingle vis, Dataset data, ScriptWriter out) {
        super(vis, data, out);
    }

    @Override
    public ElementDetails initializeDiagram() {
        this.out.comment("Build the cloud layout");
        this.out.add("var cloud = BrunelD3.cloudLayout(processed, [geom.inner_width, geom.inner_height])").endStatement();
        this.out.add("function keyFunction(d) { return d.key }").endStatement();
        return ElementDetails.makeForDiagram(this.vis, "data._rows", "text", "text", "box", true);
    }

    @Override
    public void writeDefinition(ElementDetails details, ElementDefinition elementDef) {
        this.out.addChained("attr('transform', cloud.transform)").endStatement();
        this.addAestheticsAndTooltips(details, false);
    }

    @Override
    public void writeDiagramEnter() {
        this.out.addChained("attr('dy', '0.3em').style('text-anchor', 'middle').classed('label', true)").addChained("text(labeling.content)");
        D3LabelBuilder.addFontSizeAttribute(this.vis, this.out);
        this.out.endStatement();
    }
}

