/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.element.ElementDefinition;
import org.brunel.build.element.ElementDetails;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Dataset;
import org.brunel.model.VisSingle;

class Bubble
extends D3Diagram {
    public Bubble(VisSingle vis, Dataset data, ScriptWriter out) {
        super(vis, data, out);
    }

    @Override
    public ElementDetails initializeDiagram() {
        this.out.comment("Define bubble (hierarchy) data structures");
        this.makeHierarchicalTree();
        this.out.add("var pack = d3.layout.pack().size([geom.inner_width, geom.inner_height])").addChained("value(function(d) { return d.value == null || d.value < 0 ? 0 : d.value })").addChained("sort(BrunelData.diagram_Hierarchical.compare)").endStatement();
        this.out.add("function keyFunction(d) { return d.key }").endStatement();
        return ElementDetails.makeForDiagram(this.vis, "pack(tree.root)", "circle", "point", "box", true);
    }

    @Override
    public void writeDefinition(ElementDetails details, ElementDefinition elementDef) {
        this.out.addChained("attr('class', function(d) { return (d.children ? 'L' + d.depth : 'leaf element " + this.element.name() + "') })").addChained("attr('cx', function(d) { return d.x; })").addChained("attr('cy', function(d) { return d.y; })").addChained("attr('r', function(d) { return d.r; })").endStatement();
        this.addAestheticsAndTooltips(details, true);
    }
}

