/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.brunel.action.Param;
import org.brunel.build.d3.D3Util;
import org.brunel.build.element.ElementDetails;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class D3LabelBuilder {
    private final VisSingle vis;
    private final ScriptWriter out;
    private final Dataset data;

    public D3LabelBuilder(VisSingle vis, ScriptWriter out, Dataset data) {
        this.vis = vis;
        this.out = out;
        this.data = data;
    }

    public void addElementLabeling() {
        if (this.vis.itemsLabel.isEmpty()) {
            return;
        }
        if (this.vis.tDiagram == VisTypes.Diagram.network) {
            this.out.add("BrunelD3.label(selection, labels, labeling, 0)").endStatement();
            return;
        }
        if (this.vis.tElement != VisTypes.Element.text) {
            this.out.add("BrunelD3.label(selection, labels, labeling, transitionMillis)").endStatement();
        }
    }

    public static void addFontSizeAttribute(VisSingle vis, ScriptWriter out) {
        if (!vis.fSize.isEmpty()) {
            ModelUtil.Size parts = ModelUtil.getFontSize(vis);
            if (parts == null) {
                out.addChained("style('font-size', function(d) { return (100*size(d)) + '%' })");
            } else {
                out.addChained("style('font-size', function(d) { return (", parts.value(), "* size(d)) +'" + parts.suffix() + "' })");
            }
        }
    }

    public void addTooltips(ElementDetails details) {
        if (this.vis.itemsTooltip.isEmpty()) {
            return;
        }
        this.out.onNewLine().ln();
        this.defineLabeling(details.modifyForTooltip(), this.prettify(this.vis.itemsTooltip, true), true);
        this.out.add("BrunelD3.addTooltip(selection, tooltipLabeling, geom)").endStatement();
    }

    public void defineLabeling(ElementDetails details, List<Param> items, boolean forTooltip) {
        if (this.vis.tElement != VisTypes.Element.text && items.isEmpty()) {
            return;
        }
        String name = forTooltip ? "tooltipLabeling" : "labeling";
        this.out.add("var", name, "= {").ln().indentMore();
        String textMethod = details.textMethod;
        if (textMethod.equals("geo")) {
            String func = "function(box,text,d) {var p = projection([d.geo_properties.c, d.geo_properties.d]); return {box:box, x:p[0], y:p[1]}}";
            this.out.onNewLine().add("where:", func, ",");
        } else {
            this.out.onNewLine().add("method:", this.out.quote(textMethod), ", ");
        }
        this.out.onNewLine().add("fit:", details.textMustFit, ",");
        if (textMethod.equals("path") || textMethod.equals("wedge")) {
            this.out.onNewLine().add("path: path,");
        }
        this.out.onNewLine().add("content: function(d) {").indentMore();
        this.out.onNewLine().add("return d.row == null ? null : ");
        this.writeContent(items, forTooltip);
        this.out.indentLess().onNewLine().add("}");
        this.out.indentLess().onNewLine().add("}").endStatement();
    }

    private List<Param> prettify(List<Param> items, boolean longForm) {
        if (items.size() < 2) {
            return items;
        }
        ArrayList<Param> result = new ArrayList<Param>();
        for (int i = 0; i < items.size(); ++i) {
            Param p = items.get(i);
            if (!p.isField()) {
                return items;
            }
            Field f = this.data.field(p.asField());
            if (i > 0) {
                result.add(Param.makeString(longForm ? "<br/>" : ", "));
            }
            if (longForm) {
                result.add(Param.makeString("<span class=\"title\">" + f.label + ": </span>"));
            }
            result.add(p);
        }
        return result;
    }

    private void writeContent(List<Param> items, boolean forTooltip) {
        if (items.isEmpty()) {
            if (this.vis.tDiagram != null) {
                items = Param.makeFields(this.vis.positionFields());
            }
            if (items.isEmpty()) {
                items = Collections.singletonList(Param.makeField("#row"));
            }
        }
        boolean first = true;
        for (Param p : this.prettify(items, false)) {
            if (!first) {
                this.out.add("\n\t\t\t+ ");
            }
            if (p.isField()) {
                Field f = this.data.field(p.asField());
                if (forTooltip) {
                    this.out.add("'<span class=\"field\">' + ");
                }
                if (p.hasModifiers()) {
                    this.out.add("BrunelD3.shorten(");
                }
                this.out.add("data." + D3Util.baseFieldID(f) + "_f(d)");
                if (p.hasModifiers()) {
                    this.out.add(",", (int)p.firstModifier().asDouble(), ")");
                }
                if (forTooltip) {
                    this.out.add(" + '</span>'");
                }
            } else {
                String o = p.asString();
                if (forTooltip) {
                    o = o.replaceAll("\\\\n", "&#10;");
                }
                this.out.add(Data.quote((String)o));
            }
            first = false;
        }
    }

    public void addTreeInternalLabels() {
        this.out.add("diagramLabels.attr('class', 'axis diagram treemap hierarchy')").endStatement();
        this.out.add("var treeLabeling = { method:'inner-left', fit:true,");
        this.out.indentMore().onNewLine().add("content:  function(d) { return d.innerNodeName }, ");
        this.out.indentMore().onNewLine().add("cssClass: function(d) { return 'axis label L' + d.depth }, ");
        this.out.indentMore().onNewLine().add("where :   function(box) { return {'x': box.x + 2, 'y': box.y, 'box': box} }").indentLess();
        this.out.add("}").endStatement();
        this.out.add("BrunelD3.label(selection, diagramLabels, treeLabeling, transitionMillis)").endStatement();
    }
}

