/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import org.brunel.action.Param;
import org.brunel.build.chart.ChartStructure;
import org.brunel.build.d3.D3ScaleBuilder;
import org.brunel.build.element.ElementStructure;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Field;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class D3Interaction {
    private final ChartStructure structure;
    private final D3ScaleBuilder scales;
    private final ScriptWriter out;
    private final boolean zoomable;

    public D3Interaction(ChartStructure structure, D3ScaleBuilder scales, ScriptWriter out) {
        this.structure = structure;
        this.scales = scales;
        this.out = out;
        this.zoomable = this.isZoomable(structure.elementStructure);
    }

    private boolean anyCategorical(Field[] fields) {
        for (Field f : fields) {
            if (!f.preferCategorical()) continue;
            return true;
        }
        return false;
    }

    private boolean isZoomable(ElementStructure[] elements) {
        if (this.structure.coordinates.xCategorical && this.structure.coordinates.yCategorical) {
            return false;
        }
        if (this.structure.diagram != null || this.scales.coords == VisTypes.Coordinates.polar) {
            return false;
        }
        boolean defaultResult = true;
        for (ElementStructure e : elements) {
            if (e.vis.tInteraction.containsKey((Object)VisTypes.Interaction.panzoom)) {
                return true;
            }
            if (!e.vis.tInteraction.containsKey((Object)VisTypes.Interaction.none)) continue;
            defaultResult = false;
        }
        return defaultResult;
    }

    public void addElementHandlers(VisSingle vis) {
        if (D3Interaction.isSelectable(vis)) {
            Param p = vis.tInteraction.get((Object)VisTypes.Interaction.select);
            String type = "click";
            if (p.hasModifiers()) {
                type = p.firstModifier().asString();
            }
            this.out.add("selection.on('" + type + "', function(d) { BrunelD3.select(data.$row(d), original, this, updateAll) } )").endStatement();
        }
    }

    private static boolean isSelectable(VisSingle vis) {
        return vis.tInteraction.containsKey((Object)VisTypes.Interaction.select);
    }

    public void addPrerequisites() {
        if (this.zoomable) {
            this.out.add("var overlay = interior.append('g').attr('class', 'element')").addChained("attr('class', 'overlay').style('cursor','move').style('fill','none').style('pointer-events','all')").endStatement();
            this.out.add("var zoom = d3.behavior.zoom().on('zoom', function() {build(-1)} )").endStatement();
            this.out.add("overlay.append('rect').attr('class', 'overlay')").addChained("attr('width', geom.inner_width)").addChained("attr('height', geom.inner_height)").addChained("call(zoom)").endStatement();
        }
    }

    public void addScaleInteractivity() {
        if (!this.zoomable) {
            return;
        }
        this.out.add("zoom");
        if (this.scales.coords == VisTypes.Coordinates.transposed) {
            if (!this.structure.coordinates.xCategorical) {
                this.out.add(".y(scale_x)");
            }
            if (!this.structure.coordinates.yCategorical) {
                this.out.add(".x(scale_y)");
            }
        } else {
            if (!this.structure.coordinates.xCategorical) {
                this.out.add(".x(scale_x)");
            }
            if (!this.structure.coordinates.yCategorical) {
                this.out.add(".y(scale_y)");
            }
        }
        this.out.endStatement();
    }
}

