/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.brunel.data.Data;
import org.brunel.data.Field;
import org.brunel.data.auto.Auto;
import org.brunel.data.util.Range;

class AxisDetails {
    public final String title;
    public final String scale;
    public boolean rotatedTicks = false;
    public Object[] tickValues;
    public Integer tickCount;
    public int size;
    public int leftGutter;
    public int rightGutter;
    public int topGutter;
    public int bottomGutter;
    private final Field[] fields;
    private final boolean categorical;

    public AxisDetails(String dimension, Field[] definedFields, boolean categorical, String userTitle, int tickCount) {
        this.scale = "scale_" + dimension;
        this.fields = definedFields;
        this.categorical = categorical;
        Integer n = this.tickCount = tickCount < 100 ? Integer.valueOf(tickCount) : null;
        this.title = userTitle != null ? (userTitle.isEmpty() ? null : userTitle) : AxisDetails.title(this.fields);
    }

    private static String title(Field[] fields) {
        if (fields.length == 1) {
            return fields[0].isSynthetic() ? null : fields[0].label;
        }
        LinkedHashSet<String> titles = new LinkedHashSet<String>();
        LinkedHashSet<String> originalTitles = new LinkedHashSet<String>();
        for (Field f : fields) {
            titles.add(f.label);
            String originalLabel = (String)f.property("originalLabel");
            originalTitles.add(originalLabel == null ? f.label : originalLabel);
        }
        if (originalTitles.size() < titles.size()) {
            titles = originalTitles;
        }
        return titles.isEmpty() ? null : Data.join(titles);
    }

    public boolean isLog() {
        return this.fields.length > 0 && "log".equals(this.fields[0].property("transform"));
    }

    public void layoutHorizontally(double availableSpace, boolean fillToEdge) {
        if (!this.exists()) {
            return;
        }
        int tickWidth = this.maxCategoryWidth() + 5;
        int tickCount = this.countTicks(this.fields);
        if (!this.categorical) {
            fillToEdge = true;
        }
        if (fillToEdge) {
            availableSpace -= (double)tickWidth;
        }
        int spaceForOneTick = (int)(availableSpace / (double)tickCount);
        if (this.categorical && availableSpace < (double)(tickWidth * tickCount)) {
            this.rotatedTicks = true;
            this.tickValues = this.makeSkippingTickValues(availableSpace, tickCount);
            int tickHeight = (int)((double)tickWidth / Math.sqrt(2.0));
            this.size = tickHeight + 16 + this.estimatedTitleHeight();
            if (fillToEdge) {
                this.rightGutter = 10;
                this.leftGutter = tickHeight - 8;
            } else {
                this.rightGutter = Math.max(0, 10 - spaceForOneTick / 2);
                this.leftGutter = Math.max(0, tickHeight - 8 - spaceForOneTick / 2);
            }
        } else {
            this.size = this.estimatedSimpleSizeWhenHorizontal();
            this.leftGutter = fillToEdge ? tickWidth / 2 : Math.max(0, tickWidth / 2 - spaceForOneTick / 2);
            this.rightGutter = this.leftGutter;
            if (availableSpace < (double)(tickWidth * tickCount) && this.tickCount == null) {
                this.tickCount = (int)(availableSpace / (double)(tickWidth + 5));
            }
        }
    }

    public boolean exists() {
        return this.fields.length > 0;
    }

    public int maxCategoryWidth() {
        if (this.fields.length == 0) {
            return 0;
        }
        int maxCharCount = 1;
        for (Field f : this.fields) {
            Double[] sampleTicks;
            if (this.categorical) {
                for (Object s : f.categories()) {
                    int length = f.format(s).length();
                    if (s instanceof Range) {
                        ++length;
                    }
                    maxCharCount = Math.max(maxCharCount, length);
                }
                continue;
            }
            for (Double s : sampleTicks = Auto.makeNumericScale((Field)f, (boolean)true, (double[])new double[]{0.0, 0.0}, (double)0.0, (int)5, (boolean)false).divisions) {
                maxCharCount = Math.max(maxCharCount, f.format((Object)s).length());
            }
            maxCharCount = Math.max(maxCharCount, 3);
        }
        return (int)((double)maxCharCount * 6.5);
    }

    private int countTicks(Field[] fields) {
        if (!this.categorical) {
            return 10;
        }
        if (fields.length == 0) {
            return 1;
        }
        int n = 0;
        for (Field f : fields) {
            n += f.categories().length;
        }
        return n;
    }

    private Object[] makeSkippingTickValues(double width, int count) {
        if (!this.categorical) {
            return null;
        }
        double spacePerTick = width / (double)count;
        int skipFrequency = (int)Math.round(20.0 / spacePerTick);
        if (skipFrequency < 2) {
            return null;
        }
        ArrayList<Object> useThese = new ArrayList<Object>();
        int at = 0;
        for (Field f : this.fields) {
            for (Object s : f.categories()) {
                if (at++ % skipFrequency != 0) continue;
                useThese.add(s);
            }
        }
        return useThese.toArray(new Object[useThese.size()]);
    }

    private int estimatedTitleHeight() {
        return this.title == null ? 0 : 16;
    }

    public int estimatedSimpleSizeWhenHorizontal() {
        return this.exists() ? 20 + this.estimatedTitleHeight() : 0;
    }

    public void layoutVertically(double availableSpace) {
        if (!this.exists()) {
            return;
        }
        int tickCount = this.countTicks(this.fields);
        this.topGutter = 5;
        this.bottomGutter = 5;
        availableSpace -= (double)(this.topGutter + this.bottomGutter);
        if (this.categorical) {
            this.tickValues = this.makeSkippingTickValues(availableSpace, tickCount);
        } else {
            int tickWidth = 16;
            if ((double)(tickWidth * tickCount) > availableSpace && this.tickCount == null) {
                this.tickCount = (int)(availableSpace / (double)tickWidth);
            }
        }
        this.size = this.tickValues == null ? this.maxCategoryWidth() : this.maxTickWidth();
        this.size += this.estimatedTitleHeight() + 10;
    }

    public int maxTickWidth() {
        int maxCharCount = 1;
        for (Object s : this.tickValues) {
            int length = s.toString().length();
            if (s instanceof Range) {
                ++length;
            }
            maxCharCount = Math.max(maxCharCount, length);
        }
        return (int)((double)maxCharCount * 6.5);
    }
}

