/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.controls;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.brunel.action.Param;
import org.brunel.build.controls.FilterControl;
import org.brunel.build.util.BuilderOptions;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Dataset;
import org.brunel.model.VisSingle;

public class Controls {
    public final List<FilterControl> filters;
    private final BuilderOptions options;

    public Controls(BuilderOptions options) {
        this.options = options;
        this.filters = new ArrayList<FilterControl>();
    }

    public void buildControls(VisSingle vis, Dataset data) {
        for (Param f : vis.fFilter) {
            this.filters.add(FilterControl.makeForField(data, f.asField(data)));
        }
    }

    public boolean isNeeded() {
        return !this.filters.isEmpty();
    }

    public void write(ScriptWriter out) {
        if (this.options.controlsIdentifier != null) {
            this.write(this.options.controlsIdentifier, "BrunelJQueryControlFactory", out);
        }
    }

    public void write(String controlId, String uiFactoryClass, ScriptWriter out) {
        if (this.filters.isEmpty()) {
            return;
        }
        out.titleComment("Create and wire controls");
        out.add("$(function() {").ln().indentMore();
        this.createFilters(controlId, uiFactoryClass, out);
        out.indentLess().ln();
        out.add("})").endStatement();
        out.add("BrunelEventHandlers.make_filter_handler(v)").endStatement();
    }

    private void createFilters(String controlId, String uiFactoryClass, ScriptWriter out) {
        Gson gson = new Gson();
        for (FilterControl filter : this.filters) {
            String fieldId = filter.id;
            String label = filter.label;
            Object[] categories = filter.categories;
            Double min = filter.min;
            Double max = filter.max;
            if (categories == null) {
                out.add("$(", out.quote("#" + controlId), ").append(", uiFactoryClass, ".make_range_slider(", out.quote(this.options.visIdentifier), ",", out.quote(fieldId), ",", out.quote(label), ",", min, ",", max, "))").endStatement();
                continue;
            }
            out.add("$(", out.quote("#" + controlId), ").append(", uiFactoryClass, ".make_category_filter(", out.quote(this.options.visIdentifier), ",", out.quote(fieldId), ",", out.quote(label), ",", gson.toJson((Object)categories), "))").endStatement();
        }
    }
}

