/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.summary;

import java.util.List;
import org.brunel.data.Data;
import org.brunel.data.Field;
import org.brunel.data.auto.Auto;
import org.brunel.data.summary.Fit;
import org.brunel.data.summary.Regression;

public class Smooth
implements Fit {
    private final double window;
    private final double[] x;
    private final double[] y;
    private final double mean;

    public Smooth(Field y, Field x, Double windowPercent, List<Integer> rows) {
        if (windowPercent == null) {
            int n = Auto.optimalBinCount(x);
            this.window = (x.max() - x.min()) / (double)n;
        } else {
            this.window = (x.max() - x.min()) * windowPercent / 200.0;
        }
        double[][] pairs = Regression.asPairs(y, x, rows);
        this.x = pairs[1];
        this.y = pairs[0];
        this.mean = y.numericProperty("mean");
    }

    @Override
    public Double get(Object value) {
        Double at = Data.asNumeric(value);
        if (at == null) {
            return null;
        }
        return this.eval(at, this.window);
    }

    private Double eval(double at, double h) {
        int low = this.search(at - h, this.x);
        int high = this.search(at + h, this.x);
        double sy = 0.0;
        double sw = 0.0;
        for (int i = low; i <= high; ++i) {
            double d = (this.x[i] - at) / h;
            double w = 0.75 * (1.0 - d * d);
            if (!(w > 1.0E-5)) continue;
            sw += w;
            sy += w * this.y[i];
        }
        if (sw < 1.0E-4) {
            return h < this.window * 10.0 ? this.eval(at, h * 2.0) : this.mean;
        }
        return sy / sw;
    }

    private int search(double at, double[] x) {
        int p = 0;
        int q = x.length - 1;
        while (q - p > 1) {
            int t = p + q >> 1;
            if (x[t] <= at) {
                p = t;
            }
            if (!(x[t] >= at)) continue;
            q = t;
        }
        while (p > 0 && x[p - 1] == at) {
            --p;
        }
        while (q < x.length - 1 && x[q + 1] == at) {
            ++q;
        }
        return p + q >> 1;
    }
}

