/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data;

import java.util.HashMap;
import org.brunel.data.Data;
import org.brunel.data.stats.DateStats;
import org.brunel.data.stats.NominalStats;
import org.brunel.data.stats.NumericStats;
import org.brunel.data.util.DateFormat;
import org.brunel.data.util.Informative;
import org.brunel.data.util.Range;
import org.brunel.data.values.Provider;

public class Field
extends Informative
implements Comparable<Field> {
    public static final String VAL_SELECTED = "\u2713";
    public static final String VAL_UNSELECTED = "\u2717";
    public final String label;
    public final String name;
    Provider provider;
    private boolean calculatedNominal;
    private boolean calculatedNumeric;
    private boolean calculatedDate;
    private HashMap<Object, Integer> categoryOrder;

    public Field(String name, String label, Provider provider) {
        this(name, label, provider, null);
    }

    Field(String name, String label, Provider provider, Field base) {
        this.name = name;
        this.label = label == null ? name : label;
        this.provider = provider;
        if (base != null) {
            if (provider == null) {
                base.makeNominalStats();
                base.makeNumericStats();
                base.makeDateStats();
            }
            this.copyPropertiesFrom(base);
        }
    }

    public void setValue(Object o, int index) {
        this.provider = this.provider.setValue(o, index);
    }

    public int compareRows(int a, int b) {
        if (this.categoryOrder == null) {
            this.categoryOrder = new HashMap();
            if (this.preferCategorical()) {
                Object[] cats = this.categories();
                for (int i = 0; i < cats.length; ++i) {
                    this.categoryOrder.put(cats[i], i);
                }
            }
        }
        return this.provider.compareRows(a, b, this.categoryOrder);
    }

    public long expectedSize() {
        return (this.label.length() + this.name.length()) * 2 + 84 + 24 + this.provider.expectedSize();
    }

    @Override
    public Object property(String key) {
        Object o = super.property(key);
        if (o == null) {
            if (!this.calculatedNominal && NominalStats.creates(key)) {
                this.makeNominalStats();
                o = super.property(key);
            }
            if (!this.calculatedNumeric && NumericStats.creates(key)) {
                if (!this.calculatedNominal) {
                    this.makeNominalStats();
                }
                this.makeNumericStats();
                o = super.property(key);
            }
            if (!this.calculatedDate && DateStats.creates(key)) {
                if (!this.calculatedNominal) {
                    this.makeNominalStats();
                }
                if (!this.calculatedNumeric) {
                    this.makeNumericStats();
                }
                this.makeDateStats();
                o = super.property(key);
            }
        }
        return o;
    }

    public void setCategories(Object[] cats) {
        this.set("categories", cats);
        this.set("categoriesOrdered", true);
    }

    private void makeDateStats() {
        if (this.isNumeric()) {
            DateStats.populate(this);
        }
        this.calculatedDate = true;
    }

    public boolean isNumeric() {
        return this.propertyTrue("numeric");
    }

    public boolean isDate() {
        return this.propertyTrue("date");
    }

    public boolean isBinned() {
        return this.propertyTrue("binned");
    }

    private void makeNumericStats() {
        if (this.provider != null) {
            NumericStats.populate(this);
        }
        this.calculatedNumeric = true;
    }

    private void makeNominalStats() {
        if (this.provider != null) {
            NominalStats.populate(this);
        }
        this.calculatedNominal = true;
    }

    public Object[] categories() {
        return (Object[])this.property("categories");
    }

    @Override
    public int compareTo(Field o) {
        int p = Data.compare(this.name, o.name);
        if (this.name.startsWith("#")) {
            return o.name.startsWith("#") ? p : 1;
        }
        return o.name.startsWith("#") ? -1 : p;
    }

    public Field dropData() {
        return new Field(this.name, this.label, null, this);
    }

    public Double max() {
        return (Double)this.property("max");
    }

    public Double min() {
        return (Double)this.property("min");
    }

    public boolean isSynthetic() {
        return this.name.startsWith("#");
    }

    public boolean preferCategorical() {
        return !this.isNumeric() || this.isBinned();
    }

    public boolean ordered() {
        return this.isNumeric() || this.name.equals("#selection");
    }

    public Field rename(String name, String label) {
        Field field = new Field(name, label, this.provider);
        field.copyPropertiesFrom(this);
        return field;
    }

    public int rowCount() {
        return this.provider != null ? this.provider.count() : this.numericProperty("n").intValue();
    }

    public String toString() {
        return this.name;
    }

    public int uniqueValuesCount() {
        return (int)Math.round(this.numericProperty("unique"));
    }

    public int valid() {
        return (Integer)this.property("valid");
    }

    public Object value(int index) {
        return this.provider.value(index);
    }

    public String valueFormatted(int index) {
        return this.format(this.provider.value(index));
    }

    public String format(Object v) {
        if (v == null) {
            return "?";
        }
        if (v instanceof Range) {
            return v.toString();
        }
        if (this.isDate()) {
            return ((DateFormat)((Object)this.property("dateFormat"))).format(Data.asDate(v));
        }
        if ("percent".equals(this.property("summary"))) {
            Double d = Data.asNumeric(v);
            if (d == null) {
                return null;
            }
            return Data.formatNumeric((double)Math.round(d * 10.0) / 10.0, false) + "%";
        }
        if (this.isNumeric()) {
            Double d = Data.asNumeric(v);
            return d == null ? "?" : Data.formatNumeric(d, true);
        }
        return v.toString();
    }
}

