/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive_grid_cloud_portal.scheduler.client.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.objectweb.proactive.extensions.dataspaces.vfs.selector.FileSelector;

public class Zipper {
    private static final Logger logger = Logger.getLogger(Zipper.class);
    private static byte[] MAGIC = new byte[]{80, 75, 3, 4};

    private Zipper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isZipFile(File file) throws FileNotFoundException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            boolean bl = Zipper.isZipFile(inputStream);
            return bl;
        }
        catch (IOException e) {
            throw new FileNotFoundException("Error when reading file " + file + " " + e.getMessage());
        }
    }

    public static boolean isZipFile(InputStream is) {
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        boolean isZipStream = true;
        try {
            is.mark(MAGIC.length);
            for (int i = 0; i < MAGIC.length; ++i) {
                if (MAGIC[i] == (byte)is.read()) continue;
                isZipStream = false;
                break;
            }
            is.reset();
        }
        catch (IOException ioe) {
            isZipStream = false;
        }
        return isZipStream;
    }

    private static class FileSelectionPredicate
    implements Predicate<File> {
        private File root;
        private List<String> includes;
        private List<String> excludes;

        public FileSelectionPredicate(File root, List<String> includes, List<String> excludes) {
            this.root = root;
            this.includes = includes;
            this.excludes = excludes;
        }

        public boolean apply(File file) {
            boolean answer;
            Path pathRelativeToRoot = this.root.toPath().relativize(file.toPath());
            FileSelector selector = new FileSelector(this.includes, this.excludes);
            boolean bl = answer = !file.isDirectory() && selector.matches(pathRelativeToRoot);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Analysing file " + file + " for selector " + selector + " : " + answer));
                logger.trace((Object)("Path relative to root : " + pathRelativeToRoot));
            }
            return answer;
        }
    }

    private static class FilesOnlyPredicate
    implements Predicate<File> {
        private FilesOnlyPredicate() {
        }

        public boolean apply(File file) {
            return !file.isDirectory();
        }
    }

    public static class ZIP {
        public static void zip(File root, List<String> includes, List<String> excludes, OutputStream os) throws IOException {
            Preconditions.checkNotNull((Object)root);
            Preconditions.checkNotNull((Object)os);
            FluentIterable fi = Files.fileTreeTraverser().postOrderTraversal((Object)root);
            ImmutableList fileList = ZIP.nullOrEmpty(includes) && ZIP.nullOrEmpty(excludes) ? fi.filter((Predicate)new FilesOnlyPredicate()).toList() : fi.filter((Predicate)new FileSelectionPredicate(root, includes, excludes)).toList();
            ZIP.zipFiles((List<File>)fileList, root.getAbsolutePath(), os);
        }

        private static boolean nullOrEmpty(List<String> strings) {
            return strings == null || strings.size() == 0;
        }

        private static void zipFiles(List<File> files, String basepath, OutputStream os) throws IOException {
            try (Closer closer = Closer.create();){
                ZipOutputStream zos = new ZipOutputStream(os);
                closer.register((Closeable)zos);
                for (File file : files) {
                    FileInputStream inputStream = new FileInputStream(file);
                    closer.register((Closeable)inputStream);
                    ZIP.writeZipEntry(ZIP.zipEntry(basepath, file), inputStream, zos);
                }
            }
        }

        public static void writeZipEntry(ZipEntry zipEntry, InputStream is, ZipOutputStream zos) throws IOException {
            Closer closer = Closer.create();
            closer.register((Closeable)is);
            try {
                logger.trace((Object)("Adding zip entry" + zipEntry.toString()));
                zos.putNextEntry(zipEntry);
                ByteStreams.copy((InputStream)is, (OutputStream)zos);
                zos.flush();
            }
            catch (IOException ioe) {
                throw closer.rethrow((Throwable)ioe);
            }
            finally {
                closer.close();
            }
        }

        public static void unzip(InputStream is, File outFile) throws IOException {
            try (Closer closer = Closer.create();){
                ZipInputStream zis = new ZipInputStream(is);
                closer.register((Closeable)zis);
                ZipEntry zipEntry = zis.getNextEntry();
                while (zipEntry != null) {
                    File entryFile = new File(outFile, zipEntry.getName());
                    File entryContainer = entryFile.getParentFile();
                    if (!entryContainer.exists()) {
                        entryContainer.mkdirs();
                    }
                    if (!entryFile.isDirectory()) {
                        FileOutputStream outputStream = new FileOutputStream(entryFile);
                        closer.register((Closeable)outputStream);
                        ZIP.unzipEntry(zis, outputStream);
                    }
                    zipEntry = zis.getNextEntry();
                }
            }
        }

        public static void unzipEntry(ZipInputStream zis, OutputStream os) throws IOException {
            Closer closer = Closer.create();
            closer.register((Closeable)os);
            try {
                ByteStreams.copy((InputStream)zis, (OutputStream)os);
            }
            catch (IOException ioe) {
                throw closer.rethrow((Throwable)ioe);
            }
            finally {
                closer.close();
            }
        }

        private static ZipEntry zipEntry(String basepath, File file) {
            String name = Strings.isNullOrEmpty((String)basepath) || basepath.equals(file.getAbsolutePath()) ? file.getPath() : file.getAbsolutePath().substring(basepath.length() + 1);
            return new ZipEntry(name);
        }
    }

    public static class GZIP {
        public static void zip(File file, OutputStream os) throws IOException {
            Preconditions.checkNotNull((Object)file);
            Preconditions.checkNotNull((Object)os);
            try (FileInputStream inputStream = new FileInputStream(file);){
                GZIP.zip(inputStream, os);
            }
        }

        public static void zip(InputStream is, OutputStream os) throws IOException {
            Closer closer = Closer.create();
            closer.register((Closeable)is);
            try {
                GZIPOutputStream zos = new GZIPOutputStream(os);
                closer.register((Closeable)zos);
                ByteStreams.copy((InputStream)is, (OutputStream)zos);
            }
            catch (IOException ioe) {
                throw closer.rethrow((Throwable)ioe);
            }
            finally {
                closer.close();
            }
        }

        public static void unzip(InputStream is, File file) throws IOException {
            Preconditions.checkNotNull((Object)is);
            Preconditions.checkNotNull((Object)file);
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                GZIP.unzip(is, outputStream);
            }
        }

        public static void unzip(InputStream is, OutputStream os) throws IOException {
            Closer closer = Closer.create();
            closer.register((Closeable)os);
            try {
                GZIPInputStream gis = new GZIPInputStream(is);
                closer.register((Closeable)gis);
                ByteStreams.copy((InputStream)gis, (OutputStream)os);
            }
            catch (IOException ioe) {
                throw closer.rethrow((Throwable)ioe);
            }
            finally {
                closer.close();
            }
        }
    }
}

