/* /////////////////////////////////////////////////////////////////////////
 * File:        winstl/time/functions.h
 *
 * Purpose:     Time manipulation functions.
 *
 * Created:     21st November 2003
 * Updated:     10th August 2009
 *
 * Home:        http://stlsoft.org/
 *
 * Copyright (c) 2003-2009, Matthew Wilson and Synesis Software
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * - Neither the name(s) of Matthew Wilson and Synesis Software nor the names of
 *   any contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * ////////////////////////////////////////////////////////////////////// */


/** \file winstl/time/functions.h
 *
 * \brief [C, C++] Main include file that includes all WinSTL time function
 *   include files
 *   (\ref group__library__time "Time" Library).
 */

#ifndef WINSTL_INCL_WINSTL_TIME_H_FUNCTIONS
#define WINSTL_INCL_WINSTL_TIME_H_FUNCTIONS

#ifndef STLSOFT_DOCUMENTATION_SKIP_SECTION
# define WINSTL_VER_WINSTL_TIME_H_FUNCTIONS_MAJOR       5
# define WINSTL_VER_WINSTL_TIME_H_FUNCTIONS_MINOR       0
# define WINSTL_VER_WINSTL_TIME_H_FUNCTIONS_REVISION    3
# define WINSTL_VER_WINSTL_TIME_H_FUNCTIONS_EDIT        39
#endif /* !STLSOFT_DOCUMENTATION_SKIP_SECTION */

/* /////////////////////////////////////////////////////////////////////////
 * Includes
 */

#ifndef WINSTL_INCL_WINSTL_H_WINSTL
# include <winstl/winstl.h>
#endif /* !WINSTL_INCL_WINSTL_H_WINSTL */
#ifndef WINSTL_INCL_WINSTL_TIME_H_COMPARISON_FUNCTIONS
# include <winstl/time/comparison_functions.h>
#endif /* !WINSTL_INCL_WINSTL_TIME_H_COMPARISON_FUNCTIONS */
#ifndef WINSTL_INCL_WINSTL_TIME_H_CONVERSION_FUNCTIONS
# include <winstl/time/conversion_functions.h>
#endif /* !WINSTL_INCL_WINSTL_TIME_H_CONVERSION_FUNCTIONS */
#ifdef __cplusplus
# ifndef WINSTL_INCL_WINSTL_TIME_HPP_FORMAT_FUNCTIONS
#  include <winstl/time/format_functions.hpp>
# endif /* !WINSTL_INCL_WINSTL_TIME_HPP_FORMAT_FUNCTIONS */
#endif /* __cplusplus */

/* ////////////////////////////////////////////////////////////////////// */

#endif /* WINSTL_INCL_WINSTL_TIME_H_FUNCTIONS */

/* ///////////////////////////// end of file //////////////////////////// */
