/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.resourcemanager.core.properties;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.core.properties.PACommonProperties;
import org.ow2.proactive.core.properties.PACommonPropertiesHelper;
import org.ow2.proactive.core.properties.PropertyType;
import org.ow2.proactive.utils.PAPropertiesLazyLoader;

@PublicAPI
public enum PAResourceManagerProperties implements PACommonProperties
{
    RM_NODE_NAME("pa.rm.node.name", PropertyType.STRING, "RM_NODE"),
    RM_NODE_SOURCE_PING_FREQUENCY("pa.rm.node.source.ping.frequency", PropertyType.INTEGER, "45000"),
    RM_CLIENT_PING_FREQUENCY("pa.rm.client.ping.frequency", PropertyType.INTEGER, "45000"),
    RM_SELECT_SCRIPT_TIMEOUT("pa.rm.select.script.timeout", PropertyType.INTEGER, "60000"),
    RM_SELECT_SCRIPT_CACHE_SIZE("pa.rm.select.script.cache", PropertyType.INTEGER, "10000"),
    RM_SELECT_SCRIPT_NODE_DYNAMICITY("pa.rm.select.node.dynamicity", PropertyType.INTEGER, "300000"),
    RM_EXECUTE_SCRIPT_TIMEOUT("pa.rm.execute.script.timeout", PropertyType.INTEGER, "600000"),
    RM_EXECUTE_SCRIPT_AUTHORIZED_DIR("pa.rm.select.script.authorized.dir", PropertyType.STRING),
    RM_EXECUTE_SCRIPT_AUTHORIZED_DIR_REFRESHPERIOD("pa.rm.select.script.authorized.dir.refreshperiod", PropertyType.INTEGER, "60000"),
    RM_NODELOOKUP_TIMEOUT("pa.rm.nodelookup.timeout", PropertyType.INTEGER, "60000"),
    RM_GCM_TEMPLATE_APPLICATION_FILE("pa.rm.gcm.template.application.file", PropertyType.STRING, "config/rm/deployment/GCMNodeSourceApplication.xml"),
    RM_GCMD_PATH_PROPERTY_NAME("pa.rm.gcmd.path.property.name", PropertyType.STRING, "gcmd.file"),
    RM_EC2_PATH_PROPERTY_NAME("pa.rm.ec2.properties", PropertyType.STRING, "config/rm/deployment/ec2.properties"),
    RM_HOME("pa.rm.home", PropertyType.STRING, "."),
    RM_AUTH_JAAS_PATH("pa.rm.auth.jaas.path", PropertyType.STRING, "config/authentication/jaas.config"),
    RM_AUTH_PRIVKEY_PATH("pa.rm.auth.privkey.path", PropertyType.STRING, "config/authentication/keys/priv.key"),
    RM_AUTH_PUBKEY_PATH("pa.rm.auth.pubkey.path", PropertyType.STRING, "config/authentication/keys/pub.key"),
    RM_LOGIN_METHOD("pa.rm.authentication.loginMethod", PropertyType.STRING, "RMFileLoginMethod"),
    RM_LDAP_CONFIG("pa.rm.ldap.config.path", PropertyType.STRING, "config/authentication/ldap.cfg"),
    RM_MULTI_LDAP_CONFIG("pa.rm.multi.ldap.config", PropertyType.LIST),
    RM_LOGIN_FILE("pa.rm.defaultloginfilename", PropertyType.STRING, "config/authentication/login.cfg"),
    RM_GROUP_FILE("pa.rm.defaultgroupfilename", PropertyType.STRING, "config/authentication/group.cfg"),
    RM_TENANT_FILE("pa.rm.defaulttenantfilename", PropertyType.STRING, "config/authentication/tenant.cfg"),
    RM_ALLOWED_DOMAINS("pa.rm.allowed.domains", PropertyType.LIST),
    RM_JMX_CONNECTOR_NAME("pa.rm.jmx.connectorname", PropertyType.STRING, "JMXRMAgent"),
    RM_JMX_PORT("pa.rm.jmx.port", PropertyType.INTEGER, "5822"),
    RM_RRD_DATABASE_NAME("pa.rm.jmx.rrd.name", PropertyType.STRING, "data/rm_statistics.rrd"),
    RM_RRD_STEP("pa.rm.jmx.rrd.step", PropertyType.INTEGER, "4"),
    RM_NODESOURCE_INFRASTRUCTURE_FILE("pa.rm.nodesource.infrastructures", PropertyType.STRING, "config/rm/nodesource/infrastructures"),
    RM_NODESOURCE_POLICY_FILE("pa.rm.nodesource.policies", PropertyType.STRING, "config/rm/nodesource/policies"),
    RM_NODESOURCE_INFRA_POLICY_MAPPING("pa.rm.nodesource.infra.policy.mapping", PropertyType.STRING, "config/rm/nodesource/infrastructures-policies-mapping"),
    RM_SCHEDULER_AWARE_POLICY_NODESOURCE_RECOVERY_TIMEOUT("pa.rm.scheduler.aware.policy.nodesource.recovery.timeout", PropertyType.INTEGER, "10000"),
    RM_SCHEDULER_AWARE_POLICY_NODESOURCE_RECOVERY_TRIAL_NUMBER("pa.rm.scheduler.aware.policy.nodesource.recovery.trial.number", PropertyType.INTEGER, "10"),
    RM_NODESOURCE_MAX_THREAD_NUMBER("pa.rm.nodesource.maxthreadnumber", PropertyType.INTEGER, "75"),
    RM_SELECTION_POLICY("pa.rm.selection.policy", PropertyType.STRING, "org.ow2.proactive.resourcemanager.selection.policies.ShufflePolicy"),
    RM_SELECTION_MAX_THREAD_NUMBER("pa.rm.selection.maxthreadnumber", PropertyType.INTEGER, "50"),
    RM_MONITORING_MAX_THREAD_NUMBER("pa.rm.monitoring.maxthreadnumber", PropertyType.INTEGER, "5"),
    RM_CLEANING_MAX_THREAD_NUMBER("pa.rm.cleaning.maxthreadnumber", PropertyType.INTEGER, "5"),
    RM_HISTORY_MAX_PERIOD("pa.rm.history.maxperiod", PropertyType.INTEGER),
    RM_HISTORY_REMOVAL_CRONPERIOD("pa.rm.history.removal.cronperiod", PropertyType.STRING, "*/10 * * * *"),
    RM_UNAVAILABLE_NODES_REMOVAL_FREQUENCY("pa.rm.nodes.unavailable.removal.frequency", PropertyType.STRING),
    RM_UNAVAILABLE_NODES_MAX_PERIOD("pa.rm.nodes.unavailable.maxperiod", PropertyType.INTEGER),
    RM_INFRASTRUCTURE_PROCESS_OUTPUT_MAX_LINES("pa.rm.infrastructure.process.output.maxlines", PropertyType.INTEGER, "2000"),
    RM_CREDS("pa.rm.credentials", PropertyType.STRING, "config/authentication/rm.cred"),
    RM_DB_HIBERNATE_CONFIG("pa.rm.db.hibernate.configuration", PropertyType.STRING, "config/rm/database.properties"),
    POLICY_RELOAD_FREQUENCY_IN_SECONDS("pa.rm.auth.policy.refreshperiod.seconds", PropertyType.INTEGER, "30"),
    RM_DB_HIBERNATE_DROPDB("pa.rm.db.hibernate.dropdb", PropertyType.BOOLEAN, "false"),
    RM_DB_HIBERNATE_DROPDB_NODESOURCES("pa.rm.db.hibernate.dropdb.nodesources", PropertyType.BOOLEAN, "false"),
    RM_ALIVE_EVENT_FREQUENCY("pa.rm.aliveevent.frequency", PropertyType.INTEGER, "300000"),
    RM_ACCOUNT_REFRESH_RATE("pa.rm.account.refreshrate", PropertyType.INTEGER, "180"),
    RM_TOPOLOGY_ENABLED("pa.rm.topology.enabled", PropertyType.BOOLEAN, "true"),
    RM_TOPOLOGY_DISTANCE_ENABLED("pa.rm.topology.distance.enabled", PropertyType.BOOLEAN, "false"),
    RM_TOPOLOGY_PINGER("pa.rm.topology.pinger.class", PropertyType.STRING, "org.ow2.proactive.resourcemanager.frontend.topology.pinging.HostsPinger"),
    RM_SELECTION_LOGS_LOCATION("pa.rm.logs.selection.location", PropertyType.STRING, "logs/jobs/"),
    RM_SELECTION_LOGS_MAX_SIZE("pa.rm.logs.selection.max.size", PropertyType.STRING, "10000"),
    RM_NB_LOCAL_NODES("pa.rm.local.nodes.number", PropertyType.INTEGER, "-1"),
    RM_SHUTDOWN_KILL_RUNTIME("pa.rm.shutdown.kill.rt", PropertyType.BOOLEAN, "true"),
    RM_SHUTDOWN_TIMEOUT("pa.rm.shutdown.timeout", PropertyType.INTEGER, "300"),
    RM_NODES_LOCK_RESTORATION("pa.rm.nodes.lock.restoration", PropertyType.BOOLEAN, "true"),
    RM_PRESERVE_NODES_ON_SHUTDOWN("pa.rm.preserve.nodes.on.shutdown", PropertyType.BOOLEAN, "false"),
    RM_NODES_RECOVERY("pa.rm.nodes.recovery", PropertyType.BOOLEAN, "true"),
    RM_NODES_DB_OPERATIONS_DELAY("pa.rm.node.db.operations.delay", PropertyType.INTEGER, "100"),
    RM_NODES_DB_SYNCHRONOUS_UPDATES("pa.rm.nodes.db.operations.update.synchronous", PropertyType.BOOLEAN, "true"),
    RM_DB_ITEMS_MAX_SIZE("pa.rm.db.items.max.size", PropertyType.INTEGER, "1000"),
    RM_CLOUD_INFRASTRUCTURES_DESTROY_INSTANCES_ON_SHUTDOWN("pa.rm.cloud.infrastructures.destroy.instances.on.shutdown", PropertyType.BOOLEAN, "false"),
    RM_REST_MONITORING_MAXIMUM_CHUNK_SIZE("pa.rm.rest.monitoring.maximum.chunk.size", PropertyType.INTEGER, "100"),
    LOG4J_ASYNC_APPENDER_ENABLED("pa.log4j.async.appender.enabled", PropertyType.BOOLEAN, "true"),
    LOG4J_ASYNC_APPENDER_CACHE_ENABLED("pa.log4j.async.appender.cache.enabled", PropertyType.BOOLEAN, "false"),
    LOG4J_ASYNC_APPENDER_BUFFER_SIZE("pa.log4j.async.appender.buffer.size", PropertyType.INTEGER, "50000"),
    LOG4J_ASYNC_APPENDER_FLUSH_TIMOUT("pa.log4j.async.appender.flush.timeout", PropertyType.INTEGER, "50"),
    LO4J_FILE_APPENDER_PATTERN("pa.log4j.file.appender.pattern", PropertyType.STRING, "%d{ISO8601} %-5p [%c{1.}] %m%n"),
    JSCH_ADDITIONAL_CIPHERS("pa.jsch.additional.ciphers", PropertyType.LIST, "aes128-cbc,aes192-cbc,aes256-cbc,3des-cbc"),
    JSCH_ADDITIONAL_KEX_ALGORITHMS("pa.jsch.additional.kexalgorithms", PropertyType.LIST, "diffie-hellman-group-exchange-sha1,diffie-hellman-group14-sha1"),
    JSCH_ADDITIONAL_MACS("pa.jsch.additional.macs", PropertyType.LIST),
    JSCH_ADDITIONAL_SERVER_HOST_KEYS("pa.jsch.additional.host.keys", PropertyType.LIST, "ssh-rsa");

    public static final String PA_RM_PROPERTIES_FILEPATH = "pa.rm.properties.filepath";
    public static final String PA_RM_PROPERTIES_RELATIVE_FILEPATH = "config/rm/settings.ini";
    private static PAPropertiesLazyLoader propertiesLoader;
    private static PACommonPropertiesHelper propertiesHelper;
    private String key;
    private PropertyType type;
    private String defaultValue;

    private PAResourceManagerProperties(String str, PropertyType type, String defaultValue) {
        this.key = str;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    private PAResourceManagerProperties(String str, PropertyType type) {
        this(str, type, null);
    }

    protected static void loadProperties(String filename) {
        propertiesLoader = new PAPropertiesLazyLoader(PAResourceManagerProperties.RM_HOME.key, PA_RM_PROPERTIES_FILEPATH, PA_RM_PROPERTIES_RELATIVE_FILEPATH, filename);
        propertiesHelper = new PACommonPropertiesHelper(propertiesLoader);
    }

    public static synchronized void reload() {
        propertiesLoader = new PAPropertiesLazyLoader(PAResourceManagerProperties.RM_HOME.key, PA_RM_PROPERTIES_FILEPATH, PA_RM_PROPERTIES_RELATIVE_FILEPATH);
        propertiesHelper = new PACommonPropertiesHelper(propertiesLoader);
    }

    public static void updateProperties(String filename) {
        propertiesHelper.updateProperties(filename);
    }

    public static Map<String, Object> getPropertiesAsHashMap() {
        return propertiesHelper.getPropertiesAsHashMap();
    }

    public static String getAbsolutePath(String userPath) {
        if (new File(userPath).isAbsolute()) {
            return userPath;
        }
        File pathName = new File(RM_HOME.getValueAsString(), userPath);
        try {
            return pathName.getCanonicalPath();
        }
        catch (IOException e) {
            return pathName.getAbsolutePath();
        }
    }

    public String getConfigurationFilePathPropertyName() {
        return PA_RM_PROPERTIES_FILEPATH;
    }

    public String getConfigurationDefaultRelativeFilePath() {
        return PA_RM_PROPERTIES_RELATIVE_FILEPATH;
    }

    public void loadPropertiesFromFile(String filename) {
        PAResourceManagerProperties.loadProperties(filename);
    }

    public void reloadConfiguration() {
        PAResourceManagerProperties.reload();
    }

    public String getKey() {
        return this.key;
    }

    public void updateProperty(String value) {
        propertiesHelper.updateProperty(this.key, value);
    }

    public boolean isSet() {
        return propertiesHelper.isSet(this.key, this.defaultValue);
    }

    public void unSet() {
        propertiesHelper.unSet(this.key);
    }

    public String getCmdLine() {
        return propertiesHelper.getCmdLine(this.key);
    }

    public int getValueAsInt() {
        return propertiesHelper.getValueAsInt(this.key, this.type, this.defaultValue);
    }

    public long getValueAsLong() {
        return propertiesHelper.getValueAsLong(this.key, this.type, this.defaultValue);
    }

    public String getValueAsString() {
        return propertiesHelper.getValueAsString(this.key, this.defaultValue);
    }

    public String getValueAsStringOrNull() {
        return propertiesHelper.getValueAsStringOrNull(this.key);
    }

    public boolean getValueAsBoolean() {
        return propertiesHelper.getValueAsBoolean(this.key, this.type, this.defaultValue);
    }

    public List<String> getValueAsList(String separator) {
        return propertiesHelper.getValueAsList(this.key, this.type, separator, false, this.defaultValue);
    }

    public List<String> getValueAsList(String separator, boolean allowEmpty) {
        return propertiesHelper.getValueAsList(this.key, this.type, separator, allowEmpty, this.defaultValue);
    }

    public PropertyType getType() {
        return this.type;
    }

    public String toString() {
        return this.getValueAsString();
    }

    static {
        PAResourceManagerProperties.reload();
    }
}

