/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive_grid_cloud_portal.scheduler.client;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.ow2.proactive_grid_cloud_portal.common.SchedulerRestInterface;
import org.ow2.proactive_grid_cloud_portal.scheduler.client.SchedulerRestClient;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobIdData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobResultData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.JobStateData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.RestMapPage;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.SchedulerUserData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskResultData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.TaskStateData;
import org.ow2.proactive_grid_cloud_portal.scheduler.dto.UserJobData;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.UnknownJobRestException;

public class SchedulerClientExample {
    public static void main(String[] args) throws Exception {
        JobIdData xmlJob;
        SchedulerRestClient client = new SchedulerRestClient("http://localhost:9191/rest/rest/");
        SchedulerRestInterface scheduler = client.getScheduler();
        String sessionId = scheduler.login("admin", "admin");
        File xmlJobFile = new File("/home/ybonnaffe/src/cloud_service_provider_conectors/cloudstack/vminfo_job.xml");
        try (FileInputStream inputStream = new FileInputStream(xmlJobFile);){
            xmlJob = client.submitXml(sessionId, inputStream);
        }
        System.out.println(xmlJob.getReadableName() + " " + xmlJob.getId());
        JobIdData flatJob = scheduler.submitFlat(sessionId, "echo hello", "test-hello", null, null);
        System.out.println("Jobid=" + flatJob);
        String serverlog = scheduler.jobServerLog(sessionId, Long.toString(flatJob.getId()));
        System.out.println(serverlog);
        while (true) {
            JobStateData jobState2 = scheduler.listJobs(sessionId, Long.toString(flatJob.getId()));
            System.out.println(jobState2);
            if (jobState2.getJobInfo().getStatus().name().equals("FINISHED")) break;
            Thread.sleep(100L);
        }
        JobResultData jobResultData = scheduler.jobResult(sessionId, Long.toString(flatJob.getId()));
        System.out.println(jobResultData);
        TaskResultData taskresult = scheduler.taskResult(sessionId, Long.toString(flatJob.getId()), "task_1");
        System.out.println(taskresult);
        List<TaskStateData> jobTaskStates = scheduler.getJobTaskStates(sessionId, Long.toString(flatJob.getId())).getList();
        System.out.println(jobTaskStates);
        TaskStateData task_1 = scheduler.jobTask(sessionId, Long.toString(flatJob.getId()), "task_1");
        System.out.println(task_1);
        List<SchedulerUserData> users = scheduler.getUsers(sessionId);
        System.out.println(users);
        System.out.println(users.size());
        RestMapPage<Long, ArrayList<UserJobData>> page = scheduler.revisionAndJobsInfo(sessionId, 0, 50, true, true, true, true);
        Map<Long, ArrayList<UserJobData>> map = page.getMap();
        System.out.println(map);
        System.out.println((Object)scheduler.getSchedulerStatus(sessionId));
        System.out.println(scheduler.getUsageOnMyAccount(sessionId, new Date(), new Date()));
        try {
            JobStateData jobState = scheduler.listJobs(sessionId, "601");
            System.out.println(jobState);
        }
        catch (UnknownJobRestException e) {
            System.err.println("exception! " + e.getMessage());
            e.printStackTrace();
        }
    }
}

