/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.smartproxy.common;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jdbm.PrimaryHashMap;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import org.apache.log4j.Logger;
import org.ow2.proactive.scheduler.smartproxy.common.AwaitedJob;
import org.ow2.proactive.scheduler.smartproxy.common.AwaitedTask;

public class JobDatabase {
    private static final Logger log = Logger.getLogger(JobDatabase.class);
    protected static final String TMPDIR = System.getProperty("java.io.tmpdir");
    protected static final String DEFAULT_STATUS_FILENAME = "SmartProxy";
    protected static String sessionName = "SmartProxy";
    public static File statusFile = new File(TMPDIR, sessionName);
    public static final String STATUS_RECORD_NAME = "AWAITED_JOBS";
    protected RecordManager recMan;
    ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
    protected PrimaryHashMap<String, AwaitedJob> awaitedJobs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanDataBase() {
        try {
            File[] dbJobFiles;
            this.writeLock.lock();
            if (this.recMan != null) {
                throw new IllegalStateException("Connection to a DB is established, cannot clean it");
            }
            log.info((Object)"Cleaning database");
            for (File file : dbJobFiles = new File(TMPDIR).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(sessionName);
                }
            })) {
                try {
                    log.info((Object)("Deleting " + file));
                    file.delete();
                }
                catch (Exception e) {
                    log.info((Object)"Error while deleting file during database cleanup", (Throwable)e);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void commit() throws IOException {
        try {
            this.writeLock.lock();
            this.recMan.commit();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void discardAllJobs() {
        try {
            this.writeLock.lock();
            this.awaitedJobs.clear();
            log.info((Object)"Proxy's database has been reseted.");
            try {
                this.recMan.commit();
            }
            catch (IOException e) {
                log.error((Object)"Exception occured while closing connection to status file:", (Throwable)e);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void discardJob(String jobID) {
        try {
            this.writeLock.lock();
            if (this.awaitedJobs.containsKey((Object)jobID)) {
                this.awaitedJobs.remove((Object)jobID);
                try {
                    this.recMan.commit();
                }
                catch (IOException e) {
                    log.error((Object)"Exception occured while closing connection to status file:", (Throwable)e);
                }
            } else {
                log.warn((Object)("Job " + jobID + " is not handled by the proxy."));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<String> getAwaitedJobsIds() {
        try {
            this.readLock.lock();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.awaitedJobs.keySet());
            return linkedHashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public AwaitedJob getAwaitedJob(String id) {
        try {
            this.readLock.lock();
            AwaitedJob awaitedJob = (AwaitedJob)this.awaitedJobs.get((Object)id);
            return awaitedJob;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void loadJobs() {
        this.loadJobs(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJobs(boolean firstAttempt) {
        block8: {
            try {
                this.writeLock.lock();
                this.closeRecordManager();
                try {
                    this.recMan = RecordManagerFactory.createRecordManager((String)statusFile.getCanonicalPath());
                    this.awaitedJobs = this.recMan.hashMap(STATUS_RECORD_NAME);
                    for (Map.Entry entry : this.awaitedJobs.entrySet()) {
                    }
                    this.recMan.commit();
                    if (!firstAttempt) {
                        log.info((Object)"Loading of job database successful after clean.");
                    }
                }
                catch (Throwable e) {
                    if (firstAttempt) {
                        log.error((Object)("Error occurred when loading job database " + statusFile.getAbsolutePath() + ", now cleaning it and retrying."), e);
                        this.closeRecordManager();
                        this.recMan = null;
                        this.cleanDataBase();
                        this.loadJobs(false);
                        break block8;
                    }
                    this.closeRecordManager();
                    throw new IllegalStateException("Error when loading database (even after cleaning it): " + statusFile.getAbsolutePath(), e);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private void closeRecordManager() {
        if (this.recMan != null) {
            try {
                this.recMan.close();
            }
            catch (IOException e1) {
                log.trace((Object)"Error when closing record manager", (Throwable)e1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAwaitedJob(String id, AwaitedJob awaitedJob) {
        try {
            this.writeLock.lock();
            if (!awaitedJob.getJobId().equals(id)) {
                throw new IllegalArgumentException("given id " + id + " is different from job id : " + awaitedJob.getJobId());
            }
            this.awaitedJobs.put((Object)id, (Object)awaitedJob);
            try {
                this.recMan.commit();
            }
            catch (IOException e) {
                log.error((Object)("Could not save status file after adding job on awaited jobs list " + awaitedJob.getJobId()), (Throwable)e);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public AwaitedJob removeAwaitedJob(String id) {
        try {
            this.writeLock.lock();
            AwaitedJob awaitedJob = (AwaitedJob)this.awaitedJobs.remove((Object)id);
            return awaitedJob;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setSessionName(String name) {
        try {
            this.writeLock.lock();
            if (this.awaitedJobs != null) {
                throw new IllegalStateException("Session already started, try calling setSessionName before calling init");
            }
            if (name != null && !name.matches("\\w+")) {
                throw new IllegalArgumentException("Session Name must be an alphanumerical word.");
            }
            sessionName = name == null ? DEFAULT_STATUS_FILENAME : name;
            statusFile = new File(TMPDIR, sessionName);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskTransferring(String id, String taskName, boolean transferring) {
        try {
            this.writeLock.lock();
            AwaitedJob aj = (AwaitedJob)this.awaitedJobs.get((Object)id);
            if (aj == null) {
                log.warn((Object)("Job " + id + " not in the awaited list"));
                return;
            }
            AwaitedTask at = aj.getAwaitedTask(taskName);
            if (at == null) {
                log.warn((Object)("Task " + taskName + " from Job " + id + " not in the awaited list"));
                return;
            }
            at.setTransferring(transferring);
            this.awaitedJobs.put((Object)id, (Object)aj);
            try {
                this.recMan.commit();
            }
            catch (IOException e) {
                log.error((Object)("Could not save status file after setting transferring mode to task Task " + taskName + " from Job" + id), (Throwable)e);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void close() {
        try {
            this.writeLock.lock();
            if (this.recMan != null) {
                try {
                    this.recMan.close();
                    this.recMan = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

