/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive_grid_cloud_portal.common;

import java.io.IOException;
import java.security.KeyException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.LoginException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jboss.resteasy.annotations.providers.multipart.MultipartForm;
import org.ow2.proactive.authentication.InputUserInfo;
import org.ow2.proactive.authentication.OutputUserInfo;
import org.ow2.proactive.authentication.UserData;
import org.ow2.proactive_grid_cloud_portal.common.dto.JAASConfiguration;
import org.ow2.proactive_grid_cloud_portal.common.dto.LoginForm;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.LoginRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.NotConnectedRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.PermissionRestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.RestException;
import org.ow2.proactive_grid_cloud_portal.scheduler.exception.SchedulerRestException;

@Path(value="/common")
@Produces(value={"application/json"})
public interface CommonRestInterface {
    @POST
    @Path(value="login")
    @Produces(value={"text/plain", "application/json"})
    public String login(@FormParam(value="username") String var1, @FormParam(value="password") String var2) throws LoginException, SchedulerRestException;

    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="login")
    @Produces(value={"text/plain", "application/json"})
    public String loginWithCredential(@MultipartForm LoginForm var1) throws KeyException, LoginException, SchedulerRestException;

    @PUT
    @Path(value="logout")
    public void logout(@HeaderParam(value="sessionid") String var1) throws RestException;

    @GET
    @Path(value="connected")
    @Produces(value={"application/json"})
    public boolean isConnected(@HeaderParam(value="sessionid") String var1);

    @POST
    @Path(value="tokens")
    @Produces(value={"application/json"})
    public Set<String> generateTokens(@HeaderParam(value="sessionid") String var1, @QueryParam(value="numberTokens") @DefaultValue(value="1") int var2);

    @GET
    @Path(value="currentuser")
    @Produces(value={"text/plain"})
    public String currentUser(@HeaderParam(value="sessionid") String var1);

    @GET
    @Path(value="currentuserdata")
    @Produces(value={"application/json"})
    public UserData currentUserData(@HeaderParam(value="sessionid") String var1);

    @GET
    @Path(value="permissions/portals")
    @Produces(value={"application/json"})
    public List<String> portalsAccesses(@HeaderParam(value="sessionid") String var1, @QueryParam(value="portals") List<String> var2) throws RestException;

    @GET
    @Path(value="permissions/portals/{portal}")
    @Produces(value={"application/json"})
    public boolean portalAccess(@HeaderParam(value="sessionid") String var1, @PathParam(value="portal") String var2) throws RestException;

    @GET
    @Path(value="manager/groups")
    @Produces(value={"application/json"})
    public JAASConfiguration permissionManagerGroupsRead(@HeaderParam(value="sessionid") String var1) throws RestException, IOException;

    @PUT
    @Path(value="manager/groups")
    @Produces(value={"application/json"})
    public JAASConfiguration permissionManagerGroupsWrite(@HeaderParam(value="sessionid") String var1, JAASConfiguration var2) throws RestException, IOException;

    @GET
    @Path(value="permissions/notification-service/admin")
    @Produces(value={"application/json"})
    public boolean checkSubscriptionAdmin(@HeaderParam(value="sessionid") String var1) throws RestException;

    @GET
    @Path(value="permissions/cloud-automation-service/admin")
    @Produces(value={"application/json"})
    public boolean checkPcaAdmin(@HeaderParam(value="sessionid") String var1) throws RestException;

    @GET
    @Path(value="logger")
    @Produces(value={"application/json"})
    public String getLogLevel(@HeaderParam(value="sessionid") String var1, @QueryParam(value="name") String var2) throws RestException;

    @PUT
    @Path(value="logger")
    @Produces(value={"application/json"})
    public boolean setLogLevel(@HeaderParam(value="sessionid") String var1, @QueryParam(value="name") String var2, @QueryParam(value="level") String var3) throws RestException;

    @POST
    @Path(value="logger")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public boolean setLogLevelMultiple(@HeaderParam(value="sessionid") String var1, Map<String, String> var2) throws RestException;

    @GET
    @Path(value="logger/current")
    @Produces(value={"application/json"})
    public Map<String, String> getCurrentLoggers(@HeaderParam(value="sessionid") String var1) throws RestException;

    @POST
    @Path(value="permissions/methods")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Map<String, Boolean> checkPermissions(@HeaderParam(value="sessionid") String var1, List<String> var2) throws RestException;

    @POST
    @Path(value="permissions/roles")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Map<String, Boolean> checkRolePermissions(@HeaderParam(value="sessionid") String var1, List<String> var2) throws RestException;

    @POST
    @Path(value="manager/users")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<OutputUserInfo> createUser(@HeaderParam(value="sessionid") String var1, InputUserInfo var2) throws NotConnectedRestException, PermissionRestException, LoginRestException;

    @GET
    @Path(value="manager/users")
    @Produces(value={"application/json"})
    public List<OutputUserInfo> listUsers(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException, LoginRestException;

    @GET
    @Path(value="manager/users/{username}")
    @Produces(value={"application/json"})
    public OutputUserInfo getUserDetails(@HeaderParam(value="sessionid") String var1, @PathParam(value="username") String var2) throws NotConnectedRestException, PermissionRestException, LoginRestException;

    @PUT
    @Path(value="manager/users/{username}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<OutputUserInfo> editUser(@HeaderParam(value="sessionid") String var1, @PathParam(value="username") String var2, InputUserInfo var3) throws NotConnectedRestException, PermissionRestException, LoginRestException;

    @DELETE
    @Path(value="manager/users/{username}")
    @Produces(value={"application/json"})
    public List<OutputUserInfo> deleteUser(@HeaderParam(value="sessionid") String var1, @PathParam(value="username") String var2) throws NotConnectedRestException, PermissionRestException, LoginRestException;

    @GET
    @Path(value="manager/tenants")
    @Produces(value={"application/json"})
    public Map<String, Collection<String>> listTenants(@HeaderParam(value="sessionid") String var1) throws NotConnectedRestException, PermissionRestException, LoginRestException;

    @PUT
    @Path(value="manager/tenants/{tenant}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Map<String, Collection<String>> addOrEditTenant(@HeaderParam(value="sessionid") String var1, @PathParam(value="tenant") String var2, Collection<String> var3) throws NotConnectedRestException, PermissionRestException, LoginRestException;

    @DELETE
    @Path(value="manager/tenants/{tenant}")
    @Produces(value={"application/json"})
    public Map<String, Collection<String>> removeTenant(@HeaderParam(value="sessionid") String var1, @PathParam(value="tenant") String var2) throws NotConnectedRestException, PermissionRestException, LoginRestException;
}

