/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.job.Job;
import org.ow2.proactive.scheduler.common.job.JobId;
import org.ow2.proactive.scheduler.common.job.JobInfo;
import org.ow2.proactive.scheduler.common.job.JobPriority;
import org.ow2.proactive.scheduler.common.job.JobStatus;
import org.ow2.proactive.scheduler.common.task.TaskId;
import org.ow2.proactive.scheduler.common.task.TaskInfo;
import org.ow2.proactive.scheduler.common.task.TaskState;
import org.ow2.proactive.scheduler.common.task.TaskStatesPage;
import org.ow2.proactive.scheduler.common.task.TaskStatus;
import org.ow2.proactive.scheduler.common.util.PageBoundaries;
import org.ow2.proactive.scheduler.common.util.Pagination;
import org.ow2.proactive.scheduler.core.properties.PASchedulerProperties;
import org.ow2.proactive.scheduler.task.SchedulerVars;

@PublicAPI
public abstract class JobState
extends Job
implements Comparable<JobState> {
    public static int PENDING_RANK = 2;
    public static int RUNNING_RANK = 1;
    public static int FINISHED_RANK = 0;
    public static final int SORT_BY_ID = 1;
    public static final int SORT_BY_NAME = 2;
    public static final int SORT_BY_PRIORITY = 3;
    public static final int SORT_BY_TYPE = 4;
    public static final int SORT_BY_DESCRIPTION = 5;
    public static final int SORT_BY_OWNER = 6;
    public static final int SORT_BY_STATUS = 7;
    public static final int SORT_BY_PROJECT = 8;
    public static final int ASC_ORDER = 1;
    public static final int DESC_ORDER = 2;
    private static int currentSort = 1;
    private static int currentOrder = 1;
    private static final long serialVersionUID = 142L;

    public abstract void update(TaskInfo var1);

    public abstract void update(JobInfo var1);

    public static void setSortingBy(int sortBy) {
        currentSort = sortBy;
    }

    public static void setSortingOrder(int order) {
        currentOrder = order == 1 || order == 2 ? order : 1;
    }

    @Override
    public int compareTo(JobState job) {
        switch (currentSort) {
            case 5: {
                return currentOrder == 1 ? this.description.compareTo(job.description) : job.description.compareTo(this.description);
            }
            case 2: {
                return currentOrder == 1 ? this.name.compareTo(job.name) : job.name.compareTo(this.name);
            }
            case 3: {
                return currentOrder == 1 ? this.getJobInfo().getPriority().getPriority() - job.getJobInfo().getPriority().getPriority() : job.getJobInfo().getPriority().getPriority() - this.getJobInfo().getPriority().getPriority();
            }
            case 4: {
                return currentOrder == 1 ? this.getType().compareTo(job.getType()) : job.getType().compareTo(this.getType());
            }
            case 6: {
                return currentOrder == 1 ? this.getOwner().compareTo(job.getOwner()) : job.getOwner().compareTo(this.getOwner());
            }
            case 7: {
                return currentOrder == 1 ? this.getJobInfo().getStatus().compareTo(job.getJobInfo().getStatus()) : job.getJobInfo().getStatus().compareTo(this.getJobInfo().getStatus());
            }
            case 8: {
                return currentOrder == 1 ? this.getProjectName().compareTo(job.getProjectName()) : job.getProjectName().compareTo(this.getProjectName());
            }
        }
        return currentOrder == 1 ? this.getId().compareTo(job.getId()) : job.getId().compareTo(this.getId());
    }

    public abstract JobInfo getJobInfo();

    @Override
    public JobId getId() {
        return this.getJobInfo().getJobId();
    }

    @Override
    public JobPriority getPriority() {
        return this.getJobInfo().getPriority();
    }

    public abstract List<TaskState> getTasks();

    public abstract Map<TaskId, TaskState> getHMTasks();

    public List<TaskState> getTasksByTag(String tag) {
        List<TaskState> tasks = this.getTasks();
        return (List)CollectionUtils.select(tasks, object -> {
            String taskTag = ((TaskState)object).getTag();
            return taskTag != null && taskTag.equals(tag);
        });
    }

    public TaskStatesPage getTasksPaginated(int offset, int limit) {
        return this.getTaskStatesPage(offset, limit, this.getTasks());
    }

    public TaskStatesPage getTasksPaginated(String statusFilter, int offset, int limit) {
        return this.getTaskStatesPage(offset, limit, this.filterByStatus(this.getTasks(), statusFilter));
    }

    public TaskStatesPage getTaskByTagPaginated(String tag, int offset, int limit) {
        return this.getTaskStatesPage(offset, limit, this.getTasksByTag(tag));
    }

    public TaskStatesPage getTaskByTagByStatusPaginated(int offset, int limit, String tag, String statusFilter) {
        return this.getTaskStatesPage(offset, limit, this.filterByStatus(this.getTasksByTag(tag), statusFilter));
    }

    private List<TaskState> filterByStatus(List<TaskState> tasks, String statusFilter) {
        List<String> aggregatedStatuses = Arrays.asList(statusFilter.split("\\s*;\\s*"));
        Set<TaskStatus> goodTaskStatuses = TaskStatus.expandAggregatedStatusesToRealStatuses(aggregatedStatuses);
        return tasks.stream().filter(task -> goodTaskStatuses.contains(task.getTaskInfo().getStatus())).collect(Collectors.toList());
    }

    private TaskStatesPage getTaskStatesPage(int offset, int limit, List<TaskState> tasks) {
        PageBoundaries pageBoundaries = Pagination.getTasksPageBoundaries(offset, limit, PASchedulerProperties.TASKS_PAGE_SIZE.getValueAsInt());
        int nbTasks = tasks.size();
        int indexLastItemToReturn = pageBoundaries.getOffset() + pageBoundaries.getLimit();
        offset = pageBoundaries.getOffset();
        if (offset >= nbTasks) {
            offset = 0;
        }
        if (indexLastItemToReturn >= nbTasks) {
            indexLastItemToReturn = nbTasks;
        }
        return new TaskStatesPage(tasks.subList(offset, indexLastItemToReturn), nbTasks);
    }

    public List<String> getTags() {
        HashSet<String> result = new HashSet<String>();
        String tag = null;
        for (TaskState task : this.getTasks()) {
            tag = task.getTag();
            if (tag == null) continue;
            result.add(task.getTag());
        }
        return new ArrayList<String>(result);
    }

    public List<String> getTags(String prefix) {
        HashSet<String> result = new HashSet<String>();
        String tag = null;
        for (TaskState task : this.getTasks()) {
            tag = task.getTag();
            if (tag == null || !tag.startsWith(prefix)) continue;
            result.add(task.getTag());
        }
        return new ArrayList<String>(result);
    }

    public int getNumberOfFinishedTasks() {
        return this.getJobInfo().getNumberOfFinishedTasks();
    }

    public boolean isFinished() {
        return this.getNumberOfFinishedTasks() == this.getTotalNumberOfTasks();
    }

    public long getFinishedTime() {
        return this.getJobInfo().getFinishedTime();
    }

    public int getNumberOfPendingTasks() {
        return this.getJobInfo().getNumberOfPendingTasks();
    }

    public int getNumberOfRunningTasks() {
        return this.getJobInfo().getNumberOfRunningTasks();
    }

    public int getNumberOfFailedTasks() {
        return this.getJobInfo().getNumberOfFailedTasks();
    }

    public int getNumberOfFaultyTasks() {
        return this.getJobInfo().getNumberOfFaultyTasks();
    }

    public int getNumberOfInErrorTasks() {
        return this.getJobInfo().getNumberOfInErrorTasks();
    }

    public long getStartTime() {
        return this.getJobInfo().getStartTime();
    }

    public long getInErrorTime() {
        return this.getJobInfo().getInErrorTime();
    }

    public int getTotalNumberOfTasks() {
        return this.getJobInfo().getTotalNumberOfTasks();
    }

    public long getRemovedTime() {
        return this.getJobInfo().getRemovedTime();
    }

    public long getSubmittedTime() {
        return this.getJobInfo().getSubmittedTime();
    }

    public long getCumulatedCoreTime() {
        return this.getJobInfo().getCumulatedCoreTime();
    }

    public int getNumberOfNodes() {
        return this.getJobInfo().getNumberOfNodes();
    }

    public int getNumberOfNodesInParallel() {
        return this.getJobInfo().getNumberOfNodesInParallel();
    }

    @Override
    public String getSubmissionMode() {
        return this.getJobInfo().getSubmissionMode();
    }

    public JobStatus getStatus() {
        return this.getJobInfo().getStatus();
    }

    public abstract String getOwner();

    public abstract String getTenant();

    public abstract String getDomain();

    public boolean isToBeRemoved() {
        return this.getJobInfo().isToBeRemoved();
    }

    @Override
    public String getName() {
        if (this.getId() == null || this.getId().getReadableName().equals("NOT SET")) {
            return super.getName();
        }
        return this.getId().getReadableName();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof JobState) {
            return this.getId().equals(((JobState)o).getId());
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "]";
    }

    public Map<String, String> getRuntimeGenericInformation() {
        if (this.genericInformation == null) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, Serializable> replacements = new HashMap<String, Serializable>();
        JobId jobId = this.getJobInfo().getJobId();
        if (jobId != null) {
            replacements.put(SchedulerVars.PA_JOB_ID.toString(), (Serializable)((Object)jobId.toString()));
            replacements.put(SchedulerVars.PA_JOB_NAME.toString(), (Serializable)((Object)jobId.getReadableName()));
            replacements.put(SchedulerVars.PA_USER.toString(), (Serializable)((Object)this.getOwner()));
        }
        if (this.variables != null) {
            replacements.putAll(this.variables);
        }
        return JobState.applyReplacementsOnGenericInformation(this.genericInformation, replacements);
    }
}

