/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.core.properties;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.core.properties.PropertyType;
import org.ow2.proactive.utils.PAPropertiesLazyLoader;

@PublicAPI
public class PACommonPropertiesHelper {
    private PAPropertiesLazyLoader propertiesLoader;

    public PACommonPropertiesHelper(PAPropertiesLazyLoader propertiesLoader) {
        this.propertiesLoader = propertiesLoader;
    }

    public synchronized void updateProperty(String key, String value) {
        this.propertiesLoader.getProperties().setProperty(key, value);
    }

    public synchronized boolean isSet(String key, String defaultValue) {
        return defaultValue != null || this.propertiesLoader.getProperties().containsKey(key);
    }

    public synchronized void unSet(String key) {
        this.propertiesLoader.getProperties().remove(key);
    }

    public String getCmdLine(String key) {
        return "-D" + key + '=';
    }

    public synchronized void updateProperties(String filename) {
        Properties prop = this.propertiesLoader.getProperties();
        Properties ptmp = new Properties();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));){
            ptmp.load(reader);
            for (Object o : ptmp.keySet()) {
                prop.setProperty((String)o, (String)ptmp.get(o));
            }
            PAPropertiesLazyLoader.updateWithSystemProperties(prop);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> getPropertiesAsHashMap() {
        return new HashMap<Object, Object>(this.propertiesLoader.getProperties());
    }

    public synchronized int getValueAsInt(String key, PropertyType type, String defaultValue) {
        if (type != PropertyType.INTEGER) {
            throw new IllegalArgumentException("Property " + key + " is not a " + (Object)((Object)PropertyType.INTEGER));
        }
        String valueString = this.getValueAsString(key, defaultValue);
        if (valueString != null) {
            try {
                return Integer.parseInt(valueString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(key + " is not an integer property. getValueAsInt cannot be called on this property");
            }
        }
        throw new IllegalArgumentException("Property " + key + " is undefined and does not declare a default value.");
    }

    public synchronized long getValueAsLong(String key, PropertyType type, String defaultValue) {
        if (type != PropertyType.INTEGER) {
            throw new IllegalArgumentException("Property " + key + " is not a " + (Object)((Object)PropertyType.INTEGER));
        }
        String valueString = this.getValueAsString(key, defaultValue);
        if (valueString != null) {
            try {
                return Long.parseLong(valueString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(key + " is not an integer property. getValueAsInt cannot be called on this property");
            }
        }
        throw new IllegalArgumentException("Property " + key + " is undefined and does not declare a default value.");
    }

    public synchronized String getValueAsString(String key, String defaultValue) {
        Properties prop = this.propertiesLoader.getProperties();
        if (prop.containsKey(key)) {
            return prop.getProperty(key);
        }
        return defaultValue;
    }

    public synchronized List<String> getValueAsList(String key, PropertyType type, String separator, boolean allowEmpty, String defaultValue) {
        if (type != PropertyType.LIST) {
            throw new IllegalArgumentException("Property " + key + " is not a " + (Object)((Object)PropertyType.LIST));
        }
        String valueString = this.getValueAsString(key, defaultValue);
        ArrayList<String> valueList = new ArrayList<String>();
        if (valueString != null) {
            for (String val : valueString.split(Pattern.quote(separator))) {
                val = val.trim();
                if (!allowEmpty && val.length() <= 0) continue;
                valueList.add(val);
            }
        } else {
            throw new IllegalArgumentException("Property " + key + " is undefined and does not declare a default value.");
        }
        return valueList;
    }

    public synchronized String getValueAsStringOrNull(String key) {
        Properties prop = this.propertiesLoader.getProperties();
        if (prop.containsKey(key)) {
            String ret = prop.getProperty(key);
            if ("".equals(ret)) {
                return null;
            }
            return ret;
        }
        return null;
    }

    public synchronized boolean getValueAsBoolean(String key, PropertyType type, String defaultValue) {
        if (type != PropertyType.BOOLEAN) {
            throw new IllegalArgumentException("Property " + key + " is not a " + (Object)((Object)PropertyType.BOOLEAN));
        }
        String valueString = this.getValueAsString(key, defaultValue);
        if (valueString != null) {
            return Boolean.parseBoolean(valueString);
        }
        return false;
    }
}

