# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class VnetInfo(Resource):
    """
    VNETInfo contract. This contract is public and is a stripped down version
    of VNETInfoInternal

    :param str id: Resource Id
    :param str name: Resource Name
    :param str location: Resource Location
    :param str type: Resource type
    :param dict tags: Resource tags
    :param str vnet_resource_id: The vnet resource id
    :param str cert_thumbprint: The client certificate thumbprint
    :param str cert_blob: A certificate file (.cer) blob containing the
     public key of the private key used to authenticate a
     Point-To-Site VPN connection.
    :param list routes: The routes that this virtual network connection uses.
    """

    _required = []

    _attribute_map = {
        'vnet_resource_id': {'key': 'properties.vnetResourceId', 'type': 'str', 'flatten': True},
        'cert_thumbprint': {'key': 'properties.certThumbprint', 'type': 'str', 'flatten': True},
        'cert_blob': {'key': 'properties.certBlob', 'type': 'str', 'flatten': True},
        'routes': {'key': 'properties.routes', 'type': '[VnetRoute]', 'flatten': True},
    }

    def __init__(self, location, id=None, name=None, type=None, tags=None, vnet_resource_id=None, cert_thumbprint=None, cert_blob=None, routes=None):
        super(VnetInfo, self).__init__(id=id, name=name, location=location, type=type, tags=tags)
        self.vnet_resource_id = vnet_resource_id
        self.cert_thumbprint = cert_thumbprint
        self.cert_blob = cert_blob
        self.routes = routes
