# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class RestoreRequest(Resource):
    """
    Description of a restore request

    :param str id: Resource Id
    :param str name: Resource Name
    :param str location: Resource Location
    :param str type: Resource type
    :param dict tags: Resource tags
    :param str storage_account_url: SAS URL to the container
    :param str blob_name: Name of a blob which contains the backup
    :param bool overwrite: True if the restore operation can overwrite target
     site. "True" needed if trying to restore over an existing site.
    :param str site_name: Name of a site (Web App)
    :param list databases: Collection of databses which should be restored.
     This list has to match the list of databases included in the backup.
    :param bool ignore_conflicting_host_names: Changes a logic when restoring
     a site with custom domains. If "true", custom domains are removed
     automatically. If "false", custom domains are added to
     the site object when it is being restored, but that might
     fail due to conflicts during the operation.
    :param str operation_type: Operation type. Possible values include:
     'Default', 'Clone', 'Relocation'
    :param bool adjust_connection_strings: Gets or sets a flag showing if
     SiteConfig.ConnectionStrings should be set in new site
    :param str hosting_environment: App Service Environment name, if needed
     (only when restoring a site to an App Service Environment)
    """

    _required = []

    _attribute_map = {
        'storage_account_url': {'key': 'properties.storageAccountUrl', 'type': 'str', 'flatten': True},
        'blob_name': {'key': 'properties.blobName', 'type': 'str', 'flatten': True},
        'overwrite': {'key': 'properties.overwrite', 'type': 'bool', 'flatten': True},
        'site_name': {'key': 'properties.siteName', 'type': 'str', 'flatten': True},
        'databases': {'key': 'properties.databases', 'type': '[DatabaseBackupSetting]', 'flatten': True},
        'ignore_conflicting_host_names': {'key': 'properties.ignoreConflictingHostNames', 'type': 'bool', 'flatten': True},
        'operation_type': {'key': 'properties.operationType', 'type': 'BackupRestoreOperationType', 'flatten': True},
        'adjust_connection_strings': {'key': 'properties.adjustConnectionStrings', 'type': 'bool', 'flatten': True},
        'hosting_environment': {'key': 'properties.hostingEnvironment', 'type': 'str', 'flatten': True},
    }

    def __init__(self, location, id=None, name=None, type=None, tags=None, storage_account_url=None, blob_name=None, overwrite=None, site_name=None, databases=None, ignore_conflicting_host_names=None, operation_type=None, adjust_connection_strings=None, hosting_environment=None):
        super(RestoreRequest, self).__init__(id=id, name=name, location=location, type=type, tags=tags)
        self.storage_account_url = storage_account_url
        self.blob_name = blob_name
        self.overwrite = overwrite
        self.site_name = site_name
        self.databases = databases
        self.ignore_conflicting_host_names = ignore_conflicting_host_names
        self.operation_type = operation_type
        self.adjust_connection_strings = adjust_connection_strings
        self.hosting_environment = hosting_environment
