# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class NetworkFeatures(Resource):
    """
    This is an object used to store a full view of network features (presently
    VNET integration and Hybrid Connections)
    for a web app.

    :param str id: Resource Id
    :param str name: Resource Name
    :param str location: Resource Location
    :param str type: Resource type
    :param dict tags: Resource tags
    :param str virtual_network_name: The Vnet Name
    :param VnetInfo virtual_network_connection: The Vnet Summary view
    :param list hybrid_connections: The Hybrid Connections Summary view
    """

    _required = []

    _attribute_map = {
        'virtual_network_name': {'key': 'properties.virtualNetworkName', 'type': 'str', 'flatten': True},
        'virtual_network_connection': {'key': 'properties.virtualNetworkConnection', 'type': 'VnetInfo', 'flatten': True},
        'hybrid_connections': {'key': 'properties.hybridConnections', 'type': '[RelayServiceConnectionEntity]', 'flatten': True},
    }

    def __init__(self, location, id=None, name=None, type=None, tags=None, virtual_network_name=None, virtual_network_connection=None, hybrid_connections=None):
        super(NetworkFeatures, self).__init__(id=id, name=name, location=location, type=type, tags=tags)
        self.virtual_network_name = virtual_network_name
        self.virtual_network_connection = virtual_network_connection
        self.hybrid_connections = hybrid_connections
