# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class HostNameBinding(Resource):
    """
    A host name binding object

    :param str id: Resource Id
    :param str name: Resource Name
    :param str location: Resource Location
    :param str type: Resource type
    :param dict tags: Resource tags
    :param str host_name_binding_name: Hostname
    :param str site_name: Web app name
    :param str domain_id: Fully qualified ARM domain resource URI
    :param str azure_resource_name: Azure resource name
    :param str azure_resource_type: Azure resource type. Possible values
     include: 'Website', 'TrafficManager'
    :param str custom_host_name_dns_record_type: Custom DNS record type.
     Possible values include: 'CName', 'A'
    :param str host_name_type: Host name type. Possible values include:
     'Verified', 'Managed'
    """

    _required = []

    _attribute_map = {
        'host_name_binding_name': {'key': 'properties.name', 'type': 'str', 'flatten': True},
        'site_name': {'key': 'properties.siteName', 'type': 'str', 'flatten': True},
        'domain_id': {'key': 'properties.domainId', 'type': 'str', 'flatten': True},
        'azure_resource_name': {'key': 'properties.azureResourceName', 'type': 'str', 'flatten': True},
        'azure_resource_type': {'key': 'properties.azureResourceType', 'type': 'AzureResourceType', 'flatten': True},
        'custom_host_name_dns_record_type': {'key': 'properties.customHostNameDnsRecordType', 'type': 'CustomHostNameDnsRecordType', 'flatten': True},
        'host_name_type': {'key': 'properties.hostNameType', 'type': 'HostNameType', 'flatten': True},
    }

    def __init__(self, location, id=None, name=None, type=None, tags=None, host_name_binding_name=None, site_name=None, domain_id=None, azure_resource_name=None, azure_resource_type=None, custom_host_name_dns_record_type=None, host_name_type=None):
        super(HostNameBinding, self).__init__(id=id, name=name, location=location, type=type, tags=tags)
        self.host_name_binding_name = host_name_binding_name
        self.site_name = site_name
        self.domain_id = domain_id
        self.azure_resource_name = azure_resource_name
        self.azure_resource_type = azure_resource_type
        self.custom_host_name_dns_record_type = custom_host_name_dns_record_type
        self.host_name_type = host_name_type
