# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DomainPurchaseConsent(Model):
    """
    Domain purchase consent object representing acceptance of applicable legal
    agreements

    :param list agreement_keys: List of applicable legal agreement keys. This
     list can be retrieved using ListLegalAgreements Api under TopLevelDomain
     resource
    :param str agreed_by: Client IP address
    :param datetime agreed_at: Timestamp when the agreements were accepted
    """

    _required = []

    _attribute_map = {
        'agreement_keys': {'key': 'agreementKeys', 'type': '[str]'},
        'agreed_by': {'key': 'agreedBy', 'type': 'str'},
        'agreed_at': {'key': 'agreedAt', 'type': 'iso-8601'},
    }

    def __init__(self, agreement_keys=None, agreed_by=None, agreed_at=None):
        self.agreement_keys = agreement_keys
        self.agreed_by = agreed_by
        self.agreed_at = agreed_at
