# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class Deployment(Resource):
    """
    Represents user crendentials used for publishing activity

    :param str id: Resource Id
    :param str name: Resource Name
    :param str location: Resource Location
    :param str type: Resource type
    :param dict tags: Resource tags
    :param str deployment_id: Id
    :param int status: Status
    :param str message: Message
    :param str author: Author
    :param str deployer: Deployer
    :param str author_email: AuthorEmail
    :param datetime start_time: StartTime
    :param datetime end_time: EndTime
    :param bool active: Active
    :param str details: Detail
    """

    _required = []

    _attribute_map = {
        'deployment_id': {'key': 'properties.id', 'type': 'str', 'flatten': True},
        'status': {'key': 'properties.status', 'type': 'int', 'flatten': True},
        'message': {'key': 'properties.message', 'type': 'str', 'flatten': True},
        'author': {'key': 'properties.author', 'type': 'str', 'flatten': True},
        'deployer': {'key': 'properties.deployer', 'type': 'str', 'flatten': True},
        'author_email': {'key': 'properties.author_email', 'type': 'str', 'flatten': True},
        'start_time': {'key': 'properties.start_time', 'type': 'iso-8601', 'flatten': True},
        'end_time': {'key': 'properties.end_time', 'type': 'iso-8601', 'flatten': True},
        'active': {'key': 'properties.active', 'type': 'bool', 'flatten': True},
        'details': {'key': 'properties.details', 'type': 'str', 'flatten': True},
    }

    def __init__(self, location, id=None, name=None, type=None, tags=None, deployment_id=None, status=None, message=None, author=None, deployer=None, author_email=None, start_time=None, end_time=None, active=None, details=None):
        super(Deployment, self).__init__(id=id, name=name, location=location, type=type, tags=tags)
        self.deployment_id = deployment_id
        self.status = status
        self.message = message
        self.author = author
        self.deployer = deployer
        self.author_email = author_email
        self.start_time = start_time
        self.end_time = end_time
        self.active = active
        self.details = details
