﻿#-------------------------------------------------------------------------
# Copyright (c) Microsoft.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#--------------------------------------------------------------------------

# Warning: This code was generated by a tool.
# 
# Changes to this file may cause incorrect behavior and will be lost if the
# code is regenerated.

from datetime import datetime
import json
import re
from requests import Session, Request
import time
try:
    from urllib import quote, unquote
except:
    from urllib.parse import quote, unquote
from azure.common import AzureHttpError
from azure.mgmt.common import AzureOperationResponse, OperationStatusResponse, OperationStatus, Service
from azure.mgmt.common.arm import ResourceBase, ResourceBaseExtended

class LongRunningOperationResponse(AzureOperationResponse):
    """
     A standard service response for long running operations.
    """
    
    def __init__(self, **kwargs):
        super(LongRunningOperationResponse, self).__init__(**kwargs)
        self._operation_status_link = kwargs.get('operation_status_link')
        self._retry_after = kwargs.get('retry_after')
        self._status = kwargs.get('status')
        self._error = kwargs.get('error')
    
    @property
    def error(self):
        return self._error
    
    @error.setter 
    def error(self, value):
        self._error = value
    
    @property
    def operation_status_link(self):
        return self._operation_status_link
    
    @operation_status_link.setter 
    def operation_status_link(self, value):
        self._operation_status_link = value
    
    @property
    def retry_after(self):
        return self._retry_after
    
    @retry_after.setter 
    def retry_after(self, value):
        self._retry_after = value
    
    @property
    def status(self):
        return self._status
    
    @status.setter 
    def status(self, value):
        self._status = value

class ProviderUnregistionResult(AzureOperationResponse):
    """
     Resource provider registration information.
    """
    
    def __init__(self, **kwargs):
        super(ProviderUnregistionResult, self).__init__(**kwargs)
        self._provider = kwargs.get('provider')
    
    @property
    def provider(self):
        """
         Gets or sets the resource provider.
        """
        return self._provider
    
    @provider.setter 
    def provider(self, value):
        self._provider = value

class ProviderRegistionResult(AzureOperationResponse):
    """
     Resource provider registration information.
    """
    
    def __init__(self, **kwargs):
        super(ProviderRegistionResult, self).__init__(**kwargs)
        self._provider = kwargs.get('provider')
    
    @property
    def provider(self):
        """
         Gets or sets the resource provider.
        """
        return self._provider
    
    @provider.setter 
    def provider(self, value):
        self._provider = value

class ProviderListResult(AzureOperationResponse):
    """
     List of resource providers.
    """
    
    def __init__(self, **kwargs):
        super(ProviderListResult, self).__init__(**kwargs)
        self._providers = kwargs.get('providers')
        self._next_link = kwargs.get('next_link')
    
    @property
    def next_link(self):
        """
         Gets or sets the URL to get the next set of results.
        """
        return self._next_link
    
    @next_link.setter 
    def next_link(self, value):
        self._next_link = value
    
    @property
    def providers(self):
        """
         Gets or sets the list of resource providers.
        """
        return self._providers
    
    @providers.setter 
    def providers(self, value):
        self._providers = value

class ProviderListParameters(object):
    """
     Deployment list operation parameters.
    """
    
    def __init__(self, **kwargs):
        self._top = kwargs.get('top')
    
    @property
    def top(self):
        """
         Get or sets the number of records to return. Optional.
        """
        return self._top
    
    @top.setter 
    def top(self, value):
        self._top = value

class ProviderGetResult(AzureOperationResponse):
    """
     Resource provider information.
    """
    
    def __init__(self, **kwargs):
        super(ProviderGetResult, self).__init__(**kwargs)
        self._provider = kwargs.get('provider')
    
    @property
    def provider(self):
        """
         Gets or sets the resource provider.
        """
        return self._provider
    
    @provider.setter 
    def provider(self, value):
        self._provider = value

class ResourcesMoveInfo(object):
    """
     Parameters of move resources.
    """
    
    def __init__(self, **kwargs):
        self._resources = kwargs.get('resources')
        self._target_resource_group = kwargs.get('target_resource_group')
    
    @property
    def resources(self):
        """
         Gets or sets the ids of the resources.
        """
        return self._resources
    
    @resources.setter 
    def resources(self, value):
        self._resources = value
    
    @property
    def target_resource_group(self):
        """
         The target resource group.
        """
        return self._target_resource_group
    
    @target_resource_group.setter 
    def target_resource_group(self, value):
        self._target_resource_group = value

class ResourceExistsResult(AzureOperationResponse):
    """
     Resource group information.
    """
    
    def __init__(self, **kwargs):
        super(ResourceExistsResult, self).__init__(**kwargs)
        self._exists = kwargs.get('exists')
    
    @property
    def exists(self):
        """
         Gets or sets the value indicating whether the resource group exists.
        """
        return self._exists
    
    @exists.setter 
    def exists(self, value):
        self._exists = value

class ResourceListResult(AzureOperationResponse):
    """
     List of resource groups.
    """
    
    def __init__(self, **kwargs):
        super(ResourceListResult, self).__init__(**kwargs)
        self._resources = kwargs.get('resources')
        self._next_link = kwargs.get('next_link')
    
    @property
    def next_link(self):
        """
         Gets or sets the URL to get the next set of results.
        """
        return self._next_link
    
    @next_link.setter 
    def next_link(self, value):
        self._next_link = value
    
    @property
    def resources(self):
        """
         Gets or sets the list of resource groups.
        """
        return self._resources
    
    @resources.setter 
    def resources(self, value):
        self._resources = value

class ResourceListParameters(object):
    """
     Resource group information.
    """
    
    def __init__(self, **kwargs):
        self._resource_group_name = kwargs.get('resource_group_name')
        self._resource_type = kwargs.get('resource_type')
        self._tag_name = kwargs.get('tag_name')
        self._tag_value = kwargs.get('tag_value')
        self._top = kwargs.get('top')
    
    @property
    def resource_group_name(self):
        """
         Gets or sets resource resource group to filter by. Optional.
        """
        return self._resource_group_name
    
    @resource_group_name.setter 
    def resource_group_name(self, value):
        self._resource_group_name = value
    
    @property
    def resource_type(self):
        """
         Filter the results for a particular resource type. Optional.
        """
        return self._resource_type
    
    @resource_type.setter 
    def resource_type(self, value):
        self._resource_type = value
    
    @property
    def tag_name(self):
        """
         Filter the results based on a particular tag name. Optional.
        """
        return self._tag_name
    
    @tag_name.setter 
    def tag_name(self, value):
        self._tag_name = value
    
    @property
    def tag_value(self):
        """
         Filter the results for a tag name along with a particular tag value.
         Optional.
        """
        return self._tag_value
    
    @tag_value.setter 
    def tag_value(self, value):
        self._tag_value = value
    
    @property
    def top(self):
        """
         Number of records to return. Optional.
        """
        return self._top
    
    @top.setter 
    def top(self, value):
        self._top = value

class ResourceCreateOrUpdateResult(AzureOperationResponse):
    """
     Resource information.
    """
    
    def __init__(self, **kwargs):
        super(ResourceCreateOrUpdateResult, self).__init__(**kwargs)
        self._resource = kwargs.get('resource')
    
    @property
    def resource(self):
        """
         Gets or sets the resource.
        """
        return self._resource
    
    @resource.setter 
    def resource(self, value):
        self._resource = value

class GenericResource(ResourceBase):
    """
     Resource information.
    """
    
    def __init__(self, **kwargs):
        super(GenericResource, self).__init__(**kwargs)
        self._properties = kwargs.get('properties')
        self._provisioning_state = kwargs.get('provisioning_state')
        self._plan = kwargs.get('plan')
    
    @property
    def plan(self):
        """
         Gets or sets the plan of the resource.
        """
        return self._plan
    
    @plan.setter 
    def plan(self, value):
        self._plan = value
    
    @property
    def properties(self):
        """
         Gets or sets the resource properties.
        """
        return self._properties
    
    @properties.setter 
    def properties(self, value):
        self._properties = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets resource provisioning state.
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value

class ResourceGetResult(AzureOperationResponse):
    """
     Resource information.
    """
    
    def __init__(self, **kwargs):
        super(ResourceGetResult, self).__init__(**kwargs)
        self._resource = kwargs.get('resource')
    
    @property
    def resource(self):
        """
         Gets or sets the resource.
        """
        return self._resource
    
    @resource.setter 
    def resource(self, value):
        self._resource = value

class TagCreateValueResult(AzureOperationResponse):
    """
     Tag information.
    """
    
    def __init__(self, **kwargs):
        super(TagCreateValueResult, self).__init__(**kwargs)
        self._value = kwargs.get('value')
    
    @property
    def value(self):
        """
         Gets or sets the tag value.
        """
        return self._value
    
    @value.setter 
    def value(self, value):
        self._value = value

class TagCreateResult(AzureOperationResponse):
    """
     Tag information.
    """
    
    def __init__(self, **kwargs):
        super(TagCreateResult, self).__init__(**kwargs)
        self._tag = kwargs.get('tag')
    
    @property
    def tag(self):
        """
         Gets or sets the tag.
        """
        return self._tag
    
    @tag.setter 
    def tag(self, value):
        self._tag = value

class TagsListResult(AzureOperationResponse):
    """
     List of subscription tags.
    """
    
    def __init__(self, **kwargs):
        super(TagsListResult, self).__init__(**kwargs)
        self._tags = kwargs.get('tags')
        self._next_link = kwargs.get('next_link')
    
    @property
    def next_link(self):
        """
         Gets or sets the URL to get the next set of results.
        """
        return self._next_link
    
    @next_link.setter 
    def next_link(self, value):
        self._next_link = value
    
    @property
    def tags(self):
        """
         Gets or sets the list of tags.
        """
        return self._tags
    
    @tags.setter 
    def tags(self, value):
        self._tags = value

class DeploymentOperationsGetResult(AzureOperationResponse):
    """
     Deployment operation.
    """
    
    def __init__(self, **kwargs):
        super(DeploymentOperationsGetResult, self).__init__(**kwargs)
        self._operation = kwargs.get('operation')
    
    @property
    def operation(self):
        """
         Gets or sets the deployment operation.
        """
        return self._operation
    
    @operation.setter 
    def operation(self, value):
        self._operation = value

class DeploymentOperationsListResult(AzureOperationResponse):
    """
     List of deployment operations.
    """
    
    def __init__(self, **kwargs):
        super(DeploymentOperationsListResult, self).__init__(**kwargs)
        self._operations = kwargs.get('operations')
        self._next_link = kwargs.get('next_link')
    
    @property
    def next_link(self):
        """
         Gets or sets the URL to get the next set of results.
        """
        return self._next_link
    
    @next_link.setter 
    def next_link(self, value):
        self._next_link = value
    
    @property
    def operations(self):
        """
         Gets or sets the list of deployments.
        """
        return self._operations
    
    @operations.setter 
    def operations(self, value):
        self._operations = value

class DeploymentOperationsListParameters(object):
    """
     Deployment operation list parameters.
    """
    
    def __init__(self, **kwargs):
        self._top = kwargs.get('top')
    
    @property
    def top(self):
        """
         Get or sets the number of records to return. Optional.
        """
        return self._top
    
    @top.setter 
    def top(self, value):
        self._top = value

class ResourceProviderOperationDetailListResult(AzureOperationResponse):
    """
     List of resource provider operations.
    """
    
    def __init__(self, **kwargs):
        super(ResourceProviderOperationDetailListResult, self).__init__(**kwargs)
        self._resource_provider_operation_details = kwargs.get('resource_provider_operation_details')
    
    @property
    def resource_provider_operation_details(self):
        """
         Gets or sets the list of resource provider operations.
        """
        return self._resource_provider_operation_details
    
    @resource_provider_operation_details.setter 
    def resource_provider_operation_details(self, value):
        self._resource_provider_operation_details = value

class ResourceGroupExistsResult(AzureOperationResponse):
    """
     Resource group information.
    """
    
    def __init__(self, **kwargs):
        super(ResourceGroupExistsResult, self).__init__(**kwargs)
        self._exists = kwargs.get('exists')
    
    @property
    def exists(self):
        """
         Gets or sets the value indicating whether the resource group exists.
        """
        return self._exists
    
    @exists.setter 
    def exists(self, value):
        self._exists = value

class ResourceGroupCreateOrUpdateResult(AzureOperationResponse):
    """
     Resource group information.
    """
    
    def __init__(self, **kwargs):
        super(ResourceGroupCreateOrUpdateResult, self).__init__(**kwargs)
        self._resource_group = kwargs.get('resource_group')
    
    @property
    def resource_group(self):
        """
         Gets or sets the resource group.
        """
        return self._resource_group
    
    @resource_group.setter 
    def resource_group(self, value):
        self._resource_group = value

class ResourceGroup(object):
    """
     Resource group information.
    """
    
    def __init__(self, **kwargs):
        self._location = kwargs.get('location')
        self._properties = kwargs.get('properties')
        self._tags = kwargs.get('tags')
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def location(self):
        """
         Gets or sets the location of the resource group. It cannot be changed
         after the resource group has been created. Has to be one of the
         supported Azure Locations, such as West US, East US, West Europe,
         East Asia, etc.
        """
        return self._location
    
    @location.setter 
    def location(self, value):
        self._location = value
    
    @property
    def properties(self):
        """
         Gets or sets the resource group properties.
        """
        return self._properties
    
    @properties.setter 
    def properties(self, value):
        self._properties = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets resource group provisioning state.
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value
    
    @property
    def tags(self):
        """
         Gets or sets the tags attached to the resource group.
        """
        return self._tags
    
    @tags.setter 
    def tags(self, value):
        self._tags = value

class ResourceGroupGetResult(AzureOperationResponse):
    """
     Resource group information.
    """
    
    def __init__(self, **kwargs):
        super(ResourceGroupGetResult, self).__init__(**kwargs)
        self._resource_group = kwargs.get('resource_group')
    
    @property
    def resource_group(self):
        """
         Gets or sets the resource group.
        """
        return self._resource_group
    
    @resource_group.setter 
    def resource_group(self, value):
        self._resource_group = value

class ResourceGroupListResult(AzureOperationResponse):
    """
     List of resource groups.
    """
    
    def __init__(self, **kwargs):
        super(ResourceGroupListResult, self).__init__(**kwargs)
        self._resource_groups = kwargs.get('resource_groups')
        self._next_link = kwargs.get('next_link')
    
    @property
    def next_link(self):
        """
         Gets or sets the URL to get the next set of results.
        """
        return self._next_link
    
    @next_link.setter 
    def next_link(self, value):
        self._next_link = value
    
    @property
    def resource_groups(self):
        """
         Gets or sets the list of resource groups.
        """
        return self._resource_groups
    
    @resource_groups.setter 
    def resource_groups(self, value):
        self._resource_groups = value

class ResourceGroupListParameters(object):
    """
     Resource group information.
    """
    
    def __init__(self, **kwargs):
        self._tag_name = kwargs.get('tag_name')
        self._tag_value = kwargs.get('tag_value')
        self._top = kwargs.get('top')
    
    @property
    def tag_name(self):
        """
         Filter the results based on a particular tag name. Optional.
        """
        return self._tag_name
    
    @tag_name.setter 
    def tag_name(self, value):
        self._tag_name = value
    
    @property
    def tag_value(self):
        """
         Filter the results for a tag name along with a particular tag value.
         Optional.
        """
        return self._tag_value
    
    @tag_value.setter 
    def tag_value(self, value):
        self._tag_value = value
    
    @property
    def top(self):
        """
         Number of records to return. Optional.
        """
        return self._top
    
    @top.setter 
    def top(self, value):
        self._top = value

class ResourceGroupPatchResult(AzureOperationResponse):
    """
     Resource group information.
    """
    
    def __init__(self, **kwargs):
        super(ResourceGroupPatchResult, self).__init__(**kwargs)
        self._resource_group = kwargs.get('resource_group')
    
    @property
    def resource_group(self):
        """
         Gets or sets the resource group.
        """
        return self._resource_group
    
    @resource_group.setter 
    def resource_group(self, value):
        self._resource_group = value

class DeploymentValidateResponse(AzureOperationResponse):
    """
     Information from validate template deployment response.
    """
    
    def __init__(self, **kwargs):
        super(DeploymentValidateResponse, self).__init__(**kwargs)
        self._is_valid = kwargs.get('is_valid')
        self._error = kwargs.get('error')
        self._properties = kwargs.get('properties')
    
    @property
    def error(self):
        """
         Gets or sets validation error.
        """
        return self._error
    
    @error.setter 
    def error(self, value):
        self._error = value
    
    @property
    def is_valid(self):
        """
         Gets or sets the value indicating whether the template is valid or not.
        """
        return self._is_valid
    
    @is_valid.setter 
    def is_valid(self, value):
        self._is_valid = value
    
    @property
    def properties(self):
        """
         Gets or sets the template deployment properties.
        """
        return self._properties
    
    @properties.setter 
    def properties(self, value):
        self._properties = value

class Deployment(object):
    """
     Deployment operation parameters.
    """
    
    def __init__(self, **kwargs):
        self._properties = kwargs.get('properties')
    
    @property
    def properties(self):
        """
         Gets or sets the deployment properties.
        """
        return self._properties
    
    @properties.setter 
    def properties(self, value):
        self._properties = value

class DeploymentOperationsCreateResult(AzureOperationResponse):
    """
     Template deployment operation create result.
    """
    
    def __init__(self, **kwargs):
        super(DeploymentOperationsCreateResult, self).__init__(**kwargs)
        self._deployment = kwargs.get('deployment')
    
    @property
    def deployment(self):
        """
         Gets or sets the deployment.
        """
        return self._deployment
    
    @deployment.setter 
    def deployment(self, value):
        self._deployment = value

class DeploymentGetResult(AzureOperationResponse):
    """
     Template deployment information.
    """
    
    def __init__(self, **kwargs):
        super(DeploymentGetResult, self).__init__(**kwargs)
        self._deployment = kwargs.get('deployment')
    
    @property
    def deployment(self):
        """
         Gets or sets the deployment.
        """
        return self._deployment
    
    @deployment.setter 
    def deployment(self, value):
        self._deployment = value

class DeploymentListResult(AzureOperationResponse):
    """
     List of deployments.
    """
    
    def __init__(self, **kwargs):
        super(DeploymentListResult, self).__init__(**kwargs)
        self._deployments = kwargs.get('deployments')
        self._next_link = kwargs.get('next_link')
    
    @property
    def deployments(self):
        """
         Gets or sets the list of deployments.
        """
        return self._deployments
    
    @deployments.setter 
    def deployments(self, value):
        self._deployments = value
    
    @property
    def next_link(self):
        """
         Gets or sets the URL to get the next set of results.
        """
        return self._next_link
    
    @next_link.setter 
    def next_link(self, value):
        self._next_link = value

class DeploymentListParameters(object):
    """
     Deployment list operation parameters.
    """
    
    def __init__(self, **kwargs):
        self._top = kwargs.get('top')
        self._provisioning_state = kwargs.get('provisioning_state')
    
    @property
    def provisioning_state(self):
        """
         Get or sets the provisioning state to filer by. Optional.
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value
    
    @property
    def top(self):
        """
         Get or sets the number of records to return. Optional.
        """
        return self._top
    
    @top.setter 
    def top(self, value):
        self._top = value

class ResourceManagementError(object):
    
    def __init__(self, **kwargs):
        self._code = kwargs.get('code')
        self._message = kwargs.get('message')
        self._target = kwargs.get('target')
    
    @property
    def code(self):
        """
         Gets or sets the error code returned from the server.
        """
        return self._code
    
    @code.setter 
    def code(self, value):
        self._code = value
    
    @property
    def message(self):
        """
         Gets or sets the error message returned from the server.
        """
        return self._message
    
    @message.setter 
    def message(self, value):
        self._message = value
    
    @property
    def target(self):
        """
         Gets or sets the target of the error.
        """
        return self._target
    
    @target.setter 
    def target(self, value):
        self._target = value

class ResourceManagementErrorWithDetails(ResourceManagementError):
    
    def __init__(self, **kwargs):
        super(ResourceManagementErrorWithDetails, self).__init__(**kwargs)
        self._details = kwargs.get('details')
    
    @property
    def details(self):
        """
         Gets or sets validation error.
        """
        return self._details
    
    @details.setter 
    def details(self, value):
        self._details = value

class Provider(AzureOperationResponse):
    """
     Resource provider information.
    """
    
    def __init__(self, **kwargs):
        super(Provider, self).__init__(**kwargs)
        self._id = kwargs.get('id')
        self._namespace = kwargs.get('namespace')
        self._registration_state = kwargs.get('registration_state')
        self._resource_types = kwargs.get('resource_types')
    
    @property
    def id(self):
        """
         Gets or sets the provider id.
        """
        return self._id
    
    @id.setter 
    def id(self, value):
        self._id = value
    
    @property
    def namespace(self):
        """
         Gets or sets the namespace of the provider.
        """
        return self._namespace
    
    @namespace.setter 
    def namespace(self, value):
        self._namespace = value
    
    @property
    def registration_state(self):
        """
         Gets or sets the registration state of the provider.
        """
        return self._registration_state
    
    @registration_state.setter 
    def registration_state(self, value):
        self._registration_state = value
    
    @property
    def resource_types(self):
        """
         Gets or sets the collection of provider resource types.
        """
        return self._resource_types
    
    @resource_types.setter 
    def resource_types(self, value):
        self._resource_types = value

class ProviderRegistrationState(object):
    """
     Provider registration states.
    """
    not_registered = 'NotRegistered'
    unregistering = 'Unregistering'
    registering = 'Registering'
    registered = 'Registered'

class ProviderResourceType(object):
    """
     Resource type managed by the resource provider.
    """
    
    def __init__(self, **kwargs):
        self._name = kwargs.get('name')
        self._locations = kwargs.get('locations')
        self._api_versions = kwargs.get('api_versions')
        self._properties = kwargs.get('properties')
    
    @property
    def api_versions(self):
        """
         Gets or sets the api version.
        """
        return self._api_versions
    
    @api_versions.setter 
    def api_versions(self, value):
        self._api_versions = value
    
    @property
    def locations(self):
        """
         Gets or sets the collection of locations where this resource type can
         be created in.
        """
        return self._locations
    
    @locations.setter 
    def locations(self, value):
        self._locations = value
    
    @property
    def name(self):
        """
         Gets or sets the resource type.
        """
        return self._name
    
    @name.setter 
    def name(self, value):
        self._name = value
    
    @property
    def properties(self):
        """
         Gets or sets the properties.
        """
        return self._properties
    
    @properties.setter 
    def properties(self, value):
        self._properties = value

class GenericResourceExtended(ResourceBaseExtended):
    """
     Resource information.
    """
    
    def __init__(self, **kwargs):
        super(GenericResourceExtended, self).__init__(**kwargs)
        self._properties = kwargs.get('properties')
        self._provisioning_state = kwargs.get('provisioning_state')
        self._plan = kwargs.get('plan')
    
    @property
    def plan(self):
        """
         Gets or sets the plan of the resource.
        """
        return self._plan
    
    @plan.setter 
    def plan(self, value):
        self._plan = value
    
    @property
    def properties(self):
        """
         Gets or sets the resource properties.
        """
        return self._properties
    
    @properties.setter 
    def properties(self, value):
        self._properties = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets resource provisioning state.
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value

class ProvisioningState(object):
    """
     Common provisioning states.
    """
    not_specified = 'NotSpecified'
    accepted = 'Accepted'
    running = 'Running'
    registering = 'Registering'
    creating = 'Creating'
    created = 'Created'
    deleting = 'Deleting'
    deleted = 'Deleted'
    canceled = 'Canceled'
    failed = 'Failed'
    succeeded = 'Succeeded'

class Plan(object):
    """
     Plan for the resource.
    """
    
    def __init__(self, **kwargs):
        self._name = kwargs.get('name')
        self._publisher = kwargs.get('publisher')
        self._product = kwargs.get('product')
        self._promotion_code = kwargs.get('promotion_code')
    
    @property
    def name(self):
        """
         Gets or sets the plan ID.
        """
        return self._name
    
    @name.setter 
    def name(self, value):
        self._name = value
    
    @property
    def product(self):
        """
         Gets or sets the offer ID.
        """
        return self._product
    
    @product.setter 
    def product(self, value):
        self._product = value
    
    @property
    def promotion_code(self):
        """
         Gets or sets the promotion code.
        """
        return self._promotion_code
    
    @promotion_code.setter 
    def promotion_code(self, value):
        self._promotion_code = value
    
    @property
    def publisher(self):
        """
         Gets or sets the publisher ID.
        """
        return self._publisher
    
    @publisher.setter 
    def publisher(self, value):
        self._publisher = value

class TagValue(object):
    """
     Tag information.
    """
    
    def __init__(self, **kwargs):
        self._id = kwargs.get('id')
        self._value = kwargs.get('value')
        self._count = kwargs.get('count')
    
    @property
    def count(self):
        """
         Gets or sets the tag value count.
        """
        return self._count
    
    @count.setter 
    def count(self, value):
        self._count = value
    
    @property
    def id(self):
        """
         Gets or sets the tag ID.
        """
        return self._id
    
    @id.setter 
    def id(self, value):
        self._id = value
    
    @property
    def value(self):
        """
         Gets or sets the tag value.
        """
        return self._value
    
    @value.setter 
    def value(self, value):
        self._value = value

class TagCount(object):
    """
     Tag count.
    """
    
    def __init__(self, **kwargs):
        self._type = kwargs.get('type')
        self._value = kwargs.get('value')
    
    @property
    def type(self):
        """
         Type of count.
        """
        return self._type
    
    @type.setter 
    def type(self, value):
        self._type = value
    
    @property
    def value(self):
        """
         Value of count.
        """
        return self._value
    
    @value.setter 
    def value(self, value):
        self._value = value

class TagDetails(object):
    """
     Tag details.
    """
    
    def __init__(self, **kwargs):
        self._id = kwargs.get('id')
        self._name = kwargs.get('name')
        self._count = kwargs.get('count')
        self._values = kwargs.get('values')
    
    @property
    def count(self):
        """
         Gets or sets the tag count.
        """
        return self._count
    
    @count.setter 
    def count(self, value):
        self._count = value
    
    @property
    def id(self):
        """
         Gets or sets the tag ID.
        """
        return self._id
    
    @id.setter 
    def id(self, value):
        self._id = value
    
    @property
    def name(self):
        """
         Gets or sets the tag name.
        """
        return self._name
    
    @name.setter 
    def name(self, value):
        self._name = value
    
    @property
    def values(self):
        """
         Gets or sets the list of tag values.
        """
        return self._values
    
    @values.setter 
    def values(self, value):
        self._values = value

class DeploymentOperation(object):
    """
     Deployment operation information.
    """
    
    def __init__(self, **kwargs):
        self._id = kwargs.get('id')
        self._operation_id = kwargs.get('operation_id')
        self._properties = kwargs.get('properties')
    
    @property
    def id(self):
        """
         Gets or sets full deployment operation id.
        """
        return self._id
    
    @id.setter 
    def id(self, value):
        self._id = value
    
    @property
    def operation_id(self):
        """
         Gets or sets deployment operation id.
        """
        return self._operation_id
    
    @operation_id.setter 
    def operation_id(self, value):
        self._operation_id = value
    
    @property
    def properties(self):
        """
         Gets or sets deployment properties.
        """
        return self._properties
    
    @properties.setter 
    def properties(self, value):
        self._properties = value

class DeploymentOperationProperties(object):
    """
     Deployment operation properties.
    """
    
    def __init__(self, **kwargs):
        self._provisioning_state = kwargs.get('provisioning_state')
        self._timestamp = kwargs.get('timestamp')
        self._status_code = kwargs.get('status_code')
        self._status_message = kwargs.get('status_message')
        self._target_resource = kwargs.get('target_resource')
    
    @property
    def provisioning_state(self):
        """
         Gets or sets the state of the provisioning.
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value
    
    @property
    def status_code(self):
        """
         Gets or sets operation status code.
        """
        return self._status_code
    
    @status_code.setter 
    def status_code(self, value):
        self._status_code = value
    
    @property
    def status_message(self):
        """
         Gets or sets operation status message.
        """
        return self._status_message
    
    @status_message.setter 
    def status_message(self, value):
        self._status_message = value
    
    @property
    def target_resource(self):
        """
         Gets or sets the target resource.
        """
        return self._target_resource
    
    @target_resource.setter 
    def target_resource(self, value):
        self._target_resource = value
    
    @property
    def timestamp(self):
        """
         Gets or sets the date and time of the operation.
        """
        return self._timestamp
    
    @timestamp.setter 
    def timestamp(self, value):
        self._timestamp = value

class TargetResource(object):
    """
     Target resource.
    """
    
    def __init__(self, **kwargs):
        self._id = kwargs.get('id')
        self._resource_name = kwargs.get('resource_name')
        self._resource_type = kwargs.get('resource_type')
    
    @property
    def id(self):
        """
         Gets or sets the ID of the resource.
        """
        return self._id
    
    @id.setter 
    def id(self, value):
        self._id = value
    
    @property
    def resource_name(self):
        """
         Gets or sets the name of the resource.
        """
        return self._resource_name
    
    @resource_name.setter 
    def resource_name(self, value):
        self._resource_name = value
    
    @property
    def resource_type(self):
        """
         Gets or sets the type of the resource.
        """
        return self._resource_type
    
    @resource_type.setter 
    def resource_type(self, value):
        self._resource_type = value

class ResourceProviderOperationDefinition(object):
    """
     Resource provider operation information.
    """
    
    def __init__(self, **kwargs):
        self._name = kwargs.get('name')
        self._resource_provider_operation_display_properties = kwargs.get('resource_provider_operation_display_properties')
    
    @property
    def name(self):
        """
         Gets or sets the provider operation name.
        """
        return self._name
    
    @name.setter 
    def name(self, value):
        self._name = value
    
    @property
    def resource_provider_operation_display_properties(self):
        """
         Gets or sets the display property of the provider operation.
        """
        return self._resource_provider_operation_display_properties
    
    @resource_provider_operation_display_properties.setter 
    def resource_provider_operation_display_properties(self, value):
        self._resource_provider_operation_display_properties = value

class ResourceProviderOperationDisplayProperties(object):
    """
     Resource provider operation's display properties.
    """
    
    def __init__(self, **kwargs):
        self._publisher = kwargs.get('publisher')
        self._provider = kwargs.get('provider')
        self._resource = kwargs.get('resource')
        self._operation = kwargs.get('operation')
        self._description = kwargs.get('description')
    
    @property
    def description(self):
        """
         Gets or sets operation description.
        """
        return self._description
    
    @description.setter 
    def description(self, value):
        self._description = value
    
    @property
    def operation(self):
        """
         Gets or sets operation.
        """
        return self._operation
    
    @operation.setter 
    def operation(self, value):
        self._operation = value
    
    @property
    def provider(self):
        """
         Gets or sets operation provider.
        """
        return self._provider
    
    @provider.setter 
    def provider(self, value):
        self._provider = value
    
    @property
    def publisher(self):
        """
         Gets or sets operation description.
        """
        return self._publisher
    
    @publisher.setter 
    def publisher(self, value):
        self._publisher = value
    
    @property
    def resource(self):
        """
         Gets or sets operation resource.
        """
        return self._resource
    
    @resource.setter 
    def resource(self, value):
        self._resource = value

class ResourceGroupExtended(ResourceGroup):
    """
     Resource group information.
    """
    
    def __init__(self, **kwargs):
        super(ResourceGroupExtended, self).__init__(**kwargs)
        self._id = kwargs.get('id')
        self._name = kwargs.get('name')
    
    @property
    def id(self):
        """
         Gets or sets the ID of the resource group.
        """
        return self._id
    
    @id.setter 
    def id(self, value):
        self._id = value
    
    @property
    def name(self):
        """
         Gets or sets the Name of the resource group.
        """
        return self._name
    
    @name.setter 
    def name(self, value):
        self._name = value

class DeploymentProperties(object):
    """
     Deployment properties.
    """
    
    def __init__(self, **kwargs):
        self._template = kwargs.get('template')
        self._template_link = kwargs.get('template_link')
        self._parameters = kwargs.get('parameters')
        self._parameters_link = kwargs.get('parameters_link')
        self._mode = kwargs.get('mode')
    
    @property
    def mode(self):
        """
         Gets or sets the deployment mode.
        """
        return self._mode
    
    @mode.setter 
    def mode(self, value):
        self._mode = value
    
    @property
    def parameters(self):
        """
         Deployment parameters. Use only one of Parameters or ParametersLink.
        """
        return self._parameters
    
    @parameters.setter 
    def parameters(self, value):
        self._parameters = value
    
    @property
    def parameters_link(self):
        """
         Gets or sets the URI referencing the parameters. Use only one of
         Parameters or ParametersLink.
        """
        return self._parameters_link
    
    @parameters_link.setter 
    def parameters_link(self, value):
        self._parameters_link = value
    
    @property
    def template(self):
        """
         Gets or sets the template content. Use only one of Template or
         TemplateLink.
        """
        return self._template
    
    @template.setter 
    def template(self, value):
        self._template = value
    
    @property
    def template_link(self):
        """
         Gets or sets the URI referencing the template. Use only one of
         Template or TemplateLink.
        """
        return self._template_link
    
    @template_link.setter 
    def template_link(self, value):
        self._template_link = value

class DeploymentPropertiesExtended(DeploymentProperties):
    """
     Deployment properties with additional details.
    """
    
    def __init__(self, **kwargs):
        super(DeploymentPropertiesExtended, self).__init__(**kwargs)
        self._provisioning_state = kwargs.get('provisioning_state')
        self._correlation_id = kwargs.get('correlation_id')
        self._timestamp = kwargs.get('timestamp')
        self._outputs = kwargs.get('outputs')
        self._providers = kwargs.get('providers')
        self._dependencies = kwargs.get('dependencies')
    
    @property
    def correlation_id(self):
        """
         Gets or sets the correlation ID of the deployment.
        """
        return self._correlation_id
    
    @correlation_id.setter 
    def correlation_id(self, value):
        self._correlation_id = value
    
    @property
    def dependencies(self):
        """
         Gets the list of deployment dependencies.
        """
        return self._dependencies
    
    @dependencies.setter 
    def dependencies(self, value):
        self._dependencies = value
    
    @property
    def outputs(self):
        """
         Gets or sets key/value pairs that represent deploymentoutput.
        """
        return self._outputs
    
    @outputs.setter 
    def outputs(self, value):
        self._outputs = value
    
    @property
    def providers(self):
        """
         Gets the list of resource providers needed for the deployment.
        """
        return self._providers
    
    @providers.setter 
    def providers(self, value):
        self._providers = value
    
    @property
    def provisioning_state(self):
        """
         Gets or sets the state of the provisioning.
        """
        return self._provisioning_state
    
    @provisioning_state.setter 
    def provisioning_state(self, value):
        self._provisioning_state = value
    
    @property
    def timestamp(self):
        """
         Gets or sets the timestamp of the template deployment.
        """
        return self._timestamp
    
    @timestamp.setter 
    def timestamp(self, value):
        self._timestamp = value

class TemplateLink(object):
    """
     Entity representing the reference to the template.
    """
    
    def __init__(self, **kwargs):
        self._uri = kwargs.get('uri')
        self._content_version = kwargs.get('content_version')
    
    @property
    def content_version(self):
        """
         If included it must match the ContentVersion in the template.
        """
        return self._content_version
    
    @content_version.setter 
    def content_version(self, value):
        self._content_version = value
    
    @property
    def uri(self):
        """
         URI referencing the template.
        """
        return self._uri
    
    @uri.setter 
    def uri(self, value):
        self._uri = value

class ParametersLink(object):
    """
     Entity representing the reference to the deployment paramaters.
    """
    
    def __init__(self, **kwargs):
        self._uri = kwargs.get('uri')
        self._content_version = kwargs.get('content_version')
    
    @property
    def content_version(self):
        """
         If included it must match the ContentVersion in the template.
        """
        return self._content_version
    
    @content_version.setter 
    def content_version(self, value):
        self._content_version = value
    
    @property
    def uri(self):
        """
         URI referencing the template.
        """
        return self._uri
    
    @uri.setter 
    def uri(self, value):
        self._uri = value

class DeploymentMode(object):
    """
     Specifies the deployment type for the deployment operations.
    """
    incremental = "Incremental"

class BasicDependency(object):
    """
     Deployment dependency information.
    """
    
    def __init__(self, **kwargs):
        self._id = kwargs.get('id')
        self._resource_type = kwargs.get('resource_type')
        self._resource_name = kwargs.get('resource_name')
    
    @property
    def id(self):
        """
         Gets or sets the ID of the dependency.
        """
        return self._id
    
    @id.setter 
    def id(self, value):
        self._id = value
    
    @property
    def resource_name(self):
        """
         Gets or sets the dependency resource name.
        """
        return self._resource_name
    
    @resource_name.setter 
    def resource_name(self, value):
        self._resource_name = value
    
    @property
    def resource_type(self):
        """
         Gets or sets the dependency resource type.
        """
        return self._resource_type
    
    @resource_type.setter 
    def resource_type(self, value):
        self._resource_type = value

class Dependency(BasicDependency):
    """
     Deployment dependency information.
    """
    
    def __init__(self, **kwargs):
        super(Dependency, self).__init__(**kwargs)
        self._depends_on = kwargs.get('depends_on')
    
    @property
    def depends_on(self):
        """
         Gets the list of dependencies.
        """
        return self._depends_on
    
    @depends_on.setter 
    def depends_on(self, value):
        self._depends_on = value

class DeploymentExtended(object):
    """
     Deployment information.
    """
    
    def __init__(self, **kwargs):
        self._id = kwargs.get('id')
        self._name = kwargs.get('name')
        self._properties = kwargs.get('properties')
    
    @property
    def id(self):
        """
         Gets or sets the ID of the deployment.
        """
        return self._id
    
    @id.setter 
    def id(self, value):
        self._id = value
    
    @property
    def name(self):
        """
         Gets or sets the name of the deployment.
        """
        return self._name
    
    @name.setter 
    def name(self, value):
        self._name = value
    
    @property
    def properties(self):
        """
         Gets or sets deployment properties.
        """
        return self._properties
    
    @properties.setter 
    def properties(self, value):
        self._properties = value

class ResourceIdentity: 
    def __init__(self, **kwargs): 
        self.resource_name = kwargs.get('resource_name') 
        self.resource_provider_api_version = kwargs.get('api_version') 
        self.resource_provider_namespace = kwargs.get('resource_namespace') 
        self.resource_type = kwargs.get('resource_type') 
        self.parent_resource_path = kwargs.get('parent_resource_path') 

class ResourceManagementClient(Service):
    
    @property
    def api_version(self):
        """
         Gets the API version.
        """
        return self._api_version
    
    @property
    def long_running_operation_initial_timeout(self):
        """
         Gets or sets the initial timeout for Long Running Operations.
        """
        return self._long_running_operation_initial_timeout
    
    @long_running_operation_initial_timeout.setter 
    def long_running_operation_initial_timeout(self, value):
        self._long_running_operation_initial_timeout = value
    
    @property
    def long_running_operation_retry_timeout(self):
        """
         Gets or sets the retry timeout for Long Running Operations.
        """
        return self._long_running_operation_retry_timeout
    
    @long_running_operation_retry_timeout.setter 
    def long_running_operation_retry_timeout(self, value):
        self._long_running_operation_retry_timeout = value
    
    @property
    def deployment_operations(self):
        """
         Operations for managing deployment operations.
        """
        return self._deployment_operations
    
    @property
    def deployments(self):
        """
         Operations for managing deployments.
        """
        return self._deployments
    
    @property
    def providers(self):
        """
         Operations for managing providers.
        """
        return self._providers
    
    @property
    def resource_groups(self):
        """
         Operations for managing resource groups.
        """
        return self._resource_groups
    
    @property
    def resources(self):
        """
         Operations for managing resources.
        """
        return self._resources
    
    @property
    def resource_provider_operation_details(self):
        """
         Operations for managing Resource provider operations.
        """
        return self._resource_provider_operation_details
    
    @property
    def tags(self):
        """
         Operations for managing tags.
        """
        return self._tags
    
    def __init__(self, credentials, **kwargs):
        super(ResourceManagementClient, self).__init__(credentials, **kwargs)
        
        if getattr(self, '_base_uri', None) is None:
            self._base_uri = 'https://management.azure.com/'
        
        if getattr(self, '_api_version', None) is None:
            self._api_version = '2014-04-01-preview'
        
        if getattr(self, '_long_running_operation_initial_timeout', None) is None:
            self._long_running_operation_initial_timeout = -1
        
        if getattr(self, '_long_running_operation_retry_timeout', None) is None:
            self._long_running_operation_retry_timeout = -1
        
        self._deployment_operations = DeploymentOperationOperations(self)
        self._deployments = DeploymentOperations(self)
        self._providers = ProviderOperations(self)
        self._resource_groups = ResourceGroupOperations(self)
        self._resources = ResourceOperations(self)
        self._resource_provider_operation_details = ResourceProviderOperationDetailsOperations(self)
        self._tags = TagOperations(self)
    
    def get_long_running_operation_status(self, operation_status_link):
        """
         The Get Operation Status operation returns the status of the specified
         operation. After calling an asynchronous operation, you can call Get
         Operation Status to determine whether the operation has succeeded,
         failed, or is still in progress.
         
         Args:
         
         operation_status_link (string): Location value returned by the Begin
         operation.
         
         Returns:
         
         LongRunningOperationResponse: A standard service response for long
         running operations.
        """
        # Validate
        if operation_status_link is None:
            raise ValueError('operation_status_link cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + operation_status_link
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['x-ms-version'] = '2014-04-01-preview'
        
        # Send Request
        response = self.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 202:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = LongRunningOperationResponse()
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        if status_code == 409:
            result.status = OperationStatus.Failed
        
        if status_code == 200:
            result.status = OperationStatus.Succeeded
        
        return result
    
class DeploymentOperationOperations(object):
    """
     Operations for managing deployment operations.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [ResourceManagementClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Resources.ResourceManagementClient.
        """
        return self._client
    
    def get(self, resource_group_name, deployment_name, operation_id):
        """
         Get a list of deployments operations.
         
         Args:
         
         resource_group_name (string): The name of the resource group. The name
         is case insensitive.
         
         deployment_name (string): The name of the deployment.
         
         operation_id (string): Operation Id.
         
         Returns:
         
         DeploymentOperationsGetResult: Deployment operation.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if resource_group_name is not None and len(resource_group_name) > 1000:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if (re.search('^[-\\w\\._]+$', resource_group_name) is not None) == False:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if deployment_name is None:
            raise ValueError('deployment_name cannot be None.')
        
        if operation_id is None:
            raise ValueError('operation_id cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourcegroups/'
        url = url + quote(resource_group_name)
        url = url + '/deployments/'
        url = url + quote(deployment_name)
        url = url + '/operations/'
        url = url + quote(operation_id)
        query_parameters = []
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = DeploymentOperationsGetResult()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                operation_instance = DeploymentOperation()
                result.operation = operation_instance
                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    operation_instance.id = id_instance
                
                operation_id_value = response_doc.get('operationId', None)
                if operation_id_value is not None:
                    operation_id_instance = operation_id_value
                    operation_instance.operation_id = operation_id_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    properties_instance = DeploymentOperationProperties()
                    operation_instance.properties = properties_instance
                    
                    provisioning_state_value = properties_value.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        properties_instance.provisioning_state = provisioning_state_instance
                    
                    timestamp_value = properties_value.get('timestamp', None)
                    if timestamp_value is not None:
                        timestamp_instance = timestamp_value
                        properties_instance.timestamp = timestamp_instance
                    
                    status_code_value = properties_value.get('statusCode', None)
                    if status_code_value is not None:
                        status_code_instance = status_code_value
                        properties_instance.status_code = status_code_instance
                    
                    status_message_value = properties_value.get('statusMessage', None)
                    if status_message_value is not None:
                        status_message_instance = json.dumps(status_message_value)
                        properties_instance.status_message = status_message_instance
                    
                    target_resource_value = properties_value.get('targetResource', None)
                    if target_resource_value is not None:
                        target_resource_instance = TargetResource()
                        properties_instance.target_resource = target_resource_instance
                        
                        id_value2 = target_resource_value.get('id', None)
                        if id_value2 is not None:
                            id_instance2 = id_value2
                            target_resource_instance.id = id_instance2
                        
                        resource_name_value = target_resource_value.get('resourceName', None)
                        if resource_name_value is not None:
                            resource_name_instance = resource_name_value
                            target_resource_instance.resource_name = resource_name_instance
                        
                        resource_type_value = target_resource_value.get('resourceType', None)
                        if resource_type_value is not None:
                            resource_type_instance = resource_type_value
                            target_resource_instance.resource_type = resource_type_instance
                        
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self, resource_group_name, deployment_name, parameters):
        """
         Gets a list of deployments operations.
         
         Args:
         
         resource_group_name (string): The name of the resource group. The name
         is case insensitive.
         
         deployment_name (string): The name of the deployment.
         
         parameters (DeploymentOperationsListParameters): Query parameters.
         
         Returns:
         
         DeploymentOperationsListResult: List of deployment operations.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if resource_group_name is not None and len(resource_group_name) > 1000:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if (re.search('^[-\\w\\._]+$', resource_group_name) is not None) == False:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if deployment_name is None:
            raise ValueError('deployment_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourcegroups/'
        url = url + quote(resource_group_name)
        url = url + '/deployments/'
        url = url + quote(deployment_name)
        url = url + '/operations'
        query_parameters = []
        if parameters is not None and parameters.top is not None:
            query_parameters.append('$top=' + quote(str(parameters.top)))
        
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = DeploymentOperationsListResult(operations=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        deployment_operation_instance = DeploymentOperation()
                        result.operations.append(deployment_operation_instance)
                        
                        id_value = value_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            deployment_operation_instance.id = id_instance
                        
                        operation_id_value = value_value.get('operationId', None)
                        if operation_id_value is not None:
                            operation_id_instance = operation_id_value
                            deployment_operation_instance.operation_id = operation_id_instance
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            properties_instance = DeploymentOperationProperties()
                            deployment_operation_instance.properties = properties_instance
                            
                            provisioning_state_value = properties_value.get('provisioningState', None)
                            if provisioning_state_value is not None:
                                provisioning_state_instance = provisioning_state_value
                                properties_instance.provisioning_state = provisioning_state_instance
                            
                            timestamp_value = properties_value.get('timestamp', None)
                            if timestamp_value is not None:
                                timestamp_instance = timestamp_value
                                properties_instance.timestamp = timestamp_instance
                            
                            status_code_value = properties_value.get('statusCode', None)
                            if status_code_value is not None:
                                status_code_instance = status_code_value
                                properties_instance.status_code = status_code_instance
                            
                            status_message_value = properties_value.get('statusMessage', None)
                            if status_message_value is not None:
                                status_message_instance = json.dumps(status_message_value)
                                properties_instance.status_message = status_message_instance
                            
                            target_resource_value = properties_value.get('targetResource', None)
                            if target_resource_value is not None:
                                target_resource_instance = TargetResource()
                                properties_instance.target_resource = target_resource_instance
                                
                                id_value2 = target_resource_value.get('id', None)
                                if id_value2 is not None:
                                    id_instance2 = id_value2
                                    target_resource_instance.id = id_instance2
                                
                                resource_name_value = target_resource_value.get('resourceName', None)
                                if resource_name_value is not None:
                                    resource_name_instance = resource_name_value
                                    target_resource_instance.resource_name = resource_name_instance
                                
                                resource_type_value = target_resource_value.get('resourceType', None)
                                if resource_type_value is not None:
                                    resource_type_instance = resource_type_value
                                    target_resource_instance.resource_type = resource_type_instance
                                
                odatanext_link_value = response_doc.get('@odata.nextLink', None)
                if odatanext_link_value is not None:
                    odatanext_link_instance = odatanext_link_value
                    result.next_link = odatanext_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_next(self, next_link):
        """
         Gets a next list of deployments operations.
         
         Args:
         
         next_link (string): NextLink from the previous successful call to List
         operation.
         
         Returns:
         
         DeploymentOperationsListResult: List of deployment operations.
        """
        # Validate
        if next_link is None:
            raise ValueError('next_link cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + next_link
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = DeploymentOperationsListResult(operations=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        deployment_operation_instance = DeploymentOperation()
                        result.operations.append(deployment_operation_instance)
                        
                        id_value = value_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            deployment_operation_instance.id = id_instance
                        
                        operation_id_value = value_value.get('operationId', None)
                        if operation_id_value is not None:
                            operation_id_instance = operation_id_value
                            deployment_operation_instance.operation_id = operation_id_instance
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            properties_instance = DeploymentOperationProperties()
                            deployment_operation_instance.properties = properties_instance
                            
                            provisioning_state_value = properties_value.get('provisioningState', None)
                            if provisioning_state_value is not None:
                                provisioning_state_instance = provisioning_state_value
                                properties_instance.provisioning_state = provisioning_state_instance
                            
                            timestamp_value = properties_value.get('timestamp', None)
                            if timestamp_value is not None:
                                timestamp_instance = timestamp_value
                                properties_instance.timestamp = timestamp_instance
                            
                            status_code_value = properties_value.get('statusCode', None)
                            if status_code_value is not None:
                                status_code_instance = status_code_value
                                properties_instance.status_code = status_code_instance
                            
                            status_message_value = properties_value.get('statusMessage', None)
                            if status_message_value is not None:
                                status_message_instance = json.dumps(status_message_value)
                                properties_instance.status_message = status_message_instance
                            
                            target_resource_value = properties_value.get('targetResource', None)
                            if target_resource_value is not None:
                                target_resource_instance = TargetResource()
                                properties_instance.target_resource = target_resource_instance
                                
                                id_value2 = target_resource_value.get('id', None)
                                if id_value2 is not None:
                                    id_instance2 = id_value2
                                    target_resource_instance.id = id_instance2
                                
                                resource_name_value = target_resource_value.get('resourceName', None)
                                if resource_name_value is not None:
                                    resource_name_instance = resource_name_value
                                    target_resource_instance.resource_name = resource_name_instance
                                
                                resource_type_value = target_resource_value.get('resourceType', None)
                                if resource_type_value is not None:
                                    resource_type_instance = resource_type_value
                                    target_resource_instance.resource_type = resource_type_instance
                                
                odatanext_link_value = response_doc.get('@odata.nextLink', None)
                if odatanext_link_value is not None:
                    odatanext_link_instance = odatanext_link_value
                    result.next_link = odatanext_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class DeploymentOperations(object):
    """
     Operations for managing deployments.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [ResourceManagementClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Resources.ResourceManagementClient.
        """
        return self._client
    
    def cancel(self, resource_group_name, deployment_name):
        """
         Cancel a currently running template deployment.
         
         Args:
         
         resource_group_name (string): The name of the resource group. The name
         is case insensitive.
         
         deployment_name (string): The name of the deployment.
         
         Returns:
         
         AzureOperationResponse: A standard service response including an HTTP
         status code and request ID.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if resource_group_name is not None and len(resource_group_name) > 1000:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if (re.search('^[-\\w\\._]+$', resource_group_name) is not None) == False:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if deployment_name is None:
            raise ValueError('deployment_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourcegroups/'
        url = url + quote(resource_group_name)
        url = url + '/deployments/'
        url = url + quote(deployment_name)
        url = url + '/cancel'
        query_parameters = []
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'POST'
        
        # Set Headers
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 204:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = AzureOperationResponse()
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def create_or_update(self, resource_group_name, deployment_name, parameters):
        """
         Create a named template deployment using a template.
         
         Args:
         
         resource_group_name (string): The name of the resource group. The name
         is case insensitive.
         
         deployment_name (string): The name of the deployment.
         
         parameters (Deployment): Additional parameters supplied to the
         operation.
         
         Returns:
         
         DeploymentOperationsCreateResult: Template deployment operation create
         result.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if resource_group_name is not None and len(resource_group_name) > 1000:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if (re.search('^[-\\w\\._]+$', resource_group_name) is not None) == False:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if deployment_name is None:
            raise ValueError('deployment_name cannot be None.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        if parameters.properties is not None:
            if parameters.properties.parameters_link is not None:
                if parameters.properties.parameters_link.uri is None:
                    raise ValueError('parameters.properties.parameters_link.uri cannot be None.')
                
            if parameters.properties.template_link is not None:
                if parameters.properties.template_link.uri is None:
                    raise ValueError('parameters.properties.template_link.uri cannot be None.')
                
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourcegroups/'
        url = url + quote(resource_group_name)
        url = url + '/deployments/'
        url = url + quote(deployment_name)
        query_parameters = []
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        deployment_value = {}
        request_doc = deployment_value
        
        if parameters.properties is not None:
            properties_value = {}
            deployment_value['properties'] = properties_value
            
            if parameters.properties.template is not None:
                properties_value['template'] = json.loads(parameters.properties.template)
            
            if parameters.properties.template_link is not None:
                template_link_value = {}
                properties_value['templateLink'] = template_link_value
                
                template_link_value['uri'] = parameters.properties.template_link.uri
                
                if parameters.properties.template_link.content_version is not None:
                    template_link_value['contentVersion'] = parameters.properties.template_link.content_version
                
            if parameters.properties.parameters is not None:
                properties_value['parameters'] = json.loads(parameters.properties.parameters)
            
            if parameters.properties.parameters_link is not None:
                parameters_link_value = {}
                properties_value['parametersLink'] = parameters_link_value
                
                parameters_link_value['uri'] = parameters.properties.parameters_link.uri
                
                if parameters.properties.parameters_link.content_version is not None:
                    parameters_link_value['contentVersion'] = parameters.properties.parameters_link.content_version
                
            if parameters.properties.mode is not None:
                properties_value['mode'] = str(parameters.properties.mode) if parameters.properties.mode is not None else 'Incremental'
            
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = DeploymentOperationsCreateResult()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                deployment_instance = DeploymentExtended()
                result.deployment = deployment_instance
                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    deployment_instance.id = id_instance
                
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    deployment_instance.name = name_instance
                
                properties_value2 = response_doc.get('properties', None)
                if properties_value2 is not None:
                    properties_instance = DeploymentPropertiesExtended(dependencies=[], providers=[])
                    deployment_instance.properties = properties_instance
                    
                    provisioning_state_value = properties_value2.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        properties_instance.provisioning_state = provisioning_state_instance
                    
                    correlation_id_value = properties_value2.get('correlationId', None)
                    if correlation_id_value is not None:
                        correlation_id_instance = correlation_id_value
                        properties_instance.correlation_id = correlation_id_instance
                    
                    timestamp_value = properties_value2.get('timestamp', None)
                    if timestamp_value is not None:
                        timestamp_instance = timestamp_value
                        properties_instance.timestamp = timestamp_instance
                    
                    outputs_value = properties_value2.get('outputs', None)
                    if outputs_value is not None:
                        outputs_instance = json.dumps(outputs_value)
                        properties_instance.outputs = outputs_instance
                    
                    providers_array = properties_value2.get('providers', None)
                    if providers_array is not None:
                        for providers_value in providers_array:
                            provider_instance = Provider(resource_types=[])
                            properties_instance.providers.append(provider_instance)
                            
                            id_value2 = providers_value.get('id', None)
                            if id_value2 is not None:
                                id_instance2 = id_value2
                                provider_instance.id = id_instance2
                            
                            namespace_value = providers_value.get('namespace', None)
                            if namespace_value is not None:
                                namespace_instance = namespace_value
                                provider_instance.namespace = namespace_instance
                            
                            registration_state_value = providers_value.get('registrationState', None)
                            if registration_state_value is not None:
                                registration_state_instance = registration_state_value
                                provider_instance.registration_state = registration_state_instance
                            
                            resource_types_array = providers_value.get('resourceTypes', None)
                            if resource_types_array is not None:
                                for resource_types_value in resource_types_array:
                                    provider_resource_type_instance = ProviderResourceType(api_versions=[], locations=[], properties={})
                                    provider_instance.resource_types.append(provider_resource_type_instance)
                                    
                                    resource_type_value = resource_types_value.get('resourceType', None)
                                    if resource_type_value is not None:
                                        resource_type_instance = resource_type_value
                                        provider_resource_type_instance.name = resource_type_instance
                                    
                                    locations_array = resource_types_value.get('locations', None)
                                    if locations_array is not None:
                                        for locations_value in locations_array:
                                            provider_resource_type_instance.locations.append(locations_value)
                                        
                                    api_versions_array = resource_types_value.get('apiVersions', None)
                                    if api_versions_array is not None:
                                        for api_versions_value in api_versions_array:
                                            provider_resource_type_instance.api_versions.append(api_versions_value)
                                        
                                    properties_sequence_element = resource_types_value.get('properties', None)
                                    if properties_sequence_element is not None:
                                        for property in properties_sequence_element:
                                            properties_key = property
                                            properties_value3 = properties_sequence_element[property]
                                            provider_resource_type_instance.properties[properties_key] = properties_value3
                                        
                    dependencies_array = properties_value2.get('dependencies', None)
                    if dependencies_array is not None:
                        for dependencies_value in dependencies_array:
                            dependency_instance = Dependency(depends_on=[])
                            properties_instance.dependencies.append(dependency_instance)
                            
                            depends_on_array = dependencies_value.get('dependsOn', None)
                            if depends_on_array is not None:
                                for depends_on_value in depends_on_array:
                                    basic_dependency_instance = BasicDependency()
                                    dependency_instance.depends_on.append(basic_dependency_instance)
                                    
                                    id_value3 = depends_on_value.get('id', None)
                                    if id_value3 is not None:
                                        id_instance3 = id_value3
                                        basic_dependency_instance.id = id_instance3
                                    
                                    resource_type_value2 = depends_on_value.get('resourceType', None)
                                    if resource_type_value2 is not None:
                                        resource_type_instance2 = resource_type_value2
                                        basic_dependency_instance.resource_type = resource_type_instance2
                                    
                                    resource_name_value = depends_on_value.get('resourceName', None)
                                    if resource_name_value is not None:
                                        resource_name_instance = resource_name_value
                                        basic_dependency_instance.resource_name = resource_name_instance
                                    
                            id_value4 = dependencies_value.get('id', None)
                            if id_value4 is not None:
                                id_instance4 = id_value4
                                dependency_instance.id = id_instance4
                            
                            resource_type_value3 = dependencies_value.get('resourceType', None)
                            if resource_type_value3 is not None:
                                resource_type_instance3 = resource_type_value3
                                dependency_instance.resource_type = resource_type_instance3
                            
                            resource_name_value2 = dependencies_value.get('resourceName', None)
                            if resource_name_value2 is not None:
                                resource_name_instance2 = resource_name_value2
                                dependency_instance.resource_name = resource_name_instance2
                            
                    template_value = properties_value2.get('template', None)
                    if template_value is not None:
                        template_instance = json.dumps(template_value)
                        properties_instance.template = template_instance
                    
                    template_link_value2 = properties_value2.get('templateLink', None)
                    if template_link_value2 is not None:
                        template_link_instance = TemplateLink()
                        properties_instance.template_link = template_link_instance
                        
                        uri_value = template_link_value2.get('uri', None)
                        if uri_value is not None:
                            uri_instance = uri_value
                            template_link_instance.uri = uri_instance
                        
                        content_version_value = template_link_value2.get('contentVersion', None)
                        if content_version_value is not None:
                            content_version_instance = content_version_value
                            template_link_instance.content_version = content_version_instance
                        
                    parameters_value = properties_value2.get('parameters', None)
                    if parameters_value is not None:
                        parameters_instance = json.dumps(parameters_value)
                        properties_instance.parameters = parameters_instance
                    
                    parameters_link_value2 = properties_value2.get('parametersLink', None)
                    if parameters_link_value2 is not None:
                        parameters_link_instance = ParametersLink()
                        properties_instance.parameters_link = parameters_link_instance
                        
                        uri_value2 = parameters_link_value2.get('uri', None)
                        if uri_value2 is not None:
                            uri_instance2 = uri_value2
                            parameters_link_instance.uri = uri_instance2
                        
                        content_version_value2 = parameters_link_value2.get('contentVersion', None)
                        if content_version_value2 is not None:
                            content_version_instance2 = content_version_value2
                            parameters_link_instance.content_version = content_version_instance2
                        
                    mode_value = properties_value2.get('mode', None)
                    if mode_value is not None:
                        mode_instance = mode_value
                        properties_instance.mode = mode_instance
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def get(self, resource_group_name, deployment_name):
        """
         Get a deployment.
         
         Args:
         
         resource_group_name (string): The name of the resource group to get.
         The name is case insensitive.
         
         deployment_name (string): The name of the deployment.
         
         Returns:
         
         DeploymentGetResult: Template deployment information.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if resource_group_name is not None and len(resource_group_name) > 1000:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if (re.search('^[-\\w\\._]+$', resource_group_name) is not None) == False:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if deployment_name is None:
            raise ValueError('deployment_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourcegroups/'
        url = url + quote(resource_group_name)
        url = url + '/deployments/'
        url = url + quote(deployment_name)
        query_parameters = []
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = DeploymentGetResult()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                deployment_instance = DeploymentExtended()
                result.deployment = deployment_instance
                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    deployment_instance.id = id_instance
                
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    deployment_instance.name = name_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    properties_instance = DeploymentPropertiesExtended(dependencies=[], providers=[])
                    deployment_instance.properties = properties_instance
                    
                    provisioning_state_value = properties_value.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        properties_instance.provisioning_state = provisioning_state_instance
                    
                    correlation_id_value = properties_value.get('correlationId', None)
                    if correlation_id_value is not None:
                        correlation_id_instance = correlation_id_value
                        properties_instance.correlation_id = correlation_id_instance
                    
                    timestamp_value = properties_value.get('timestamp', None)
                    if timestamp_value is not None:
                        timestamp_instance = timestamp_value
                        properties_instance.timestamp = timestamp_instance
                    
                    outputs_value = properties_value.get('outputs', None)
                    if outputs_value is not None:
                        outputs_instance = json.dumps(outputs_value)
                        properties_instance.outputs = outputs_instance
                    
                    providers_array = properties_value.get('providers', None)
                    if providers_array is not None:
                        for providers_value in providers_array:
                            provider_instance = Provider(resource_types=[])
                            properties_instance.providers.append(provider_instance)
                            
                            id_value2 = providers_value.get('id', None)
                            if id_value2 is not None:
                                id_instance2 = id_value2
                                provider_instance.id = id_instance2
                            
                            namespace_value = providers_value.get('namespace', None)
                            if namespace_value is not None:
                                namespace_instance = namespace_value
                                provider_instance.namespace = namespace_instance
                            
                            registration_state_value = providers_value.get('registrationState', None)
                            if registration_state_value is not None:
                                registration_state_instance = registration_state_value
                                provider_instance.registration_state = registration_state_instance
                            
                            resource_types_array = providers_value.get('resourceTypes', None)
                            if resource_types_array is not None:
                                for resource_types_value in resource_types_array:
                                    provider_resource_type_instance = ProviderResourceType(api_versions=[], locations=[], properties={})
                                    provider_instance.resource_types.append(provider_resource_type_instance)
                                    
                                    resource_type_value = resource_types_value.get('resourceType', None)
                                    if resource_type_value is not None:
                                        resource_type_instance = resource_type_value
                                        provider_resource_type_instance.name = resource_type_instance
                                    
                                    locations_array = resource_types_value.get('locations', None)
                                    if locations_array is not None:
                                        for locations_value in locations_array:
                                            provider_resource_type_instance.locations.append(locations_value)
                                        
                                    api_versions_array = resource_types_value.get('apiVersions', None)
                                    if api_versions_array is not None:
                                        for api_versions_value in api_versions_array:
                                            provider_resource_type_instance.api_versions.append(api_versions_value)
                                        
                                    properties_sequence_element = resource_types_value.get('properties', None)
                                    if properties_sequence_element is not None:
                                        for property in properties_sequence_element:
                                            properties_key = property
                                            properties_value2 = properties_sequence_element[property]
                                            provider_resource_type_instance.properties[properties_key] = properties_value2
                                        
                    dependencies_array = properties_value.get('dependencies', None)
                    if dependencies_array is not None:
                        for dependencies_value in dependencies_array:
                            dependency_instance = Dependency(depends_on=[])
                            properties_instance.dependencies.append(dependency_instance)
                            
                            depends_on_array = dependencies_value.get('dependsOn', None)
                            if depends_on_array is not None:
                                for depends_on_value in depends_on_array:
                                    basic_dependency_instance = BasicDependency()
                                    dependency_instance.depends_on.append(basic_dependency_instance)
                                    
                                    id_value3 = depends_on_value.get('id', None)
                                    if id_value3 is not None:
                                        id_instance3 = id_value3
                                        basic_dependency_instance.id = id_instance3
                                    
                                    resource_type_value2 = depends_on_value.get('resourceType', None)
                                    if resource_type_value2 is not None:
                                        resource_type_instance2 = resource_type_value2
                                        basic_dependency_instance.resource_type = resource_type_instance2
                                    
                                    resource_name_value = depends_on_value.get('resourceName', None)
                                    if resource_name_value is not None:
                                        resource_name_instance = resource_name_value
                                        basic_dependency_instance.resource_name = resource_name_instance
                                    
                            id_value4 = dependencies_value.get('id', None)
                            if id_value4 is not None:
                                id_instance4 = id_value4
                                dependency_instance.id = id_instance4
                            
                            resource_type_value3 = dependencies_value.get('resourceType', None)
                            if resource_type_value3 is not None:
                                resource_type_instance3 = resource_type_value3
                                dependency_instance.resource_type = resource_type_instance3
                            
                            resource_name_value2 = dependencies_value.get('resourceName', None)
                            if resource_name_value2 is not None:
                                resource_name_instance2 = resource_name_value2
                                dependency_instance.resource_name = resource_name_instance2
                            
                    template_value = properties_value.get('template', None)
                    if template_value is not None:
                        template_instance = json.dumps(template_value)
                        properties_instance.template = template_instance
                    
                    template_link_value = properties_value.get('templateLink', None)
                    if template_link_value is not None:
                        template_link_instance = TemplateLink()
                        properties_instance.template_link = template_link_instance
                        
                        uri_value = template_link_value.get('uri', None)
                        if uri_value is not None:
                            uri_instance = uri_value
                            template_link_instance.uri = uri_instance
                        
                        content_version_value = template_link_value.get('contentVersion', None)
                        if content_version_value is not None:
                            content_version_instance = content_version_value
                            template_link_instance.content_version = content_version_instance
                        
                    parameters_value = properties_value.get('parameters', None)
                    if parameters_value is not None:
                        parameters_instance = json.dumps(parameters_value)
                        properties_instance.parameters = parameters_instance
                    
                    parameters_link_value = properties_value.get('parametersLink', None)
                    if parameters_link_value is not None:
                        parameters_link_instance = ParametersLink()
                        properties_instance.parameters_link = parameters_link_instance
                        
                        uri_value2 = parameters_link_value.get('uri', None)
                        if uri_value2 is not None:
                            uri_instance2 = uri_value2
                            parameters_link_instance.uri = uri_instance2
                        
                        content_version_value2 = parameters_link_value.get('contentVersion', None)
                        if content_version_value2 is not None:
                            content_version_instance2 = content_version_value2
                            parameters_link_instance.content_version = content_version_instance2
                        
                    mode_value = properties_value.get('mode', None)
                    if mode_value is not None:
                        mode_instance = mode_value
                        properties_instance.mode = mode_instance
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self, resource_group_name, parameters):
        """
         Get a list of deployments.
         
         Args:
         
         resource_group_name (string): The name of the resource group to filter
         by. The name is case insensitive.
         
         parameters (DeploymentListParameters): Query parameters. If null is
         passed returns all deployments.
         
         Returns:
         
         DeploymentListResult: List of deployments.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/'
        url = url + 'resourcegroups/' + quote(resource_group_name) + '/'
        url = url + 'deployments/'
        query_parameters = []
        odata_filter = []
        if parameters is not None and parameters.provisioning_state is not None:
            odata_filter.append('provisioningState eq \'' + quote(parameters.provisioning_state) + '\'')
        
        if len(odata_filter) > 0:
            query_parameters.append('$filter=' + ''.join(odata_filter))
        
        if parameters is not None and parameters.top is not None:
            query_parameters.append('$top=' + quote(str(parameters.top)))
        
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = DeploymentListResult(deployments=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        deployment_extended_instance = DeploymentExtended()
                        result.deployments.append(deployment_extended_instance)
                        
                        id_value = value_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            deployment_extended_instance.id = id_instance
                        
                        name_value = value_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            deployment_extended_instance.name = name_instance
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            properties_instance = DeploymentPropertiesExtended(dependencies=[], providers=[])
                            deployment_extended_instance.properties = properties_instance
                            
                            provisioning_state_value = properties_value.get('provisioningState', None)
                            if provisioning_state_value is not None:
                                provisioning_state_instance = provisioning_state_value
                                properties_instance.provisioning_state = provisioning_state_instance
                            
                            correlation_id_value = properties_value.get('correlationId', None)
                            if correlation_id_value is not None:
                                correlation_id_instance = correlation_id_value
                                properties_instance.correlation_id = correlation_id_instance
                            
                            timestamp_value = properties_value.get('timestamp', None)
                            if timestamp_value is not None:
                                timestamp_instance = timestamp_value
                                properties_instance.timestamp = timestamp_instance
                            
                            outputs_value = properties_value.get('outputs', None)
                            if outputs_value is not None:
                                outputs_instance = json.dumps(outputs_value)
                                properties_instance.outputs = outputs_instance
                            
                            providers_array = properties_value.get('providers', None)
                            if providers_array is not None:
                                for providers_value in providers_array:
                                    provider_instance = Provider(resource_types=[])
                                    properties_instance.providers.append(provider_instance)
                                    
                                    id_value2 = providers_value.get('id', None)
                                    if id_value2 is not None:
                                        id_instance2 = id_value2
                                        provider_instance.id = id_instance2
                                    
                                    namespace_value = providers_value.get('namespace', None)
                                    if namespace_value is not None:
                                        namespace_instance = namespace_value
                                        provider_instance.namespace = namespace_instance
                                    
                                    registration_state_value = providers_value.get('registrationState', None)
                                    if registration_state_value is not None:
                                        registration_state_instance = registration_state_value
                                        provider_instance.registration_state = registration_state_instance
                                    
                                    resource_types_array = providers_value.get('resourceTypes', None)
                                    if resource_types_array is not None:
                                        for resource_types_value in resource_types_array:
                                            provider_resource_type_instance = ProviderResourceType(api_versions=[], locations=[], properties={})
                                            provider_instance.resource_types.append(provider_resource_type_instance)
                                            
                                            resource_type_value = resource_types_value.get('resourceType', None)
                                            if resource_type_value is not None:
                                                resource_type_instance = resource_type_value
                                                provider_resource_type_instance.name = resource_type_instance
                                            
                                            locations_array = resource_types_value.get('locations', None)
                                            if locations_array is not None:
                                                for locations_value in locations_array:
                                                    provider_resource_type_instance.locations.append(locations_value)
                                                
                                            api_versions_array = resource_types_value.get('apiVersions', None)
                                            if api_versions_array is not None:
                                                for api_versions_value in api_versions_array:
                                                    provider_resource_type_instance.api_versions.append(api_versions_value)
                                                
                                            properties_sequence_element = resource_types_value.get('properties', None)
                                            if properties_sequence_element is not None:
                                                for property in properties_sequence_element:
                                                    properties_key = property
                                                    properties_value2 = properties_sequence_element[property]
                                                    provider_resource_type_instance.properties[properties_key] = properties_value2
                                                
                            dependencies_array = properties_value.get('dependencies', None)
                            if dependencies_array is not None:
                                for dependencies_value in dependencies_array:
                                    dependency_instance = Dependency(depends_on=[])
                                    properties_instance.dependencies.append(dependency_instance)
                                    
                                    depends_on_array = dependencies_value.get('dependsOn', None)
                                    if depends_on_array is not None:
                                        for depends_on_value in depends_on_array:
                                            basic_dependency_instance = BasicDependency()
                                            dependency_instance.depends_on.append(basic_dependency_instance)
                                            
                                            id_value3 = depends_on_value.get('id', None)
                                            if id_value3 is not None:
                                                id_instance3 = id_value3
                                                basic_dependency_instance.id = id_instance3
                                            
                                            resource_type_value2 = depends_on_value.get('resourceType', None)
                                            if resource_type_value2 is not None:
                                                resource_type_instance2 = resource_type_value2
                                                basic_dependency_instance.resource_type = resource_type_instance2
                                            
                                            resource_name_value = depends_on_value.get('resourceName', None)
                                            if resource_name_value is not None:
                                                resource_name_instance = resource_name_value
                                                basic_dependency_instance.resource_name = resource_name_instance
                                            
                                    id_value4 = dependencies_value.get('id', None)
                                    if id_value4 is not None:
                                        id_instance4 = id_value4
                                        dependency_instance.id = id_instance4
                                    
                                    resource_type_value3 = dependencies_value.get('resourceType', None)
                                    if resource_type_value3 is not None:
                                        resource_type_instance3 = resource_type_value3
                                        dependency_instance.resource_type = resource_type_instance3
                                    
                                    resource_name_value2 = dependencies_value.get('resourceName', None)
                                    if resource_name_value2 is not None:
                                        resource_name_instance2 = resource_name_value2
                                        dependency_instance.resource_name = resource_name_instance2
                                    
                            template_value = properties_value.get('template', None)
                            if template_value is not None:
                                template_instance = json.dumps(template_value)
                                properties_instance.template = template_instance
                            
                            template_link_value = properties_value.get('templateLink', None)
                            if template_link_value is not None:
                                template_link_instance = TemplateLink()
                                properties_instance.template_link = template_link_instance
                                
                                uri_value = template_link_value.get('uri', None)
                                if uri_value is not None:
                                    uri_instance = uri_value
                                    template_link_instance.uri = uri_instance
                                
                                content_version_value = template_link_value.get('contentVersion', None)
                                if content_version_value is not None:
                                    content_version_instance = content_version_value
                                    template_link_instance.content_version = content_version_instance
                                
                            parameters_value = properties_value.get('parameters', None)
                            if parameters_value is not None:
                                parameters_instance = json.dumps(parameters_value)
                                properties_instance.parameters = parameters_instance
                            
                            parameters_link_value = properties_value.get('parametersLink', None)
                            if parameters_link_value is not None:
                                parameters_link_instance = ParametersLink()
                                properties_instance.parameters_link = parameters_link_instance
                                
                                uri_value2 = parameters_link_value.get('uri', None)
                                if uri_value2 is not None:
                                    uri_instance2 = uri_value2
                                    parameters_link_instance.uri = uri_instance2
                                
                                content_version_value2 = parameters_link_value.get('contentVersion', None)
                                if content_version_value2 is not None:
                                    content_version_instance2 = content_version_value2
                                    parameters_link_instance.content_version = content_version_instance2
                                
                            mode_value = properties_value.get('mode', None)
                            if mode_value is not None:
                                mode_instance = mode_value
                                properties_instance.mode = mode_instance
                            
                odatanext_link_value = response_doc.get('@odata.nextLink', None)
                if odatanext_link_value is not None:
                    odatanext_link_instance = odatanext_link_value
                    result.next_link = odatanext_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_next(self, next_link):
        """
         Get a list of deployments.
         
         Args:
         
         next_link (string): NextLink from the previous successful call to List
         operation.
         
         Returns:
         
         DeploymentListResult: List of deployments.
        """
        # Validate
        if next_link is None:
            raise ValueError('next_link cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + next_link
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = DeploymentListResult(deployments=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        deployment_extended_instance = DeploymentExtended()
                        result.deployments.append(deployment_extended_instance)
                        
                        id_value = value_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            deployment_extended_instance.id = id_instance
                        
                        name_value = value_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            deployment_extended_instance.name = name_instance
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            properties_instance = DeploymentPropertiesExtended(dependencies=[], providers=[])
                            deployment_extended_instance.properties = properties_instance
                            
                            provisioning_state_value = properties_value.get('provisioningState', None)
                            if provisioning_state_value is not None:
                                provisioning_state_instance = provisioning_state_value
                                properties_instance.provisioning_state = provisioning_state_instance
                            
                            correlation_id_value = properties_value.get('correlationId', None)
                            if correlation_id_value is not None:
                                correlation_id_instance = correlation_id_value
                                properties_instance.correlation_id = correlation_id_instance
                            
                            timestamp_value = properties_value.get('timestamp', None)
                            if timestamp_value is not None:
                                timestamp_instance = timestamp_value
                                properties_instance.timestamp = timestamp_instance
                            
                            outputs_value = properties_value.get('outputs', None)
                            if outputs_value is not None:
                                outputs_instance = json.dumps(outputs_value)
                                properties_instance.outputs = outputs_instance
                            
                            providers_array = properties_value.get('providers', None)
                            if providers_array is not None:
                                for providers_value in providers_array:
                                    provider_instance = Provider(resource_types=[])
                                    properties_instance.providers.append(provider_instance)
                                    
                                    id_value2 = providers_value.get('id', None)
                                    if id_value2 is not None:
                                        id_instance2 = id_value2
                                        provider_instance.id = id_instance2
                                    
                                    namespace_value = providers_value.get('namespace', None)
                                    if namespace_value is not None:
                                        namespace_instance = namespace_value
                                        provider_instance.namespace = namespace_instance
                                    
                                    registration_state_value = providers_value.get('registrationState', None)
                                    if registration_state_value is not None:
                                        registration_state_instance = registration_state_value
                                        provider_instance.registration_state = registration_state_instance
                                    
                                    resource_types_array = providers_value.get('resourceTypes', None)
                                    if resource_types_array is not None:
                                        for resource_types_value in resource_types_array:
                                            provider_resource_type_instance = ProviderResourceType(api_versions=[], locations=[], properties={})
                                            provider_instance.resource_types.append(provider_resource_type_instance)
                                            
                                            resource_type_value = resource_types_value.get('resourceType', None)
                                            if resource_type_value is not None:
                                                resource_type_instance = resource_type_value
                                                provider_resource_type_instance.name = resource_type_instance
                                            
                                            locations_array = resource_types_value.get('locations', None)
                                            if locations_array is not None:
                                                for locations_value in locations_array:
                                                    provider_resource_type_instance.locations.append(locations_value)
                                                
                                            api_versions_array = resource_types_value.get('apiVersions', None)
                                            if api_versions_array is not None:
                                                for api_versions_value in api_versions_array:
                                                    provider_resource_type_instance.api_versions.append(api_versions_value)
                                                
                                            properties_sequence_element = resource_types_value.get('properties', None)
                                            if properties_sequence_element is not None:
                                                for property in properties_sequence_element:
                                                    properties_key = property
                                                    properties_value2 = properties_sequence_element[property]
                                                    provider_resource_type_instance.properties[properties_key] = properties_value2
                                                
                            dependencies_array = properties_value.get('dependencies', None)
                            if dependencies_array is not None:
                                for dependencies_value in dependencies_array:
                                    dependency_instance = Dependency(depends_on=[])
                                    properties_instance.dependencies.append(dependency_instance)
                                    
                                    depends_on_array = dependencies_value.get('dependsOn', None)
                                    if depends_on_array is not None:
                                        for depends_on_value in depends_on_array:
                                            basic_dependency_instance = BasicDependency()
                                            dependency_instance.depends_on.append(basic_dependency_instance)
                                            
                                            id_value3 = depends_on_value.get('id', None)
                                            if id_value3 is not None:
                                                id_instance3 = id_value3
                                                basic_dependency_instance.id = id_instance3
                                            
                                            resource_type_value2 = depends_on_value.get('resourceType', None)
                                            if resource_type_value2 is not None:
                                                resource_type_instance2 = resource_type_value2
                                                basic_dependency_instance.resource_type = resource_type_instance2
                                            
                                            resource_name_value = depends_on_value.get('resourceName', None)
                                            if resource_name_value is not None:
                                                resource_name_instance = resource_name_value
                                                basic_dependency_instance.resource_name = resource_name_instance
                                            
                                    id_value4 = dependencies_value.get('id', None)
                                    if id_value4 is not None:
                                        id_instance4 = id_value4
                                        dependency_instance.id = id_instance4
                                    
                                    resource_type_value3 = dependencies_value.get('resourceType', None)
                                    if resource_type_value3 is not None:
                                        resource_type_instance3 = resource_type_value3
                                        dependency_instance.resource_type = resource_type_instance3
                                    
                                    resource_name_value2 = dependencies_value.get('resourceName', None)
                                    if resource_name_value2 is not None:
                                        resource_name_instance2 = resource_name_value2
                                        dependency_instance.resource_name = resource_name_instance2
                                    
                            template_value = properties_value.get('template', None)
                            if template_value is not None:
                                template_instance = json.dumps(template_value)
                                properties_instance.template = template_instance
                            
                            template_link_value = properties_value.get('templateLink', None)
                            if template_link_value is not None:
                                template_link_instance = TemplateLink()
                                properties_instance.template_link = template_link_instance
                                
                                uri_value = template_link_value.get('uri', None)
                                if uri_value is not None:
                                    uri_instance = uri_value
                                    template_link_instance.uri = uri_instance
                                
                                content_version_value = template_link_value.get('contentVersion', None)
                                if content_version_value is not None:
                                    content_version_instance = content_version_value
                                    template_link_instance.content_version = content_version_instance
                                
                            parameters_value = properties_value.get('parameters', None)
                            if parameters_value is not None:
                                parameters_instance = json.dumps(parameters_value)
                                properties_instance.parameters = parameters_instance
                            
                            parameters_link_value = properties_value.get('parametersLink', None)
                            if parameters_link_value is not None:
                                parameters_link_instance = ParametersLink()
                                properties_instance.parameters_link = parameters_link_instance
                                
                                uri_value2 = parameters_link_value.get('uri', None)
                                if uri_value2 is not None:
                                    uri_instance2 = uri_value2
                                    parameters_link_instance.uri = uri_instance2
                                
                                content_version_value2 = parameters_link_value.get('contentVersion', None)
                                if content_version_value2 is not None:
                                    content_version_instance2 = content_version_value2
                                    parameters_link_instance.content_version = content_version_instance2
                                
                            mode_value = properties_value.get('mode', None)
                            if mode_value is not None:
                                mode_instance = mode_value
                                properties_instance.mode = mode_instance
                            
                odatanext_link_value = response_doc.get('@odata.nextLink', None)
                if odatanext_link_value is not None:
                    odatanext_link_instance = odatanext_link_value
                    result.next_link = odatanext_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def validate(self, resource_group_name, deployment_name, parameters):
        """
         Validate a deployment template.
         
         Args:
         
         resource_group_name (string): The name of the resource group. The name
         is case insensitive.
         
         deployment_name (string): The name of the deployment.
         
         parameters (Deployment): Deployment to validate.
         
         Returns:
         
         DeploymentValidateResponse: Information from validate template
         deployment response.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if resource_group_name is not None and len(resource_group_name) > 1000:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if (re.search('^[-\\w\\._]+$', resource_group_name) is not None) == False:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if deployment_name is None:
            raise ValueError('deployment_name cannot be None.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        if parameters.properties is not None:
            if parameters.properties.parameters_link is not None:
                if parameters.properties.parameters_link.uri is None:
                    raise ValueError('parameters.properties.parameters_link.uri cannot be None.')
                
            if parameters.properties.template_link is not None:
                if parameters.properties.template_link.uri is None:
                    raise ValueError('parameters.properties.template_link.uri cannot be None.')
                
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourcegroups/'
        url = url + quote(resource_group_name)
        url = url + '/deployments/'
        url = url + quote(deployment_name)
        url = url + '/validate'
        query_parameters = []
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'POST'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        deployment_value = {}
        request_doc = deployment_value
        
        if parameters.properties is not None:
            properties_value = {}
            deployment_value['properties'] = properties_value
            
            if parameters.properties.template is not None:
                properties_value['template'] = json.loads(parameters.properties.template)
            
            if parameters.properties.template_link is not None:
                template_link_value = {}
                properties_value['templateLink'] = template_link_value
                
                template_link_value['uri'] = parameters.properties.template_link.uri
                
                if parameters.properties.template_link.content_version is not None:
                    template_link_value['contentVersion'] = parameters.properties.template_link.content_version
                
            if parameters.properties.parameters is not None:
                properties_value['parameters'] = json.loads(parameters.properties.parameters)
            
            if parameters.properties.parameters_link is not None:
                parameters_link_value = {}
                properties_value['parametersLink'] = parameters_link_value
                
                parameters_link_value['uri'] = parameters.properties.parameters_link.uri
                
                if parameters.properties.parameters_link.content_version is not None:
                    parameters_link_value['contentVersion'] = parameters.properties.parameters_link.content_version
                
            if parameters.properties.mode is not None:
                properties_value['mode'] = str(parameters.properties.mode) if parameters.properties.mode is not None else 'Incremental'
            
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 400:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 400:
            response_content = body
            result = DeploymentValidateResponse()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                error_value = response_doc.get('error', None)
                if error_value is not None:
                    error_instance = ResourceManagementErrorWithDetails(details=[])
                    result.error = error_instance
                    
                    details_array = error_value.get('details', None)
                    if details_array is not None:
                        for details_value in details_array:
                            resource_management_error_instance = ResourceManagementError()
                            error_instance.details.append(resource_management_error_instance)
                            
                            code_value = details_value.get('code', None)
                            if code_value is not None:
                                code_instance = code_value
                                resource_management_error_instance.code = code_instance
                            
                            message_value = details_value.get('message', None)
                            if message_value is not None:
                                message_instance = message_value
                                resource_management_error_instance.message = message_instance
                            
                            target_value = details_value.get('target', None)
                            if target_value is not None:
                                target_instance = target_value
                                resource_management_error_instance.target = target_instance
                            
                    code_value2 = error_value.get('code', None)
                    if code_value2 is not None:
                        code_instance2 = code_value2
                        error_instance.code = code_instance2
                    
                    message_value2 = error_value.get('message', None)
                    if message_value2 is not None:
                        message_instance2 = message_value2
                        error_instance.message = message_instance2
                    
                    target_value2 = error_value.get('target', None)
                    if target_value2 is not None:
                        target_instance2 = target_value2
                        error_instance.target = target_instance2
                    
                properties_value2 = response_doc.get('properties', None)
                if properties_value2 is not None:
                    properties_instance = DeploymentPropertiesExtended(dependencies=[], providers=[])
                    result.properties = properties_instance
                    
                    provisioning_state_value = properties_value2.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        properties_instance.provisioning_state = provisioning_state_instance
                    
                    correlation_id_value = properties_value2.get('correlationId', None)
                    if correlation_id_value is not None:
                        correlation_id_instance = correlation_id_value
                        properties_instance.correlation_id = correlation_id_instance
                    
                    timestamp_value = properties_value2.get('timestamp', None)
                    if timestamp_value is not None:
                        timestamp_instance = timestamp_value
                        properties_instance.timestamp = timestamp_instance
                    
                    outputs_value = properties_value2.get('outputs', None)
                    if outputs_value is not None:
                        outputs_instance = json.dumps(outputs_value)
                        properties_instance.outputs = outputs_instance
                    
                    providers_array = properties_value2.get('providers', None)
                    if providers_array is not None:
                        for providers_value in providers_array:
                            provider_instance = Provider(resource_types=[])
                            properties_instance.providers.append(provider_instance)
                            
                            id_value = providers_value.get('id', None)
                            if id_value is not None:
                                id_instance = id_value
                                provider_instance.id = id_instance
                            
                            namespace_value = providers_value.get('namespace', None)
                            if namespace_value is not None:
                                namespace_instance = namespace_value
                                provider_instance.namespace = namespace_instance
                            
                            registration_state_value = providers_value.get('registrationState', None)
                            if registration_state_value is not None:
                                registration_state_instance = registration_state_value
                                provider_instance.registration_state = registration_state_instance
                            
                            resource_types_array = providers_value.get('resourceTypes', None)
                            if resource_types_array is not None:
                                for resource_types_value in resource_types_array:
                                    provider_resource_type_instance = ProviderResourceType(api_versions=[], locations=[], properties={})
                                    provider_instance.resource_types.append(provider_resource_type_instance)
                                    
                                    resource_type_value = resource_types_value.get('resourceType', None)
                                    if resource_type_value is not None:
                                        resource_type_instance = resource_type_value
                                        provider_resource_type_instance.name = resource_type_instance
                                    
                                    locations_array = resource_types_value.get('locations', None)
                                    if locations_array is not None:
                                        for locations_value in locations_array:
                                            provider_resource_type_instance.locations.append(locations_value)
                                        
                                    api_versions_array = resource_types_value.get('apiVersions', None)
                                    if api_versions_array is not None:
                                        for api_versions_value in api_versions_array:
                                            provider_resource_type_instance.api_versions.append(api_versions_value)
                                        
                                    properties_sequence_element = resource_types_value.get('properties', None)
                                    if properties_sequence_element is not None:
                                        for property in properties_sequence_element:
                                            properties_key = property
                                            properties_value3 = properties_sequence_element[property]
                                            provider_resource_type_instance.properties[properties_key] = properties_value3
                                        
                    dependencies_array = properties_value2.get('dependencies', None)
                    if dependencies_array is not None:
                        for dependencies_value in dependencies_array:
                            dependency_instance = Dependency(depends_on=[])
                            properties_instance.dependencies.append(dependency_instance)
                            
                            depends_on_array = dependencies_value.get('dependsOn', None)
                            if depends_on_array is not None:
                                for depends_on_value in depends_on_array:
                                    basic_dependency_instance = BasicDependency()
                                    dependency_instance.depends_on.append(basic_dependency_instance)
                                    
                                    id_value2 = depends_on_value.get('id', None)
                                    if id_value2 is not None:
                                        id_instance2 = id_value2
                                        basic_dependency_instance.id = id_instance2
                                    
                                    resource_type_value2 = depends_on_value.get('resourceType', None)
                                    if resource_type_value2 is not None:
                                        resource_type_instance2 = resource_type_value2
                                        basic_dependency_instance.resource_type = resource_type_instance2
                                    
                                    resource_name_value = depends_on_value.get('resourceName', None)
                                    if resource_name_value is not None:
                                        resource_name_instance = resource_name_value
                                        basic_dependency_instance.resource_name = resource_name_instance
                                    
                            id_value3 = dependencies_value.get('id', None)
                            if id_value3 is not None:
                                id_instance3 = id_value3
                                dependency_instance.id = id_instance3
                            
                            resource_type_value3 = dependencies_value.get('resourceType', None)
                            if resource_type_value3 is not None:
                                resource_type_instance3 = resource_type_value3
                                dependency_instance.resource_type = resource_type_instance3
                            
                            resource_name_value2 = dependencies_value.get('resourceName', None)
                            if resource_name_value2 is not None:
                                resource_name_instance2 = resource_name_value2
                                dependency_instance.resource_name = resource_name_instance2
                            
                    template_value = properties_value2.get('template', None)
                    if template_value is not None:
                        template_instance = json.dumps(template_value)
                        properties_instance.template = template_instance
                    
                    template_link_value2 = properties_value2.get('templateLink', None)
                    if template_link_value2 is not None:
                        template_link_instance = TemplateLink()
                        properties_instance.template_link = template_link_instance
                        
                        uri_value = template_link_value2.get('uri', None)
                        if uri_value is not None:
                            uri_instance = uri_value
                            template_link_instance.uri = uri_instance
                        
                        content_version_value = template_link_value2.get('contentVersion', None)
                        if content_version_value is not None:
                            content_version_instance = content_version_value
                            template_link_instance.content_version = content_version_instance
                        
                    parameters_value = properties_value2.get('parameters', None)
                    if parameters_value is not None:
                        parameters_instance = json.dumps(parameters_value)
                        properties_instance.parameters = parameters_instance
                    
                    parameters_link_value2 = properties_value2.get('parametersLink', None)
                    if parameters_link_value2 is not None:
                        parameters_link_instance = ParametersLink()
                        properties_instance.parameters_link = parameters_link_instance
                        
                        uri_value2 = parameters_link_value2.get('uri', None)
                        if uri_value2 is not None:
                            uri_instance2 = uri_value2
                            parameters_link_instance.uri = uri_instance2
                        
                        content_version_value2 = parameters_link_value2.get('contentVersion', None)
                        if content_version_value2 is not None:
                            content_version_instance2 = content_version_value2
                            parameters_link_instance.content_version = content_version_instance2
                        
                    mode_value = properties_value2.get('mode', None)
                    if mode_value is not None:
                        mode_instance = mode_value
                        properties_instance.mode = mode_instance
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        if status_code == 200:
            result.is_valid = True
        
        return result
    
class ProviderOperations(object):
    """
     Operations for managing providers.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [ResourceManagementClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Resources.ResourceManagementClient.
        """
        return self._client
    
    def get(self, resource_provider_namespace):
        """
         Gets a resource provider.
         
         Args:
         
         resource_provider_namespace (string): Namespace of the resource
         provider.
         
         Returns:
         
         ProviderGetResult: Resource provider information.
        """
        # Validate
        if resource_provider_namespace is None:
            raise ValueError('resource_provider_namespace cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + quote(resource_provider_namespace)
        query_parameters = []
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = ProviderGetResult()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                provider_instance = Provider(resource_types=[])
                result.provider = provider_instance
                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    provider_instance.id = id_instance
                
                namespace_value = response_doc.get('namespace', None)
                if namespace_value is not None:
                    namespace_instance = namespace_value
                    provider_instance.namespace = namespace_instance
                
                registration_state_value = response_doc.get('registrationState', None)
                if registration_state_value is not None:
                    registration_state_instance = registration_state_value
                    provider_instance.registration_state = registration_state_instance
                
                resource_types_array = response_doc.get('resourceTypes', None)
                if resource_types_array is not None:
                    for resource_types_value in resource_types_array:
                        provider_resource_type_instance = ProviderResourceType(api_versions=[], locations=[], properties={})
                        provider_instance.resource_types.append(provider_resource_type_instance)
                        
                        resource_type_value = resource_types_value.get('resourceType', None)
                        if resource_type_value is not None:
                            resource_type_instance = resource_type_value
                            provider_resource_type_instance.name = resource_type_instance
                        
                        locations_array = resource_types_value.get('locations', None)
                        if locations_array is not None:
                            for locations_value in locations_array:
                                provider_resource_type_instance.locations.append(locations_value)
                            
                        api_versions_array = resource_types_value.get('apiVersions', None)
                        if api_versions_array is not None:
                            for api_versions_value in api_versions_array:
                                provider_resource_type_instance.api_versions.append(api_versions_value)
                            
                        properties_sequence_element = resource_types_value.get('properties', None)
                        if properties_sequence_element is not None:
                            for property in properties_sequence_element:
                                properties_key = property
                                properties_value = properties_sequence_element[property]
                                provider_resource_type_instance.properties[properties_key] = properties_value
                            
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self, parameters):
        """
         Gets a list of resource providers.
         
         Args:
         
         parameters (ProviderListParameters): Query parameters. If null is
         passed returns all deployments.
         
         Returns:
         
         ProviderListResult: List of resource providers.
        """
        # Validate
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers'
        query_parameters = []
        if parameters is not None and parameters.top is not None:
            query_parameters.append('$top=' + quote(str(parameters.top)))
        
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = ProviderListResult(providers=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        provider_instance = Provider(resource_types=[])
                        result.providers.append(provider_instance)
                        
                        id_value = value_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            provider_instance.id = id_instance
                        
                        namespace_value = value_value.get('namespace', None)
                        if namespace_value is not None:
                            namespace_instance = namespace_value
                            provider_instance.namespace = namespace_instance
                        
                        registration_state_value = value_value.get('registrationState', None)
                        if registration_state_value is not None:
                            registration_state_instance = registration_state_value
                            provider_instance.registration_state = registration_state_instance
                        
                        resource_types_array = value_value.get('resourceTypes', None)
                        if resource_types_array is not None:
                            for resource_types_value in resource_types_array:
                                provider_resource_type_instance = ProviderResourceType(api_versions=[], locations=[], properties={})
                                provider_instance.resource_types.append(provider_resource_type_instance)
                                
                                resource_type_value = resource_types_value.get('resourceType', None)
                                if resource_type_value is not None:
                                    resource_type_instance = resource_type_value
                                    provider_resource_type_instance.name = resource_type_instance
                                
                                locations_array = resource_types_value.get('locations', None)
                                if locations_array is not None:
                                    for locations_value in locations_array:
                                        provider_resource_type_instance.locations.append(locations_value)
                                    
                                api_versions_array = resource_types_value.get('apiVersions', None)
                                if api_versions_array is not None:
                                    for api_versions_value in api_versions_array:
                                        provider_resource_type_instance.api_versions.append(api_versions_value)
                                    
                                properties_sequence_element = resource_types_value.get('properties', None)
                                if properties_sequence_element is not None:
                                    for property in properties_sequence_element:
                                        properties_key = property
                                        properties_value = properties_sequence_element[property]
                                        provider_resource_type_instance.properties[properties_key] = properties_value
                                    
                odatanext_link_value = response_doc.get('@odata.nextLink', None)
                if odatanext_link_value is not None:
                    odatanext_link_instance = odatanext_link_value
                    result.next_link = odatanext_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_next(self, next_link):
        """
         Get a list of deployments.
         
         Args:
         
         next_link (string): NextLink from the previous successful call to List
         operation.
         
         Returns:
         
         ProviderListResult: List of resource providers.
        """
        # Validate
        if next_link is None:
            raise ValueError('next_link cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + next_link
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = ProviderListResult(providers=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        provider_instance = Provider(resource_types=[])
                        result.providers.append(provider_instance)
                        
                        id_value = value_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            provider_instance.id = id_instance
                        
                        namespace_value = value_value.get('namespace', None)
                        if namespace_value is not None:
                            namespace_instance = namespace_value
                            provider_instance.namespace = namespace_instance
                        
                        registration_state_value = value_value.get('registrationState', None)
                        if registration_state_value is not None:
                            registration_state_instance = registration_state_value
                            provider_instance.registration_state = registration_state_instance
                        
                        resource_types_array = value_value.get('resourceTypes', None)
                        if resource_types_array is not None:
                            for resource_types_value in resource_types_array:
                                provider_resource_type_instance = ProviderResourceType(api_versions=[], locations=[], properties={})
                                provider_instance.resource_types.append(provider_resource_type_instance)
                                
                                resource_type_value = resource_types_value.get('resourceType', None)
                                if resource_type_value is not None:
                                    resource_type_instance = resource_type_value
                                    provider_resource_type_instance.name = resource_type_instance
                                
                                locations_array = resource_types_value.get('locations', None)
                                if locations_array is not None:
                                    for locations_value in locations_array:
                                        provider_resource_type_instance.locations.append(locations_value)
                                    
                                api_versions_array = resource_types_value.get('apiVersions', None)
                                if api_versions_array is not None:
                                    for api_versions_value in api_versions_array:
                                        provider_resource_type_instance.api_versions.append(api_versions_value)
                                    
                                properties_sequence_element = resource_types_value.get('properties', None)
                                if properties_sequence_element is not None:
                                    for property in properties_sequence_element:
                                        properties_key = property
                                        properties_value = properties_sequence_element[property]
                                        provider_resource_type_instance.properties[properties_key] = properties_value
                                    
                odatanext_link_value = response_doc.get('@odata.nextLink', None)
                if odatanext_link_value is not None:
                    odatanext_link_instance = odatanext_link_value
                    result.next_link = odatanext_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def register(self, resource_provider_namespace):
        """
         Registers provider to be used with a subscription.
         
         Args:
         
         resource_provider_namespace (string): Namespace of the resource
         provider.
         
         Returns:
         
         ProviderRegistionResult: Resource provider registration information.
        """
        # Validate
        if resource_provider_namespace is None:
            raise ValueError('resource_provider_namespace cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + quote(resource_provider_namespace)
        url = url + '/register'
        query_parameters = []
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'POST'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = ProviderRegistionResult()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                provider_instance = Provider(resource_types=[])
                result.provider = provider_instance
                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    provider_instance.id = id_instance
                
                namespace_value = response_doc.get('namespace', None)
                if namespace_value is not None:
                    namespace_instance = namespace_value
                    provider_instance.namespace = namespace_instance
                
                registration_state_value = response_doc.get('registrationState', None)
                if registration_state_value is not None:
                    registration_state_instance = registration_state_value
                    provider_instance.registration_state = registration_state_instance
                
                resource_types_array = response_doc.get('resourceTypes', None)
                if resource_types_array is not None:
                    for resource_types_value in resource_types_array:
                        provider_resource_type_instance = ProviderResourceType(api_versions=[], locations=[], properties={})
                        provider_instance.resource_types.append(provider_resource_type_instance)
                        
                        resource_type_value = resource_types_value.get('resourceType', None)
                        if resource_type_value is not None:
                            resource_type_instance = resource_type_value
                            provider_resource_type_instance.name = resource_type_instance
                        
                        locations_array = resource_types_value.get('locations', None)
                        if locations_array is not None:
                            for locations_value in locations_array:
                                provider_resource_type_instance.locations.append(locations_value)
                            
                        api_versions_array = resource_types_value.get('apiVersions', None)
                        if api_versions_array is not None:
                            for api_versions_value in api_versions_array:
                                provider_resource_type_instance.api_versions.append(api_versions_value)
                            
                        properties_sequence_element = resource_types_value.get('properties', None)
                        if properties_sequence_element is not None:
                            for property in properties_sequence_element:
                                properties_key = property
                                properties_value = properties_sequence_element[property]
                                provider_resource_type_instance.properties[properties_key] = properties_value
                            
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def unregister(self, resource_provider_namespace):
        """
         Unregisters provider from a subscription.
         
         Args:
         
         resource_provider_namespace (string): Namespace of the resource
         provider.
         
         Returns:
         
         ProviderUnregistionResult: Resource provider registration information.
        """
        # Validate
        if resource_provider_namespace is None:
            raise ValueError('resource_provider_namespace cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/providers/'
        url = url + quote(resource_provider_namespace)
        url = url + '/unregister'
        query_parameters = []
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'POST'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = ProviderUnregistionResult()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                provider_instance = Provider(resource_types=[])
                result.provider = provider_instance
                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    provider_instance.id = id_instance
                
                namespace_value = response_doc.get('namespace', None)
                if namespace_value is not None:
                    namespace_instance = namespace_value
                    provider_instance.namespace = namespace_instance
                
                registration_state_value = response_doc.get('registrationState', None)
                if registration_state_value is not None:
                    registration_state_instance = registration_state_value
                    provider_instance.registration_state = registration_state_instance
                
                resource_types_array = response_doc.get('resourceTypes', None)
                if resource_types_array is not None:
                    for resource_types_value in resource_types_array:
                        provider_resource_type_instance = ProviderResourceType(api_versions=[], locations=[], properties={})
                        provider_instance.resource_types.append(provider_resource_type_instance)
                        
                        resource_type_value = resource_types_value.get('resourceType', None)
                        if resource_type_value is not None:
                            resource_type_instance = resource_type_value
                            provider_resource_type_instance.name = resource_type_instance
                        
                        locations_array = resource_types_value.get('locations', None)
                        if locations_array is not None:
                            for locations_value in locations_array:
                                provider_resource_type_instance.locations.append(locations_value)
                            
                        api_versions_array = resource_types_value.get('apiVersions', None)
                        if api_versions_array is not None:
                            for api_versions_value in api_versions_array:
                                provider_resource_type_instance.api_versions.append(api_versions_value)
                            
                        properties_sequence_element = resource_types_value.get('properties', None)
                        if properties_sequence_element is not None:
                            for property in properties_sequence_element:
                                properties_key = property
                                properties_value = properties_sequence_element[property]
                                provider_resource_type_instance.properties[properties_key] = properties_value
                            
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class ResourceGroupOperations(object):
    """
     Operations for managing resource groups.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [ResourceManagementClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Resources.ResourceManagementClient.
        """
        return self._client
    
    def begin_deleting(self, resource_group_name):
        """
         Begin deleting resource group.To determine whether the operation has
         finished processing the request, call GetLongRunningOperationStatus.
         
         Args:
         
         resource_group_name (string): The name of the resource group to be
         deleted. The name is case insensitive.
         
         Returns:
         
         LongRunningOperationResponse: A standard service response for long
         running operations.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if resource_group_name is not None and len(resource_group_name) > 1000:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if (re.search('^[-\\w\\._]+$', resource_group_name) is not None) == False:
            raise IndexError('resource_group_name is outside the valid range.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourcegroups/'
        url = url + quote(resource_group_name)
        query_parameters = []
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'DELETE'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 202:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = LongRunningOperationResponse()
        result.status_code = status_code
        result.operation_status_link = response.headers.get('location')
        result.retry_after = int(response.headers.get('retry-after', '0'))
        result.request_id = response.headers.get('x-ms-request-id')
        if status_code == 409:
            result.status = OperationStatus.Failed
        
        if status_code == 200:
            result.status = OperationStatus.Succeeded
        
        return result
    
    def check_existence(self, resource_group_name):
        """
         Checks whether resource group exists.
         
         Args:
         
         resource_group_name (string): The name of the resource group to check.
         The name is case insensitive.
         
         Returns:
         
         ResourceGroupExistsResult: Resource group information.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if resource_group_name is not None and len(resource_group_name) > 1000:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if (re.search('^[-\\w\\._]+$', resource_group_name) is not None) == False:
            raise IndexError('resource_group_name is outside the valid range.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + 'subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourcegroups/'
        url = url + quote(resource_group_name)
        query_parameters = []
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'HEAD'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 204 and status_code != 404:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = ResourceGroupExistsResult()
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        if status_code == 204:
            result.exists = True
        
        return result
    
    def create_or_update(self, resource_group_name, parameters):
        """
         Create a resource group.
         
         Args:
         
         resource_group_name (string): The name of the resource group to be
         created or updated.
         
         parameters (ResourceGroup): Parameters supplied to the create or
         update resource group service operation.
         
         Returns:
         
         ResourceGroupCreateOrUpdateResult: Resource group information.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if resource_group_name is not None and len(resource_group_name) > 1000:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if (re.search('^[-\\w\\._]+$', resource_group_name) is not None) == False:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        if parameters.location is None:
            raise ValueError('parameters.location cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourcegroups/'
        url = url + quote(resource_group_name)
        query_parameters = []
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        resource_group_value = {}
        request_doc = resource_group_value
        
        resource_group_value['location'] = parameters.location
        
        if parameters.properties is not None:
            resource_group_value['properties'] = json.loads(parameters.properties)
        
        if parameters.tags is not None:
            tags_dictionary = {}
            for tags_key in parameters.tags:
                tags_value = parameters.tags[tags_key]
                tags_dictionary[tags_key] = tags_value
            
            resource_group_value['tags'] = tags_dictionary
        
        if parameters.provisioning_state is not None:
            resource_group_value['provisioningState'] = parameters.provisioning_state
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = ResourceGroupCreateOrUpdateResult()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                resource_group_instance = ResourceGroupExtended(tags={})
                result.resource_group = resource_group_instance
                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    resource_group_instance.id = id_instance
                
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    resource_group_instance.name = name_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    provisioning_state_value = properties_value.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        resource_group_instance.provisioning_state = provisioning_state_instance
                    
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    resource_group_instance.location = location_instance
                
                properties_value2 = response_doc.get('properties', None)
                if properties_value2 is not None:
                    properties_instance = json.dumps(properties_value2)
                    resource_group_instance.properties = properties_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key2 = property
                        tags_value2 = tags_sequence_element[property]
                        resource_group_instance.tags[tags_key2] = tags_value2
                    
                provisioning_state_value2 = response_doc.get('provisioningState', None)
                if provisioning_state_value2 is not None:
                    provisioning_state_instance2 = provisioning_state_value2
                    resource_group_instance.provisioning_state = provisioning_state_instance2
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def delete(self, resource_group_name):
        """
         Delete resource group and all of its resources.
         
         Args:
         
         resource_group_name (string): The name of the resource group to be
         deleted. The name is case insensitive.
         
         Returns:
         
         AzureOperationResponse: A standard service response including an HTTP
         status code and request ID.
        """
        client2 = self.client
        
        response = client2.resource_groups.begin_deleting(resource_group_name)
        result = client2.get_long_running_operation_status(response.operation_status_link)
        delay_in_seconds = response.retry_after
        if delay_in_seconds == 0:
            delay_in_seconds = 30
        
        if client2.long_running_operation_initial_timeout >= 0:
            delay_in_seconds = client2.long_running_operation_initial_timeout
        
        while (result.status != OperationStatus.in_progress) == False:
            time.sleep(delay_in_seconds)
            result = client2.get_long_running_operation_status(response.operation_status_link)
            delay_in_seconds = result.retry_after
            if delay_in_seconds == 0:
                delay_in_seconds = 15
            
            if client2.long_running_operation_retry_timeout >= 0:
                delay_in_seconds = client2.long_running_operation_retry_timeout
            
        
        return result
    
    def get(self, resource_group_name):
        """
         Get a resource group.
         
         Args:
         
         resource_group_name (string): The name of the resource group to get.
         The name is case insensitive.
         
         Returns:
         
         ResourceGroupGetResult: Resource group information.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if resource_group_name is not None and len(resource_group_name) > 1000:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if (re.search('^[-\\w\\._]+$', resource_group_name) is not None) == False:
            raise IndexError('resource_group_name is outside the valid range.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourcegroups/'
        url = url + quote(resource_group_name)
        query_parameters = []
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = ResourceGroupGetResult()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                resource_group_instance = ResourceGroupExtended(tags={})
                result.resource_group = resource_group_instance
                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    resource_group_instance.id = id_instance
                
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    resource_group_instance.name = name_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    provisioning_state_value = properties_value.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        resource_group_instance.provisioning_state = provisioning_state_instance
                    
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    resource_group_instance.location = location_instance
                
                properties_value2 = response_doc.get('properties', None)
                if properties_value2 is not None:
                    properties_instance = json.dumps(properties_value2)
                    resource_group_instance.properties = properties_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key = property
                        tags_value = tags_sequence_element[property]
                        resource_group_instance.tags[tags_key] = tags_value
                    
                provisioning_state_value2 = response_doc.get('provisioningState', None)
                if provisioning_state_value2 is not None:
                    provisioning_state_instance2 = provisioning_state_value2
                    resource_group_instance.provisioning_state = provisioning_state_instance2
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self, parameters):
        """
         Gets a collection of resource groups.
         
         Args:
         
         parameters (ResourceGroupListParameters): Query parameters. If null is
         passed returns all resource groups.
         
         Returns:
         
         ResourceGroupListResult: List of resource groups.
        """
        # Validate
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourcegroups'
        query_parameters = []
        odata_filter = []
        if parameters is not None and parameters.tag_name is not None:
            odata_filter.append('tagname eq \'' + quote(parameters.tag_name) + '\'')
        
        if parameters is not None and parameters.tag_value is not None:
            odata_filter.append('tagvalue eq \'' + quote(parameters.tag_value) + '\'')
        
        if len(odata_filter) > 0:
            query_parameters.append('$filter=' + ' and '.join(odata_filter))
        
        if parameters is not None and parameters.top is not None:
            query_parameters.append('$top=' + quote(str(parameters.top)))
        
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = ResourceGroupListResult(resource_groups=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        resource_group_json_format_instance = ResourceGroupExtended(tags={})
                        result.resource_groups.append(resource_group_json_format_instance)
                        
                        id_value = value_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            resource_group_json_format_instance.id = id_instance
                        
                        name_value = value_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            resource_group_json_format_instance.name = name_instance
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            provisioning_state_value = properties_value.get('provisioningState', None)
                            if provisioning_state_value is not None:
                                provisioning_state_instance = provisioning_state_value
                                resource_group_json_format_instance.provisioning_state = provisioning_state_instance
                            
                        location_value = value_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            resource_group_json_format_instance.location = location_instance
                        
                        properties_value2 = value_value.get('properties', None)
                        if properties_value2 is not None:
                            properties_instance = json.dumps(properties_value2)
                            resource_group_json_format_instance.properties = properties_instance
                        
                        tags_sequence_element = value_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                resource_group_json_format_instance.tags[tags_key] = tags_value
                            
                        provisioning_state_value2 = value_value.get('provisioningState', None)
                        if provisioning_state_value2 is not None:
                            provisioning_state_instance2 = provisioning_state_value2
                            resource_group_json_format_instance.provisioning_state = provisioning_state_instance2
                        
                odatanext_link_value = response_doc.get('@odata.nextLink', None)
                if odatanext_link_value is not None:
                    odatanext_link_instance = odatanext_link_value
                    result.next_link = odatanext_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_next(self, next_link):
        """
         Get a list of deployments.
         
         Args:
         
         next_link (string): NextLink from the previous successful call to List
         operation.
         
         Returns:
         
         ResourceGroupListResult: List of resource groups.
        """
        # Validate
        if next_link is None:
            raise ValueError('next_link cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + next_link
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = ResourceGroupListResult(resource_groups=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        resource_group_json_format_instance = ResourceGroupExtended(tags={})
                        result.resource_groups.append(resource_group_json_format_instance)
                        
                        id_value = value_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            resource_group_json_format_instance.id = id_instance
                        
                        name_value = value_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            resource_group_json_format_instance.name = name_instance
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            provisioning_state_value = properties_value.get('provisioningState', None)
                            if provisioning_state_value is not None:
                                provisioning_state_instance = provisioning_state_value
                                resource_group_json_format_instance.provisioning_state = provisioning_state_instance
                            
                        location_value = value_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            resource_group_json_format_instance.location = location_instance
                        
                        properties_value2 = value_value.get('properties', None)
                        if properties_value2 is not None:
                            properties_instance = json.dumps(properties_value2)
                            resource_group_json_format_instance.properties = properties_instance
                        
                        tags_sequence_element = value_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                resource_group_json_format_instance.tags[tags_key] = tags_value
                            
                        provisioning_state_value2 = value_value.get('provisioningState', None)
                        if provisioning_state_value2 is not None:
                            provisioning_state_instance2 = provisioning_state_value2
                            resource_group_json_format_instance.provisioning_state = provisioning_state_instance2
                        
                odatanext_link_value = response_doc.get('@odata.nextLink', None)
                if odatanext_link_value is not None:
                    odatanext_link_instance = odatanext_link_value
                    result.next_link = odatanext_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def patch(self, resource_group_name, parameters):
        """
         Resource groups can be updated through a simple PATCH operation to a
         group address. The format of the request is the same as that for
         creating a resource groups, though if a field is unspecified current
         value will be carried over.
         
         Args:
         
         resource_group_name (string): The name of the resource group to be
         created or updated. The name is case insensitive.
         
         parameters (ResourceGroup): Parameters supplied to the update state
         resource group service operation.
         
         Returns:
         
         ResourceGroupPatchResult: Resource group information.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if resource_group_name is not None and len(resource_group_name) > 1000:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if (re.search('^[-\\w\\._]+$', resource_group_name) is not None) == False:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        if parameters.location is None:
            raise ValueError('parameters.location cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourcegroups/'
        url = url + quote(resource_group_name)
        query_parameters = []
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PATCH'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        resource_group_value = {}
        request_doc = resource_group_value
        
        resource_group_value['location'] = parameters.location
        
        if parameters.properties is not None:
            resource_group_value['properties'] = json.loads(parameters.properties)
        
        if parameters.tags is not None:
            tags_dictionary = {}
            for tags_key in parameters.tags:
                tags_value = parameters.tags[tags_key]
                tags_dictionary[tags_key] = tags_value
            
            resource_group_value['tags'] = tags_dictionary
        
        if parameters.provisioning_state is not None:
            resource_group_value['provisioningState'] = parameters.provisioning_state
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = ResourceGroupPatchResult()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                resource_group_instance = ResourceGroupExtended(tags={})
                result.resource_group = resource_group_instance
                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    resource_group_instance.id = id_instance
                
                name_value = response_doc.get('name', None)
                if name_value is not None:
                    name_instance = name_value
                    resource_group_instance.name = name_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    provisioning_state_value = properties_value.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        resource_group_instance.provisioning_state = provisioning_state_instance
                    
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    resource_group_instance.location = location_instance
                
                properties_value2 = response_doc.get('properties', None)
                if properties_value2 is not None:
                    properties_instance = json.dumps(properties_value2)
                    resource_group_instance.properties = properties_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key2 = property
                        tags_value2 = tags_sequence_element[property]
                        resource_group_instance.tags[tags_key2] = tags_value2
                    
                provisioning_state_value2 = response_doc.get('provisioningState', None)
                if provisioning_state_value2 is not None:
                    provisioning_state_instance2 = provisioning_state_value2
                    resource_group_instance.provisioning_state = provisioning_state_instance2
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class ResourceOperations(object):
    """
     Operations for managing resources.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [ResourceManagementClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Resources.ResourceManagementClient.
        """
        return self._client
    
    def check_existence(self, resource_group_name, identity):
        """
         Checks whether resource exists.
         
         Args:
         
         resource_group_name (string): The name of the resource group. The name
         is case insensitive.
         
         identity (ResourceIdentity): Resource identity.
         
         Returns:
         
         ResourceExistsResult: Resource group information.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if resource_group_name is not None and len(resource_group_name) > 1000:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if (re.search('^[-\\w\\._]+$', resource_group_name) is not None) == False:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if identity is None:
            raise ValueError('identity cannot be None.')
        
        if identity.resource_name is None:
            raise ValueError('identity. cannot be None.')
        
        if identity.resource_provider_api_version is None:
            raise ValueError('identity. cannot be None.')
        
        if identity.resource_provider_namespace is None:
            raise ValueError('identity. cannot be None.')
        
        if identity.resource_type is None:
            raise ValueError('identity. cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourcegroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + quote(identity.resource_provider_namespace)
        url = url + '/'
        if identity.parent_resource_path is not None:
            url = url + identity.parent_resource_path
        
        url = url + '/'
        url = url + identity.resource_type
        url = url + '/'
        url = url + quote(identity.resource_name)
        query_parameters = []
        query_parameters.append('api-version=' + quote(identity.resource_provider_api_version))
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 404:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = ResourceExistsResult()
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        if status_code == 200:
            result.exists = True
        else:
            result.exists = False
        
        return result
    
    def create_or_update(self, resource_group_name, identity, parameters):
        """
         Create a resource.
         
         Args:
         
         resource_group_name (string): The name of the resource group. The name
         is case insensitive.
         
         identity (ResourceIdentity): Resource identity.
         
         parameters (GenericResource): Create or update resource parameters.
         
         Returns:
         
         ResourceCreateOrUpdateResult: Resource information.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if resource_group_name is not None and len(resource_group_name) > 1000:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if (re.search('^[-\\w\\._]+$', resource_group_name) is not None) == False:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if identity is None:
            raise ValueError('identity cannot be None.')
        
        if identity.resource_name is None:
            raise ValueError('identity. cannot be None.')
        
        if identity.resource_provider_api_version is None:
            raise ValueError('identity. cannot be None.')
        
        if identity.resource_provider_namespace is None:
            raise ValueError('identity. cannot be None.')
        
        if identity.resource_type is None:
            raise ValueError('identity. cannot be None.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        if parameters.location is None:
            raise ValueError('parameters.location cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourcegroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + quote(identity.resource_provider_namespace)
        url = url + '/'
        if identity.parent_resource_path is not None:
            url = url + identity.parent_resource_path
        
        url = url + '/'
        url = url + identity.resource_type
        url = url + '/'
        url = url + quote(identity.resource_name)
        query_parameters = []
        query_parameters.append('api-version=' + quote(identity.resource_provider_api_version))
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        generic_resource_value = {}
        request_doc = generic_resource_value
        
        if parameters.properties is not None:
            generic_resource_value['properties'] = json.loads(parameters.properties)
        
        if parameters.provisioning_state is not None:
            generic_resource_value['provisioningState'] = parameters.provisioning_state
        
        if parameters.plan is not None:
            plan_value = {}
            generic_resource_value['plan'] = plan_value
            
            if parameters.plan.name is not None:
                plan_value['name'] = parameters.plan.name
            
            if parameters.plan.publisher is not None:
                plan_value['publisher'] = parameters.plan.publisher
            
            if parameters.plan.product is not None:
                plan_value['product'] = parameters.plan.product
            
            if parameters.plan.promotion_code is not None:
                plan_value['promotionCode'] = parameters.plan.promotion_code
            
        generic_resource_value['location'] = parameters.location
        
        if parameters.tags is not None:
            tags_dictionary = {}
            for tags_key in parameters.tags:
                tags_value = parameters.tags[tags_key]
                tags_dictionary[tags_key] = tags_value
            
            generic_resource_value['tags'] = tags_dictionary
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = ResourceCreateOrUpdateResult()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                resource_instance = GenericResourceExtended(tags={})
                result.resource = resource_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    provisioning_state_value = properties_value.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        resource_instance.provisioning_state = provisioning_state_instance
                    
                properties_value2 = response_doc.get('properties', None)
                if properties_value2 is not None:
                    properties_instance = json.dumps(properties_value2)
                    resource_instance.properties = properties_instance
                
                provisioning_state_value2 = response_doc.get('provisioningState', None)
                if provisioning_state_value2 is not None:
                    provisioning_state_instance2 = provisioning_state_value2
                    resource_instance.provisioning_state = provisioning_state_instance2
                
                plan_value2 = response_doc.get('plan', None)
                if plan_value2 is not None:
                    plan_instance = Plan()
                    resource_instance.plan = plan_instance
                    
                    name_value = plan_value2.get('name', None)
                    if name_value is not None:
                        name_instance = name_value
                        plan_instance.name = name_instance
                    
                    publisher_value = plan_value2.get('publisher', None)
                    if publisher_value is not None:
                        publisher_instance = publisher_value
                        plan_instance.publisher = publisher_instance
                    
                    product_value = plan_value2.get('product', None)
                    if product_value is not None:
                        product_instance = product_value
                        plan_instance.product = product_instance
                    
                    promotion_code_value = plan_value2.get('promotionCode', None)
                    if promotion_code_value is not None:
                        promotion_code_instance = promotion_code_value
                        plan_instance.promotion_code = promotion_code_instance
                    
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    resource_instance.id = id_instance
                
                name_value2 = response_doc.get('name', None)
                if name_value2 is not None:
                    name_instance2 = name_value2
                    resource_instance.name = name_instance2
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    resource_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    resource_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key2 = property
                        tags_value2 = tags_sequence_element[property]
                        resource_instance.tags[tags_key2] = tags_value2
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def delete(self, resource_group_name, identity):
        """
         Delete resource and all of its resources.
         
         Args:
         
         resource_group_name (string): The name of the resource group. The name
         is case insensitive.
         
         identity (ResourceIdentity): Resource identity.
         
         Returns:
         
         AzureOperationResponse: A standard service response including an HTTP
         status code and request ID.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if resource_group_name is not None and len(resource_group_name) > 1000:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if (re.search('^[-\\w\\._]+$', resource_group_name) is not None) == False:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if identity is None:
            raise ValueError('identity cannot be None.')
        
        if identity.resource_name is None:
            raise ValueError('identity. cannot be None.')
        
        if identity.resource_provider_api_version is None:
            raise ValueError('identity. cannot be None.')
        
        if identity.resource_provider_namespace is None:
            raise ValueError('identity. cannot be None.')
        
        if identity.resource_type is None:
            raise ValueError('identity. cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourcegroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + quote(identity.resource_provider_namespace)
        url = url + '/'
        if identity.parent_resource_path is not None:
            url = url + identity.parent_resource_path
        
        url = url + '/'
        url = url + identity.resource_type
        url = url + '/'
        url = url + quote(identity.resource_name)
        query_parameters = []
        query_parameters.append('api-version=' + quote(identity.resource_provider_api_version))
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'DELETE'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 202 and status_code != 204:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = AzureOperationResponse()
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def get(self, resource_group_name, identity):
        """
         Returns a resource belonging to a resource group.
         
         Args:
         
         resource_group_name (string): The name of the resource group. The name
         is case insensitive.
         
         identity (ResourceIdentity): Resource identity.
         
         Returns:
         
         ResourceGetResult: Resource information.
        """
        # Validate
        if resource_group_name is None:
            raise ValueError('resource_group_name cannot be None.')
        
        if resource_group_name is not None and len(resource_group_name) > 1000:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if (re.search('^[-\\w\\._]+$', resource_group_name) is not None) == False:
            raise IndexError('resource_group_name is outside the valid range.')
        
        if identity is None:
            raise ValueError('identity cannot be None.')
        
        if identity.resource_name is None:
            raise ValueError('identity. cannot be None.')
        
        if identity.resource_provider_api_version is None:
            raise ValueError('identity. cannot be None.')
        
        if identity.resource_provider_namespace is None:
            raise ValueError('identity. cannot be None.')
        
        if identity.resource_type is None:
            raise ValueError('identity. cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourcegroups/'
        url = url + quote(resource_group_name)
        url = url + '/providers/'
        url = url + quote(identity.resource_provider_namespace)
        url = url + '/'
        if identity.parent_resource_path is not None:
            url = url + identity.parent_resource_path
        
        url = url + '/'
        url = url + identity.resource_type
        url = url + '/'
        url = url + quote(identity.resource_name)
        query_parameters = []
        query_parameters.append('api-version=' + quote(identity.resource_provider_api_version))
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 204:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 204:
            response_content = body
            result = ResourceGetResult()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                resource_instance = GenericResourceExtended(tags={})
                result.resource = resource_instance
                
                properties_value = response_doc.get('properties', None)
                if properties_value is not None:
                    provisioning_state_value = properties_value.get('provisioningState', None)
                    if provisioning_state_value is not None:
                        provisioning_state_instance = provisioning_state_value
                        resource_instance.provisioning_state = provisioning_state_instance
                    
                properties_value2 = response_doc.get('properties', None)
                if properties_value2 is not None:
                    properties_instance = json.dumps(properties_value2)
                    resource_instance.properties = properties_instance
                
                provisioning_state_value2 = response_doc.get('provisioningState', None)
                if provisioning_state_value2 is not None:
                    provisioning_state_instance2 = provisioning_state_value2
                    resource_instance.provisioning_state = provisioning_state_instance2
                
                plan_value = response_doc.get('plan', None)
                if plan_value is not None:
                    plan_instance = Plan()
                    resource_instance.plan = plan_instance
                    
                    name_value = plan_value.get('name', None)
                    if name_value is not None:
                        name_instance = name_value
                        plan_instance.name = name_instance
                    
                    publisher_value = plan_value.get('publisher', None)
                    if publisher_value is not None:
                        publisher_instance = publisher_value
                        plan_instance.publisher = publisher_instance
                    
                    product_value = plan_value.get('product', None)
                    if product_value is not None:
                        product_instance = product_value
                        plan_instance.product = product_instance
                    
                    promotion_code_value = plan_value.get('promotionCode', None)
                    if promotion_code_value is not None:
                        promotion_code_instance = promotion_code_value
                        plan_instance.promotion_code = promotion_code_instance
                    
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    resource_instance.id = id_instance
                
                name_value2 = response_doc.get('name', None)
                if name_value2 is not None:
                    name_instance2 = name_value2
                    resource_instance.name = name_instance2
                
                type_value = response_doc.get('type', None)
                if type_value is not None:
                    type_instance = type_value
                    resource_instance.type = type_instance
                
                location_value = response_doc.get('location', None)
                if location_value is not None:
                    location_instance = location_value
                    resource_instance.location = location_instance
                
                tags_sequence_element = response_doc.get('tags', None)
                if tags_sequence_element is not None:
                    for property in tags_sequence_element:
                        tags_key = property
                        tags_value = tags_sequence_element[property]
                        resource_instance.tags[tags_key] = tags_value
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self, parameters):
        """
         Get all of the resources under a subscription.
         
         Args:
         
         parameters (ResourceListParameters): Query parameters. If null is
         passed returns all resource groups.
         
         Returns:
         
         ResourceListResult: List of resource groups.
        """
        # Validate
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/'
        if parameters is not None and parameters.resource_group_name is not None:
            url = url + 'resourceGroups/' + quote(parameters.resource_group_name) + '/'
        
        url = url + 'resources'
        query_parameters = []
        odata_filter = []
        if parameters is not None and parameters.resource_type is not None:
            odata_filter.append('resourceType eq \'' + quote(parameters.resource_type) + '\'')
        
        if parameters is not None and parameters.tag_name is not None:
            odata_filter.append('tagname eq \'' + quote(parameters.tag_name) + '\'')
        
        if parameters is not None and parameters.tag_value is not None:
            odata_filter.append('tagvalue eq \'' + quote(parameters.tag_value) + '\'')
        
        if len(odata_filter) > 0:
            query_parameters.append('$filter=' + ' and '.join(odata_filter))
        
        if parameters is not None and parameters.top is not None:
            query_parameters.append('$top=' + quote(str(parameters.top)))
        
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = ResourceListResult(resources=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        resource_json_format_instance = GenericResourceExtended(tags={})
                        result.resources.append(resource_json_format_instance)
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            provisioning_state_value = properties_value.get('provisioningState', None)
                            if provisioning_state_value is not None:
                                provisioning_state_instance = provisioning_state_value
                                resource_json_format_instance.provisioning_state = provisioning_state_instance
                            
                        properties_value2 = value_value.get('properties', None)
                        if properties_value2 is not None:
                            properties_instance = json.dumps(properties_value2)
                            resource_json_format_instance.properties = properties_instance
                        
                        provisioning_state_value2 = value_value.get('provisioningState', None)
                        if provisioning_state_value2 is not None:
                            provisioning_state_instance2 = provisioning_state_value2
                            resource_json_format_instance.provisioning_state = provisioning_state_instance2
                        
                        plan_value = value_value.get('plan', None)
                        if plan_value is not None:
                            plan_instance = Plan()
                            resource_json_format_instance.plan = plan_instance
                            
                            name_value = plan_value.get('name', None)
                            if name_value is not None:
                                name_instance = name_value
                                plan_instance.name = name_instance
                            
                            publisher_value = plan_value.get('publisher', None)
                            if publisher_value is not None:
                                publisher_instance = publisher_value
                                plan_instance.publisher = publisher_instance
                            
                            product_value = plan_value.get('product', None)
                            if product_value is not None:
                                product_instance = product_value
                                plan_instance.product = product_instance
                            
                            promotion_code_value = plan_value.get('promotionCode', None)
                            if promotion_code_value is not None:
                                promotion_code_instance = promotion_code_value
                                plan_instance.promotion_code = promotion_code_instance
                            
                        id_value = value_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            resource_json_format_instance.id = id_instance
                        
                        name_value2 = value_value.get('name', None)
                        if name_value2 is not None:
                            name_instance2 = name_value2
                            resource_json_format_instance.name = name_instance2
                        
                        type_value = value_value.get('type', None)
                        if type_value is not None:
                            type_instance = type_value
                            resource_json_format_instance.type = type_instance
                        
                        location_value = value_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            resource_json_format_instance.location = location_instance
                        
                        tags_sequence_element = value_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                resource_json_format_instance.tags[tags_key] = tags_value
                            
                odatanext_link_value = response_doc.get('@odata.nextLink', None)
                if odatanext_link_value is not None:
                    odatanext_link_instance = odatanext_link_value
                    result.next_link = odatanext_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_next(self, next_link):
        """
         Get a list of deployments.
         
         Args:
         
         next_link (string): NextLink from the previous successful call to List
         operation.
         
         Returns:
         
         ResourceListResult: List of resource groups.
        """
        # Validate
        if next_link is None:
            raise ValueError('next_link cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + next_link
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = ResourceListResult(resources=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        resource_json_format_instance = GenericResourceExtended(tags={})
                        result.resources.append(resource_json_format_instance)
                        
                        properties_value = value_value.get('properties', None)
                        if properties_value is not None:
                            provisioning_state_value = properties_value.get('provisioningState', None)
                            if provisioning_state_value is not None:
                                provisioning_state_instance = provisioning_state_value
                                resource_json_format_instance.provisioning_state = provisioning_state_instance
                            
                        properties_value2 = value_value.get('properties', None)
                        if properties_value2 is not None:
                            properties_instance = json.dumps(properties_value2)
                            resource_json_format_instance.properties = properties_instance
                        
                        provisioning_state_value2 = value_value.get('provisioningState', None)
                        if provisioning_state_value2 is not None:
                            provisioning_state_instance2 = provisioning_state_value2
                            resource_json_format_instance.provisioning_state = provisioning_state_instance2
                        
                        plan_value = value_value.get('plan', None)
                        if plan_value is not None:
                            plan_instance = Plan()
                            resource_json_format_instance.plan = plan_instance
                            
                            name_value = plan_value.get('name', None)
                            if name_value is not None:
                                name_instance = name_value
                                plan_instance.name = name_instance
                            
                            publisher_value = plan_value.get('publisher', None)
                            if publisher_value is not None:
                                publisher_instance = publisher_value
                                plan_instance.publisher = publisher_instance
                            
                            product_value = plan_value.get('product', None)
                            if product_value is not None:
                                product_instance = product_value
                                plan_instance.product = product_instance
                            
                            promotion_code_value = plan_value.get('promotionCode', None)
                            if promotion_code_value is not None:
                                promotion_code_instance = promotion_code_value
                                plan_instance.promotion_code = promotion_code_instance
                            
                        id_value = value_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            resource_json_format_instance.id = id_instance
                        
                        name_value2 = value_value.get('name', None)
                        if name_value2 is not None:
                            name_instance2 = name_value2
                            resource_json_format_instance.name = name_instance2
                        
                        type_value = value_value.get('type', None)
                        if type_value is not None:
                            type_instance = type_value
                            resource_json_format_instance.type = type_instance
                        
                        location_value = value_value.get('location', None)
                        if location_value is not None:
                            location_instance = location_value
                            resource_json_format_instance.location = location_instance
                        
                        tags_sequence_element = value_value.get('tags', None)
                        if tags_sequence_element is not None:
                            for property in tags_sequence_element:
                                tags_key = property
                                tags_value = tags_sequence_element[property]
                                resource_json_format_instance.tags[tags_key] = tags_value
                            
                odatanext_link_value = response_doc.get('@odata.nextLink', None)
                if odatanext_link_value is not None:
                    odatanext_link_instance = odatanext_link_value
                    result.next_link = odatanext_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def move_resources(self, source_resource_group_name, parameters):
        """
         Move resources within or across subscriptions.
         
         Args:
         
         source_resource_group_name (string): Source resource group name.
         
         parameters (ResourcesMoveInfo): move resources' parameters.
         
         Returns:
         
         AzureOperationResponse: A standard service response including an HTTP
         status code and request ID.
        """
        # Validate
        if source_resource_group_name is None:
            raise ValueError('source_resource_group_name cannot be None.')
        
        if parameters is None:
            raise ValueError('parameters cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/resourceGroups/'
        url = url + quote(source_resource_group_name)
        url = url + '/moveResources'
        query_parameters = []
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'POST'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Serialize Request
        request_content = None
        request_doc = None
        
        resources_move_info_value = {}
        request_doc = resources_move_info_value
        
        if parameters.resources is not None:
            resources_array = []
            for resources_item in parameters.resources:
                resources_array.append(resources_item)
            
            resources_move_info_value['resources'] = resources_array
        
        if parameters.target_resource_group is not None:
            resources_move_info_value['targetResourceGroup'] = parameters.target_resource_group
        
        request_content = json.dumps(request_doc)
        http_request.data = request_content
        http_request.headers['Content-Length'] = len(request_content)
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 202:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = AzureOperationResponse()
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class ResourceProviderOperationDetailsOperations(object):
    """
     Operations for managing Resource provider operations.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [ResourceManagementClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Resources.ResourceManagementClient.
        """
        return self._client
    
    def list(self, identity):
        """
         Gets a list of resource providers.
         
         Args:
         
         identity (ResourceIdentity): Resource identity.
         
         Returns:
         
         ResourceProviderOperationDetailListResult: List of resource provider
         operations.
        """
        # Validate
        if identity is None:
            raise ValueError('identity cannot be None.')
        
        if identity.resource_name is None:
            raise ValueError('identity. cannot be None.')
        
        if identity.resource_provider_api_version is None:
            raise ValueError('identity. cannot be None.')
        
        if identity.resource_provider_namespace is None:
            raise ValueError('identity. cannot be None.')
        
        if identity.resource_type is None:
            raise ValueError('identity. cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/providers/'
        url = url + quote(identity.resource_provider_namespace)
        url = url + '/operations'
        query_parameters = []
        query_parameters.append('api-version=' + quote(identity.resource_provider_api_version))
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 204:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 204:
            response_content = body
            result = ResourceProviderOperationDetailListResult(resource_provider_operation_details=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        resource_provider_operation_definition_instance = ResourceProviderOperationDefinition()
                        result.resource_provider_operation_details.append(resource_provider_operation_definition_instance)
                        
                        name_value = value_value.get('name', None)
                        if name_value is not None:
                            name_instance = name_value
                            resource_provider_operation_definition_instance.name = name_instance
                        
                        display_value = value_value.get('display', None)
                        if display_value is not None:
                            display_instance = ResourceProviderOperationDisplayProperties()
                            resource_provider_operation_definition_instance.resource_provider_operation_display_properties = display_instance
                            
                            publisher_value = display_value.get('publisher', None)
                            if publisher_value is not None:
                                publisher_instance = publisher_value
                                display_instance.publisher = publisher_instance
                            
                            provider_value = display_value.get('provider', None)
                            if provider_value is not None:
                                provider_instance = provider_value
                                display_instance.provider = provider_instance
                            
                            resource_value = display_value.get('resource', None)
                            if resource_value is not None:
                                resource_instance = resource_value
                                display_instance.resource = resource_instance
                            
                            operation_value = display_value.get('operation', None)
                            if operation_value is not None:
                                operation_instance = operation_value
                                display_instance.operation = operation_instance
                            
                            description_value = display_value.get('description', None)
                            if description_value is not None:
                                description_instance = description_value
                                display_instance.description = description_instance
                            
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
class TagOperations(object):
    """
     Operations for managing tags.
     __NOTE__: An instance of this class is automatically created for an
     instance of the [ResourceManagementClient]
    """
    
    def __init__(self, client):
        self._client = client
    
    @property
    def client(self):
        """
         Gets a reference to the
         Microsoft.Azure.Management.Resources.ResourceManagementClient.
        """
        return self._client
    
    def create_or_update(self, tag_name):
        """
         Create a subscription resource tag.
         
         Args:
         
         tag_name (string): The name of the tag.
         
         Returns:
         
         TagCreateResult: Tag information.
        """
        # Validate
        if tag_name is None:
            raise ValueError('tag_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/tagNames/'
        url = url + quote(tag_name)
        query_parameters = []
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = TagCreateResult()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                tag_instance = TagDetails(values=[])
                result.tag = tag_instance
                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    tag_instance.id = id_instance
                
                tag_name_value = response_doc.get('tagName', None)
                if tag_name_value is not None:
                    tag_name_instance = tag_name_value
                    tag_instance.name = tag_name_instance
                
                count_value = response_doc.get('count', None)
                if count_value is not None:
                    count_instance = TagCount()
                    tag_instance.count = count_instance
                    
                    type_value = count_value.get('type', None)
                    if type_value is not None:
                        type_instance = type_value
                        count_instance.type = type_instance
                    
                    value_value = count_value.get('value', None)
                    if value_value is not None:
                        value_instance = value_value
                        count_instance.value = value_instance
                    
                values_array = response_doc.get('values', None)
                if values_array is not None:
                    for values_value in values_array:
                        tag_value_instance = TagValue()
                        tag_instance.values.append(tag_value_instance)
                        
                        id_value2 = values_value.get('id', None)
                        if id_value2 is not None:
                            id_instance2 = id_value2
                            tag_value_instance.id = id_instance2
                        
                        tag_value_value = values_value.get('tagValue', None)
                        if tag_value_value is not None:
                            tag_value_instance2 = tag_value_value
                            tag_value_instance.value = tag_value_instance2
                        
                        count_value2 = values_value.get('count', None)
                        if count_value2 is not None:
                            count_instance2 = TagCount()
                            tag_value_instance.count = count_instance2
                            
                            type_value2 = count_value2.get('type', None)
                            if type_value2 is not None:
                                type_instance2 = type_value2
                                count_instance2.type = type_instance2
                            
                            value_value2 = count_value2.get('value', None)
                            if value_value2 is not None:
                                value_instance2 = value_value2
                                count_instance2.value = value_instance2
                            
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def create_or_update_value(self, tag_name, tag_value):
        """
         Create a subscription resource tag value.
         
         Args:
         
         tag_name (string): The name of the tag.
         
         tag_value (string): The value of the tag.
         
         Returns:
         
         TagCreateValueResult: Tag information.
        """
        # Validate
        if tag_name is None:
            raise ValueError('tag_name cannot be None.')
        
        if tag_value is None:
            raise ValueError('tag_value cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/tagNames/'
        url = url + quote(tag_name)
        url = url + '/tagValues/'
        url = url + quote(tag_value)
        query_parameters = []
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'PUT'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 201:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200 or status_code == 201:
            response_content = body
            result = TagCreateValueResult()
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_instance = TagValue()
                result.value = value_instance
                
                id_value = response_doc.get('id', None)
                if id_value is not None:
                    id_instance = id_value
                    value_instance.id = id_instance
                
                tag_value_value = response_doc.get('tagValue', None)
                if tag_value_value is not None:
                    tag_value_instance = tag_value_value
                    value_instance.value = tag_value_instance
                
                count_value = response_doc.get('count', None)
                if count_value is not None:
                    count_instance = TagCount()
                    value_instance.count = count_instance
                    
                    type_value = count_value.get('type', None)
                    if type_value is not None:
                        type_instance = type_value
                        count_instance.type = type_instance
                    
                    value_value = count_value.get('value', None)
                    if value_value is not None:
                        value_instance2 = value_value
                        count_instance.value = value_instance2
                    
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def delete(self, tag_name):
        """
         Delete a subscription resource tag.
         
         Args:
         
         tag_name (string): The name of the tag.
         
         Returns:
         
         AzureOperationResponse: A standard service response including an HTTP
         status code and request ID.
        """
        # Validate
        if tag_name is None:
            raise ValueError('tag_name cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/tagNames/'
        url = url + quote(tag_name)
        query_parameters = []
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'DELETE'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 204:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = AzureOperationResponse()
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def delete_value(self, tag_name, tag_value):
        """
         Delete a subscription resource tag value.
         
         Args:
         
         tag_name (string): The name of the tag.
         
         tag_value (string): The value of the tag.
         
         Returns:
         
         AzureOperationResponse: A standard service response including an HTTP
         status code and request ID.
        """
        # Validate
        if tag_name is None:
            raise ValueError('tag_name cannot be None.')
        
        if tag_value is None:
            raise ValueError('tag_value cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/tagNames/'
        url = url + quote(tag_name)
        url = url + '/tagValues/'
        url = url + quote(tag_value)
        query_parameters = []
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'DELETE'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200 and status_code != 204:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        result = AzureOperationResponse()
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list(self):
        """
         Get a list of subscription resource tags.
         
         Returns:
         
         TagsListResult: List of subscription tags.
        """
        # Validate
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + '/subscriptions/'
        if self.client.credentials.subscription_id is not None:
            url = url + quote(self.client.credentials.subscription_id)
        
        url = url + '/tagNames'
        query_parameters = []
        query_parameters.append('api-version=2014-04-01-preview')
        if len(query_parameters) > 0:
            url = url + '?' + '&'.join(query_parameters)
        
        base_url = self.client.base_uri
        # Trim '/' character from the end of baseUrl and beginning of url.
        if base_url[len(base_url) - 1] == '/':
            base_url = base_url[0 : len(base_url) - 1]
        
        if url[0] == '/':
            url = url[1 : ]
        
        url = base_url + '/' + url
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = TagsListResult(tags=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        tag_details_instance = TagDetails(values=[])
                        result.tags.append(tag_details_instance)
                        
                        id_value = value_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            tag_details_instance.id = id_instance
                        
                        tag_name_value = value_value.get('tagName', None)
                        if tag_name_value is not None:
                            tag_name_instance = tag_name_value
                            tag_details_instance.name = tag_name_instance
                        
                        count_value = value_value.get('count', None)
                        if count_value is not None:
                            count_instance = TagCount()
                            tag_details_instance.count = count_instance
                            
                            type_value = count_value.get('type', None)
                            if type_value is not None:
                                type_instance = type_value
                                count_instance.type = type_instance
                            
                            value_value2 = count_value.get('value', None)
                            if value_value2 is not None:
                                value_instance = value_value2
                                count_instance.value = value_instance
                            
                        values_array = value_value.get('values', None)
                        if values_array is not None:
                            for values_value in values_array:
                                tag_value_instance = TagValue()
                                tag_details_instance.values.append(tag_value_instance)
                                
                                id_value2 = values_value.get('id', None)
                                if id_value2 is not None:
                                    id_instance2 = id_value2
                                    tag_value_instance.id = id_instance2
                                
                                tag_value_value = values_value.get('tagValue', None)
                                if tag_value_value is not None:
                                    tag_value_instance2 = tag_value_value
                                    tag_value_instance.value = tag_value_instance2
                                
                                count_value2 = values_value.get('count', None)
                                if count_value2 is not None:
                                    count_instance2 = TagCount()
                                    tag_value_instance.count = count_instance2
                                    
                                    type_value2 = count_value2.get('type', None)
                                    if type_value2 is not None:
                                        type_instance2 = type_value2
                                        count_instance2.type = type_instance2
                                    
                                    value_value3 = count_value2.get('value', None)
                                    if value_value3 is not None:
                                        value_instance2 = value_value3
                                        count_instance2.value = value_instance2
                                    
                odatanext_link_value = response_doc.get('@odata.nextLink', None)
                if odatanext_link_value is not None:
                    odatanext_link_instance = odatanext_link_value
                    result.next_link = odatanext_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
    def list_next(self, next_link):
        """
         Get a list of tags under a subscription.
         
         Args:
         
         next_link (string): NextLink from the previous successful call to List
         operation.
         
         Returns:
         
         TagsListResult: List of subscription tags.
        """
        # Validate
        if next_link is None:
            raise ValueError('next_link cannot be None.')
        
        # Tracing
        
        # Construct URL
        url = ''
        url = url + next_link
        url = url.replace(' ', '%20')
        
        # Create HTTP transport objects
        http_request = Request()
        http_request.url = url
        http_request.method = 'GET'
        
        # Set Headers
        http_request.headers['Content-Type'] = 'application/json; charset=utf-8'
        
        # Send Request
        response = self.client.send_request(http_request)
        body = response.content
        status_code = response.status_code
        if status_code != 200:
            error = AzureHttpError(body, response.status_code)
            raise error
        
        # Create Result
        result = None
        # Deserialize Response
        if status_code == 200:
            response_content = body
            result = TagsListResult(tags=[])
            response_doc = None
            if response_content:
                response_doc = json.loads(response_content.decode())
            
            if response_doc is not None:
                value_array = response_doc.get('value', None)
                if value_array is not None:
                    for value_value in value_array:
                        tag_details_instance = TagDetails(values=[])
                        result.tags.append(tag_details_instance)
                        
                        id_value = value_value.get('id', None)
                        if id_value is not None:
                            id_instance = id_value
                            tag_details_instance.id = id_instance
                        
                        tag_name_value = value_value.get('tagName', None)
                        if tag_name_value is not None:
                            tag_name_instance = tag_name_value
                            tag_details_instance.name = tag_name_instance
                        
                        count_value = value_value.get('count', None)
                        if count_value is not None:
                            count_instance = TagCount()
                            tag_details_instance.count = count_instance
                            
                            type_value = count_value.get('type', None)
                            if type_value is not None:
                                type_instance = type_value
                                count_instance.type = type_instance
                            
                            value_value2 = count_value.get('value', None)
                            if value_value2 is not None:
                                value_instance = value_value2
                                count_instance.value = value_instance
                            
                        values_array = value_value.get('values', None)
                        if values_array is not None:
                            for values_value in values_array:
                                tag_value_instance = TagValue()
                                tag_details_instance.values.append(tag_value_instance)
                                
                                id_value2 = values_value.get('id', None)
                                if id_value2 is not None:
                                    id_instance2 = id_value2
                                    tag_value_instance.id = id_instance2
                                
                                tag_value_value = values_value.get('tagValue', None)
                                if tag_value_value is not None:
                                    tag_value_instance2 = tag_value_value
                                    tag_value_instance.value = tag_value_instance2
                                
                                count_value2 = values_value.get('count', None)
                                if count_value2 is not None:
                                    count_instance2 = TagCount()
                                    tag_value_instance.count = count_instance2
                                    
                                    type_value2 = count_value2.get('type', None)
                                    if type_value2 is not None:
                                        type_instance2 = type_value2
                                        count_instance2.type = type_instance2
                                    
                                    value_value3 = count_value2.get('value', None)
                                    if value_value3 is not None:
                                        value_instance2 = value_value3
                                        count_instance2.value = value_instance2
                                    
                odatanext_link_value = response_doc.get('@odata.nextLink', None)
                if odatanext_link_value is not None:
                    odatanext_link_instance = odatanext_link_value
                    result.next_link = odatanext_link_instance
                
        result.status_code = status_code
        result.request_id = response.headers.get('x-ms-request-id')
        
        return result
    
