# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResourceFile(Model):
    """A file to be downloaded from Azure blob storage to a compute node.

    :param blob_source: The URL of the file within Azure Blob Storage. This
     URL should include a shared access signature if the blob is not publicly
     readable.
    :type blob_source: str
    :param file_path: The location to which to download the file, relative to
     the task's working directory.
    :type file_path: str
    :param file_mode: The file mode attribute in octal format. This property
     will be ignored if it is specified for a resourceFile which will be
     downloaded to a Windows compute node.
    :type file_mode: str
    """ 

    _attribute_map = {
        'blob_source': {'key': 'blobSource', 'type': 'str'},
        'file_path': {'key': 'filePath', 'type': 'str'},
        'file_mode': {'key': 'fileMode', 'type': 'str'},
    }

    def __init__(self, blob_source=None, file_path=None, file_mode=None):
        self.blob_source = blob_source
        self.file_path = file_path
        self.file_mode = file_mode
