# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationSummary(Model):
    """Contains information about an application in an Azure Batch account.

    :param id: A string that uniquely identifies the application within the
     account.
    :type id: str
    :param display_name: The display name for the application.
    :type display_name: str
    :param versions:
    :type versions: list of str
    """ 

    _validation = {
        'id': {'required': True},
        'display_name': {'required': True},
        'versions': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'versions': {'key': 'versions', 'type': '[str]'},
    }

    def __init__(self, id, display_name, versions):
        self.id = id
        self.display_name = display_name
        self.versions = versions
