
# -*- coding: utf-8 -*-

u'''Coefficients for C{_AUXLATITUDE_ORDER} 8 from I{Karney}'s C++ class U{AuxLatitude
<https://GeographicLib.SourceForge.io/C++/doc/classGeographicLib_1_1AuxLatitude.html>}
transcoded to a Python C{_Rdict[auxout][auxin]} of C{_Rtuple}s.

Copyright (C) Charles Karney (2022-2024) Karney@Alum.MIT.edu> and licensed under the
MIT/X11 License.  For more information, see <https:#GeographicLib.SourceForge.io>.
'''
from pygeodesy.auxilats.auxily import Aux
from pygeodesy.auxilats._CX_Rs import _Rcoeffs, _Rdict, _Rtuple

__all__ = ()
__version__ = '24.09.03'

_coeffs_8 = _Rcoeffs(8, {  # GEOGRAPHICLIB_AUXLATITUDE_ORDER == 8
    Aux.PHI: _Rdict(132,
       # C[phi,phi] skipped
       _Rtuple(Aux.BETA, 20,  # C[phi,beta]; even coeffs only
                  '0, 0, 0, 1, 0, 0, 0, 1/2, 0, 0, 1/3',
                  '0, 0, 1/4, 0, 1/5, 0, 1/6, 1/7, 1/8'),
       _Rtuple(Aux.THETA, 20,  # C[phi,theta]; even coeffs only
                  '-2, 2, -2, 2, -8, 6, -4, 2, 16, -8, 8/3',
                  '40, -16, 4, -32, 32/5, -64, 32/3, 128/7, 32'),
       _Rtuple(Aux.MU, 20,  # C[phi,mu]; even coeffs only
                  '-6607/24576, 269/512, -27/32, 3/2, -155113/122880, 6759/4096, -55/32, 21/16',
                  '87963/20480, -417/128, 151/96, 2514467/245760, -15543/2560, 1097/512',
                  '-69119/6144, 8011/2560, -5962461/286720, 293393/61440, 6459601/860160',
                  '332287993/27525120'),
       _Rtuple(Aux.CHI, 36,  # C[phi,chi]
                  '189416/99225, 16822/4725, -2854/675, 26/45, 116/45, -2, -2/3, 2',
                  '141514/8505, -31256/1575, 2323/945, 2704/315, -227/45, -8/5, 7/3',
                  '-2363828/31185, 98738/14175, 73814/2835, -1262/105, -136/35, 56/15',
                  '14416399/935550, 11763988/155925, -399572/14175, -332/35, 4279/630',
                  '258316372/1216215, -2046082/31185, -144838/6237, 4174/315',
                  '-2155215124/14189175, -115444544/2027025, 601676/22275',
                  '-170079376/1216215, 38341552/675675, 1383243703/11351340'),
       _Rtuple(Aux.XI, 36,  # C[phi,xi]
                  '-1683291094/37574026875, 22947844/1915538625, 28112932/212837625, 60136/467775',
                  '-2582/14175, -16/35, 4/45, 4/3, -14351220203/488462349375, 1228352/3007125',
                  '251310128/638512875, -21016/51975, -11966/14175, 152/945, 46/45',
                  '505559334506/488462349375, 138128272/147349125, -8797648/10945935, -94388/66825',
                  '3802/14175, 3044/2835, 973080708361/488462349375, -45079184/29469825',
                  '-1472637812/638512875, 41072/93555, 6059/4725, -1385645336626/488462349375',
                  '-550000184/147349125, 455935736/638512875, 768272/467775, -2939205114427/488462349375',
                  '443810768/383107725, 4210684958/1915538625, 101885255158/54273594375',
                  '387227992/127702575, 1392441148867/325641566250')
    ),
    Aux.BETA: _Rdict(132,
       _Rtuple(Aux.PHI, 20,  # C[beta,phi]; even coeffs only
                  '0, 0, 0, -1, 0, 0, 0, 1/2, 0, 0, -1/3',
                  '0, 0, 1/4, 0, -1/5, 0, 1/6, -1/7, 1/8'),
       # C[beta,beta] skipped
       _Rtuple(Aux.THETA, 20,  # C[beta,theta]; even coeffs only
                  '0, 0, 0, 1, 0, 0, 0, 1/2, 0, 0, 1/3',
                  '0, 0, 1/4, 0, 1/5, 0, 1/6, 1/7, 1/8'),
       _Rtuple(Aux.MU, 20,  # C[beta,mu]; even coeffs only
                  '-4879/73728, 205/1536, -9/32, 1/2, -86171/368640, 1335/4096, -37/96, 5/16',
                  '2901/4096, -75/128, 29/96, 1082857/737280, -2391/2560, 539/1536, -28223/18432',
                  '3467/7680, -733437/286720, 38081/61440, 459485/516096, 109167851/82575360'),
       _Rtuple(Aux.CHI, 36,  # C[beta,chi]
                  '-25666/99225, 4769/4725, -3118/4725, -1/3, 38/45, -1/3, -2/3, 1, 193931/42525',
                  '-14404/4725, -247/270, 50/21, -7/9, -14/15, 5/6, -1709614/155925, -36521/14175',
                  '17564/2835, -5/3, -34/21, 16/15, -637699/85050, 2454416/155925, -49877/14175',
                  '-28/9, 2069/1260, 48124558/1216215, -20989/2835, -28244/4455, 883/315',
                  '-16969807/1091475, -2471888/184275, 797222/155925, -1238578/42525, 2199332/225225',
                  '87600385/4540536'),
       _Rtuple(Aux.XI, 36,  # C[beta,xi]
                  '-5946082372/488462349375, 9708931/1915538625, 7947332/212837625, 11824/467775',
                  '-1082/14175, -46/315, 4/45, 1/3, 190673521/69780335625, 164328266/1915538625',
                  '39946703/638512875, -16672/155925, -338/2025, 68/945, 17/90, 86402898356/488462349375',
                  '236067184/1915538625, -255454/1563705, -101069/467775, 1102/14175, 461/2835',
                  '110123070361/488462349375, -98401826/383107725, -189032762/638512875, 1786/18711',
                  '3161/18900, -200020620676/488462349375, -802887278/1915538625, 80274086/638512875',
                  '88868/467775, -296107325077/488462349375, 66263486/383107725, 880980241/3831077250',
                  '4433064236/18091198125, 37151038/127702575, 495248998393/1302566265000')
    ),
    Aux.THETA: _Rdict(132,
       _Rtuple(Aux.PHI, 20,  # C[theta,phi]; even coeffs only
                  '2, -2, 2, -2, -8, 6, -4, 2, -16, 8, -8/3, 40, -16, 4',
                  '32, -32/5, -64, 32/3, -128/7, 32'),
       _Rtuple(Aux.BETA, 20,  # C[theta,beta]; even coeffs only
                  '0, 0, 0, -1, 0, 0, 0, 1/2, 0, 0, -1/3, 0, 0, 1/4',
                  '0, -1/5, 0, 1/6, -1/7, 1/8'),
       # C[theta,theta] skipped
       _Rtuple(Aux.MU, 20,  # C[theta,mu]; even coeffs only
                  '-14321/73728, 499/1536, -23/32, -1/2, -201467/368640, 6565/12288, -5/96, 5/16',
                  '2939/4096, -77/128, 1/32, 1155049/737280, -4037/7680, 283/1536, -19465/18432',
                  '1301/7680, -442269/286720, 17089/61440, 198115/516096, 48689387/82575360'),
       _Rtuple(Aux.CHI, 36,  # C[theta,chi]
                  '64424/99225, 76/225, -3658/4725, 2/9, 4/9, -2/3, -2/3, 0, 2146/1215, -2728/945',
                  '61/135, 68/45, -23/45, -4/15, 1/3, -95948/10395, 428/945, 9446/2835, -46/35',
                  '-24/35, 2/5, 29741/85050, 4472/525, -34712/14175, -80/63, 83/126, 280108/13365',
                  '-17432/3465, -2362/891, 52/45, -48965632/4729725, -548752/96525, 335882/155925',
                  '-197456/15795, 51368/12285, 1461335/174636'),
       _Rtuple(Aux.XI, 36,  # C[theta,xi]
                  '-230886326/6343666875, -189115382/1915538625, 216932/2627625, 109042/467775, -2102/14175',
                  '-158/315, 4/45, -2/3, -11696145869/69780335625, 288456008/1915538625, 117952358/638512875',
                  '-7256/155925, 934/14175, -16/945, 16/45, 91546732346/488462349375, 478700902/1915538625',
                  '-7391576/54729675, -25286/66825, 922/14175, -232/2835, 218929662961/488462349375',
                  '-67330724/383107725, -67048172/638512875, 268/18711, 719/4725, -129039188386/488462349375',
                  '-117954842/273648375, 46774256/638512875, 14354/467775, -178084928947/488462349375',
                  '2114368/34827975, 253129538/1915538625, 6489189398/54273594375, 13805944/127702575',
                  '59983985827/325641566250')
    ),
    Aux.MU: _Rdict(132,
       _Rtuple(Aux.PHI, 20,  # C[mu,phi]; even coeffs only
                  '57/2048, -3/32, 9/16, -3/2, -105/4096, 135/2048, -15/32, 15/16',
                  '-105/2048, 105/256, -35/48, 693/16384, -189/512, 315/512, 693/2048',
                  '-693/1280, -1287/4096, 1001/2048, -6435/14336, 109395/262144'),
       _Rtuple(Aux.BETA, 20,  # C[mu,beta]; even coeffs only
                  '19/2048, -1/32, 3/16, -1/2, 7/4096, -9/2048, 1/32, -1/16, -3/2048, 3/256, -1/48',
                  '-11/16384, 3/512, -5/512, 7/2048, -7/1280, 9/4096, -7/2048, -33/14336, -429/262144'),
       _Rtuple(Aux.THETA, 20,  # C[mu,theta]; even coeffs only
                  '509/2048, -15/32, 13/16, 1/2, 2599/4096, -1673/2048, 33/32, -1/16',
                  '-2989/2048, 349/256, -5/16, -43531/16384, 963/512, -261/512, 5545/2048',
                  '-921/1280, 16617/4096, -6037/6144, -19279/14336, -490925/262144'),
       # C[mu,mu] skipped
       _Rtuple(Aux.CHI, 36,  # C[mu,chi]
                  '-18975107/50803200, 72161/387072, 7891/37800, -127/288, 41/180, 5/16, -2/3, 1/2',
                  '148003883/174182400, 13769/28800, -1983433/1935360, 281/630, 557/1440, -3/5, 13/48',
                  '79682431/79833600, -67102379/29030400, 167603/181440, 15061/26880, -103/140, 61/240',
                  '-40176129013/7664025600, 97445/49896, 6601661/7257600, -179/168, 49561/161280',
                  '2605413599/622702080, 14644087/9123840, -3418889/1995840, 34729/80640',
                  '175214326799/58118860800, -30705481/10378368, 212378941/319334400',
                  '-16759934899/3113510400, 1522256789/1383782400, 1424729850961/743921418240'),
       _Rtuple(Aux.XI, 36,  # C[mu,xi]
                  '-375027460897/125046361440000, 7183403063/560431872000, 12674323/851350500',
                  '-384229/14968800, -1609/28350, 121/1680, 4/45, -1/6, 30410873385097/2000741783040000',
                  '1117820213/122594472000, -31621753811/1307674368000, -431/17325, 16463/453600, 26/945',
                  '-29/720, 151567502183/17863765920000, -116359346641/3923023104000, -32844781/1751349600',
                  '3746047/119750400, 449/28350, -1003/45360, -317251099510901/8002967132160000',
                  '-13060303/766215450, 10650637121/326918592000, 629/53460, -40457/2419200',
                  '-2105440822861/125046361440000, 146875240637/3923023104000, 205072597/20432412000',
                  '-1800439/119750400, 91496147778023/2000741783040000, 228253559/24518894400',
                  '-59109051671/3923023104000, 126430355893/13894040160000, -4255034947/261534873600',
                  '-791820407649841/42682491371520000')
    ),
    Aux.CHI: _Rdict(180,
       _Rtuple(Aux.PHI, 36,  # C[chi,phi]
                  '1514/1323, -8384/4725, 4642/4725, 32/45, -82/45, 4/3, 2/3, -2, 142607/42525, -2288/1575',
                  '-1522/945, 904/315, -13/9, -16/15, 5/3, 120202/51975, 44644/14175, -12686/2835, 8/5',
                  '34/21, -26/15, -1097407/187110, 1077964/155925, -24832/14175, -12/5, 1237/630',
                  '-12870194/1216215, 1040/567, 109598/31185, -734/315, -126463/72765, -941912/184275',
                  '444337/155925, 3463678/467775, -2405834/675675, 256663081/56756700'),
       _Rtuple(Aux.BETA, 36,  # C[chi,beta]
                  '1384/11025, -34/4725, -998/4725, 2/5, -16/45, 0, 2/3, -1, -12616/42525, 1268/4725, -2/27',
                  '-22/105, 19/45, -2/5, 1/6, 1724/51975, -1858/14175, 116/567, -22/105, 16/105, -1/15',
                  '115249/935550, -26836/155925, 2123/14175, -8/105, 17/1260, 140836/1216215, -424/6237',
                  '128/4455, -1/105, 210152/4729725, -31232/2027025, 149/311850, 30208/6081075, -499/225225',
                  '-68251/113513400'),
       _Rtuple(Aux.THETA, 36,  # C[chi,theta]
                  '-1738/11025, 18/175, 1042/4725, -14/45, -2/9, 2/3, 2/3, 0, 23159/42525, 332/945, -712/945',
                  '-4/45, 43/45, 4/15, -1/3, 13102/31185, -1352/945, 274/2835, 124/105, 2/105, -2/5',
                  '-2414843/935550, 1528/4725, 21068/14175, -16/105, -55/126, 60334/93555, 20704/10395',
                  '-9202/31185, -22/45, 40458083/14189175, -299444/675675, -90263/155925, -3818498/6081075',
                  '-8962/12285, -4259027/4365900'),
       _Rtuple(Aux.MU, 36,  # C[chi,mu]
                  '-7944359/67737600, 5406467/38707200, -96199/604800, 81/512, 1/360, -37/96, 2/3, -1/2',
                  '-24749483/348364800, -51841/1209600, 1118711/3870720, -46/105, 437/1440, -1/15, -1/48',
                  '6457463/17740800, -9261899/58060800, -5569/90720, 209/4480, 37/840, -17/480',
                  '-324154477/7664025600, -466511/2494800, 830251/7257600, 11/504, -4397/161280',
                  '-22894433/124540416, 8005831/63866880, 108847/3991680, -4583/161280, 2204645983/12915302400',
                  '16363163/518918400, -20648693/638668800, 497323811/12454041600, -219941297/5535129600',
                  '-191773887257/3719607091200'),
       # C[chi,chi] skipped
       _Rtuple(Aux.XI, 36,  # C[chi,xi]
                  '-17451293242/488462349375, 308365186/1915538625, -55271278/212837625, 27128/93555, -2312/14175',
                  '-88/315, 34/45, -2/3, -101520127208/488462349375, 149984636/1915538625, 106691108/638512875',
                  '-65864/155925, 6079/14175, -184/945, 1/45, 10010741462/37574026875, -99534832/383107725',
                  '5921152/54729675, -14246/467775, 772/14175, -106/2835, 1615002539/75148053750, -35573728/273648375',
                  '75594328/638512875, -5312/467775, -167/9450, -3358119706/488462349375, 130601488/1915538625',
                  '2837636/638512875, -248/13365, 46771947158/488462349375, -3196/3553875, -34761247/1915538625',
                  '-18696014/18091198125, -2530364/127702575, -14744861191/651283132500')
    ),
    Aux.XI: _Rdict(180,
       _Rtuple(Aux.PHI, 36,  # C[xi,phi]
                  '-88002076/13956067125, -86728/16372125, -44732/2837835, 20824/467775, 538/4725, 88/315',
                  '-4/45, -4/3, -2641983469/488462349375, -895712/147349125, -12467764/212837625, -37192/467775',
                  '-2482/14175, 8/105, 34/45, 8457703444/488462349375, 240616/4209975, 100320856/1915538625',
                  '54968/467775, -898/14175, -1532/2835, -4910552477/97692469875, -4832848/147349125',
                  '-5884124/70945875, 24496/467775, 6007/14175, 9393713176/488462349375, 816824/13395375',
                  '-839792/19348875, -23356/66825, -4532926649/97692469875, 1980656/54729675, 570284222/1915538625',
                  '-14848113968/488462349375, -496894276/1915538625, 224557742191/976924698750'),
       _Rtuple(Aux.BETA, 36,  # C[xi,beta]
                  '29232878/97692469875, -18484/4343625, -70496/8513505, 2476/467775, 34/675, 32/315, -4/45, -1/3',
                  '-324943819/488462349375, -4160804/1915538625, 53836/212837625, 3992/467775, 74/2025, -4/315',
                  '-7/90, -168643106/488462349375, 237052/383107725, -661844/1915538625, 7052/467775, 2/14175',
                  '-83/2835, 113042383/97692469875, -2915326/1915538625, 1425778/212837625, 934/467775, -797/56700',
                  '-558526274/488462349375, 6064888/1915538625, 390088/212837625, -3673/467775, 155665021/97692469875',
                  '41288/29469825, -18623681/3831077250, 504234982/488462349375, -6205669/1915538625',
                  '-8913001661/3907698795000'),
       _Rtuple(Aux.THETA, 36,  # C[xi,theta]
                  '182466964/8881133625, 53702182/212837625, -4286228/42567525, -193082/467775, 778/4725, 62/105',
                  '-4/45, 2/3, 367082779691/488462349375, -32500616/273648375, -61623938/70945875, 92696/467775',
                  '12338/14175, -32/315, 4/45, -42668482796/488462349375, -663111728/383107725, 427003576/1915538625',
                  '612536/467775, -1618/14175, -524/2835, -327791986997/97692469875, 421877252/1915538625',
                  '427770788/212837625, -8324/66825, -5933/14175, 74612072536/488462349375, 6024982024/1915538625',
                  '-9153184/70945875, -320044/467775, 489898512247/97692469875, -46140784/383107725',
                  '-1978771378/1915538625, -42056042768/488462349375, -2926201612/1915538625, -2209250801969/976924698750'),
       _Rtuple(Aux.MU, 36,  # C[xi,mu]
                  '39534358147/2858202547200, -25359310709/1743565824000, -9292991/302702400, 7764059/239500800',
                  '1297/18900, -817/10080, -4/45, 1/6, -13216941177599/571640509440000, -14814966289/245188944000',
                  '36019108271/871782912000, 35474/467775, -29609/453600, -2/35, 49/720, -27782109847927/250092722880000',
                  '99871724539/1569209241600, 3026004511/30648618000, -4306823/59875200, -2917/56700, 4463/90720',
                  '168979300892599/1600593426432000, 2123926699/15324309000, -368661577/4036032000, -102293/1871100',
                  '331799/7257600, 1959350112697/9618950880000, -493031379277/3923023104000, -875457073/13621608000',
                  '11744233/239500800, -145659994071373/800296713216000, -793693009/9807557760, 453002260127/7846046208000',
                  '-53583096419057/500185445760000, 103558761539/1426553856000, 12272105438887727/128047474114560000'),
       _Rtuple(Aux.CHI, 36,  # C[xi,chi]
                  '-64724382148/97692469875, 16676974/30405375, 2706758/42567525, -55222/93555, 2458/4725, 46/315, -34/45',
                  '2/3, 85904355287/37574026875, 158999572/1915538625, -340492279/212837625, 516944/467775, 3413/14175',
                  '-256/315, 19/45, 2986003168/37574026875, -7597644214/1915538625, 4430783356/1915538625, 206834/467775',
                  '-15958/14175, 248/567, -375566203/39037950, 851209552/174139875, 62016436/70945875, -832976/467775',
                  '16049/28350, 5106181018156/488462349375, 3475643362/1915538625, -651151712/212837625, 15602/18711',
                  '34581190223/8881133625, -10656173804/1915538625, 2561772812/1915538625, -5150169424688/488462349375',
                  '873037408/383107725, 7939103697617/1953849397500')  # PYCHOK exported
       # C[xi,xi] skipped
    )
})
# _ptrs_8 = (0,   0,  20,  40,  60,  96, 132, 152, 152, 172, 192, 228,
#          264, 284, 304, 304, 324, 360, 396, 416, 436, 456, 456, 492,
#          528, 564, 600, 636, 672, 672, 708, 744, 780, 816, 852, 888,
#          888)  # PYCHOK exported
del _Rcoeffs, _Rdict, _Rtuple

# **) MIT License
#
# Copyright (C) 2023-2025 -- mrJean1 at Gmail -- All Rights Reserved.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
# OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
# ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
# OTHER DEALINGS IN THE SOFTWARE.
