# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class OutboundEnvironmentEndpoint(Model):
    """Endpoints accessed for a common purpose that the App Service Environment
    requires outbound network access to.

    :param category: The type of service accessed by the App Service
     Environment, e.g., Azure Storage, Azure SQL Database, and Azure Active
     Directory.
    :type category: str
    :param endpoints: The endpoints that the App Service Environment reaches
     the service at.
    :type endpoints: list[~azure.mgmt.web.models.EndpointDependency]
    """

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': '[EndpointDependency]'},
    }

    def __init__(self, *, category: str=None, endpoints=None, **kwargs) -> None:
        super(OutboundEnvironmentEndpoint, self).__init__(**kwargs)
        self.category = category
        self.endpoints = endpoints
