# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EndpointDetail(Model):
    """Current TCP connectivity information from the App Service Environment to a
    single endpoint.

    :param ip_address: An IP Address that Domain Name currently resolves to.
    :type ip_address: str
    :param port: The port an endpoint is connected to.
    :type port: int
    :param latency: The time in milliseconds it takes for a TCP connection to
     be created from the App Service Environment to this IpAddress at this
     Port.
    :type latency: float
    :param is_accessable: Whether it is possible to create a TCP connection
     from the App Service Environment to this IpAddress at this Port.
    :type is_accessable: bool
    """

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'latency': {'key': 'latency', 'type': 'float'},
        'is_accessable': {'key': 'isAccessable', 'type': 'bool'},
    }

    def __init__(self, *, ip_address: str=None, port: int=None, latency: float=None, is_accessable: bool=None, **kwargs) -> None:
        super(EndpointDetail, self).__init__(**kwargs)
        self.ip_address = ip_address
        self.port = port
        self.latency = latency
        self.is_accessable = is_accessable
