# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CorsSettings(Model):
    """Cross-Origin Resource Sharing (CORS) settings for the app.

    :param allowed_origins: Gets or sets the list of origins that should be
     allowed to make cross-origin
     calls (for example: http://example.com:12345). Use "*" to allow all.
    :type allowed_origins: list[str]
    :param support_credentials: Gets or sets whether CORS requests with
     credentials are allowed. See
     https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
     for more details.
    :type support_credentials: bool
    """

    _attribute_map = {
        'allowed_origins': {'key': 'allowedOrigins', 'type': '[str]'},
        'support_credentials': {'key': 'supportCredentials', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(CorsSettings, self).__init__(**kwargs)
        self.allowed_origins = kwargs.get('allowed_origins', None)
        self.support_credentials = kwargs.get('support_credentials', None)
