# Copyright 2010 Boris Figovsky <borfig@gmail.com>
#
# This file is part of pybfc.

# pybfc is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# pybfc is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with pybfc.  If not, see <http://www.gnu.org/licenses/>.

import os, sys

if not hasattr(sys, 'version_info') or sys.version_info < (2, 6, 0, 'final'):
    raise SystemExit("pybfc requires Python 2.6 or later.")

PROJECT_ROOT = os.path.dirname(os.path.abspath(sys.argv[0]))
PACKAGE_NAME = 'bfc'

sys.path.insert(0, PROJECT_ROOT)
try:
    from bfc import setup
finally:
    del sys.path[0]

PACKAGES = setup.setup_packages(PROJECT_ROOT, PACKAGE_NAME)

try:
    VERSION_INFO = setup.read_version_info(PROJECT_ROOT, PACKAGE_NAME)
except setup.ReadVersionError:
    VERSION_INFO = setup.read_version_info_from_file(PROJECT_ROOT, PACKAGE_NAME)
    VERSION = setup.version_info_to_version(VERSION_INFO)
else:
    VERSION = setup.write_version_file(PROJECT_ROOT, PACKAGE_NAME, VERSION_INFO)



from distutils.core import setup

setup(name='pybfc',
      version=VERSION,
      author='Boris Figovsky',
      author_email='borfig@gmail.com',
      url='http://pybfc.sf.net/',
      description='A generic purpose library in Python',
      license='GNU GPLv3+',
      packages=PACKAGES,
      )
