#
# This file is part of Dragonfly.
# (c) Copyright 2007, 2008 by Christo Butcher
# Licensed under the LGPL.
#
#   Dragonfly is free software: you can redistribute it and/or modify it 
#   under the terms of the GNU Lesser General Public License as published 
#   by the Free Software Foundation, either version 3 of the License, or 
#   (at your option) any later version.
#
#   Dragonfly is distributed in the hope that it will be useful, but 
#   WITHOUT ANY WARRANTY; without even the implied warranty of 
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public 
#   License along with Dragonfly.  If not, see 
#   <http://www.gnu.org/licenses/>.
#

"""
    This file builds the mapping from key-name to Typeable instances.
"""


import win32con
from dragonfly.actions.keyboard import keyboard, Typeable


#---------------------------------------------------------------------------
# Mapping of name -> typeable.

typeables = {
    "shift":        Typeable(code=win32con.VK_SHIFT,     name="shift"),
    "control":      Typeable(code=win32con.VK_CONTROL,   name="control"),
    "ctrl":         Typeable(code=win32con.VK_CONTROL,   name="ctrl"),
    "alt":          Typeable(code=win32con.VK_MENU,      name="alt"),
    "up":           Typeable(code=win32con.VK_UP,        name="up"),
    "down":         Typeable(code=win32con.VK_DOWN,      name="down"),
    "left":         Typeable(code=win32con.VK_LEFT,      name="left"),
    "right":        Typeable(code=win32con.VK_RIGHT,     name="right"),
    "pgup":         Typeable(code=win32con.VK_PRIOR,     name="pgup"),
    "pgdown":       Typeable(code=win32con.VK_NEXT,      name="pgdown"),
    "home":         Typeable(code=win32con.VK_HOME,      name="home"),
    "end":          Typeable(code=win32con.VK_END,       name="end"),
    "insert":       Typeable(code=win32con.VK_INSERT,    name="insert"),
    "enter":        Typeable(code=win32con.VK_RETURN,    name="enter"),
    "tab":          Typeable(code=win32con.VK_TAB,       name="tab"),
    "space":        Typeable(code=win32con.VK_SPACE,     name="space"),
    "backspace":    Typeable(code=win32con.VK_BACK,      name="backspace"),
    "delete":       Typeable(code=win32con.VK_DELETE,    name="delete"),
    "del":          Typeable(code=win32con.VK_DELETE,    name="del"),
    "win":          Typeable(code=win32con.VK_LWIN,      name="win"),
    "apps":         Typeable(code=win32con.VK_APPS,      name="apps"),
    "popup":        Typeable(code=win32con.VK_APPS,      name="popup"),
    "escape":       Typeable(code=win32con.VK_ESCAPE,    name="escape"),
    "npmul":        Typeable(code=win32con.VK_MULTIPLY,  name="npmul"),
    "npadd":        Typeable(code=win32con.VK_ADD,       name="npadd"),
    "npsep":        Typeable(code=win32con.VK_SEPARATOR, name="npsep"),
    "npsub":        Typeable(code=win32con.VK_SUBTRACT,  name="npsub"),
    "npdec":        Typeable(code=win32con.VK_DECIMAL,   name="npdec"),
    "npdiv":        Typeable(code=win32con.VK_DIVIDE,    name="npdiv"),
    "np0":          Typeable(code=win32con.VK_NUMPAD0,   name="np0"),
    "numpad0":      Typeable(code=win32con.VK_NUMPAD0,   name="numpad0"),
    "np1":          Typeable(code=win32con.VK_NUMPAD1,   name="np1"),
    "numpad1":      Typeable(code=win32con.VK_NUMPAD1,   name="numpad1"),
    "np2":          Typeable(code=win32con.VK_NUMPAD2,   name="np2"),
    "numpad2":      Typeable(code=win32con.VK_NUMPAD2,   name="numpad2"),
    "np3":          Typeable(code=win32con.VK_NUMPAD3,   name="np3"),
    "numpad3":      Typeable(code=win32con.VK_NUMPAD3,   name="numpad3"),
    "np4":          Typeable(code=win32con.VK_NUMPAD4,   name="np4"),
    "numpad4":      Typeable(code=win32con.VK_NUMPAD4,   name="numpad4"),
    "np5":          Typeable(code=win32con.VK_NUMPAD5,   name="np5"),
    "numpad5":      Typeable(code=win32con.VK_NUMPAD5,   name="numpad5"),
    "np6":          Typeable(code=win32con.VK_NUMPAD6,   name="np6"),
    "numpad6":      Typeable(code=win32con.VK_NUMPAD6,   name="numpad6"),
    "np7":          Typeable(code=win32con.VK_NUMPAD7,   name="np7"),
    "numpad7":      Typeable(code=win32con.VK_NUMPAD7,   name="numpad7"),
    "np8":          Typeable(code=win32con.VK_NUMPAD8,   name="np8"),
    "numpad8":      Typeable(code=win32con.VK_NUMPAD8,   name="numpad8"),
    "np9":          Typeable(code=win32con.VK_NUMPAD9,   name="np9"),
    "numpad9":      Typeable(code=win32con.VK_NUMPAD9,   name="numpad9"),
    "f1":           Typeable(code=win32con.VK_F1,        name="f1"),
    "f2":           Typeable(code=win32con.VK_F2,        name="f2"),
    "f3":           Typeable(code=win32con.VK_F3,        name="f3"),
    "f4":           Typeable(code=win32con.VK_F4,        name="f4"),
    "f5":           Typeable(code=win32con.VK_F5,        name="f5"),
    "f6":           Typeable(code=win32con.VK_F6,        name="f6"),
    "f7":           Typeable(code=win32con.VK_F7,        name="f7"),
    "f8":           Typeable(code=win32con.VK_F8,        name="f8"),
    "f9":           Typeable(code=win32con.VK_F9,        name="f9"),
    "f10":          Typeable(code=win32con.VK_F10,       name="f10"),
    "f11":          Typeable(code=win32con.VK_F11,       name="f11"),
    "f12":          Typeable(code=win32con.VK_F12,       name="f12"),
    "f13":          Typeable(code=win32con.VK_F13,       name="f13"),
    "f14":          Typeable(code=win32con.VK_F14,       name="f14"),
    "f15":          Typeable(code=win32con.VK_F15,       name="f15"),
    "f16":          Typeable(code=win32con.VK_F16,       name="f16"),
    "f17":          Typeable(code=win32con.VK_F17,       name="f17"),
    "f18":          Typeable(code=win32con.VK_F18,       name="f18"),
    "f19":          Typeable(code=win32con.VK_F19,       name="f19"),
    "f20":          Typeable(code=win32con.VK_F20,       name="f20"),
    "f21":          Typeable(code=win32con.VK_F21,       name="f21"),
    "f22":          Typeable(code=win32con.VK_F22,       name="f22"),
    "f23":          Typeable(code=win32con.VK_F23,       name="f23"),
    "f24":          Typeable(code=win32con.VK_F24,       name="f24"),

    "alpha":        keyboard.get_typeable(char='a'),
    "a":            keyboard.get_typeable(char='a'),
    "bravo":        keyboard.get_typeable(char='b'),
    "b":            keyboard.get_typeable(char='b'),
    "charlie":      keyboard.get_typeable(char='c'),
    "c":            keyboard.get_typeable(char='c'),
    "delta":        keyboard.get_typeable(char='d'),
    "d":            keyboard.get_typeable(char='d'),
    "echo":         keyboard.get_typeable(char='e'),
    "e":            keyboard.get_typeable(char='e'),
    "foxtrot":      keyboard.get_typeable(char='f'),
    "f":            keyboard.get_typeable(char='f'),
    "golf":         keyboard.get_typeable(char='g'),
    "g":            keyboard.get_typeable(char='g'),
    "hotel":        keyboard.get_typeable(char='h'),
    "h":            keyboard.get_typeable(char='h'),
    "india":        keyboard.get_typeable(char='i'),
    "i":            keyboard.get_typeable(char='i'),
    "juliet":       keyboard.get_typeable(char='j'),
    "j":            keyboard.get_typeable(char='j'),
    "kilo":         keyboard.get_typeable(char='k'),
    "k":            keyboard.get_typeable(char='k'),
    "lima":         keyboard.get_typeable(char='l'),
    "l":            keyboard.get_typeable(char='l'),
    "mike":         keyboard.get_typeable(char='m'),
    "m":            keyboard.get_typeable(char='m'),
    "november":     keyboard.get_typeable(char='n'),
    "n":            keyboard.get_typeable(char='n'),
    "oscar":        keyboard.get_typeable(char='o'),
    "o":            keyboard.get_typeable(char='o'),
    "papa":         keyboard.get_typeable(char='p'),
    "p":            keyboard.get_typeable(char='p'),
    "quebec":       keyboard.get_typeable(char='q'),
    "q":            keyboard.get_typeable(char='q'),
    "romeo":        keyboard.get_typeable(char='r'),
    "r":            keyboard.get_typeable(char='r'),
    "sierra":       keyboard.get_typeable(char='s'),
    "s":            keyboard.get_typeable(char='s'),
    "tango":        keyboard.get_typeable(char='t'),
    "t":            keyboard.get_typeable(char='t'),
    "uniform":      keyboard.get_typeable(char='u'),
    "u":            keyboard.get_typeable(char='u'),
    "victor":       keyboard.get_typeable(char='v'),
    "v":            keyboard.get_typeable(char='v'),
    "whisky":       keyboard.get_typeable(char='w'),
    "w":            keyboard.get_typeable(char='w'),
    "xray":         keyboard.get_typeable(char='x'),
    "x":            keyboard.get_typeable(char='x'),
    "yankee":       keyboard.get_typeable(char='y'),
    "y":            keyboard.get_typeable(char='y'),
    "zulu":         keyboard.get_typeable(char='z'),
    "z":            keyboard.get_typeable(char='z'),
    "Alpha":        keyboard.get_typeable(char='A'),
    "A":            keyboard.get_typeable(char='A'),
    "Bravo":        keyboard.get_typeable(char='B'),
    "B":            keyboard.get_typeable(char='B'),
    "Charlie":      keyboard.get_typeable(char='C'),
    "C":            keyboard.get_typeable(char='C'),
    "Delta":        keyboard.get_typeable(char='D'),
    "D":            keyboard.get_typeable(char='D'),
    "Echo":         keyboard.get_typeable(char='E'),
    "E":            keyboard.get_typeable(char='E'),
    "Foxtrot":      keyboard.get_typeable(char='F'),
    "F":            keyboard.get_typeable(char='F'),
    "Golf":         keyboard.get_typeable(char='G'),
    "G":            keyboard.get_typeable(char='G'),
    "Hotel":        keyboard.get_typeable(char='H'),
    "H":            keyboard.get_typeable(char='H'),
    "India":        keyboard.get_typeable(char='I'),
    "I":            keyboard.get_typeable(char='I'),
    "Juliet":       keyboard.get_typeable(char='J'),
    "J":            keyboard.get_typeable(char='J'),
    "Kilo":         keyboard.get_typeable(char='K'),
    "K":            keyboard.get_typeable(char='K'),
    "Lima":         keyboard.get_typeable(char='L'),
    "L":            keyboard.get_typeable(char='L'),
    "Mike":         keyboard.get_typeable(char='M'),
    "M":            keyboard.get_typeable(char='M'),
    "November":     keyboard.get_typeable(char='N'),
    "N":            keyboard.get_typeable(char='N'),
    "Oscar":        keyboard.get_typeable(char='O'),
    "O":            keyboard.get_typeable(char='O'),
    "Papa":         keyboard.get_typeable(char='P'),
    "P":            keyboard.get_typeable(char='P'),
    "Quebec":       keyboard.get_typeable(char='Q'),
    "Q":            keyboard.get_typeable(char='Q'),
    "Romeo":        keyboard.get_typeable(char='R'),
    "R":            keyboard.get_typeable(char='R'),
    "Sierra":       keyboard.get_typeable(char='S'),
    "S":            keyboard.get_typeable(char='S'),
    "Tango":        keyboard.get_typeable(char='T'),
    "T":            keyboard.get_typeable(char='T'),
    "Uniform":      keyboard.get_typeable(char='U'),
    "U":            keyboard.get_typeable(char='U'),
    "Victor":       keyboard.get_typeable(char='V'),
    "V":            keyboard.get_typeable(char='V'),
    "Whisky":       keyboard.get_typeable(char='W'),
    "W":            keyboard.get_typeable(char='W'),
    "Xray":         keyboard.get_typeable(char='X'),
    "X":            keyboard.get_typeable(char='X'),
    "Yankee":       keyboard.get_typeable(char='Y'),
    "Y":            keyboard.get_typeable(char='Y'),
    "Zulu":         keyboard.get_typeable(char='Z'),
    "Z":            keyboard.get_typeable(char='Z'),
    "0":            keyboard.get_typeable(char='0'),
    "zero":         keyboard.get_typeable(char='0'),
    "1":            keyboard.get_typeable(char='1'),
    "one":          keyboard.get_typeable(char='1'),
    "2":            keyboard.get_typeable(char='2'),
    "two":          keyboard.get_typeable(char='2'),
    "3":            keyboard.get_typeable(char='3'),
    "three":        keyboard.get_typeable(char='3'),
    "4":            keyboard.get_typeable(char='4'),
    "four":         keyboard.get_typeable(char='4'),
    "5":            keyboard.get_typeable(char='5'),
    "five":         keyboard.get_typeable(char='5'),
    "6":            keyboard.get_typeable(char='6'),
    "six":          keyboard.get_typeable(char='6'),
    "7":            keyboard.get_typeable(char='7'),
    "seven":        keyboard.get_typeable(char='7'),
    "8":            keyboard.get_typeable(char='8'),
    "eight":        keyboard.get_typeable(char='8'),
    "9":            keyboard.get_typeable(char='9'),
    "nine":         keyboard.get_typeable(char='9'),
    "bang":         keyboard.get_typeable(char='!'),
    "exclamation":  keyboard.get_typeable(char='!'),
    "at":           keyboard.get_typeable(char='@'),
    "hash":         keyboard.get_typeable(char='#'),
    "dollar":       keyboard.get_typeable(char='$'),
    "percent":      keyboard.get_typeable(char='%'),
    "caret":        keyboard.get_typeable(char='^'),
    "and":          keyboard.get_typeable(char='&'),
    "ampersand":    keyboard.get_typeable(char='&'),
    "star":         keyboard.get_typeable(char='*'),
    "asterisk":     keyboard.get_typeable(char='*'),
    "leftparen":    keyboard.get_typeable(char='('),
    "lparen":       keyboard.get_typeable(char='('),
    "rightparen":   keyboard.get_typeable(char=')'),
    "rparen":       keyboard.get_typeable(char=')'),
    "minus":        keyboard.get_typeable(char='-'),
    "hyphen":       keyboard.get_typeable(char='-'),
    "underscore":   keyboard.get_typeable(char='_'),
    "plus":         keyboard.get_typeable(char='+'),
    "backtick":     keyboard.get_typeable(char='`'),
    "tilde":        keyboard.get_typeable(char='~'),
    "leftbracket":  keyboard.get_typeable(char='['),
    "lbracket":     keyboard.get_typeable(char='['),
    "rightbracket": keyboard.get_typeable(char=']'),
    "rbracket":     keyboard.get_typeable(char=']'),
    "leftbrace":    keyboard.get_typeable(char='{'),
    "lbrace":       keyboard.get_typeable(char='{'),
    "rightbrace":   keyboard.get_typeable(char='}'),
    "rbrace":       keyboard.get_typeable(char='}'),
    "backslash":    keyboard.get_typeable(char='\\'),
    "bar":          keyboard.get_typeable(char='|'),
    "colon":        keyboard.get_typeable(char=':'),
    "apostrophe":   keyboard.get_typeable(char="'"),
    "singlequote":  keyboard.get_typeable(char="'"),
    "squote":       keyboard.get_typeable(char="'"),
    "quote":        keyboard.get_typeable(char='"'),
    "doublequote":  keyboard.get_typeable(char='"'),
    "dquote":       keyboard.get_typeable(char='"'),
    "comma":        keyboard.get_typeable(char=','),
    "dot":          keyboard.get_typeable(char='.'),
    "slash":        keyboard.get_typeable(char='/'),
    "lessthan":     keyboard.get_typeable(char='<'),
    "leftangle":    keyboard.get_typeable(char='<'),
    "langle":       keyboard.get_typeable(char='<'),
    "greaterthan":  keyboard.get_typeable(char='>'),
    "rightangle":   keyboard.get_typeable(char='>'),
    "rangle":       keyboard.get_typeable(char='>'),
    "question":     keyboard.get_typeable(char='?'),
    "equal":        keyboard.get_typeable(char='='),
    "equals":       keyboard.get_typeable(char='='),
    }
