# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class Resource(Model):
    """Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AzureEntityResource(Resource):
    """The resource model definition for a Azure Resource Manager resource with an
    etag.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(AzureEntityResource, self).__init__(**kwargs)
        self.etag = None


class CloudError(Model):
    """An error response from the Batch service.

    :param error:
    :type error: ~azure.mgmt.rdbms.postgresql.models.ErrorResponse
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(CloudError, self).__init__(**kwargs)
        self.error = error


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have
    everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ProxyResource, self).__init__(**kwargs)


class Configuration(ProxyResource):
    """Represents a Configuration.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param value: Value of the configuration.
    :type value: str
    :ivar description: Description of the configuration.
    :vartype description: str
    :ivar default_value: Default value of the configuration.
    :vartype default_value: str
    :ivar data_type: Data type of the configuration.
    :vartype data_type: str
    :ivar allowed_values: Allowed values of the configuration.
    :vartype allowed_values: str
    :param source: Source of the configuration.
    :type source: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'description': {'readonly': True},
        'default_value': {'readonly': True},
        'data_type': {'readonly': True},
        'allowed_values': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'default_value': {'key': 'properties.defaultValue', 'type': 'str'},
        'data_type': {'key': 'properties.dataType', 'type': 'str'},
        'allowed_values': {'key': 'properties.allowedValues', 'type': 'str'},
        'source': {'key': 'properties.source', 'type': 'str'},
    }

    def __init__(self, *, value: str=None, source: str=None, **kwargs) -> None:
        super(Configuration, self).__init__(**kwargs)
        self.value = value
        self.description = None
        self.default_value = None
        self.data_type = None
        self.allowed_values = None
        self.source = source


class Database(ProxyResource):
    """Represents a Database.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param charset: The charset of the database.
    :type charset: str
    :param collation: The collation of the database.
    :type collation: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'charset': {'key': 'properties.charset', 'type': 'str'},
        'collation': {'key': 'properties.collation', 'type': 'str'},
    }

    def __init__(self, *, charset: str=None, collation: str=None, **kwargs) -> None:
        super(Database, self).__init__(**kwargs)
        self.charset = charset
        self.collation = collation


class ErrorAdditionalInfo(Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: object
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(self, **kwargs) -> None:
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorResponse(Model):
    """The resource management error response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.rdbms.postgresql.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.rdbms.postgresql.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class FirewallRule(ProxyResource):
    """Represents a server firewall rule.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param start_ip_address: Required. The start IP address of the server
     firewall rule. Must be IPv4 format.
    :type start_ip_address: str
    :param end_ip_address: Required. The end IP address of the server firewall
     rule. Must be IPv4 format.
    :type end_ip_address: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'start_ip_address': {'required': True, 'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$'},
        'end_ip_address': {'required': True, 'pattern': r'^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$'},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start_ip_address': {'key': 'properties.startIpAddress', 'type': 'str'},
        'end_ip_address': {'key': 'properties.endIpAddress', 'type': 'str'},
    }

    def __init__(self, *, start_ip_address: str, end_ip_address: str, **kwargs) -> None:
        super(FirewallRule, self).__init__(**kwargs)
        self.start_ip_address = start_ip_address
        self.end_ip_address = end_ip_address


class LogFile(ProxyResource):
    """Represents a log file.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param size_in_kb: Size of the log file.
    :type size_in_kb: long
    :ivar created_time: Creation timestamp of the log file.
    :vartype created_time: datetime
    :ivar last_modified_time: Last modified timestamp of the log file.
    :vartype last_modified_time: datetime
    :param log_file_type: Type of the log file.
    :type log_file_type: str
    :param url: The url to download the log file from.
    :type url: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'size_in_kb': {'key': 'properties.sizeInKB', 'type': 'long'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'log_file_type': {'key': 'properties.type', 'type': 'str'},
        'url': {'key': 'properties.url', 'type': 'str'},
    }

    def __init__(self, *, size_in_kb: int=None, log_file_type: str=None, url: str=None, **kwargs) -> None:
        super(LogFile, self).__init__(**kwargs)
        self.size_in_kb = size_in_kb
        self.created_time = None
        self.last_modified_time = None
        self.log_file_type = log_file_type
        self.url = url


class NameAvailability(Model):
    """Represents a resource name availability.

    :param message: Error Message.
    :type message: str
    :param name_available: Indicates whether the resource name is available.
    :type name_available: bool
    :param reason: Reason for name being unavailable.
    :type reason: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(self, *, message: str=None, name_available: bool=None, reason: str=None, **kwargs) -> None:
        super(NameAvailability, self).__init__(**kwargs)
        self.message = message
        self.name_available = name_available
        self.reason = reason


class NameAvailabilityRequest(Model):
    """Request from client to check resource name availability.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Resource name to verify.
    :type name: str
    :param type: Resource type used for verification.
    :type type: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, name: str, type: str=None, **kwargs) -> None:
        super(NameAvailabilityRequest, self).__init__(**kwargs)
        self.name = name
        self.type = type


class Operation(Model):
    """REST API operation definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name of the operation being performed on this particular
     object.
    :vartype name: str
    :ivar display: The localized display information for this particular
     operation or action.
    :vartype display: ~azure.mgmt.rdbms.postgresql.models.OperationDisplay
    :ivar origin: The intended executor of the operation. Possible values
     include: 'NotSpecified', 'user', 'system'
    :vartype origin: str or
     ~azure.mgmt.rdbms.postgresql.models.OperationOrigin
    :ivar properties: Additional descriptions for the operation.
    :vartype properties: dict[str, object]
    """

    _validation = {
        'name': {'readonly': True},
        'display': {'readonly': True},
        'origin': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{object}'},
    }

    def __init__(self, **kwargs) -> None:
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = None
        self.origin = None
        self.properties = None


class OperationDisplay(Model):
    """Display metadata associated with the operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar provider: Operation resource provider name.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(Model):
    """A list of resource provider operations.

    :param value: The list of resource provider operations.
    :type value: list[~azure.mgmt.rdbms.postgresql.models.Operation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value


class PerformanceTierProperties(Model):
    """Performance tier properties.

    :param id: ID of the performance tier.
    :type id: str
    :param service_level_objectives: Service level objectives associated with
     the performance tier
    :type service_level_objectives:
     list[~azure.mgmt.rdbms.postgresql.models.PerformanceTierServiceLevelObjectives]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'service_level_objectives': {'key': 'serviceLevelObjectives', 'type': '[PerformanceTierServiceLevelObjectives]'},
    }

    def __init__(self, *, id: str=None, service_level_objectives=None, **kwargs) -> None:
        super(PerformanceTierProperties, self).__init__(**kwargs)
        self.id = id
        self.service_level_objectives = service_level_objectives


class PerformanceTierServiceLevelObjectives(Model):
    """Service level objectives for performance tier.

    :param id: ID for the service level objective.
    :type id: str
    :param edition: Edition of the performance tier.
    :type edition: str
    :param v_core: vCore associated with the service level objective
    :type v_core: int
    :param hardware_generation: Hardware generation associated with the
     service level objective
    :type hardware_generation: str
    :param max_backup_retention_days: Maximum Backup retention in days for the
     performance tier edition
    :type max_backup_retention_days: int
    :param min_backup_retention_days: Minimum Backup retention in days for the
     performance tier edition
    :type min_backup_retention_days: int
    :param max_storage_mb: Max storage allowed for a server.
    :type max_storage_mb: int
    :param min_storage_mb: Max storage allowed for a server.
    :type min_storage_mb: int
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'edition': {'key': 'edition', 'type': 'str'},
        'v_core': {'key': 'vCore', 'type': 'int'},
        'hardware_generation': {'key': 'hardwareGeneration', 'type': 'str'},
        'max_backup_retention_days': {'key': 'maxBackupRetentionDays', 'type': 'int'},
        'min_backup_retention_days': {'key': 'minBackupRetentionDays', 'type': 'int'},
        'max_storage_mb': {'key': 'maxStorageMB', 'type': 'int'},
        'min_storage_mb': {'key': 'minStorageMB', 'type': 'int'},
    }

    def __init__(self, *, id: str=None, edition: str=None, v_core: int=None, hardware_generation: str=None, max_backup_retention_days: int=None, min_backup_retention_days: int=None, max_storage_mb: int=None, min_storage_mb: int=None, **kwargs) -> None:
        super(PerformanceTierServiceLevelObjectives, self).__init__(**kwargs)
        self.id = id
        self.edition = edition
        self.v_core = v_core
        self.hardware_generation = hardware_generation
        self.max_backup_retention_days = max_backup_retention_days
        self.min_backup_retention_days = min_backup_retention_days
        self.max_storage_mb = max_storage_mb
        self.min_storage_mb = min_storage_mb


class PrivateEndpointConnection(ProxyResource):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param private_endpoint: Private endpoint which the connection belongs to.
    :type private_endpoint:
     ~azure.mgmt.rdbms.postgresql.models.PrivateEndpointProperty
    :param private_link_service_connection_state: Connection state of the
     private endpoint connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.rdbms.postgresql.models.PrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the private endpoint connection.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpointProperty'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionStateProperty'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(self, *, private_endpoint=None, private_link_service_connection_state=None, **kwargs) -> None:
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointProperty(Model):
    """PrivateEndpointProperty.

    :param id: Resource id of the private endpoint.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, **kwargs) -> None:
        super(PrivateEndpointProperty, self).__init__(**kwargs)
        self.id = id


class PrivateLinkResource(ProxyResource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar properties: The private link resource group id.
    :vartype properties:
     ~azure.mgmt.rdbms.postgresql.models.PrivateLinkResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PrivateLinkResourceProperties'},
    }

    def __init__(self, **kwargs) -> None:
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.properties = None


class PrivateLinkResourceProperties(Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    """

    _validation = {
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
    }

    def __init__(self, **kwargs) -> None:
        super(PrivateLinkResourceProperties, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None


class PrivateLinkServiceConnectionStateProperty(Model):
    """PrivateLinkServiceConnectionStateProperty.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The private link service connection status.
    :type status: str
    :param description: Required. The private link service connection
     description.
    :type description: str
    :ivar actions_required: The actions required for private link service
     connection.
    :vartype actions_required: str
    """

    _validation = {
        'status': {'required': True},
        'description': {'required': True},
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(self, *, status: str, description: str, **kwargs) -> None:
        super(PrivateLinkServiceConnectionStateProperty, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = None


class ResourceIdentity(Model):
    """Azure Active Directory identity configuration for a resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: The Azure Active Directory principal id.
    :vartype principal_id: str
    :param type: The identity type. Set this to 'SystemAssigned' in order to
     automatically create and assign an Azure Active Directory principal for
     the resource. Possible values include: 'SystemAssigned'
    :type type: str or ~azure.mgmt.rdbms.postgresql.models.IdentityType
    :ivar tenant_id: The Azure Active Directory tenant id.
    :vartype tenant_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(self, *, type=None, **kwargs) -> None:
        super(ResourceIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.type = type
        self.tenant_id = None


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class Server(TrackedResource):
    """Represents a server.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :param identity: The Azure Active Directory identity of the server.
    :type identity: ~azure.mgmt.rdbms.postgresql.models.ResourceIdentity
    :param sku: The SKU (pricing tier) of the server.
    :type sku: ~azure.mgmt.rdbms.postgresql.models.Sku
    :param administrator_login: The administrator's login name of a server.
     Can only be specified when the server is being created (and is required
     for creation).
    :type administrator_login: str
    :param version: Server version. Possible values include: '9.5', '9.6',
     '10', '10.0', '10.2', '11'
    :type version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to
     server. Possible values include: 'Enabled', 'Disabled'
    :type ssl_enforcement: str or
     ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :param minimal_tls_version: Enforce a minimal Tls version for the server.
     Possible values include: 'TLS1_0', 'TLS1_1', 'TLS1_2',
     'TLSEnforcementDisabled'
    :type minimal_tls_version: str or
     ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :ivar byok_enforcement: Status showing whether the server data encryption
     is enabled with customer-managed keys.
    :vartype byok_enforcement: str
    :param infrastructure_encryption: Status showing whether the server
     enabled infrastructure encryption. Possible values include: 'Enabled',
     'Disabled'
    :type infrastructure_encryption: str or
     ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
    :param user_visible_state: A state of a server that is visible to user.
     Possible values include: 'Ready', 'Dropping', 'Disabled', 'Inaccessible'
    :type user_visible_state: str or
     ~azure.mgmt.rdbms.postgresql.models.ServerState
    :param fully_qualified_domain_name: The fully qualified domain name of a
     server.
    :type fully_qualified_domain_name: str
    :param earliest_restore_date: Earliest restore point creation time
     (ISO8601 format)
    :type earliest_restore_date: datetime
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :param replication_role: The replication role of the server.
    :type replication_role: str
    :param master_server_id: The master server id of a replica server.
    :type master_server_id: str
    :param replica_capacity: The maximum number of replicas that a master
     server can have.
    :type replica_capacity: int
    :param public_network_access: Whether or not public network access is
     allowed for this server. Value is optional but if passed in, must be
     'Enabled' or 'Disabled'. Possible values include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :ivar private_endpoint_connections: List of private endpoint connections
     on a server
    :vartype private_endpoint_connections:
     list[~azure.mgmt.rdbms.postgresql.models.ServerPrivateEndpointConnection]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'byok_enforcement': {'readonly': True},
        'replica_capacity': {'minimum': 0},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'administrator_login': {'key': 'properties.administratorLogin', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'ssl_enforcement': {'key': 'properties.sslEnforcement', 'type': 'SslEnforcementEnum'},
        'minimal_tls_version': {'key': 'properties.minimalTlsVersion', 'type': 'str'},
        'byok_enforcement': {'key': 'properties.byokEnforcement', 'type': 'str'},
        'infrastructure_encryption': {'key': 'properties.infrastructureEncryption', 'type': 'str'},
        'user_visible_state': {'key': 'properties.userVisibleState', 'type': 'str'},
        'fully_qualified_domain_name': {'key': 'properties.fullyQualifiedDomainName', 'type': 'str'},
        'earliest_restore_date': {'key': 'properties.earliestRestoreDate', 'type': 'iso-8601'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'replication_role': {'key': 'properties.replicationRole', 'type': 'str'},
        'master_server_id': {'key': 'properties.masterServerId', 'type': 'str'},
        'replica_capacity': {'key': 'properties.replicaCapacity', 'type': 'int'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[ServerPrivateEndpointConnection]'},
    }

    def __init__(self, *, location: str, tags=None, identity=None, sku=None, administrator_login: str=None, version=None, ssl_enforcement=None, minimal_tls_version=None, infrastructure_encryption=None, user_visible_state=None, fully_qualified_domain_name: str=None, earliest_restore_date=None, storage_profile=None, replication_role: str=None, master_server_id: str=None, replica_capacity: int=None, public_network_access=None, **kwargs) -> None:
        super(Server, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.sku = sku
        self.administrator_login = administrator_login
        self.version = version
        self.ssl_enforcement = ssl_enforcement
        self.minimal_tls_version = minimal_tls_version
        self.byok_enforcement = None
        self.infrastructure_encryption = infrastructure_encryption
        self.user_visible_state = user_visible_state
        self.fully_qualified_domain_name = fully_qualified_domain_name
        self.earliest_restore_date = earliest_restore_date
        self.storage_profile = storage_profile
        self.replication_role = replication_role
        self.master_server_id = master_server_id
        self.replica_capacity = replica_capacity
        self.public_network_access = public_network_access
        self.private_endpoint_connections = None


class ServerAdministratorResource(ProxyResource):
    """Represents a and external administrator to be created.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar administrator_type: Required. The type of administrator. Default
     value: "ActiveDirectory" .
    :vartype administrator_type: str
    :param login: Required. The server administrator login account name.
    :type login: str
    :param sid: Required. The server administrator Sid (Secure ID).
    :type sid: str
    :param tenant_id: Required. The server Active Directory Administrator
     tenant id.
    :type tenant_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'administrator_type': {'required': True, 'constant': True},
        'login': {'required': True},
        'sid': {'required': True},
        'tenant_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'administrator_type': {'key': 'properties.administratorType', 'type': 'str'},
        'login': {'key': 'properties.login', 'type': 'str'},
        'sid': {'key': 'properties.sid', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
    }

    administrator_type = "ActiveDirectory"

    def __init__(self, *, login: str, sid: str, tenant_id: str, **kwargs) -> None:
        super(ServerAdministratorResource, self).__init__(**kwargs)
        self.login = login
        self.sid = sid
        self.tenant_id = tenant_id


class ServerForCreate(Model):
    """Represents a server to be created.

    All required parameters must be populated in order to send to Azure.

    :param identity: The Azure Active Directory identity of the server.
    :type identity: ~azure.mgmt.rdbms.postgresql.models.ResourceIdentity
    :param sku: The SKU (pricing tier) of the server.
    :type sku: ~azure.mgmt.rdbms.postgresql.models.Sku
    :param properties: Required. Properties of the server.
    :type properties:
     ~azure.mgmt.rdbms.postgresql.models.ServerPropertiesForCreate
    :param location: Required. The location the resource resides in.
    :type location: str
    :param tags: Application-specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    """

    _validation = {
        'properties': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'properties': {'key': 'properties', 'type': 'ServerPropertiesForCreate'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, properties, location: str, identity=None, sku=None, tags=None, **kwargs) -> None:
        super(ServerForCreate, self).__init__(**kwargs)
        self.identity = identity
        self.sku = sku
        self.properties = properties
        self.location = location
        self.tags = tags


class ServerKey(ProxyResource):
    """A PostgreSQL Server key.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar kind: Kind of encryption protector used to protect the key.
    :vartype kind: str
    :ivar server_key_type: Required. The key type like 'AzureKeyVault'.
     Default value: "AzureKeyVault" .
    :vartype server_key_type: str
    :param uri: The URI of the key.
    :type uri: str
    :ivar creation_date: The key creation date.
    :vartype creation_date: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'readonly': True},
        'server_key_type': {'required': True, 'constant': True},
        'creation_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'server_key_type': {'key': 'properties.serverKeyType', 'type': 'str'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
    }

    server_key_type = "AzureKeyVault"

    def __init__(self, *, uri: str=None, **kwargs) -> None:
        super(ServerKey, self).__init__(**kwargs)
        self.kind = None
        self.uri = uri
        self.creation_date = None


class ServerPrivateEndpointConnection(Model):
    """A private endpoint connection under a server.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID of the Private Endpoint Connection.
    :vartype id: str
    :ivar properties: Private endpoint connection properties
    :vartype properties:
     ~azure.mgmt.rdbms.postgresql.models.ServerPrivateEndpointConnectionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ServerPrivateEndpointConnectionProperties'},
    }

    def __init__(self, **kwargs) -> None:
        super(ServerPrivateEndpointConnection, self).__init__(**kwargs)
        self.id = None
        self.properties = None


class ServerPrivateEndpointConnectionProperties(Model):
    """Properties of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param private_endpoint: Private endpoint which the connection belongs to.
    :type private_endpoint:
     ~azure.mgmt.rdbms.postgresql.models.PrivateEndpointProperty
    :param private_link_service_connection_state: Connection state of the
     private endpoint connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.rdbms.postgresql.models.ServerPrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the private endpoint connection.
     Possible values include: 'Approving', 'Ready', 'Dropping', 'Failed',
     'Rejecting'
    :vartype provisioning_state: str or
     ~azure.mgmt.rdbms.postgresql.models.PrivateEndpointProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'private_endpoint': {'key': 'privateEndpoint', 'type': 'PrivateEndpointProperty'},
        'private_link_service_connection_state': {'key': 'privateLinkServiceConnectionState', 'type': 'ServerPrivateLinkServiceConnectionStateProperty'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(self, *, private_endpoint=None, private_link_service_connection_state=None, **kwargs) -> None:
        super(ServerPrivateEndpointConnectionProperties, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class ServerPrivateLinkServiceConnectionStateProperty(Model):
    """ServerPrivateLinkServiceConnectionStateProperty.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The private link service connection status.
     Possible values include: 'Approved', 'Pending', 'Rejected', 'Disconnected'
    :type status: str or
     ~azure.mgmt.rdbms.postgresql.models.PrivateLinkServiceConnectionStateStatus
    :param description: Required. The private link service connection
     description.
    :type description: str
    :ivar actions_required: The actions required for private link service
     connection. Possible values include: 'None'
    :vartype actions_required: str or
     ~azure.mgmt.rdbms.postgresql.models.PrivateLinkServiceConnectionStateActionsRequire
    """

    _validation = {
        'status': {'required': True},
        'description': {'required': True},
        'actions_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(self, *, status, description: str, **kwargs) -> None:
        super(ServerPrivateLinkServiceConnectionStateProperty, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = None


class ServerPropertiesForCreate(Model):
    """The properties used to create a new server.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ServerPropertiesForDefaultCreate,
    ServerPropertiesForRestore, ServerPropertiesForGeoRestore,
    ServerPropertiesForReplica

    All required parameters must be populated in order to send to Azure.

    :param version: Server version. Possible values include: '9.5', '9.6',
     '10', '10.0', '10.2', '11'
    :type version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to
     server. Possible values include: 'Enabled', 'Disabled'
    :type ssl_enforcement: str or
     ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :param minimal_tls_version: Enforce a minimal Tls version for the server.
     Possible values include: 'TLS1_0', 'TLS1_1', 'TLS1_2',
     'TLSEnforcementDisabled'
    :type minimal_tls_version: str or
     ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :param infrastructure_encryption: Status showing whether the server
     enabled infrastructure encryption. Possible values include: 'Enabled',
     'Disabled'
    :type infrastructure_encryption: str or
     ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
    :param public_network_access: Whether or not public network access is
     allowed for this server. Value is optional but if passed in, must be
     'Enabled' or 'Disabled'. Possible values include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :param create_mode: Required. Constant filled by server.
    :type create_mode: str
    """

    _validation = {
        'create_mode': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'SslEnforcementEnum'},
        'minimal_tls_version': {'key': 'minimalTlsVersion', 'type': 'str'},
        'infrastructure_encryption': {'key': 'infrastructureEncryption', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
    }

    _subtype_map = {
        'create_mode': {'Default': 'ServerPropertiesForDefaultCreate', 'PointInTimeRestore': 'ServerPropertiesForRestore', 'GeoRestore': 'ServerPropertiesForGeoRestore', 'Replica': 'ServerPropertiesForReplica'}
    }

    def __init__(self, *, version=None, ssl_enforcement=None, minimal_tls_version=None, infrastructure_encryption=None, public_network_access=None, storage_profile=None, **kwargs) -> None:
        super(ServerPropertiesForCreate, self).__init__(**kwargs)
        self.version = version
        self.ssl_enforcement = ssl_enforcement
        self.minimal_tls_version = minimal_tls_version
        self.infrastructure_encryption = infrastructure_encryption
        self.public_network_access = public_network_access
        self.storage_profile = storage_profile
        self.create_mode = None


class ServerPropertiesForDefaultCreate(ServerPropertiesForCreate):
    """The properties used to create a new server.

    All required parameters must be populated in order to send to Azure.

    :param version: Server version. Possible values include: '9.5', '9.6',
     '10', '10.0', '10.2', '11'
    :type version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to
     server. Possible values include: 'Enabled', 'Disabled'
    :type ssl_enforcement: str or
     ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :param minimal_tls_version: Enforce a minimal Tls version for the server.
     Possible values include: 'TLS1_0', 'TLS1_1', 'TLS1_2',
     'TLSEnforcementDisabled'
    :type minimal_tls_version: str or
     ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :param infrastructure_encryption: Status showing whether the server
     enabled infrastructure encryption. Possible values include: 'Enabled',
     'Disabled'
    :type infrastructure_encryption: str or
     ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
    :param public_network_access: Whether or not public network access is
     allowed for this server. Value is optional but if passed in, must be
     'Enabled' or 'Disabled'. Possible values include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :param create_mode: Required. Constant filled by server.
    :type create_mode: str
    :param administrator_login: Required. The administrator's login name of a
     server. Can only be specified when the server is being created (and is
     required for creation).
    :type administrator_login: str
    :param administrator_login_password: Required. The password of the
     administrator login.
    :type administrator_login_password: str
    """

    _validation = {
        'create_mode': {'required': True},
        'administrator_login': {'required': True},
        'administrator_login_password': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'SslEnforcementEnum'},
        'minimal_tls_version': {'key': 'minimalTlsVersion', 'type': 'str'},
        'infrastructure_encryption': {'key': 'infrastructureEncryption', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'administrator_login': {'key': 'administratorLogin', 'type': 'str'},
        'administrator_login_password': {'key': 'administratorLoginPassword', 'type': 'str'},
    }

    def __init__(self, *, administrator_login: str, administrator_login_password: str, version=None, ssl_enforcement=None, minimal_tls_version=None, infrastructure_encryption=None, public_network_access=None, storage_profile=None, **kwargs) -> None:
        super(ServerPropertiesForDefaultCreate, self).__init__(version=version, ssl_enforcement=ssl_enforcement, minimal_tls_version=minimal_tls_version, infrastructure_encryption=infrastructure_encryption, public_network_access=public_network_access, storage_profile=storage_profile, **kwargs)
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
        self.create_mode = 'Default'


class ServerPropertiesForGeoRestore(ServerPropertiesForCreate):
    """The properties used to create a new server by restoring to a different
    region from a geo replicated backup.

    All required parameters must be populated in order to send to Azure.

    :param version: Server version. Possible values include: '9.5', '9.6',
     '10', '10.0', '10.2', '11'
    :type version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to
     server. Possible values include: 'Enabled', 'Disabled'
    :type ssl_enforcement: str or
     ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :param minimal_tls_version: Enforce a minimal Tls version for the server.
     Possible values include: 'TLS1_0', 'TLS1_1', 'TLS1_2',
     'TLSEnforcementDisabled'
    :type minimal_tls_version: str or
     ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :param infrastructure_encryption: Status showing whether the server
     enabled infrastructure encryption. Possible values include: 'Enabled',
     'Disabled'
    :type infrastructure_encryption: str or
     ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
    :param public_network_access: Whether or not public network access is
     allowed for this server. Value is optional but if passed in, must be
     'Enabled' or 'Disabled'. Possible values include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :param create_mode: Required. Constant filled by server.
    :type create_mode: str
    :param source_server_id: Required. The source server id to restore from.
    :type source_server_id: str
    """

    _validation = {
        'create_mode': {'required': True},
        'source_server_id': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'SslEnforcementEnum'},
        'minimal_tls_version': {'key': 'minimalTlsVersion', 'type': 'str'},
        'infrastructure_encryption': {'key': 'infrastructureEncryption', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'source_server_id': {'key': 'sourceServerId', 'type': 'str'},
    }

    def __init__(self, *, source_server_id: str, version=None, ssl_enforcement=None, minimal_tls_version=None, infrastructure_encryption=None, public_network_access=None, storage_profile=None, **kwargs) -> None:
        super(ServerPropertiesForGeoRestore, self).__init__(version=version, ssl_enforcement=ssl_enforcement, minimal_tls_version=minimal_tls_version, infrastructure_encryption=infrastructure_encryption, public_network_access=public_network_access, storage_profile=storage_profile, **kwargs)
        self.source_server_id = source_server_id
        self.create_mode = 'GeoRestore'


class ServerPropertiesForReplica(ServerPropertiesForCreate):
    """The properties to create a new replica.

    All required parameters must be populated in order to send to Azure.

    :param version: Server version. Possible values include: '9.5', '9.6',
     '10', '10.0', '10.2', '11'
    :type version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to
     server. Possible values include: 'Enabled', 'Disabled'
    :type ssl_enforcement: str or
     ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :param minimal_tls_version: Enforce a minimal Tls version for the server.
     Possible values include: 'TLS1_0', 'TLS1_1', 'TLS1_2',
     'TLSEnforcementDisabled'
    :type minimal_tls_version: str or
     ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :param infrastructure_encryption: Status showing whether the server
     enabled infrastructure encryption. Possible values include: 'Enabled',
     'Disabled'
    :type infrastructure_encryption: str or
     ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
    :param public_network_access: Whether or not public network access is
     allowed for this server. Value is optional but if passed in, must be
     'Enabled' or 'Disabled'. Possible values include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :param create_mode: Required. Constant filled by server.
    :type create_mode: str
    :param source_server_id: Required. The master server id to create replica
     from.
    :type source_server_id: str
    """

    _validation = {
        'create_mode': {'required': True},
        'source_server_id': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'SslEnforcementEnum'},
        'minimal_tls_version': {'key': 'minimalTlsVersion', 'type': 'str'},
        'infrastructure_encryption': {'key': 'infrastructureEncryption', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'source_server_id': {'key': 'sourceServerId', 'type': 'str'},
    }

    def __init__(self, *, source_server_id: str, version=None, ssl_enforcement=None, minimal_tls_version=None, infrastructure_encryption=None, public_network_access=None, storage_profile=None, **kwargs) -> None:
        super(ServerPropertiesForReplica, self).__init__(version=version, ssl_enforcement=ssl_enforcement, minimal_tls_version=minimal_tls_version, infrastructure_encryption=infrastructure_encryption, public_network_access=public_network_access, storage_profile=storage_profile, **kwargs)
        self.source_server_id = source_server_id
        self.create_mode = 'Replica'


class ServerPropertiesForRestore(ServerPropertiesForCreate):
    """The properties used to create a new server by restoring from a backup.

    All required parameters must be populated in order to send to Azure.

    :param version: Server version. Possible values include: '9.5', '9.6',
     '10', '10.0', '10.2', '11'
    :type version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to
     server. Possible values include: 'Enabled', 'Disabled'
    :type ssl_enforcement: str or
     ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :param minimal_tls_version: Enforce a minimal Tls version for the server.
     Possible values include: 'TLS1_0', 'TLS1_1', 'TLS1_2',
     'TLSEnforcementDisabled'
    :type minimal_tls_version: str or
     ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :param infrastructure_encryption: Status showing whether the server
     enabled infrastructure encryption. Possible values include: 'Enabled',
     'Disabled'
    :type infrastructure_encryption: str or
     ~azure.mgmt.rdbms.postgresql.models.InfrastructureEncryption
    :param public_network_access: Whether or not public network access is
     allowed for this server. Value is optional but if passed in, must be
     'Enabled' or 'Disabled'. Possible values include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :param create_mode: Required. Constant filled by server.
    :type create_mode: str
    :param source_server_id: Required. The source server id to restore from.
    :type source_server_id: str
    :param restore_point_in_time: Required. Restore point creation time
     (ISO8601 format), specifying the time to restore from.
    :type restore_point_in_time: datetime
    """

    _validation = {
        'create_mode': {'required': True},
        'source_server_id': {'required': True},
        'restore_point_in_time': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'ssl_enforcement': {'key': 'sslEnforcement', 'type': 'SslEnforcementEnum'},
        'minimal_tls_version': {'key': 'minimalTlsVersion', 'type': 'str'},
        'infrastructure_encryption': {'key': 'infrastructureEncryption', 'type': 'str'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'StorageProfile'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'source_server_id': {'key': 'sourceServerId', 'type': 'str'},
        'restore_point_in_time': {'key': 'restorePointInTime', 'type': 'iso-8601'},
    }

    def __init__(self, *, source_server_id: str, restore_point_in_time, version=None, ssl_enforcement=None, minimal_tls_version=None, infrastructure_encryption=None, public_network_access=None, storage_profile=None, **kwargs) -> None:
        super(ServerPropertiesForRestore, self).__init__(version=version, ssl_enforcement=ssl_enforcement, minimal_tls_version=minimal_tls_version, infrastructure_encryption=infrastructure_encryption, public_network_access=public_network_access, storage_profile=storage_profile, **kwargs)
        self.source_server_id = source_server_id
        self.restore_point_in_time = restore_point_in_time
        self.create_mode = 'PointInTimeRestore'


class ServerSecurityAlertPolicy(ProxyResource):
    """A server security alert policy.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param state: Required. Specifies the state of the policy, whether it is
     enabled or disabled. Possible values include: 'Enabled', 'Disabled'
    :type state: str or
     ~azure.mgmt.rdbms.postgresql.models.ServerSecurityAlertPolicyState
    :param disabled_alerts: Specifies an array of alerts that are disabled.
     Allowed values are: Sql_Injection, Sql_Injection_Vulnerability,
     Access_Anomaly
    :type disabled_alerts: list[str]
    :param email_addresses: Specifies an array of e-mail addresses to which
     the alert is sent.
    :type email_addresses: list[str]
    :param email_account_admins: Specifies that the alert is sent to the
     account administrators.
    :type email_account_admins: bool
    :param storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all
     Threat Detection audit logs.
    :type storage_endpoint: str
    :param storage_account_access_key: Specifies the identifier key of the
     Threat Detection audit storage account.
    :type storage_account_access_key: str
    :param retention_days: Specifies the number of days to keep in the Threat
     Detection audit logs.
    :type retention_days: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'state': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'ServerSecurityAlertPolicyState'},
        'disabled_alerts': {'key': 'properties.disabledAlerts', 'type': '[str]'},
        'email_addresses': {'key': 'properties.emailAddresses', 'type': '[str]'},
        'email_account_admins': {'key': 'properties.emailAccountAdmins', 'type': 'bool'},
        'storage_endpoint': {'key': 'properties.storageEndpoint', 'type': 'str'},
        'storage_account_access_key': {'key': 'properties.storageAccountAccessKey', 'type': 'str'},
        'retention_days': {'key': 'properties.retentionDays', 'type': 'int'},
    }

    def __init__(self, *, state, disabled_alerts=None, email_addresses=None, email_account_admins: bool=None, storage_endpoint: str=None, storage_account_access_key: str=None, retention_days: int=None, **kwargs) -> None:
        super(ServerSecurityAlertPolicy, self).__init__(**kwargs)
        self.state = state
        self.disabled_alerts = disabled_alerts
        self.email_addresses = email_addresses
        self.email_account_admins = email_account_admins
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.retention_days = retention_days


class ServerUpdateParameters(Model):
    """Parameters allowed to update for a server.

    :param identity: The Azure Active Directory identity of the server.
    :type identity: ~azure.mgmt.rdbms.postgresql.models.ResourceIdentity
    :param sku: The SKU (pricing tier) of the server.
    :type sku: ~azure.mgmt.rdbms.postgresql.models.Sku
    :param storage_profile: Storage profile of a server.
    :type storage_profile: ~azure.mgmt.rdbms.postgresql.models.StorageProfile
    :param administrator_login_password: The password of the administrator
     login.
    :type administrator_login_password: str
    :param version: The version of a server. Possible values include: '9.5',
     '9.6', '10', '10.0', '10.2', '11'
    :type version: str or ~azure.mgmt.rdbms.postgresql.models.ServerVersion
    :param ssl_enforcement: Enable ssl enforcement or not when connect to
     server. Possible values include: 'Enabled', 'Disabled'
    :type ssl_enforcement: str or
     ~azure.mgmt.rdbms.postgresql.models.SslEnforcementEnum
    :param minimal_tls_version: Enforce a minimal Tls version for the server.
     Possible values include: 'TLS1_0', 'TLS1_1', 'TLS1_2',
     'TLSEnforcementDisabled'
    :type minimal_tls_version: str or
     ~azure.mgmt.rdbms.postgresql.models.MinimalTlsVersionEnum
    :param public_network_access: Whether or not public network access is
     allowed for this server. Value is optional but if passed in, must be
     'Enabled' or 'Disabled'. Possible values include: 'Enabled', 'Disabled'
    :type public_network_access: str or
     ~azure.mgmt.rdbms.postgresql.models.PublicNetworkAccessEnum
    :param replication_role: The replication role of the server.
    :type replication_role: str
    :param tags: Application-specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'administrator_login_password': {'key': 'properties.administratorLoginPassword', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'ssl_enforcement': {'key': 'properties.sslEnforcement', 'type': 'SslEnforcementEnum'},
        'minimal_tls_version': {'key': 'properties.minimalTlsVersion', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'replication_role': {'key': 'properties.replicationRole', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, identity=None, sku=None, storage_profile=None, administrator_login_password: str=None, version=None, ssl_enforcement=None, minimal_tls_version=None, public_network_access=None, replication_role: str=None, tags=None, **kwargs) -> None:
        super(ServerUpdateParameters, self).__init__(**kwargs)
        self.identity = identity
        self.sku = sku
        self.storage_profile = storage_profile
        self.administrator_login_password = administrator_login_password
        self.version = version
        self.ssl_enforcement = ssl_enforcement
        self.minimal_tls_version = minimal_tls_version
        self.public_network_access = public_network_access
        self.replication_role = replication_role
        self.tags = tags


class Sku(Model):
    """Billing information related properties of a server.

    :param name: The name of the sku, typically, tier + family + cores, e.g.
     B_Gen4_1, GP_Gen5_8.
    :type name: str
    :param tier: The tier of the particular SKU, e.g. Basic. Possible values
     include: 'Basic', 'GeneralPurpose', 'MemoryOptimized'
    :type tier: str or ~azure.mgmt.rdbms.postgresql.models.SkuTier
    :param capacity: The scale up/out capacity, representing server's compute
     units.
    :type capacity: int
    :param size: The size code, to be interpreted by resource as appropriate.
    :type size: str
    :param family: The family of hardware.
    :type family: str
    """

    _validation = {
        'capacity': {'minimum': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, tier=None, capacity: int=None, size: str=None, family: str=None, **kwargs) -> None:
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity
        self.size = size
        self.family = family


class StorageProfile(Model):
    """Storage Profile properties of a server.

    :param backup_retention_days: Backup retention days for the server.
    :type backup_retention_days: int
    :param geo_redundant_backup: Enable Geo-redundant or not for server
     backup. Possible values include: 'Enabled', 'Disabled'
    :type geo_redundant_backup: str or
     ~azure.mgmt.rdbms.postgresql.models.GeoRedundantBackup
    :param storage_mb: Max storage allowed for a server.
    :type storage_mb: int
    :param storage_autogrow: Enable Storage Auto Grow. Possible values
     include: 'Enabled', 'Disabled'
    :type storage_autogrow: str or
     ~azure.mgmt.rdbms.postgresql.models.StorageAutogrow
    """

    _attribute_map = {
        'backup_retention_days': {'key': 'backupRetentionDays', 'type': 'int'},
        'geo_redundant_backup': {'key': 'geoRedundantBackup', 'type': 'str'},
        'storage_mb': {'key': 'storageMB', 'type': 'int'},
        'storage_autogrow': {'key': 'storageAutogrow', 'type': 'str'},
    }

    def __init__(self, *, backup_retention_days: int=None, geo_redundant_backup=None, storage_mb: int=None, storage_autogrow=None, **kwargs) -> None:
        super(StorageProfile, self).__init__(**kwargs)
        self.backup_retention_days = backup_retention_days
        self.geo_redundant_backup = geo_redundant_backup
        self.storage_mb = storage_mb
        self.storage_autogrow = storage_autogrow


class TagsObject(Model):
    """Tags object for patch operations.

    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, tags=None, **kwargs) -> None:
        super(TagsObject, self).__init__(**kwargs)
        self.tags = tags


class VirtualNetworkRule(ProxyResource):
    """A virtual network rule.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param virtual_network_subnet_id: Required. The ARM resource id of the
     virtual network subnet.
    :type virtual_network_subnet_id: str
    :param ignore_missing_vnet_service_endpoint: Create firewall rule before
     the virtual network has vnet service endpoint enabled.
    :type ignore_missing_vnet_service_endpoint: bool
    :ivar state: Virtual Network Rule State. Possible values include:
     'Initializing', 'InProgress', 'Ready', 'Deleting', 'Unknown'
    :vartype state: str or
     ~azure.mgmt.rdbms.postgresql.models.VirtualNetworkRuleState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'virtual_network_subnet_id': {'required': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'virtual_network_subnet_id': {'key': 'properties.virtualNetworkSubnetId', 'type': 'str'},
        'ignore_missing_vnet_service_endpoint': {'key': 'properties.ignoreMissingVnetServiceEndpoint', 'type': 'bool'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(self, *, virtual_network_subnet_id: str, ignore_missing_vnet_service_endpoint: bool=None, **kwargs) -> None:
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.virtual_network_subnet_id = virtual_network_subnet_id
        self.ignore_missing_vnet_service_endpoint = ignore_missing_vnet_service_endpoint
        self.state = None
