# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class NetworkInterfaceIPConfiguration(SubResource):
    """IPConfiguration in a network interface.

    :param id: Resource Identifier.
    :type id: str
    :param load_balancer_backend_address_pools: The reference of
     LoadBalancerBackendAddressPool resource.
    :type load_balancer_backend_address_pools: list of
     :class:`BackendAddressPool
     <azure.mgmt.network.v20150615.models.BackendAddressPool>`
    :param load_balancer_inbound_nat_rules: A list of references of
     LoadBalancerInboundNatRules.
    :type load_balancer_inbound_nat_rules: list of :class:`InboundNatRule
     <azure.mgmt.network.v20150615.models.InboundNatRule>`
    :param private_ip_address:
    :type private_ip_address: str
    :param private_ip_allocation_method: Defines how a private IP address is
     assigned. Possible values are: 'Static' and 'Dynamic'. Possible values
     include: 'Static', 'Dynamic'
    :type private_ip_allocation_method: str or :class:`IPAllocationMethod
     <azure.mgmt.network.v20150615.models.IPAllocationMethod>`
    :param subnet:
    :type subnet: :class:`Subnet <azure.mgmt.network.v20150615.models.Subnet>`
    :param public_ip_address:
    :type public_ip_address: :class:`PublicIPAddress
     <azure.mgmt.network.v20150615.models.PublicIPAddress>`
    :param provisioning_state:
    :type provisioning_state: str
    :param name: The name of the resource that is unique within a resource
     group. This name can be used to access the resource.
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated.
    :type etag: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'load_balancer_backend_address_pools': {'key': 'properties.loadBalancerBackendAddressPools', 'type': '[BackendAddressPool]'},
        'load_balancer_inbound_nat_rules': {'key': 'properties.loadBalancerInboundNatRules', 'type': '[InboundNatRule]'},
        'private_ip_address': {'key': 'properties.privateIPAddress', 'type': 'str'},
        'private_ip_allocation_method': {'key': 'properties.privateIPAllocationMethod', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'Subnet'},
        'public_ip_address': {'key': 'properties.publicIPAddress', 'type': 'PublicIPAddress'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, id=None, load_balancer_backend_address_pools=None, load_balancer_inbound_nat_rules=None, private_ip_address=None, private_ip_allocation_method=None, subnet=None, public_ip_address=None, provisioning_state=None, name=None, etag=None):
        super(NetworkInterfaceIPConfiguration, self).__init__(id=id)
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_rules = load_balancer_inbound_nat_rules
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = provisioning_state
        self.name = name
        self.etag = etag
