# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class ActionGroupList(_serialization.Model):
    """A list of action groups.

    :ivar value: The list of action groups.
    :vartype value: list[~$(python-base-namespace).v2018_03_01.models.ActionGroupResource]
    :ivar next_link: Provides the link to retrieve the next set of elements.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ActionGroupResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ActionGroupResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of action groups.
        :paramtype value: list[~$(python-base-namespace).v2018_03_01.models.ActionGroupResource]
        :keyword next_link: Provides the link to retrieve the next set of elements.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ActionGroupPatchBody(_serialization.Model):
    """An action group object for the body of patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar enabled: Indicates whether this action group is enabled. If an action group is not
     enabled, then none of its actions will be activated.
    :vartype enabled: bool
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, enabled: bool = True, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword enabled: Indicates whether this action group is enabled. If an action group is not
         enabled, then none of its actions will be activated.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.enabled = enabled


class Resource(_serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ActionGroupResource(Resource):  # pylint: disable=too-many-instance-attributes
    """An action group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar group_short_name: The short name of the action group. This will be used in SMS messages.
    :vartype group_short_name: str
    :ivar enabled: Indicates whether this action group is enabled. If an action group is not
     enabled, then none of its receivers will receive communications.
    :vartype enabled: bool
    :ivar email_receivers: The list of email receivers that are part of this action group.
    :vartype email_receivers: list[~$(python-base-namespace).v2018_03_01.models.EmailReceiver]
    :ivar sms_receivers: The list of SMS receivers that are part of this action group.
    :vartype sms_receivers: list[~$(python-base-namespace).v2018_03_01.models.SmsReceiver]
    :ivar webhook_receivers: The list of webhook receivers that are part of this action group.
    :vartype webhook_receivers: list[~$(python-base-namespace).v2018_03_01.models.WebhookReceiver]
    :ivar itsm_receivers: The list of ITSM receivers that are part of this action group.
    :vartype itsm_receivers: list[~$(python-base-namespace).v2018_03_01.models.ItsmReceiver]
    :ivar azure_app_push_receivers: The list of AzureAppPush receivers that are part of this action
     group.
    :vartype azure_app_push_receivers:
     list[~$(python-base-namespace).v2018_03_01.models.AzureAppPushReceiver]
    :ivar automation_runbook_receivers: The list of AutomationRunbook receivers that are part of
     this action group.
    :vartype automation_runbook_receivers:
     list[~$(python-base-namespace).v2018_03_01.models.AutomationRunbookReceiver]
    :ivar voice_receivers: The list of voice receivers that are part of this action group.
    :vartype voice_receivers: list[~$(python-base-namespace).v2018_03_01.models.VoiceReceiver]
    :ivar logic_app_receivers: The list of logic app receivers that are part of this action group.
    :vartype logic_app_receivers:
     list[~$(python-base-namespace).v2018_03_01.models.LogicAppReceiver]
    :ivar azure_function_receivers: The list of azure function receivers that are part of this
     action group.
    :vartype azure_function_receivers:
     list[~$(python-base-namespace).v2018_03_01.models.AzureFunctionReceiver]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "group_short_name": {"max_length": 12},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "group_short_name": {"key": "properties.groupShortName", "type": "str"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "email_receivers": {"key": "properties.emailReceivers", "type": "[EmailReceiver]"},
        "sms_receivers": {"key": "properties.smsReceivers", "type": "[SmsReceiver]"},
        "webhook_receivers": {"key": "properties.webhookReceivers", "type": "[WebhookReceiver]"},
        "itsm_receivers": {"key": "properties.itsmReceivers", "type": "[ItsmReceiver]"},
        "azure_app_push_receivers": {"key": "properties.azureAppPushReceivers", "type": "[AzureAppPushReceiver]"},
        "automation_runbook_receivers": {
            "key": "properties.automationRunbookReceivers",
            "type": "[AutomationRunbookReceiver]",
        },
        "voice_receivers": {"key": "properties.voiceReceivers", "type": "[VoiceReceiver]"},
        "logic_app_receivers": {"key": "properties.logicAppReceivers", "type": "[LogicAppReceiver]"},
        "azure_function_receivers": {"key": "properties.azureFunctionReceivers", "type": "[AzureFunctionReceiver]"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        group_short_name: Optional[str] = None,
        enabled: bool = True,
        email_receivers: Optional[List["_models.EmailReceiver"]] = None,
        sms_receivers: Optional[List["_models.SmsReceiver"]] = None,
        webhook_receivers: Optional[List["_models.WebhookReceiver"]] = None,
        itsm_receivers: Optional[List["_models.ItsmReceiver"]] = None,
        azure_app_push_receivers: Optional[List["_models.AzureAppPushReceiver"]] = None,
        automation_runbook_receivers: Optional[List["_models.AutomationRunbookReceiver"]] = None,
        voice_receivers: Optional[List["_models.VoiceReceiver"]] = None,
        logic_app_receivers: Optional[List["_models.LogicAppReceiver"]] = None,
        azure_function_receivers: Optional[List["_models.AzureFunctionReceiver"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword group_short_name: The short name of the action group. This will be used in SMS
         messages.
        :paramtype group_short_name: str
        :keyword enabled: Indicates whether this action group is enabled. If an action group is not
         enabled, then none of its receivers will receive communications.
        :paramtype enabled: bool
        :keyword email_receivers: The list of email receivers that are part of this action group.
        :paramtype email_receivers: list[~$(python-base-namespace).v2018_03_01.models.EmailReceiver]
        :keyword sms_receivers: The list of SMS receivers that are part of this action group.
        :paramtype sms_receivers: list[~$(python-base-namespace).v2018_03_01.models.SmsReceiver]
        :keyword webhook_receivers: The list of webhook receivers that are part of this action group.
        :paramtype webhook_receivers:
         list[~$(python-base-namespace).v2018_03_01.models.WebhookReceiver]
        :keyword itsm_receivers: The list of ITSM receivers that are part of this action group.
        :paramtype itsm_receivers: list[~$(python-base-namespace).v2018_03_01.models.ItsmReceiver]
        :keyword azure_app_push_receivers: The list of AzureAppPush receivers that are part of this
         action group.
        :paramtype azure_app_push_receivers:
         list[~$(python-base-namespace).v2018_03_01.models.AzureAppPushReceiver]
        :keyword automation_runbook_receivers: The list of AutomationRunbook receivers that are part of
         this action group.
        :paramtype automation_runbook_receivers:
         list[~$(python-base-namespace).v2018_03_01.models.AutomationRunbookReceiver]
        :keyword voice_receivers: The list of voice receivers that are part of this action group.
        :paramtype voice_receivers: list[~$(python-base-namespace).v2018_03_01.models.VoiceReceiver]
        :keyword logic_app_receivers: The list of logic app receivers that are part of this action
         group.
        :paramtype logic_app_receivers:
         list[~$(python-base-namespace).v2018_03_01.models.LogicAppReceiver]
        :keyword azure_function_receivers: The list of azure function receivers that are part of this
         action group.
        :paramtype azure_function_receivers:
         list[~$(python-base-namespace).v2018_03_01.models.AzureFunctionReceiver]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.group_short_name = group_short_name
        self.enabled = enabled
        self.email_receivers = email_receivers
        self.sms_receivers = sms_receivers
        self.webhook_receivers = webhook_receivers
        self.itsm_receivers = itsm_receivers
        self.azure_app_push_receivers = azure_app_push_receivers
        self.automation_runbook_receivers = automation_runbook_receivers
        self.voice_receivers = voice_receivers
        self.logic_app_receivers = logic_app_receivers
        self.azure_function_receivers = azure_function_receivers


class AutomationRunbookReceiver(_serialization.Model):
    """The Azure Automation Runbook notification receiver.

    All required parameters must be populated in order to send to Azure.

    :ivar automation_account_id: The Azure automation account Id which holds this runbook and
     authenticate to Azure resource. Required.
    :vartype automation_account_id: str
    :ivar runbook_name: The name for this runbook. Required.
    :vartype runbook_name: str
    :ivar webhook_resource_id: The resource id for webhook linked to this runbook. Required.
    :vartype webhook_resource_id: str
    :ivar is_global_runbook: Indicates whether this instance is global runbook. Required.
    :vartype is_global_runbook: bool
    :ivar name: Indicates name of the webhook.
    :vartype name: str
    :ivar service_uri: The URI where webhooks should be sent.
    :vartype service_uri: str
    """

    _validation = {
        "automation_account_id": {"required": True},
        "runbook_name": {"required": True},
        "webhook_resource_id": {"required": True},
        "is_global_runbook": {"required": True},
    }

    _attribute_map = {
        "automation_account_id": {"key": "automationAccountId", "type": "str"},
        "runbook_name": {"key": "runbookName", "type": "str"},
        "webhook_resource_id": {"key": "webhookResourceId", "type": "str"},
        "is_global_runbook": {"key": "isGlobalRunbook", "type": "bool"},
        "name": {"key": "name", "type": "str"},
        "service_uri": {"key": "serviceUri", "type": "str"},
    }

    def __init__(
        self,
        *,
        automation_account_id: str,
        runbook_name: str,
        webhook_resource_id: str,
        is_global_runbook: bool,
        name: Optional[str] = None,
        service_uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword automation_account_id: The Azure automation account Id which holds this runbook and
         authenticate to Azure resource. Required.
        :paramtype automation_account_id: str
        :keyword runbook_name: The name for this runbook. Required.
        :paramtype runbook_name: str
        :keyword webhook_resource_id: The resource id for webhook linked to this runbook. Required.
        :paramtype webhook_resource_id: str
        :keyword is_global_runbook: Indicates whether this instance is global runbook. Required.
        :paramtype is_global_runbook: bool
        :keyword name: Indicates name of the webhook.
        :paramtype name: str
        :keyword service_uri: The URI where webhooks should be sent.
        :paramtype service_uri: str
        """
        super().__init__(**kwargs)
        self.automation_account_id = automation_account_id
        self.runbook_name = runbook_name
        self.webhook_resource_id = webhook_resource_id
        self.is_global_runbook = is_global_runbook
        self.name = name
        self.service_uri = service_uri


class AzureAppPushReceiver(_serialization.Model):
    """The Azure mobile App push notification receiver.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the Azure mobile app push receiver. Names must be unique across all
     receivers within an action group. Required.
    :vartype name: str
    :ivar email_address: The email address registered for the Azure mobile app. Required.
    :vartype email_address: str
    """

    _validation = {
        "name": {"required": True},
        "email_address": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "email_address": {"key": "emailAddress", "type": "str"},
    }

    def __init__(self, *, name: str, email_address: str, **kwargs: Any) -> None:
        """
        :keyword name: The name of the Azure mobile app push receiver. Names must be unique across all
         receivers within an action group. Required.
        :paramtype name: str
        :keyword email_address: The email address registered for the Azure mobile app. Required.
        :paramtype email_address: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.email_address = email_address


class AzureFunctionReceiver(_serialization.Model):
    """An azure function receiver.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the azure function receiver. Names must be unique across all receivers
     within an action group. Required.
    :vartype name: str
    :ivar function_app_resource_id: The azure resource id of the function app. Required.
    :vartype function_app_resource_id: str
    :ivar function_name: The function name in the function app. Required.
    :vartype function_name: str
    :ivar http_trigger_url: The http trigger url where http request sent to. Required.
    :vartype http_trigger_url: str
    """

    _validation = {
        "name": {"required": True},
        "function_app_resource_id": {"required": True},
        "function_name": {"required": True},
        "http_trigger_url": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "function_app_resource_id": {"key": "functionAppResourceId", "type": "str"},
        "function_name": {"key": "functionName", "type": "str"},
        "http_trigger_url": {"key": "httpTriggerUrl", "type": "str"},
    }

    def __init__(
        self, *, name: str, function_app_resource_id: str, function_name: str, http_trigger_url: str, **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the azure function receiver. Names must be unique across all
         receivers within an action group. Required.
        :paramtype name: str
        :keyword function_app_resource_id: The azure resource id of the function app. Required.
        :paramtype function_app_resource_id: str
        :keyword function_name: The function name in the function app. Required.
        :paramtype function_name: str
        :keyword http_trigger_url: The http trigger url where http request sent to. Required.
        :paramtype http_trigger_url: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.function_app_resource_id = function_app_resource_id
        self.function_name = function_name
        self.http_trigger_url = http_trigger_url


class MultiMetricCriteria(_serialization.Model):
    """The types of conditions for a multi resource alert.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DynamicMetricCriteria, MetricCriteria

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar criterion_type: Specifies the type of threshold criteria. Required. Known values are:
     "StaticThresholdCriterion" and "DynamicThresholdCriterion".
    :vartype criterion_type: str or ~$(python-base-namespace).v2018_03_01.models.CriterionType
    :ivar name: Name of the criteria. Required.
    :vartype name: str
    :ivar metric_name: Name of the metric. Required.
    :vartype metric_name: str
    :ivar metric_namespace: Namespace of the metric.
    :vartype metric_namespace: str
    :ivar time_aggregation: the criteria time aggregation types. Required. Known values are:
     "Average", "Count", "Minimum", "Maximum", and "Total".
    :vartype time_aggregation: str or
     ~$(python-base-namespace).v2018_03_01.models.AggregationTypeEnum
    :ivar dimensions: List of dimension conditions.
    :vartype dimensions: list[~$(python-base-namespace).v2018_03_01.models.MetricDimension]
    :ivar skip_metric_validation: Allows creating an alert rule on a custom metric that isn't yet
     emitted, by causing the metric validation to be skipped.
    :vartype skip_metric_validation: bool
    """

    _validation = {
        "criterion_type": {"required": True},
        "name": {"required": True},
        "metric_name": {"required": True},
        "time_aggregation": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "criterion_type": {"key": "criterionType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "metric_name": {"key": "metricName", "type": "str"},
        "metric_namespace": {"key": "metricNamespace", "type": "str"},
        "time_aggregation": {"key": "timeAggregation", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[MetricDimension]"},
        "skip_metric_validation": {"key": "skipMetricValidation", "type": "bool"},
    }

    _subtype_map = {
        "criterion_type": {
            "DynamicThresholdCriterion": "DynamicMetricCriteria",
            "StaticThresholdCriterion": "MetricCriteria",
        }
    }

    def __init__(
        self,
        *,
        name: str,
        metric_name: str,
        time_aggregation: Union[str, "_models.AggregationTypeEnum"],
        additional_properties: Optional[Dict[str, JSON]] = None,
        metric_namespace: Optional[str] = None,
        dimensions: Optional[List["_models.MetricDimension"]] = None,
        skip_metric_validation: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Name of the criteria. Required.
        :paramtype name: str
        :keyword metric_name: Name of the metric. Required.
        :paramtype metric_name: str
        :keyword metric_namespace: Namespace of the metric.
        :paramtype metric_namespace: str
        :keyword time_aggregation: the criteria time aggregation types. Required. Known values are:
         "Average", "Count", "Minimum", "Maximum", and "Total".
        :paramtype time_aggregation: str or
         ~$(python-base-namespace).v2018_03_01.models.AggregationTypeEnum
        :keyword dimensions: List of dimension conditions.
        :paramtype dimensions: list[~$(python-base-namespace).v2018_03_01.models.MetricDimension]
        :keyword skip_metric_validation: Allows creating an alert rule on a custom metric that isn't
         yet emitted, by causing the metric validation to be skipped.
        :paramtype skip_metric_validation: bool
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.criterion_type: Optional[str] = None
        self.name = name
        self.metric_name = metric_name
        self.metric_namespace = metric_namespace
        self.time_aggregation = time_aggregation
        self.dimensions = dimensions
        self.skip_metric_validation = skip_metric_validation


class DynamicMetricCriteria(MultiMetricCriteria):  # pylint: disable=too-many-instance-attributes
    """Criterion for dynamic threshold.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar criterion_type: Specifies the type of threshold criteria. Required. Known values are:
     "StaticThresholdCriterion" and "DynamicThresholdCriterion".
    :vartype criterion_type: str or ~$(python-base-namespace).v2018_03_01.models.CriterionType
    :ivar name: Name of the criteria. Required.
    :vartype name: str
    :ivar metric_name: Name of the metric. Required.
    :vartype metric_name: str
    :ivar metric_namespace: Namespace of the metric.
    :vartype metric_namespace: str
    :ivar time_aggregation: the criteria time aggregation types. Required. Known values are:
     "Average", "Count", "Minimum", "Maximum", and "Total".
    :vartype time_aggregation: str or
     ~$(python-base-namespace).v2018_03_01.models.AggregationTypeEnum
    :ivar dimensions: List of dimension conditions.
    :vartype dimensions: list[~$(python-base-namespace).v2018_03_01.models.MetricDimension]
    :ivar skip_metric_validation: Allows creating an alert rule on a custom metric that isn't yet
     emitted, by causing the metric validation to be skipped.
    :vartype skip_metric_validation: bool
    :ivar operator: The operator used to compare the metric value against the threshold. Required.
     Known values are: "GreaterThan", "LessThan", and "GreaterOrLessThan".
    :vartype operator: str or ~$(python-base-namespace).v2018_03_01.models.DynamicThresholdOperator
    :ivar alert_sensitivity: The extent of deviation required to trigger an alert. This will affect
     how tight the threshold is to the metric series pattern. Required. Known values are: "Low",
     "Medium", and "High".
    :vartype alert_sensitivity: str or
     ~$(python-base-namespace).v2018_03_01.models.DynamicThresholdSensitivity
    :ivar failing_periods: The minimum number of violations required within the selected lookback
     time window required to raise an alert. Required.
    :vartype failing_periods:
     ~$(python-base-namespace).v2018_03_01.models.DynamicThresholdFailingPeriods
    :ivar ignore_data_before: Use this option to set the date from which to start learning the
     metric historical data and calculate the dynamic thresholds (in ISO8601 format).
    :vartype ignore_data_before: ~datetime.datetime
    """

    _validation = {
        "criterion_type": {"required": True},
        "name": {"required": True},
        "metric_name": {"required": True},
        "time_aggregation": {"required": True},
        "operator": {"required": True},
        "alert_sensitivity": {"required": True},
        "failing_periods": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "criterion_type": {"key": "criterionType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "metric_name": {"key": "metricName", "type": "str"},
        "metric_namespace": {"key": "metricNamespace", "type": "str"},
        "time_aggregation": {"key": "timeAggregation", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[MetricDimension]"},
        "skip_metric_validation": {"key": "skipMetricValidation", "type": "bool"},
        "operator": {"key": "operator", "type": "str"},
        "alert_sensitivity": {"key": "alertSensitivity", "type": "str"},
        "failing_periods": {"key": "failingPeriods", "type": "DynamicThresholdFailingPeriods"},
        "ignore_data_before": {"key": "ignoreDataBefore", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        name: str,
        metric_name: str,
        time_aggregation: Union[str, "_models.AggregationTypeEnum"],
        operator: Union[str, "_models.DynamicThresholdOperator"],
        alert_sensitivity: Union[str, "_models.DynamicThresholdSensitivity"],
        failing_periods: "_models.DynamicThresholdFailingPeriods",
        additional_properties: Optional[Dict[str, JSON]] = None,
        metric_namespace: Optional[str] = None,
        dimensions: Optional[List["_models.MetricDimension"]] = None,
        skip_metric_validation: Optional[bool] = None,
        ignore_data_before: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Name of the criteria. Required.
        :paramtype name: str
        :keyword metric_name: Name of the metric. Required.
        :paramtype metric_name: str
        :keyword metric_namespace: Namespace of the metric.
        :paramtype metric_namespace: str
        :keyword time_aggregation: the criteria time aggregation types. Required. Known values are:
         "Average", "Count", "Minimum", "Maximum", and "Total".
        :paramtype time_aggregation: str or
         ~$(python-base-namespace).v2018_03_01.models.AggregationTypeEnum
        :keyword dimensions: List of dimension conditions.
        :paramtype dimensions: list[~$(python-base-namespace).v2018_03_01.models.MetricDimension]
        :keyword skip_metric_validation: Allows creating an alert rule on a custom metric that isn't
         yet emitted, by causing the metric validation to be skipped.
        :paramtype skip_metric_validation: bool
        :keyword operator: The operator used to compare the metric value against the threshold.
         Required. Known values are: "GreaterThan", "LessThan", and "GreaterOrLessThan".
        :paramtype operator: str or
         ~$(python-base-namespace).v2018_03_01.models.DynamicThresholdOperator
        :keyword alert_sensitivity: The extent of deviation required to trigger an alert. This will
         affect how tight the threshold is to the metric series pattern. Required. Known values are:
         "Low", "Medium", and "High".
        :paramtype alert_sensitivity: str or
         ~$(python-base-namespace).v2018_03_01.models.DynamicThresholdSensitivity
        :keyword failing_periods: The minimum number of violations required within the selected
         lookback time window required to raise an alert. Required.
        :paramtype failing_periods:
         ~$(python-base-namespace).v2018_03_01.models.DynamicThresholdFailingPeriods
        :keyword ignore_data_before: Use this option to set the date from which to start learning the
         metric historical data and calculate the dynamic thresholds (in ISO8601 format).
        :paramtype ignore_data_before: ~datetime.datetime
        """
        super().__init__(
            additional_properties=additional_properties,
            name=name,
            metric_name=metric_name,
            metric_namespace=metric_namespace,
            time_aggregation=time_aggregation,
            dimensions=dimensions,
            skip_metric_validation=skip_metric_validation,
            **kwargs
        )
        self.criterion_type: str = "DynamicThresholdCriterion"
        self.operator = operator
        self.alert_sensitivity = alert_sensitivity
        self.failing_periods = failing_periods
        self.ignore_data_before = ignore_data_before


class DynamicThresholdFailingPeriods(_serialization.Model):
    """The minimum number of violations required within the selected lookback time window required to
    raise an alert.

    All required parameters must be populated in order to send to Azure.

    :ivar number_of_evaluation_periods: The number of aggregated lookback points. The lookback time
     window is calculated based on the aggregation granularity (windowSize) and the selected number
     of aggregated points. Required.
    :vartype number_of_evaluation_periods: float
    :ivar min_failing_periods_to_alert: The number of violations to trigger an alert. Should be
     smaller or equal to numberOfEvaluationPeriods. Required.
    :vartype min_failing_periods_to_alert: float
    """

    _validation = {
        "number_of_evaluation_periods": {"required": True},
        "min_failing_periods_to_alert": {"required": True},
    }

    _attribute_map = {
        "number_of_evaluation_periods": {"key": "numberOfEvaluationPeriods", "type": "float"},
        "min_failing_periods_to_alert": {"key": "minFailingPeriodsToAlert", "type": "float"},
    }

    def __init__(
        self, *, number_of_evaluation_periods: float, min_failing_periods_to_alert: float, **kwargs: Any
    ) -> None:
        """
        :keyword number_of_evaluation_periods: The number of aggregated lookback points. The lookback
         time window is calculated based on the aggregation granularity (windowSize) and the selected
         number of aggregated points. Required.
        :paramtype number_of_evaluation_periods: float
        :keyword min_failing_periods_to_alert: The number of violations to trigger an alert. Should be
         smaller or equal to numberOfEvaluationPeriods. Required.
        :paramtype min_failing_periods_to_alert: float
        """
        super().__init__(**kwargs)
        self.number_of_evaluation_periods = number_of_evaluation_periods
        self.min_failing_periods_to_alert = min_failing_periods_to_alert


class EmailReceiver(_serialization.Model):
    """An email receiver.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the email receiver. Names must be unique across all receivers within an
     action group. Required.
    :vartype name: str
    :ivar email_address: The email address of this receiver. Required.
    :vartype email_address: str
    :ivar status: The receiver status of the e-mail. Known values are: "NotSpecified", "Enabled",
     and "Disabled".
    :vartype status: str or ~$(python-base-namespace).v2018_03_01.models.ReceiverStatus
    """

    _validation = {
        "name": {"required": True},
        "email_address": {"required": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "email_address": {"key": "emailAddress", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, name: str, email_address: str, **kwargs: Any) -> None:
        """
        :keyword name: The name of the email receiver. Names must be unique across all receivers within
         an action group. Required.
        :paramtype name: str
        :keyword email_address: The email address of this receiver. Required.
        :paramtype email_address: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.email_address = email_address
        self.status = None


class EnableRequest(_serialization.Model):
    """Describes a receiver that should be resubscribed.

    All required parameters must be populated in order to send to Azure.

    :ivar receiver_name: The name of the receiver to resubscribe. Required.
    :vartype receiver_name: str
    """

    _validation = {
        "receiver_name": {"required": True},
    }

    _attribute_map = {
        "receiver_name": {"key": "receiverName", "type": "str"},
    }

    def __init__(self, *, receiver_name: str, **kwargs: Any) -> None:
        """
        :keyword receiver_name: The name of the receiver to resubscribe. Required.
        :paramtype receiver_name: str
        """
        super().__init__(**kwargs)
        self.receiver_name = receiver_name


class ErrorResponse(_serialization.Model):
    """Describes the format of Error response.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class ItsmReceiver(_serialization.Model):
    """An Itsm receiver.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the Itsm receiver. Names must be unique across all receivers within an
     action group. Required.
    :vartype name: str
    :ivar workspace_id: OMS LA instance identifier. Required.
    :vartype workspace_id: str
    :ivar connection_id: Unique identification of ITSM connection among multiple defined in above
     workspace. Required.
    :vartype connection_id: str
    :ivar ticket_configuration: JSON blob for the configurations of the ITSM action.
     CreateMultipleWorkItems option will be part of this blob as well. Required.
    :vartype ticket_configuration: str
    :ivar region: Region in which workspace resides. Supported
     values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'.
     Required.
    :vartype region: str
    """

    _validation = {
        "name": {"required": True},
        "workspace_id": {"required": True},
        "connection_id": {"required": True},
        "ticket_configuration": {"required": True},
        "region": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "connection_id": {"key": "connectionId", "type": "str"},
        "ticket_configuration": {"key": "ticketConfiguration", "type": "str"},
        "region": {"key": "region", "type": "str"},
    }

    def __init__(
        self, *, name: str, workspace_id: str, connection_id: str, ticket_configuration: str, region: str, **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the Itsm receiver. Names must be unique across all receivers within
         an action group. Required.
        :paramtype name: str
        :keyword workspace_id: OMS LA instance identifier. Required.
        :paramtype workspace_id: str
        :keyword connection_id: Unique identification of ITSM connection among multiple defined in
         above workspace. Required.
        :paramtype connection_id: str
        :keyword ticket_configuration: JSON blob for the configurations of the ITSM action.
         CreateMultipleWorkItems option will be part of this blob as well. Required.
        :paramtype ticket_configuration: str
        :keyword region: Region in which workspace resides. Supported
         values:'centralindia','japaneast','southeastasia','australiasoutheast','uksouth','westcentralus','canadacentral','eastus','westeurope'.
         Required.
        :paramtype region: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.workspace_id = workspace_id
        self.connection_id = connection_id
        self.ticket_configuration = ticket_configuration
        self.region = region


class LogicAppReceiver(_serialization.Model):
    """A logic app receiver.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the logic app receiver. Names must be unique across all receivers
     within an action group. Required.
    :vartype name: str
    :ivar resource_id: The azure resource id of the logic app receiver. Required.
    :vartype resource_id: str
    :ivar callback_url: The callback url where http request sent to. Required.
    :vartype callback_url: str
    """

    _validation = {
        "name": {"required": True},
        "resource_id": {"required": True},
        "callback_url": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "callback_url": {"key": "callbackUrl", "type": "str"},
    }

    def __init__(self, *, name: str, resource_id: str, callback_url: str, **kwargs: Any) -> None:
        """
        :keyword name: The name of the logic app receiver. Names must be unique across all receivers
         within an action group. Required.
        :paramtype name: str
        :keyword resource_id: The azure resource id of the logic app receiver. Required.
        :paramtype resource_id: str
        :keyword callback_url: The callback url where http request sent to. Required.
        :paramtype callback_url: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.resource_id = resource_id
        self.callback_url = callback_url


class MetricAlertAction(_serialization.Model):
    """An alert action.

    :ivar action_group_id: the id of the action group to use.
    :vartype action_group_id: str
    :ivar web_hook_properties: This field allows specifying custom properties, which would be
     appended to the alert payload sent as input to the webhook.
    :vartype web_hook_properties: dict[str, str]
    """

    _attribute_map = {
        "action_group_id": {"key": "actionGroupId", "type": "str"},
        "web_hook_properties": {"key": "webHookProperties", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        action_group_id: Optional[str] = None,
        web_hook_properties: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action_group_id: the id of the action group to use.
        :paramtype action_group_id: str
        :keyword web_hook_properties: This field allows specifying custom properties, which would be
         appended to the alert payload sent as input to the webhook.
        :paramtype web_hook_properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.action_group_id = action_group_id
        self.web_hook_properties = web_hook_properties


class MetricAlertCriteria(_serialization.Model):
    """The rule criteria that defines the conditions of the alert rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MetricAlertMultipleResourceMultipleMetricCriteria,
    MetricAlertSingleResourceMultipleMetricCriteria, WebtestLocationAvailabilityCriteria

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar odata_type: specifies the type of the alert criteria. Required. Known values are:
     "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria", and
     "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria".
    :vartype odata_type: str or ~$(python-base-namespace).v2018_03_01.models.Odatatype
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "odata_type": {"key": "odata\\.type", "type": "str"},
    }

    _subtype_map = {
        "odata_type": {
            "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria": "MetricAlertMultipleResourceMultipleMetricCriteria",
            "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria": "MetricAlertSingleResourceMultipleMetricCriteria",
            "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria": "WebtestLocationAvailabilityCriteria",
        }
    }

    def __init__(self, *, additional_properties: Optional[Dict[str, JSON]] = None, **kwargs: Any) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.odata_type: Optional[str] = None


class MetricAlertMultipleResourceMultipleMetricCriteria(MetricAlertCriteria):
    """Specifies the metric alert criteria for multiple resource that has multiple metric criteria.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar odata_type: specifies the type of the alert criteria. Required. Known values are:
     "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria", and
     "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria".
    :vartype odata_type: str or ~$(python-base-namespace).v2018_03_01.models.Odatatype
    :ivar all_of: the list of multiple metric criteria for this 'all of' operation.
    :vartype all_of: list[~$(python-base-namespace).v2018_03_01.models.MultiMetricCriteria]
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "odata_type": {"key": "odata\\.type", "type": "str"},
        "all_of": {"key": "allOf", "type": "[MultiMetricCriteria]"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        all_of: Optional[List["_models.MultiMetricCriteria"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword all_of: the list of multiple metric criteria for this 'all of' operation.
        :paramtype all_of: list[~$(python-base-namespace).v2018_03_01.models.MultiMetricCriteria]
        """
        super().__init__(additional_properties=additional_properties, **kwargs)
        self.odata_type: str = "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria"
        self.all_of = all_of


class MetricAlertResource(Resource):  # pylint: disable=too-many-instance-attributes
    """The metric alert resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: the description of the metric alert that will be included in the alert
     email.
    :vartype description: str
    :ivar severity: Alert severity {0, 1, 2, 3, 4}. Required.
    :vartype severity: int
    :ivar enabled: the flag that indicates whether the metric alert is enabled. Required.
    :vartype enabled: bool
    :ivar scopes: the list of resource id's that this metric alert is scoped to. Required.
    :vartype scopes: list[str]
    :ivar evaluation_frequency: how often the metric alert is evaluated represented in ISO 8601
     duration format. Required.
    :vartype evaluation_frequency: ~datetime.timedelta
    :ivar window_size: the period of time (in ISO 8601 duration format) that is used to monitor
     alert activity based on the threshold. Required.
    :vartype window_size: ~datetime.timedelta
    :ivar target_resource_type: the resource type of the target resource(s) on which the alert is
     created/updated. Mandatory if the scope contains a subscription, resource group, or more than
     one resource.
    :vartype target_resource_type: str
    :ivar target_resource_region: the region of the target resource(s) on which the alert is
     created/updated. Mandatory if the scope contains a subscription, resource group, or more than
     one resource.
    :vartype target_resource_region: str
    :ivar criteria: defines the specific alert criteria information. Required.
    :vartype criteria: ~$(python-base-namespace).v2018_03_01.models.MetricAlertCriteria
    :ivar auto_mitigate: the flag that indicates whether the alert should be auto resolved or not.
     The default is true.
    :vartype auto_mitigate: bool
    :ivar actions: the array of actions that are performed when the alert rule becomes active, and
     when an alert condition is resolved.
    :vartype actions: list[~$(python-base-namespace).v2018_03_01.models.MetricAlertAction]
    :ivar last_updated_time: Last time the rule was updated in ISO8601 format.
    :vartype last_updated_time: ~datetime.datetime
    :ivar is_migrated: the value indicating whether this alert rule is migrated.
    :vartype is_migrated: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "severity": {"required": True},
        "enabled": {"required": True},
        "scopes": {"required": True},
        "evaluation_frequency": {"required": True},
        "window_size": {"required": True},
        "criteria": {"required": True},
        "last_updated_time": {"readonly": True},
        "is_migrated": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "severity": {"key": "properties.severity", "type": "int"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "scopes": {"key": "properties.scopes", "type": "[str]"},
        "evaluation_frequency": {"key": "properties.evaluationFrequency", "type": "duration"},
        "window_size": {"key": "properties.windowSize", "type": "duration"},
        "target_resource_type": {"key": "properties.targetResourceType", "type": "str"},
        "target_resource_region": {"key": "properties.targetResourceRegion", "type": "str"},
        "criteria": {"key": "properties.criteria", "type": "MetricAlertCriteria"},
        "auto_mitigate": {"key": "properties.autoMitigate", "type": "bool"},
        "actions": {"key": "properties.actions", "type": "[MetricAlertAction]"},
        "last_updated_time": {"key": "properties.lastUpdatedTime", "type": "iso-8601"},
        "is_migrated": {"key": "properties.isMigrated", "type": "bool"},
    }

    def __init__(
        self,
        *,
        location: str,
        severity: int,
        enabled: bool,
        scopes: List[str],
        evaluation_frequency: datetime.timedelta,
        window_size: datetime.timedelta,
        criteria: "_models.MetricAlertCriteria",
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        target_resource_type: Optional[str] = None,
        target_resource_region: Optional[str] = None,
        auto_mitigate: Optional[bool] = None,
        actions: Optional[List["_models.MetricAlertAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: the description of the metric alert that will be included in the alert
         email.
        :paramtype description: str
        :keyword severity: Alert severity {0, 1, 2, 3, 4}. Required.
        :paramtype severity: int
        :keyword enabled: the flag that indicates whether the metric alert is enabled. Required.
        :paramtype enabled: bool
        :keyword scopes: the list of resource id's that this metric alert is scoped to. Required.
        :paramtype scopes: list[str]
        :keyword evaluation_frequency: how often the metric alert is evaluated represented in ISO 8601
         duration format. Required.
        :paramtype evaluation_frequency: ~datetime.timedelta
        :keyword window_size: the period of time (in ISO 8601 duration format) that is used to monitor
         alert activity based on the threshold. Required.
        :paramtype window_size: ~datetime.timedelta
        :keyword target_resource_type: the resource type of the target resource(s) on which the alert
         is created/updated. Mandatory if the scope contains a subscription, resource group, or more
         than one resource.
        :paramtype target_resource_type: str
        :keyword target_resource_region: the region of the target resource(s) on which the alert is
         created/updated. Mandatory if the scope contains a subscription, resource group, or more than
         one resource.
        :paramtype target_resource_region: str
        :keyword criteria: defines the specific alert criteria information. Required.
        :paramtype criteria: ~$(python-base-namespace).v2018_03_01.models.MetricAlertCriteria
        :keyword auto_mitigate: the flag that indicates whether the alert should be auto resolved or
         not. The default is true.
        :paramtype auto_mitigate: bool
        :keyword actions: the array of actions that are performed when the alert rule becomes active,
         and when an alert condition is resolved.
        :paramtype actions: list[~$(python-base-namespace).v2018_03_01.models.MetricAlertAction]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.description = description
        self.severity = severity
        self.enabled = enabled
        self.scopes = scopes
        self.evaluation_frequency = evaluation_frequency
        self.window_size = window_size
        self.target_resource_type = target_resource_type
        self.target_resource_region = target_resource_region
        self.criteria = criteria
        self.auto_mitigate = auto_mitigate
        self.actions = actions
        self.last_updated_time = None
        self.is_migrated = None


class MetricAlertResourceCollection(_serialization.Model):
    """Represents a collection of alert rule resources.

    :ivar value: the values for the alert rule resources.
    :vartype value: list[~$(python-base-namespace).v2018_03_01.models.MetricAlertResource]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MetricAlertResource]"},
    }

    def __init__(self, *, value: Optional[List["_models.MetricAlertResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: the values for the alert rule resources.
        :paramtype value: list[~$(python-base-namespace).v2018_03_01.models.MetricAlertResource]
        """
        super().__init__(**kwargs)
        self.value = value


class MetricAlertResourcePatch(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The metric alert resource for patch operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar description: the description of the metric alert that will be included in the alert
     email.
    :vartype description: str
    :ivar severity: Alert severity {0, 1, 2, 3, 4}.
    :vartype severity: int
    :ivar enabled: the flag that indicates whether the metric alert is enabled.
    :vartype enabled: bool
    :ivar scopes: the list of resource id's that this metric alert is scoped to.
    :vartype scopes: list[str]
    :ivar evaluation_frequency: how often the metric alert is evaluated represented in ISO 8601
     duration format.
    :vartype evaluation_frequency: ~datetime.timedelta
    :ivar window_size: the period of time (in ISO 8601 duration format) that is used to monitor
     alert activity based on the threshold.
    :vartype window_size: ~datetime.timedelta
    :ivar target_resource_type: the resource type of the target resource(s) on which the alert is
     created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
    :vartype target_resource_type: str
    :ivar target_resource_region: the region of the target resource(s) on which the alert is
     created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
    :vartype target_resource_region: str
    :ivar criteria: defines the specific alert criteria information.
    :vartype criteria: ~$(python-base-namespace).v2018_03_01.models.MetricAlertCriteria
    :ivar auto_mitigate: the flag that indicates whether the alert should be auto resolved or not.
     The default is true.
    :vartype auto_mitigate: bool
    :ivar actions: the array of actions that are performed when the alert rule becomes active, and
     when an alert condition is resolved.
    :vartype actions: list[~$(python-base-namespace).v2018_03_01.models.MetricAlertAction]
    :ivar last_updated_time: Last time the rule was updated in ISO8601 format.
    :vartype last_updated_time: ~datetime.datetime
    :ivar is_migrated: the value indicating whether this alert rule is migrated.
    :vartype is_migrated: bool
    """

    _validation = {
        "last_updated_time": {"readonly": True},
        "is_migrated": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "description": {"key": "properties.description", "type": "str"},
        "severity": {"key": "properties.severity", "type": "int"},
        "enabled": {"key": "properties.enabled", "type": "bool"},
        "scopes": {"key": "properties.scopes", "type": "[str]"},
        "evaluation_frequency": {"key": "properties.evaluationFrequency", "type": "duration"},
        "window_size": {"key": "properties.windowSize", "type": "duration"},
        "target_resource_type": {"key": "properties.targetResourceType", "type": "str"},
        "target_resource_region": {"key": "properties.targetResourceRegion", "type": "str"},
        "criteria": {"key": "properties.criteria", "type": "MetricAlertCriteria"},
        "auto_mitigate": {"key": "properties.autoMitigate", "type": "bool"},
        "actions": {"key": "properties.actions", "type": "[MetricAlertAction]"},
        "last_updated_time": {"key": "properties.lastUpdatedTime", "type": "iso-8601"},
        "is_migrated": {"key": "properties.isMigrated", "type": "bool"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        severity: Optional[int] = None,
        enabled: Optional[bool] = None,
        scopes: Optional[List[str]] = None,
        evaluation_frequency: Optional[datetime.timedelta] = None,
        window_size: Optional[datetime.timedelta] = None,
        target_resource_type: Optional[str] = None,
        target_resource_region: Optional[str] = None,
        criteria: Optional["_models.MetricAlertCriteria"] = None,
        auto_mitigate: Optional[bool] = None,
        actions: Optional[List["_models.MetricAlertAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword description: the description of the metric alert that will be included in the alert
         email.
        :paramtype description: str
        :keyword severity: Alert severity {0, 1, 2, 3, 4}.
        :paramtype severity: int
        :keyword enabled: the flag that indicates whether the metric alert is enabled.
        :paramtype enabled: bool
        :keyword scopes: the list of resource id's that this metric alert is scoped to.
        :paramtype scopes: list[str]
        :keyword evaluation_frequency: how often the metric alert is evaluated represented in ISO 8601
         duration format.
        :paramtype evaluation_frequency: ~datetime.timedelta
        :keyword window_size: the period of time (in ISO 8601 duration format) that is used to monitor
         alert activity based on the threshold.
        :paramtype window_size: ~datetime.timedelta
        :keyword target_resource_type: the resource type of the target resource(s) on which the alert
         is created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
        :paramtype target_resource_type: str
        :keyword target_resource_region: the region of the target resource(s) on which the alert is
         created/updated. Mandatory for MultipleResourceMultipleMetricCriteria.
        :paramtype target_resource_region: str
        :keyword criteria: defines the specific alert criteria information.
        :paramtype criteria: ~$(python-base-namespace).v2018_03_01.models.MetricAlertCriteria
        :keyword auto_mitigate: the flag that indicates whether the alert should be auto resolved or
         not. The default is true.
        :paramtype auto_mitigate: bool
        :keyword actions: the array of actions that are performed when the alert rule becomes active,
         and when an alert condition is resolved.
        :paramtype actions: list[~$(python-base-namespace).v2018_03_01.models.MetricAlertAction]
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.description = description
        self.severity = severity
        self.enabled = enabled
        self.scopes = scopes
        self.evaluation_frequency = evaluation_frequency
        self.window_size = window_size
        self.target_resource_type = target_resource_type
        self.target_resource_region = target_resource_region
        self.criteria = criteria
        self.auto_mitigate = auto_mitigate
        self.actions = actions
        self.last_updated_time = None
        self.is_migrated = None


class MetricAlertSingleResourceMultipleMetricCriteria(MetricAlertCriteria):
    """Specifies the metric alert criteria for a single resource that has multiple metric criteria.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar odata_type: specifies the type of the alert criteria. Required. Known values are:
     "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria", and
     "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria".
    :vartype odata_type: str or ~$(python-base-namespace).v2018_03_01.models.Odatatype
    :ivar all_of: The list of metric criteria for this 'all of' operation.
    :vartype all_of: list[~$(python-base-namespace).v2018_03_01.models.MetricCriteria]
    """

    _validation = {
        "odata_type": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "odata_type": {"key": "odata\\.type", "type": "str"},
        "all_of": {"key": "allOf", "type": "[MetricCriteria]"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, JSON]] = None,
        all_of: Optional[List["_models.MetricCriteria"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword all_of: The list of metric criteria for this 'all of' operation.
        :paramtype all_of: list[~$(python-base-namespace).v2018_03_01.models.MetricCriteria]
        """
        super().__init__(additional_properties=additional_properties, **kwargs)
        self.odata_type: str = "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria"
        self.all_of = all_of


class MetricAlertStatus(_serialization.Model):
    """An alert status.

    :ivar name: The status name.
    :vartype name: str
    :ivar id: The alert rule arm id.
    :vartype id: str
    :ivar type: The extended resource type name.
    :vartype type: str
    :ivar properties: The alert status properties of the metric alert status.
    :vartype properties: ~$(python-base-namespace).v2018_03_01.models.MetricAlertStatusProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "MetricAlertStatusProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        type: Optional[str] = None,
        properties: Optional["_models.MetricAlertStatusProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The status name.
        :paramtype name: str
        :keyword id: The alert rule arm id.
        :paramtype id: str
        :keyword type: The extended resource type name.
        :paramtype type: str
        :keyword properties: The alert status properties of the metric alert status.
        :paramtype properties: ~$(python-base-namespace).v2018_03_01.models.MetricAlertStatusProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.id = id
        self.type = type
        self.properties = properties


class MetricAlertStatusCollection(_serialization.Model):
    """Represents a collection of alert rule resources.

    :ivar value: the values for the alert rule resources.
    :vartype value: list[~$(python-base-namespace).v2018_03_01.models.MetricAlertStatus]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[MetricAlertStatus]"},
    }

    def __init__(self, *, value: Optional[List["_models.MetricAlertStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: the values for the alert rule resources.
        :paramtype value: list[~$(python-base-namespace).v2018_03_01.models.MetricAlertStatus]
        """
        super().__init__(**kwargs)
        self.value = value


class MetricAlertStatusProperties(_serialization.Model):
    """An alert status properties.

    :ivar dimensions: An object describing the type of the dimensions.
    :vartype dimensions: dict[str, str]
    :ivar status: status value.
    :vartype status: str
    :ivar timestamp: UTC time when the status was checked.
    :vartype timestamp: ~datetime.datetime
    """

    _attribute_map = {
        "dimensions": {"key": "dimensions", "type": "{str}"},
        "status": {"key": "status", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        dimensions: Optional[Dict[str, str]] = None,
        status: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword dimensions: An object describing the type of the dimensions.
        :paramtype dimensions: dict[str, str]
        :keyword status: status value.
        :paramtype status: str
        :keyword timestamp: UTC time when the status was checked.
        :paramtype timestamp: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.dimensions = dimensions
        self.status = status
        self.timestamp = timestamp


class MetricCriteria(MultiMetricCriteria):
    """Criterion to filter metrics.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar criterion_type: Specifies the type of threshold criteria. Required. Known values are:
     "StaticThresholdCriterion" and "DynamicThresholdCriterion".
    :vartype criterion_type: str or ~$(python-base-namespace).v2018_03_01.models.CriterionType
    :ivar name: Name of the criteria. Required.
    :vartype name: str
    :ivar metric_name: Name of the metric. Required.
    :vartype metric_name: str
    :ivar metric_namespace: Namespace of the metric.
    :vartype metric_namespace: str
    :ivar time_aggregation: the criteria time aggregation types. Required. Known values are:
     "Average", "Count", "Minimum", "Maximum", and "Total".
    :vartype time_aggregation: str or
     ~$(python-base-namespace).v2018_03_01.models.AggregationTypeEnum
    :ivar dimensions: List of dimension conditions.
    :vartype dimensions: list[~$(python-base-namespace).v2018_03_01.models.MetricDimension]
    :ivar skip_metric_validation: Allows creating an alert rule on a custom metric that isn't yet
     emitted, by causing the metric validation to be skipped.
    :vartype skip_metric_validation: bool
    :ivar operator: the criteria operator. Required. Known values are: "Equals", "GreaterThan",
     "GreaterThanOrEqual", "LessThan", and "LessThanOrEqual".
    :vartype operator: str or ~$(python-base-namespace).v2018_03_01.models.Operator
    :ivar threshold: the criteria threshold value that activates the alert. Required.
    :vartype threshold: float
    """

    _validation = {
        "criterion_type": {"required": True},
        "name": {"required": True},
        "metric_name": {"required": True},
        "time_aggregation": {"required": True},
        "operator": {"required": True},
        "threshold": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "criterion_type": {"key": "criterionType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "metric_name": {"key": "metricName", "type": "str"},
        "metric_namespace": {"key": "metricNamespace", "type": "str"},
        "time_aggregation": {"key": "timeAggregation", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[MetricDimension]"},
        "skip_metric_validation": {"key": "skipMetricValidation", "type": "bool"},
        "operator": {"key": "operator", "type": "str"},
        "threshold": {"key": "threshold", "type": "float"},
    }

    def __init__(
        self,
        *,
        name: str,
        metric_name: str,
        time_aggregation: Union[str, "_models.AggregationTypeEnum"],
        operator: Union[str, "_models.Operator"],
        threshold: float,
        additional_properties: Optional[Dict[str, JSON]] = None,
        metric_namespace: Optional[str] = None,
        dimensions: Optional[List["_models.MetricDimension"]] = None,
        skip_metric_validation: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword name: Name of the criteria. Required.
        :paramtype name: str
        :keyword metric_name: Name of the metric. Required.
        :paramtype metric_name: str
        :keyword metric_namespace: Namespace of the metric.
        :paramtype metric_namespace: str
        :keyword time_aggregation: the criteria time aggregation types. Required. Known values are:
         "Average", "Count", "Minimum", "Maximum", and "Total".
        :paramtype time_aggregation: str or
         ~$(python-base-namespace).v2018_03_01.models.AggregationTypeEnum
        :keyword dimensions: List of dimension conditions.
        :paramtype dimensions: list[~$(python-base-namespace).v2018_03_01.models.MetricDimension]
        :keyword skip_metric_validation: Allows creating an alert rule on a custom metric that isn't
         yet emitted, by causing the metric validation to be skipped.
        :paramtype skip_metric_validation: bool
        :keyword operator: the criteria operator. Required. Known values are: "Equals", "GreaterThan",
         "GreaterThanOrEqual", "LessThan", and "LessThanOrEqual".
        :paramtype operator: str or ~$(python-base-namespace).v2018_03_01.models.Operator
        :keyword threshold: the criteria threshold value that activates the alert. Required.
        :paramtype threshold: float
        """
        super().__init__(
            additional_properties=additional_properties,
            name=name,
            metric_name=metric_name,
            metric_namespace=metric_namespace,
            time_aggregation=time_aggregation,
            dimensions=dimensions,
            skip_metric_validation=skip_metric_validation,
            **kwargs
        )
        self.criterion_type: str = "StaticThresholdCriterion"
        self.operator = operator
        self.threshold = threshold


class MetricDimension(_serialization.Model):
    """Specifies a metric dimension.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Name of the dimension. Required.
    :vartype name: str
    :ivar operator: the dimension operator. Only 'Include' and 'Exclude' are supported. Required.
    :vartype operator: str
    :ivar values: list of dimension values. Required.
    :vartype values: list[str]
    """

    _validation = {
        "name": {"required": True},
        "operator": {"required": True},
        "values": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "operator": {"key": "operator", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
    }

    def __init__(self, *, name: str, operator: str, values: List[str], **kwargs: Any) -> None:
        """
        :keyword name: Name of the dimension. Required.
        :paramtype name: str
        :keyword operator: the dimension operator. Only 'Include' and 'Exclude' are supported.
         Required.
        :paramtype operator: str
        :keyword values: list of dimension values. Required.
        :paramtype values: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.operator = operator
        self.values = values


class SmsReceiver(_serialization.Model):
    """An SMS receiver.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the SMS receiver. Names must be unique across all receivers within an
     action group. Required.
    :vartype name: str
    :ivar country_code: The country code of the SMS receiver. Required.
    :vartype country_code: str
    :ivar phone_number: The phone number of the SMS receiver. Required.
    :vartype phone_number: str
    :ivar status: The status of the receiver. Known values are: "NotSpecified", "Enabled", and
     "Disabled".
    :vartype status: str or ~$(python-base-namespace).v2018_03_01.models.ReceiverStatus
    """

    _validation = {
        "name": {"required": True},
        "country_code": {"required": True},
        "phone_number": {"required": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "country_code": {"key": "countryCode", "type": "str"},
        "phone_number": {"key": "phoneNumber", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, name: str, country_code: str, phone_number: str, **kwargs: Any) -> None:
        """
        :keyword name: The name of the SMS receiver. Names must be unique across all receivers within
         an action group. Required.
        :paramtype name: str
        :keyword country_code: The country code of the SMS receiver. Required.
        :paramtype country_code: str
        :keyword phone_number: The phone number of the SMS receiver. Required.
        :paramtype phone_number: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.country_code = country_code
        self.phone_number = phone_number
        self.status = None


class VoiceReceiver(_serialization.Model):
    """A voice receiver.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the voice receiver. Names must be unique across all receivers within an
     action group. Required.
    :vartype name: str
    :ivar country_code: The country code of the voice receiver. Required.
    :vartype country_code: str
    :ivar phone_number: The phone number of the voice receiver. Required.
    :vartype phone_number: str
    """

    _validation = {
        "name": {"required": True},
        "country_code": {"required": True},
        "phone_number": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "country_code": {"key": "countryCode", "type": "str"},
        "phone_number": {"key": "phoneNumber", "type": "str"},
    }

    def __init__(self, *, name: str, country_code: str, phone_number: str, **kwargs: Any) -> None:
        """
        :keyword name: The name of the voice receiver. Names must be unique across all receivers within
         an action group. Required.
        :paramtype name: str
        :keyword country_code: The country code of the voice receiver. Required.
        :paramtype country_code: str
        :keyword phone_number: The phone number of the voice receiver. Required.
        :paramtype phone_number: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.country_code = country_code
        self.phone_number = phone_number


class WebhookReceiver(_serialization.Model):
    """A webhook receiver.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the webhook receiver. Names must be unique across all receivers within
     an action group. Required.
    :vartype name: str
    :ivar service_uri: The URI where webhooks should be sent. Required.
    :vartype service_uri: str
    """

    _validation = {
        "name": {"required": True},
        "service_uri": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "service_uri": {"key": "serviceUri", "type": "str"},
    }

    def __init__(self, *, name: str, service_uri: str, **kwargs: Any) -> None:
        """
        :keyword name: The name of the webhook receiver. Names must be unique across all receivers
         within an action group. Required.
        :paramtype name: str
        :keyword service_uri: The URI where webhooks should be sent. Required.
        :paramtype service_uri: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.service_uri = service_uri


class WebtestLocationAvailabilityCriteria(MetricAlertCriteria):
    """Specifies the metric alert rule criteria for a web test resource.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, JSON]
    :ivar odata_type: specifies the type of the alert criteria. Required. Known values are:
     "Microsoft.Azure.Monitor.SingleResourceMultipleMetricCriteria",
     "Microsoft.Azure.Monitor.MultipleResourceMultipleMetricCriteria", and
     "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria".
    :vartype odata_type: str or ~$(python-base-namespace).v2018_03_01.models.Odatatype
    :ivar web_test_id: The Application Insights web test Id. Required.
    :vartype web_test_id: str
    :ivar component_id: The Application Insights resource Id. Required.
    :vartype component_id: str
    :ivar failed_location_count: The number of failed locations. Required.
    :vartype failed_location_count: float
    """

    _validation = {
        "odata_type": {"required": True},
        "web_test_id": {"required": True},
        "component_id": {"required": True},
        "failed_location_count": {"required": True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "odata_type": {"key": "odata\\.type", "type": "str"},
        "web_test_id": {"key": "webTestId", "type": "str"},
        "component_id": {"key": "componentId", "type": "str"},
        "failed_location_count": {"key": "failedLocationCount", "type": "float"},
    }

    def __init__(
        self,
        *,
        web_test_id: str,
        component_id: str,
        failed_location_count: float,
        additional_properties: Optional[Dict[str, JSON]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, JSON]
        :keyword web_test_id: The Application Insights web test Id. Required.
        :paramtype web_test_id: str
        :keyword component_id: The Application Insights resource Id. Required.
        :paramtype component_id: str
        :keyword failed_location_count: The number of failed locations. Required.
        :paramtype failed_location_count: float
        """
        super().__init__(additional_properties=additional_properties, **kwargs)
        self.odata_type: str = "Microsoft.Azure.Monitor.WebtestLocationAvailabilityCriteria"
        self.web_test_id = web_test_id
        self.component_id = component_id
        self.failed_location_count = failed_location_count
