/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.util;

import java.text.DecimalFormat;

public class NumberFormat {
    public static final double INV_LOG10 = 1.0 / Math.log(10.0);
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat();
    public static final DecimalFormat EXPONENTIAL_FORMAT = new DecimalFormat("0.E0");
    public static final char DECIMAL_SEPARATOR = DECIMAL_FORMAT.getDecimalFormatSymbols().getDecimalSeparator();
    private static final int MAXIMUM_EXPONENT = 8;

    public static final String decimalString(double d, int n) {
        return NumberFormat.decimalString(d, -1, n, false);
    }

    public static final String decimalString(double d, int n, int n2, boolean bl) {
        return NumberFormat.decimalString(d, n, n2, n2, bl);
    }

    public static final String decimalString(double d, int n, int n2, int n3, boolean bl) {
        double d2 = Math.abs(d);
        if (d2 > 1.0E7 || d2 < 1.0E-7 && d2 > Double.MIN_VALUE) {
            return NumberFormat.exponentialString(d, n2, n3);
        }
        DECIMAL_FORMAT.setMinimumFractionDigits(n2);
        DECIMAL_FORMAT.setMaximumFractionDigits(n3);
        DECIMAL_FORMAT.setGroupingUsed(false);
        String string = DECIMAL_FORMAT.format(d);
        if (bl) {
            string = NumberFormat.zeroPadString(string, n, n3);
        }
        return string;
    }

    public static final String exponentialString(double d, int n, int n2) {
        EXPONENTIAL_FORMAT.setMinimumFractionDigits(n);
        EXPONENTIAL_FORMAT.setMaximumFractionDigits(n2);
        String string = EXPONENTIAL_FORMAT.format(d);
        return string;
    }

    public static final String intString(int n, int n2) {
        String string = String.valueOf(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    public static final String prependBlanks(String string, int n) {
        while (string.length() < n) {
            string = " " + string;
        }
        return string;
    }

    public static final String zeroPadString(String string, int n, int n2) {
        int n3;
        for (n3 = 0; n3 < 1000 && string.length() < n; ++n3) {
            if (string.indexOf(DECIMAL_SEPARATOR) >= 0) continue;
            string = string + ".";
        }
        for (n3 = 0; n3 < 1000 && (n <= 0 || string.length() < n) && string.length() - string.indexOf(DECIMAL_SEPARATOR) - 1 < n2; ++n3) {
            string = string + "0";
        }
        for (n3 = 0; n3 < 1000 && string.length() < n; ++n3) {
            string = "0" + string;
        }
        return string;
    }

    public static final String removeTrailingZeros(String string) {
        if (string.indexOf(DECIMAL_SEPARATOR) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        int n2 = stringBuffer.indexOf("E");
        if (n2 < 0) {
            n2 = stringBuffer.indexOf("e");
        }
        if (n2 >= 0) {
            n = n2;
        }
        for (int i = n - 1; i >= 0; --i) {
            char c = stringBuffer.charAt(i);
            if (c != '0') {
                if (c != DECIMAL_SEPARATOR) break;
                stringBuffer.delete(i, i + 1);
                break;
            }
            stringBuffer.delete(i, i + 1);
        }
        return stringBuffer.toString();
    }

    public static final String doubleString(double d) {
        return NumberFormat.doubleString(d, -1, -1, false);
    }

    public static final String doubleString(double d, int n, int n2) {
        return NumberFormat.doubleString(d, n, n2, false);
    }

    public static final String doubleString(double d, int n, int n2, boolean bl) {
        int n3 = 0;
        double d2 = Math.abs(d);
        if (d2 > Double.MIN_VALUE) {
            n3 = (int)(Math.log(d2) * INV_LOG10);
        }
        boolean bl2 = false;
        String string = null;
        if (n3 < -3 || n3 > 4) {
            if (n2 < 0) {
                bl2 = true;
                n2 = 4;
            }
            string = NumberFormat.exponentialString(d, n2, n2);
        } else {
            if (n2 < 0) {
                bl2 = true;
                n2 = n3 <= 0 ? Math.abs(n3) + 5 : 4;
            }
            string = NumberFormat.decimalString(d, n, n2, n2, bl);
        }
        if (bl2) {
            string = NumberFormat.removeTrailingZeros(string);
        }
        return string;
    }

    public static final String floatString(float f, int n, int n2) {
        return NumberFormat.floatString(f, n, n2, true);
    }

    public static final String floatString(float f, int n, int n2, boolean bl) {
        return NumberFormat.doubleString(f, n, n2, bl);
    }

    public static final String StringValueOf(double d, int n) {
        return String.valueOf(d);
    }

    public static final String StringValueOf(float f, int n) {
        return String.valueOf(f);
    }

    public static float nearestPower10(double d) {
        double d2 = Math.pow(10.0, (int)(0.5 + Math.log(d) * INV_LOG10));
        return (float)d2;
    }

    public static double niceValue(double d) {
        double d2 = Math.pow(10.0, 1 + (int)(Math.log(d) * INV_LOG10));
        int n = 0;
        do {
            if (d2 > d) {
                d2 /= 2.0;
            }
            if (d2 > d) {
                d2 /= 2.5;
            }
            if (!(d2 > d)) continue;
            d2 /= 2.0;
        } while (d2 > d && n++ < 1000);
        return d2;
    }

    public static void main(String[] stringArray) {
        double d = 1.0E-8;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1.0E-7;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1.0E-6;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1.0E-5;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1.0E-4;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 0.001;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 0.01;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 0.1;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1.0;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 10.0;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 100.0;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1000.0;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 10000.0;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 100000.0;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1000000.0;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1.0E7;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1.2345E-8;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1.2345E-7;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1.2345E-6;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1.2345E-5;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1.2345E-4;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 0.0012345;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 0.012345;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 0.12345;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1.2345;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 12.345;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 123.45;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1234.5;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 12345.0;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 123450.0;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1234500.0;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1.2345E7;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1.2345E8;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = -1.2345E8;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1.2345E56;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = -1.2345E56;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = 1.2345E-65;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
        d = -1.2345E-65;
        System.out.println("" + d + "\t\t" + NumberFormat.doubleString(d) + "\t\t" + (d - Double.parseDouble(NumberFormat.doubleString(d))) / d);
    }
}

