/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.timedom;

import net.alomax.math.TimeSeries;
import net.alomax.timedom.BasicPicker;
import net.alomax.timedom.PickData;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainText;

public class TestPicker2
extends BasicPicker {
    private static final double WINDOW_MIN = Double.MIN_VALUE;
    private static final double WINDOW_MAX = Double.MAX_VALUE;
    public double longTermWindow = 10.0;
    public double threshold1 = 10.0;
    public double threshold2 = 10.0;
    public double tUpEvent = 1.0;
    public double recursionWindow = 2.0;
    public String errorMessage;
    private static final double THRESHOLD_MIN = Double.MIN_VALUE;
    private static final double THRESHOLD_MAX = Double.MAX_VALUE;
    private static final double TIME_MIN = -1.7976931348623157E308;
    private static final double TIME_MAX = Double.MAX_VALUE;

    public TestPicker2(String string, double d, double d2, double d3, double d4, double d5, int n) {
        super(string, n);
        this.longTermWindow = d;
        this.threshold1 = d2;
        this.threshold2 = d3;
        this.tUpEvent = d4;
        this.recursionWindow = d5;
    }

    public void setLongTermWindow(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_long_term_window_value + ": " + d);
        }
        this.longTermWindow = d;
    }

    public void setLongTermWindow(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_long_term_window_value + ": " + string);
        }
        this.setLongTermWindow(d);
    }

    public void setThreshold1(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold1_value + ": " + d);
        }
        this.threshold1 = d;
    }

    public void setThreshold1(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold1_value + ": " + string);
        }
        this.setThreshold1(d);
    }

    public void setThreshold2(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold2_value + ": " + d);
        }
        this.threshold2 = d;
    }

    public void setThreshold2(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_threshold2_value + ": " + string);
        }
        this.setThreshold2(d);
    }

    public void setTUpEvent(double d) throws TimeDomainException {
        if (d < -1.7976931348623157E308 || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_tUpEvent_value + ": " + d);
        }
        this.tUpEvent = d;
    }

    public void setTUpEvent(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_tUpEvent_value + ": " + string);
        }
        this.setTUpEvent(d);
    }

    public void setMeanWindow(double d) throws TimeDomainException {
        if (d < Double.MIN_VALUE || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_meanWindow_value + ": " + d);
        }
        this.recursionWindow = d;
    }

    public void setMeanWindow(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_meanWindow_value + ": " + string);
        }
        this.setMeanWindow(d);
    }

    public void checkSettings() throws TimeDomainException {
        super.checkSettings();
        String string = "";
        int n = 0;
        if (this.longTermWindow < Double.MIN_VALUE || this.longTermWindow > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_long_term_window_value;
            ++n;
        }
        if (this.threshold1 < Double.MIN_VALUE || this.threshold1 > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_threshold1_value;
            ++n;
        }
        if (this.threshold2 < Double.MIN_VALUE || this.threshold2 > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_threshold2_value;
            ++n;
        }
        if (this.tUpEvent < -1.7976931348623157E308 || this.tUpEvent > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_tUpEvent_value;
            ++n;
        }
        if (this.recursionWindow < -1.7976931348623157E308 || this.recursionWindow > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_meanWindow_value;
            ++n;
        }
        if (n > 0) {
            throw new TimeDomainException(string + ".");
        }
    }

    public void updateFields(TimeSeries timeSeries) {
        super.updateFields(timeSeries);
    }

    public final float[] apply(double d, float[] fArray) {
        int n;
        int n2;
        int n3;
        double d2 = 2.0;
        int n4 = -1;
        double d3 = 0.0;
        double d4 = 0.0;
        int n5 = 0;
        double d5 = d / this.longTermWindow;
        double d6 = 1.0 - d5;
        int n6 = n3 = 1 + (int)(this.longTermWindow / d);
        int n7 = (int)(this.recursionWindow / d);
        int n8 = 1;
        for (n2 = 1; n2 < n7; n2 *= 2) {
            ++n8;
        }
        n7 = n2;
        System.out.println("numRecursive, numPrevious " + n8 + " " + n7);
        double[] dArray = new double[n8];
        double[] dArray2 = new double[n7];
        double[] dArray3 = new double[n8];
        double[] dArray4 = new double[n8];
        double[] dArray5 = new double[n8];
        double[] dArray6 = new double[n8];
        double[] dArray7 = new double[n8];
        for (int i = 0; i < n8; ++i) {
            dArray3[i] = 0.0;
            dArray5[i] = 0.0;
        }
        double d7 = 0.0;
        double d8 = 0.0;
        boolean bl = false;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        boolean bl2 = false;
        double d14 = 0.0;
        boolean bl3 = this.direction == -1;
        int n9 = -1;
        int n10 = -2147483647;
        int n11 = (int)(0.5 + this.tUpEvent / d) - 1;
        if (n11 < 1) {
            n11 = 1;
        }
        double d15 = (double)n11 * this.threshold2;
        double d16 = 0.0;
        double[] dArray8 = new double[n11];
        int n12 = -1;
        boolean bl4 = false;
        boolean bl5 = false;
        int n13 = 0;
        boolean bl6 = false;
        if (bl3) {
            for (n = 0; n < n7; ++n) {
                dArray2[n] = fArray[fArray.length - 1];
            }
        } else {
            for (n = 0; n < n7; ++n) {
                dArray2[n] = fArray[0];
            }
        }
        if (this.resultType == 2 || this.resultType == 1) {
            fArray[fArray.length - 1] = 0.0f;
            fArray[0] = 0.0f;
        }
        for (int i = 1; i < fArray.length - 1; ++i) {
            int n14;
            n = bl3 ? fArray.length - i - 1 : i;
            if (!bl2) {
                for (int j = 0; j < n8; ++j) {
                    dArray4[j] = dArray3[j];
                    dArray6[j] = dArray5[j];
                }
            }
            d9 = 0.0;
            float f = fArray[n];
            int n15 = n % n7;
            int n16 = 1;
            for (n14 = 0; n14 < n8; ++n14) {
                dArray[n14] = (double)f - dArray2[n15];
                int n17 = n14;
                dArray[n17] = dArray[n17] * dArray[n14];
                if ((bl2 || i > n10 + n16) && dArray6[n14] > (double)1.4E-45f) {
                    d9 = Math.max(d9, (dArray[n14] - dArray4[n14]) / dArray6[n14]);
                }
                n15 = (n7 + n15 - n16) % n7;
                n16 *= 2;
            }
            dArray2[(n + 1) % n7] = f;
            d11 = (d9 + d12 + d13) / 3.0;
            d13 = d12;
            d12 = d9;
            if (d11 > d2) {
                if (n4 < 0) {
                    n4 = bl3 ? n + 1 : n - 1;
                    d4 = d3 = (double)fArray[n4];
                    n5 = 0;
                }
            } else if (!bl2) {
                n4 = -1;
            }
            if (n4 >= 0 && !bl2) {
                d4 = Math.abs((double)f - d3) > Math.abs(d4) ? (double)f - d3 : d4;
                n5 += (double)f - d7 > 0.0 ? 1 : -1;
            }
            if (i > n6) {
                n12 = (n12 + 1) % n11;
                d16 -= dArray8[n12];
                dArray8[n12] = d9;
                if (bl2) {
                    if (n > n9 + 1) {
                        d16 += d9;
                    } else {
                        double d17 = d9 < this.threshold1 ? d9 : this.threshold1;
                        d16 += d17;
                        dArray8[n12] = d17;
                    }
                    d14 += d9;
                    if (i <= n10) {
                        if (!bl5 && d16 >= d15) {
                            bl5 = true;
                        }
                    } else {
                        if (bl5) {
                            bl4 = true;
                            n6 = i + n7;
                        } else {
                            n10 = -2147483647;
                        }
                        bl5 = false;
                        bl2 = false;
                    }
                } else if (d9 >= this.threshold1) {
                    bl2 = true;
                    d14 = d9;
                    n9 = n;
                    n10 = i + n11;
                    d16 += this.threshold1;
                    dArray8[n12] = this.threshold1;
                    n13 = n5 > 1 ? 1 : (n5 < -1 ? -1 : 0);
                } else {
                    d16 += d9;
                }
            }
            for (n14 = 0; n14 < n8; ++n14) {
                dArray3[n14] = dArray3[n14] * d6 + dArray[n14] * d5;
                double d18 = dArray[n14] - dArray3[n14];
                dArray7[n14] = dArray7[n14] * d6 + d18 * d18 * d5;
                dArray5[n14] = Math.sqrt(dArray7[n14]);
            }
            if (this.resultType == 2) {
                fArray[n] = bl4 ? 1.0f : 0.0f;
            } else if (this.resultType == 1) {
                fArray[n] = (float)d9;
            } else if (bl4) {
                PickData pickData = new PickData(n4, n9, n13, Math.log(d14 / d15), "_CF");
                this.triggerPickData.add(pickData);
                n4 = -1;
            }
            bl4 = false;
            d7 = f;
        }
        return fArray;
    }
}

