/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.timedom;

import net.alomax.freq.PoleZeroResponse;
import net.alomax.math.Cmplx;
import net.alomax.math.TimeSeries;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainMemory;
import net.alomax.timedom.TimeDomainProcess;
import net.alomax.timedom.TimeDomainText;

public class RecursionFilter
extends TimeDomainProcess {
    public static final boolean VERBOSE = true;
    public static final int TYPE_DEFAULT = 0;
    public int type = 0;
    private static final int NUM_TYPES = 1;
    public static final String NAME_DEFAULT = "DEAFULT";
    public String errorMessage;
    protected double[] inputCoeffs = null;
    protected double[] outputCoeffs = null;
    protected double gain = 0.0;
    protected double TOLERANCE = 1.0E-40;

    public RecursionFilter(String string, int n) {
        this.type = n;
        this.errorMessage = " ";
        TimeDomainText.setLocale(string);
    }

    public RecursionFilter(RecursionFilter recursionFilter) {
        this.useMemory = recursionFilter.useMemory;
        if (recursionFilter.memory != null) {
            this.memory = new TimeDomainMemory(recursionFilter.memory);
        }
        this.type = recursionFilter.type;
        this.errorMessage = recursionFilter.errorMessage;
        if (recursionFilter.inputCoeffs != null) {
            this.inputCoeffs = new double[recursionFilter.inputCoeffs.length];
            System.arraycopy(recursionFilter.inputCoeffs, 0, this.inputCoeffs, 0, recursionFilter.inputCoeffs.length);
        }
        if (recursionFilter.outputCoeffs != null) {
            this.outputCoeffs = new double[recursionFilter.outputCoeffs.length];
            System.arraycopy(recursionFilter.outputCoeffs, 0, this.outputCoeffs, 0, recursionFilter.outputCoeffs.length);
        }
        this.gain = recursionFilter.gain;
    }

    public void setType(String string) throws TimeDomainException {
        if (!NAME_DEFAULT.startsWith(string.toUpperCase())) {
            throw new TimeDomainException(TimeDomainText.invalid_recursion_filter_type + ": " + string);
        }
        this.type = 0;
    }

    public void setType(int n) throws TimeDomainException {
        if (n < 0 || n >= 1) {
            throw new TimeDomainException(TimeDomainText.invalid_recursion_filter_type + ": " + n);
        }
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void checkSettings() throws TimeDomainException {
        String string = "RecursionFilter";
        int n = 0;
        try {
            this.setType(this.type);
        }
        catch (Exception exception) {
            string = string + ": " + exception.getMessage();
        }
        if (n > 0) {
            throw new TimeDomainException(string + ".");
        }
    }

    public final float[] apply(double d, float[] fArray) throws TimeDomainException {
        if (this.type == 0) {
            return this.applyDefault(d, fArray);
        }
        return fArray;
    }

    public final float[] applyDefault(double d, float[] fArray) throws TimeDomainException {
        int n;
        float f;
        int n2;
        if (fArray.length < this.inputCoeffs.length || fArray.length < this.outputCoeffs.length) {
            throw new TimeDomainException("RecursionFilter: " + TimeDomainText.recursion_filter_number_coefficients);
        }
        float f2 = (float)(1.0 / this.gain);
        TimeDomainMemory timeDomainMemory = null;
        if (this.useMemory) {
            if (this.memory == null) {
                this.memory = new TimeDomainMemory(this.inputCoeffs.length, fArray[0], this.outputCoeffs.length, fArray[0] * f2);
            }
            timeDomainMemory = this.memory;
        } else {
            timeDomainMemory = new TimeDomainMemory(this.inputCoeffs.length, fArray[0], this.outputCoeffs.length, fArray[0] * f2);
        }
        float[] fArray2 = new float[fArray.length];
        int n3 = Math.max(this.inputCoeffs.length, this.outputCoeffs.length);
        for (n2 = 0; n2 < n3 && n2 < fArray.length; ++n2) {
            int n4;
            f = 0.0f;
            for (n = 0; n < this.inputCoeffs.length; ++n) {
                n4 = n2 - n;
                f = n4 >= 0 ? (float)((double)f + this.inputCoeffs[n] * (double)fArray[n4] * (double)f2) : (float)((double)f + this.inputCoeffs[n] * (double)timeDomainMemory.input[this.inputCoeffs.length + n4] * (double)f2);
            }
            for (n = 1; n < this.outputCoeffs.length; ++n) {
                n4 = n2 - n;
                f = n4 >= 0 ? (float)((double)f + this.outputCoeffs[n] * (double)fArray2[n4]) : (float)((double)f + this.outputCoeffs[n] * (double)timeDomainMemory.output[this.outputCoeffs.length + n4]);
            }
            fArray2[n2] = f;
        }
        for (n2 = n3; n2 < fArray.length; ++n2) {
            f = 0.0f;
            for (n = 0; n < this.inputCoeffs.length; ++n) {
                f = (float)((double)f + this.inputCoeffs[n] * (double)fArray[n2 - n] * (double)f2);
            }
            for (n = 1; n < this.outputCoeffs.length; ++n) {
                f = (float)((double)f + this.outputCoeffs[n] * (double)fArray2[n2 - n]);
            }
            fArray2[n2] = f;
        }
        if (this.useMemory) {
            System.arraycopy(fArray, fArray.length - this.memory.input.length, this.memory.input, 0, this.memory.input.length);
            System.arraycopy(fArray2, fArray2.length - this.memory.output.length, this.memory.output, 0, this.memory.output.length);
        }
        return fArray2;
    }

    public void updateFields(TimeSeries timeSeries) {
    }

    public boolean amplititudeModified() {
        return true;
    }

    public boolean supportsMemory() {
        return true;
    }

    public void setPoleZeroResponse(PoleZeroResponse poleZeroResponse) {
        int n;
        int n2;
        System.out.println(poleZeroResponse.toString());
        PoleZeroResponse poleZeroResponse2 = null;
        if (poleZeroResponse.getTransformType() != PoleZeroResponse.Z) {
            try {
                poleZeroResponse2 = poleZeroResponse.convertToZ();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            poleZeroResponse2 = poleZeroResponse;
        }
        System.out.println(poleZeroResponse2.toString());
        Cmplx[] cmplxArray = this.expand(poleZeroResponse2.zeros);
        Cmplx[] cmplxArray2 = this.expand(poleZeroResponse2.poles);
        System.out.println("Numerator Coefficients:");
        for (n2 = cmplxArray.length - 1; n2 >= 0; --n2) {
            System.out.println("z^" + n2 + " " + cmplxArray[n2]);
        }
        System.out.println("Denominator Coefficients:");
        for (n2 = cmplxArray2.length - 1; n2 >= 0; --n2) {
            System.out.println("z^" + n2 + " " + cmplxArray2[n2]);
        }
        double d = cmplxArray2[cmplxArray2.length - 1].r;
        double[] dArray = new double[poleZeroResponse2.zeros.length + 1];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[dArray.length - i - 1] = cmplxArray[i].r / d;
        }
        double[] dArray2 = new double[poleZeroResponse2.poles.length + 1];
        for (n = 0; n < dArray2.length; ++n) {
            dArray2[dArray2.length - n - 1] = -cmplxArray2[n].r / d;
        }
        this.inputCoeffs = dArray;
        this.outputCoeffs = dArray2;
        this.gain = poleZeroResponse2.gain;
        System.out.println("Input or Feed-Forward (Numerator) Coefficients :");
        for (n = this.inputCoeffs.length - 1; n >= 0; --n) {
            System.out.println("x[n-" + n + "] " + this.inputCoeffs[n]);
        }
        System.out.println("Output or Feedback (Denominator) Coefficients :");
        for (n = this.outputCoeffs.length - 1; n >= 0; --n) {
            System.out.println("y[n-" + n + "] " + this.outputCoeffs[n]);
        }
        System.out.println("Gain: " + this.gain);
    }

    protected Cmplx[] expand(Cmplx[] cmplxArray) {
        int n;
        Cmplx[] cmplxArray2 = new Cmplx[cmplxArray.length + 1];
        cmplxArray2[0] = new Cmplx(1.0, 0.0);
        for (n = 1; n < cmplxArray2.length; ++n) {
            cmplxArray2[n] = new Cmplx(0.0, 0.0);
        }
        for (n = 0; n < cmplxArray.length; ++n) {
            cmplxArray2 = this.multin(cmplxArray[n], cmplxArray2);
        }
        for (n = 0; n < cmplxArray.length + 1; ++n) {
            if (Math.abs(cmplxArray2[n].i) > this.TOLERANCE) {
                System.out.println("ERROR: RecursionFilter.expand(): coeff of z^" + n + " (imag = " + Math.abs(cmplxArray2[n].i) + ") is not real; poles/zeros are not Cmplx conjugates");
            }
            cmplxArray2[n].i = 0.0;
        }
        return cmplxArray2;
    }

    protected Cmplx[] multin(Cmplx cmplx, Cmplx[] cmplxArray) {
        Cmplx cmplx2 = cmplx.mul(-1.0);
        for (int i = cmplxArray.length - 1; i >= 1; --i) {
            cmplxArray[i].mul(cmplx2).add(cmplxArray[i - 1]);
        }
        cmplxArray[0].mul(cmplx2);
        return cmplxArray;
    }

    public static void main(String[] stringArray) {
        try {
            PoleZeroResponse poleZeroResponse = new PoleZeroResponse(null, stringArray[0], null, null, null);
            System.out.println(poleZeroResponse);
            RecursionFilter recursionFilter = new RecursionFilter(null, 0);
            recursionFilter.setPoleZeroResponse(poleZeroResponse);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }
}

