/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.timedom;

import net.alomax.math.TimeSeries;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainProcess;
import net.alomax.timedom.TimeDomainText;

public class FunctionGenerator
extends TimeDomainProcess {
    public static final int TYPE_IMPULSE = 0;
    public static final int TYPE_SINE = 1;
    private static final int NUM_TYPES = 1;
    public int type = 0;
    public static final String NAME_IMPULSE = "Impulse";
    public static final String NAME_SINE = "Sine";
    public double[] params = null;
    public String errorMessage;
    public static final double TWO_PI = Math.PI * 2;
    public static final double RPD = Math.PI / 180;
    public static final double DEG2RAD = Math.PI / 180;
    public static final double RAD2DEG = 57.29577951308232;

    public FunctionGenerator(String string) {
        this.errorMessage = " ";
        TimeDomainText.setLocale(string);
    }

    public FunctionGenerator(String string, int n, double[] dArray) {
        this.type = n;
        this.params = dArray;
        this.errorMessage = " ";
        TimeDomainText.setLocale(string);
    }

    public void setType(String string) throws TimeDomainException {
        if (NAME_IMPULSE.toUpperCase().startsWith(string.toUpperCase())) {
            this.type = 0;
        } else if (NAME_SINE.toUpperCase().startsWith(string.toUpperCase())) {
            this.type = 1;
        } else {
            throw new TimeDomainException(TimeDomainText.invalid_function_generator_type + ": " + string);
        }
    }

    public void setType(int n) throws TimeDomainException {
        if (n < 0 || n >= 1) {
            throw new TimeDomainException(TimeDomainText.invalid_smoothing_type + ": " + n);
        }
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void setParams(double[] dArray) {
        this.params = dArray;
    }

    public void checkSettings() throws TimeDomainException {
        String string = "";
        int n = 0;
        this.setType(this.type);
        if (n > 0) {
            throw new TimeDomainException(string + ".");
        }
    }

    public final float[] apply(double d, float[] fArray) {
        if (this.type == 0) {
            return this.generateImpulse(d, fArray);
        }
        if (this.type == 1) {
            return this.generateSine(d, fArray);
        }
        return fArray;
    }

    public final float[] generateImpulse(double d, float[] fArray) {
        int n;
        int n2 = (int)Math.round(this.params[0]);
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= fArray.length) {
            n2 = fArray.length - 1;
        }
        for (n = 0; n < n2; ++n) {
            fArray[n] = 0.0f;
        }
        fArray[n2] = (float)(1.0 / d);
        for (n = n2 + 1; n < fArray.length; ++n) {
            fArray[n] = 0.0f;
        }
        return fArray;
    }

    public final float[] generateSine(double d, float[] fArray) {
        double d2 = this.params[0] * (Math.PI * 2);
        double d3 = this.params[1] * (Math.PI / 180);
        double d4 = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = (float)Math.sin(d2 * d4 + d3);
            d4 += d;
        }
        return fArray;
    }

    public void updateFields(TimeSeries timeSeries) {
    }

    public boolean amplititudeModified() {
        return true;
    }
}

