/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.timedom;

import java.util.Vector;
import net.alomax.math.TimeSeries;
import net.alomax.timedom.PickData;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainProcess;
import net.alomax.timedom.TimeDomainText;

public class CumulativeDuration
extends TimeDomainProcess {
    public double thresholdLevel = 0.5;
    public double cutoffLevel = 0.1;
    public double durationFraction = -1.0;
    public double durationMin = 0.0;
    public String errorMessage;
    protected Vector cumDurPicks = new Vector();
    private static final double THRESHOLD_MIN = 0.0;
    private static final double THRESHOLD_MAX = 1.0;
    private static final double CUTOFF_MIN = 0.0;
    private static final double CUTOFF_MAX = 1.0;
    private static final double DURATION_FRACTION_MIN = -1.1;
    private static final double DURATION_FRACTION_MAX = Double.MAX_VALUE;
    private static final double DURATION_MIN_MIN = 0.0;
    private static final double DURATION_MIN_MAX = Double.MAX_VALUE;

    public CumulativeDuration(String string, double d, double d2, double d3, double d4) {
        this.thresholdLevel = d;
        this.cutoffLevel = d2;
        this.durationFraction = d3;
        this.durationMin = d4;
        this.errorMessage = " ";
        TimeDomainText.setLocale(string);
    }

    public void setThresholdLevel(double d) throws TimeDomainException {
        if (d < 0.0 || d > 1.0) {
            throw new TimeDomainException(TimeDomainText.invalid_cumdur_threshold_value + ": " + d);
        }
        this.thresholdLevel = d;
    }

    public void setThresholdLevel(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_cumdur_threshold_value + ": " + string);
        }
        this.setThresholdLevel(d);
    }

    public void setCutoffLevel(double d) throws TimeDomainException {
        if (d < 0.0 || d > 1.0) {
            throw new TimeDomainException(TimeDomainText.invalid_cumdur_cutoff_value + ": " + d);
        }
        this.cutoffLevel = d;
    }

    public void setCutoffLevel(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_cumdur_cutoff_value + ": " + string);
        }
        this.setCutoffLevel(d);
    }

    public void setDurationFraction(double d) throws TimeDomainException {
        if (d < -1.1 || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_cumdur_duration_fraction_value + ": " + d);
        }
        this.durationFraction = d;
    }

    public void setDurationFraction(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_cumdur_duration_fraction_value + ": " + string);
        }
        this.setDurationFraction(d);
    }

    public void setDurationMin(double d) throws TimeDomainException {
        if (d < 0.0 || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_cumdur_duration_min_value + ": " + d);
        }
        this.durationMin = d;
    }

    public void setDurationMin(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_cumdur_duration_min_value + ": " + string);
        }
        this.setDurationMin(d);
    }

    public Vector getPickData() {
        return this.cumDurPicks;
    }

    public void checkSettings() throws TimeDomainException {
        String string = "";
        int n = 0;
        if (this.thresholdLevel < 0.0 || this.thresholdLevel > 1.0) {
            string = string + ": " + TimeDomainText.invalid_cumdur_threshold_value;
            ++n;
        }
        if (this.cutoffLevel < 0.0 || this.cutoffLevel > 1.0) {
            string = string + ": " + TimeDomainText.invalid_cumdur_cutoff_value;
            ++n;
        }
        if (this.durationFraction < -1.1 || this.durationFraction > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_cumdur_duration_fraction_value;
            ++n;
        }
        if (this.durationMin < 0.0 || this.durationMin > Double.MAX_VALUE) {
            string = string + ": " + TimeDomainText.invalid_cumdur_duration_min_value;
            ++n;
        }
        if (n > 0) {
            throw new TimeDomainException(string + ".");
        }
    }

    public final float[] apply(double d, float[] fArray) {
        if (this.durationFraction <= 0.0) {
            return this.applyImpl(d, fArray);
        }
        return this.applyImpl(d, fArray, this.durationFraction, this.cutoffLevel);
    }

    public final float[] applyImpl(double d, float[] fArray) {
        float f = -3.4028235E38f;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            float f2 = fArray[i];
            if (!(f2 > f)) continue;
            f = f2;
            n = i;
        }
        float f3 = (float)this.thresholdLevel * f;
        double d2 = 0.0;
        double[] dArray = new double[2];
        for (int i = 0; i < fArray.length; ++i) {
            float f4 = fArray[i];
            if (i > n && !(f4 > f3)) continue;
            d2 += d;
            dArray[0] = i;
            dArray[1] = i;
        }
        PickData pickData = new PickData(dArray[0], dArray[1], 0, d2, "_INDEP_VAR");
        this.cumDurPicks = new Vector();
        this.cumDurPicks.add(pickData);
        return fArray;
    }

    public final float[] applyImpl(double d, float[] fArray, double d2, double d3) {
        float f;
        float f2 = -3.4028235E38f;
        double d4 = 0.0;
        double d5 = Double.MAX_VALUE;
        int n = 0;
        for (int i = 0; i < fArray.length; ++i) {
            d4 += d;
            f = fArray[i];
            if (f > f2) {
                f2 = f;
                n = i;
                double d6 = d2 * d4 + d;
                d5 = d4 + d6;
                double d7 = d5 = d5 < this.durationMin ? this.durationMin : d5;
            }
            if (d4 > d5) break;
        }
        float f3 = (float)this.thresholdLevel * f2;
        f = (float)d3 * f2;
        d4 = 0.0;
        d5 = Double.MAX_VALUE;
        boolean bl = false;
        double d8 = 0.0;
        double[] dArray = new double[2];
        for (int i = 0; i < fArray.length; ++i) {
            d4 += d;
            float f4 = fArray[i];
            if (i <= n || f4 > f3) {
                d8 = d4;
                dArray[0] = i;
                dArray[1] = i;
                bl = false;
                d5 = Double.MAX_VALUE;
            } else if (f4 >= f) {
                bl = false;
                d5 = Double.MAX_VALUE;
            } else if (!bl && f4 < f) {
                bl = true;
                double d9 = d2 * d4 + d;
                d5 = d4 + d9;
                double d10 = d5 = d5 < this.durationMin ? this.durationMin : d5;
            }
            if (d4 > d5) break;
        }
        PickData pickData = new PickData(dArray[0], dArray[1], 0, d8, "_INDEP_VAR");
        this.cumDurPicks = new Vector();
        this.cumDurPicks.add(pickData);
        return fArray;
    }

    public void updateFields(TimeSeries timeSeries) {
        timeSeries.ampUnits = "counts";
    }

    public boolean amplititudeModified() {
        return false;
    }
}

