/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.alomax.seisgram2k.PickPhase;
import net.alomax.seisgram2k.SeisGram2KColors;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.seisgram2k.SeisPick;
import net.alomax.seisgram2k.toolmanager.BearKradolferToolManager;
import net.alomax.seisgram2k.toolmanager.CumulativeDurationToolManager;
import net.alomax.seisgram2k.toolmanager.PeakExtractorToolManager;
import net.alomax.seisgram2k.toolmanager.PeakSlidingWindowToolManager;
import net.alomax.seisgram2k.toolmanager.ShortLongTermAveToolManager;
import net.alomax.seisgram2k.toolmanager.TestPicker2ToolManager;
import net.alomax.seisgram2k.toolmanager.TestPicker3ToolManager;
import net.alomax.seisgram2k.toolmanager.TestPicker4ToolManager;
import net.alomax.seisgram2k.toolmanager.TestPickerToolManager;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.SwingExt;

public class PickToolManager
extends JToolManager {
    protected SeisGram2KFrame seisFrame = null;
    protected Vector pickPhases = new Vector();
    protected JPopupMenu pickPhasePopup;
    protected AJLJButton buttonPick_e;
    protected AJLJButton buttonPick_i;
    protected AJLJButton buttonPick_onset_unk;
    protected AJLJButton buttonPick_P;
    protected AJLJButton buttonPick_S;
    protected AJLJButton buttonPick_coda;
    protected AJLJButton buttonPick_c;
    protected AJLJButton buttonPick_d;
    protected AJLJButton buttonPick_fm_unk;
    protected AJLJButton buttonPick_0;
    protected AJLJButton buttonPick_1;
    protected AJLJButton buttonPick_2;
    protected AJLJButton buttonPick_3;
    protected AJLJButton buttonPick_4;
    protected AJLJButton buttonPick_Set;
    protected AJLJButton buttonPick_DeleteAll;
    protected AJLJButton buttonPick_Clear;
    protected JTextField textFieldName;
    protected JComboBox choiceName;
    protected AJLJButton buttonAmpZeroToPeak;
    protected AJLJButton buttonAmpPeakToPeak;
    protected PeakSlidingWindowToolManager peakSlidingWindowToolManager = null;
    protected AJLJButton buttonPeakSlidingWindow;
    protected ShortLongTermAveToolManager shortLongTermAveManager = null;
    protected AJLJButton buttonShortLongTermAve;
    protected BearKradolferToolManager bearKradolferToolManager = null;
    protected AJLJButton buttonBearKradolfer;
    protected TestPickerToolManager testPickerToolManager = null;
    protected AJLJButton buttonTestPicker;
    protected TestPicker2ToolManager testPicker2ToolManager = null;
    protected AJLJButton buttonTestPicker2;
    protected TestPicker3ToolManager testPicker3ToolManager = null;
    protected AJLJButton buttonTestPicker3;
    protected TestPicker4ToolManager testPicker4ToolManager = null;
    protected AJLJButton buttonTestPicker4;
    protected PeakExtractorToolManager peakExtractorToolManager = null;
    protected AJLJButton buttonPeakExtractorToolManager;
    protected CumulativeDurationToolManager cumulativeDurationToolManager = null;
    protected AJLJButton buttonCumulativeDurationToolManager;
    protected AJLJButton buttonPickCumulative;
    protected double timeWindowWidth = 0.8;
    protected double cumulativeWidth = 0.025;
    protected double cumulativeValue = 0.95;
    protected String ztpID = "0-P_max";
    protected AJLJButton buttonPickPivotLine;
    protected String pivotID = "0-P_max";
    protected double linePivotDelay = 10.0;
    protected double linePivotDistanceLimit = 0.1;
    protected double linePivotErrorWidth = 0.05;
    protected AJLJButton buttonToBox;
    protected String boxID1 = "";
    protected String boxID2 = "";
    protected static String DEFAULT_PHASES = "i,P,c,0,(" + SeisGramText.SET + ");i,P,d,0,(" + SeisGramText.SET + ");e,P,c;e,P,d;e,S,,,(" + SeisGramText.SET + ");" + "," + SeisPick.CODA_STRING + ",,,(" + SeisGramText.SET + ");" + "," + "0-P_max" + ",,,(" + SeisGramText.SET + ");" + "," + "P-P_min" + ",,,(" + SeisGramText.SET + ");" + "," + "P-P_max" + ",,,(" + SeisGramText.SET + ");";
    protected static String DEFAULT_PHASES_SCHOOL = ",P,,,(" + SeisGramText.SET + ");,S,,,(" + SeisGramText.SET + ");" + "," + SeisPick.CODA_STRING + ",,,(" + SeisGramText.SET + ");";
    protected static String[] DEFAULT_NAMES = new String[]{"P", "S", SeisPick.CODA_STRING, "0-P_max", "P-P_min", "P-P_max"};
    protected static final int MARKPTP = 0;
    protected static final int MARKZTP = 1;
    protected static final int MARKCUM = 2;
    protected static final int MARKPIV = 3;
    protected static final int MARKBOX = 4;
    protected static final int MARKCUMDUR = 2;
    protected String[] commandNames = new String[]{"markptp", "markztp", "markcum", "marklinepiv", "markbox"};
    protected String[] commandNamesShort = new String[]{"markp", "markz", "markc", "marklp", "markb"};
    protected int variant = 0;
    protected String argumentString = "";

    public PickToolManager(SeisGram2KFrame seisGram2KFrame) {
        String string;
        String string2;
        this.seisFrame = seisGram2KFrame;
        this.updateLabel();
        String string3 = seisGram2KFrame.getParameter("pick.phases");
        if (string3 == null) {
            string3 = seisGram2KFrame.getConfiguration() == 1 ? DEFAULT_PHASES_SCHOOL : DEFAULT_PHASES;
        }
        JPopupMenu jPopupMenu = this.createPickPhasePopup(string3);
        String string4 = null;
        string4 = "pick.p2pmax.windowlen";
        String string5 = seisGram2KFrame.getParameter(string4);
        if (string5 != null) {
            try {
                double d;
                this.timeWindowWidth = d = Double.valueOf(string5).doubleValue();
            }
            catch (Exception exception) {
                System.out.println(this.getClass().getName() + ": " + "WARNING: invalid <" + string4 + "> value: " + string5);
            }
        }
        if ((string2 = seisGram2KFrame.getParameter(string4 = "pick.cumulative.value")) != null) {
            try {
                double d;
                this.cumulativeValue = d = Double.valueOf(string2).doubleValue();
            }
            catch (Exception exception) {
                System.out.println(this.getClass().getName() + ": " + "WARNING: invalid <" + string4 + "> value: " + string2);
            }
        }
        if ((string = seisGram2KFrame.getParameter(string4 = "pick.cumulative.width")) != null) {
            try {
                double d;
                this.cumulativeWidth = d = Double.valueOf(string).doubleValue();
            }
            catch (Exception exception) {
                System.out.println(this.getClass().getName() + ": " + "WARNING: invalid <" + string4 + "> value: " + string);
            }
        }
    }

    public void updateLabel() {
        this.label = SeisGramText.PICK;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void activate() {
        this.seisFrame.setPickCursor();
        this.seisFrame.getActiveGather().checkForSorPorCodaTimes(this.seisFrame.getActiveGather().activeSeismogram, false);
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null);
    }

    public boolean processPopupTrigger(Component component, int n, int n2) {
        this.showPickPhasePopup(component, n, n2);
        return true;
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonPick_Clear = new AJLJButton(this, this, SeisGramText.CLEAR);
        if (!this.seisFrame.isSchool()) {
            jToolBar.add(this.buttonPick_Clear);
        }
        if (SeisPick.getFileFormat() == 0) {
            this.setHypo71Options(jToolBar);
        } else if (SeisPick.getFileFormat() == 1) {
            this.setNLLocOptions(jToolBar);
        } else if (SeisPick.getFileFormat() == 2) {
            this.setNLLocOptions(jToolBar);
        } else {
            this.setNLLocOptions(jToolBar);
        }
        this.buttonPick_Set = new AJLJButton(this, this, SeisGramText.SET);
        if (!this.seisFrame.isSchool()) {
            jToolBar.add(this.buttonPick_Set);
        }
        jToolBar.addSeparator();
        this.buttonPick_DeleteAll = new AJLJButton(this, this, SeisGramText.DEL_ALL);
        jToolBar.add(this.buttonPick_DeleteAll);
        if (!this.seisFrame.isSchool()) {
            jToolBar.addSeparator();
            jToolBar.add(new JLabel(SeisGramText.AUTO + ":", 4));
            this.buttonAmpZeroToPeak = new AJLJButton(this, this, "0-P_max");
            jToolBar.add(this.buttonAmpZeroToPeak);
            this.buttonAmpPeakToPeak = new AJLJButton(this, this, "P-P_max");
            jToolBar.add(this.buttonAmpPeakToPeak);
            this.buttonPeakSlidingWindow = new AJLJButton(this, this, SeisGramText.PEAK_SLIDING_WINDOW);
            jToolBar.add(this.buttonPeakSlidingWindow);
            this.buttonShortLongTermAve = new AJLJButton(this, this, SeisGramText.SHORT_LONG_TERM_AVE);
            jToolBar.add(this.buttonShortLongTermAve);
            this.buttonBearKradolfer = new AJLJButton(this, this, SeisGramText.BAER_KRADOLFER_PICKER);
            jToolBar.add(this.buttonBearKradolfer);
            this.buttonTestPicker = new AJLJButton(this, this, SeisGramText.TEST_PICKER);
            this.buttonTestPicker2 = new AJLJButton(this, this, SeisGramText.TEST_PICKER2);
            this.buttonTestPicker3 = new AJLJButton(this, this, SeisGramText.TEST_PICKER3);
            this.buttonTestPicker4 = new AJLJButton(this, this, SeisGramText.TEST_PICKER4);
            if (this.seisFrame.checkTestParameter("$rissc$") || this.seisFrame.checkTestParameter("XrisscX")) {
                jToolBar.add(this.buttonTestPicker3);
                jToolBar.add(this.buttonTestPicker4);
            }
            this.buttonPickCumulative = new AJLJButton(this, this, "Cumul");
            jToolBar.add(this.buttonPickCumulative);
            this.buttonPeakExtractorToolManager = new AJLJButton(this, this, SeisGramText.PEAK_EXTRACTOR);
            jToolBar.add(this.buttonPeakExtractorToolManager);
            this.buttonCumulativeDurationToolManager = new AJLJButton(this, this, SeisGramText.CUMULATIVE_DURATION);
            jToolBar.add(this.buttonCumulativeDurationToolManager);
            this.buttonPickPivotLine = new AJLJButton(this, this, "Pivot");
            if (SeisGram2KFrame.TEST_FLAG) {
                jToolBar.add(this.buttonPickPivotLine);
            }
            this.buttonToBox = new AJLJButton(this, this, "Box");
            if (SeisGram2KFrame.TEST_FLAG) {
                jToolBar.add(this.buttonToBox);
            }
        }
        jToolBar.validate();
    }

    public void updateComponents() {
        try {
            this.seisFrame.setPickCursor();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.seisFrame.clearPicks();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getSource().equals(this.buttonPick_e)) {
                this.seisFrame.getActiveGather().workingPick.onset = "e";
                this.seisFrame.getActiveGather().displayPick(-1, 0);
                return;
            }
            if (actionEvent.getSource().equals(this.buttonPick_i)) {
                this.seisFrame.getActiveGather().workingPick.onset = "i";
                this.seisFrame.getActiveGather().displayPick(-1, 0);
                return;
            }
            if (actionEvent.getSource().equals(this.buttonPick_onset_unk)) {
                this.seisFrame.getActiveGather().workingPick.onset = "?";
                this.seisFrame.getActiveGather().displayPick(-1, 0);
                return;
            }
            if (actionEvent.getSource().equals(this.buttonPick_P)) {
                this.seisFrame.getActiveGather().workingPick.name = "P";
                if (this.textFieldName != null) {
                    this.textFieldName.setText("P");
                }
                this.seisFrame.getActiveGather().displayPick(-1, 0);
                if (this.seisFrame.getConfiguration() == 1) {
                    this.setPick();
                }
                return;
            }
            if (actionEvent.getSource().equals(this.buttonPick_S)) {
                this.seisFrame.getActiveGather().workingPick.name = "S";
                if (this.textFieldName != null) {
                    this.textFieldName.setText("S");
                }
                this.seisFrame.getActiveGather().displayPick(-1, 0);
                if (this.seisFrame.getConfiguration() == 1) {
                    this.setPick();
                }
            } else {
                if (actionEvent.getSource().equals(this.buttonPick_coda)) {
                    this.seisFrame.getActiveGather().workingPick.init();
                    this.seisFrame.getActiveGather().workingPick.name = SeisPick.CODA_STRING;
                    if (this.textFieldName != null) {
                        this.textFieldName.setText(SeisPick.CODA_STRING);
                    }
                    this.seisFrame.getActiveGather().displayPick(-1, 0);
                    if (this.seisFrame.getConfiguration() == 1) {
                        this.setPick();
                    }
                    return;
                }
                if (actionEvent.getSource().equals(this.textFieldName)) {
                    this.seisFrame.getActiveGather().workingPick.name = this.textFieldName.getText();
                    this.seisFrame.getActiveGather().displayPick(-1, 0);
                    return;
                }
                if (this.performPickPhasePopupAction(actionEvent.getActionCommand())) {
                    if (this.textFieldName != null) {
                        this.textFieldName.setText(this.seisFrame.getActiveGather().workingPick.name);
                    }
                    this.seisFrame.getActiveGather().displayPick(-1, 0);
                    return;
                }
                if (actionEvent.getSource().equals(this.buttonPick_c)) {
                    this.seisFrame.getActiveGather().workingPick.firstMot = "c";
                    this.seisFrame.getActiveGather().displayPick(-1, 0);
                    return;
                }
                if (actionEvent.getSource().equals(this.buttonPick_d)) {
                    this.seisFrame.getActiveGather().workingPick.firstMot = "d";
                    this.seisFrame.getActiveGather().displayPick(-1, 0);
                    return;
                }
                if (actionEvent.getSource().equals(this.buttonPick_fm_unk)) {
                    this.seisFrame.getActiveGather().workingPick.firstMot = "?";
                    this.seisFrame.getActiveGather().displayPick(-1, 0);
                    return;
                }
                if (actionEvent.getSource().equals(this.buttonPick_0)) {
                    this.seisFrame.getActiveGather().workingPick.quality = 0;
                    this.seisFrame.getActiveGather().displayPick(-1, 0);
                    return;
                }
                if (actionEvent.getSource().equals(this.buttonPick_1)) {
                    this.seisFrame.getActiveGather().workingPick.quality = 1;
                    this.seisFrame.getActiveGather().displayPick(-1, 0);
                    return;
                }
                if (actionEvent.getSource().equals(this.buttonPick_2)) {
                    this.seisFrame.getActiveGather().workingPick.quality = 2;
                    this.seisFrame.getActiveGather().displayPick(-1, 0);
                    return;
                }
                if (actionEvent.getSource().equals(this.buttonPick_3)) {
                    this.seisFrame.getActiveGather().workingPick.quality = 3;
                    this.seisFrame.getActiveGather().displayPick(-1, 0);
                    return;
                }
                if (actionEvent.getSource().equals(this.buttonPick_4)) {
                    this.seisFrame.getActiveGather().workingPick.quality = 4;
                    this.seisFrame.getActiveGather().displayPick(-1, 0);
                    return;
                }
                if (actionEvent.getSource().equals(this.buttonPick_Set)) {
                    this.setPick();
                    return;
                }
                if (actionEvent.getSource().equals(this.buttonPick_DeleteAll)) {
                    this.seisFrame.getActiveGather().deleteAllPicks();
                    this.seisFrame.getActiveGather().workingPick.init();
                    this.seisFrame.getActiveGather().displayPick(-1, 0);
                } else {
                    if (actionEvent.getSource().equals(this.buttonPick_Clear)) {
                        if (this.textFieldName != null) {
                            this.textFieldName.setText(" ");
                        }
                        this.seisFrame.getActiveGather().removePickCursor();
                        this.seisFrame.getActiveGather().clearPick();
                        return;
                    }
                    if (actionEvent.getSource().equals(this.buttonAmpZeroToPeak)) {
                        this.variant = 1;
                        this.apply();
                        return;
                    }
                    if (actionEvent.getSource().equals(this.buttonAmpPeakToPeak)) {
                        this.variant = 0;
                        this.apply();
                        return;
                    }
                    if (actionEvent.getSource().equals(this.buttonShortLongTermAve)) {
                        if (this.shortLongTermAveManager == null) {
                            this.shortLongTermAveManager = new ShortLongTermAveToolManager(this.seisFrame, "PICKS");
                        }
                        this.seisFrame.initializeInteractionPanel(this.shortLongTermAveManager);
                        return;
                    }
                    if (actionEvent.getSource().equals(this.buttonPeakSlidingWindow)) {
                        if (this.peakSlidingWindowToolManager == null) {
                            this.peakSlidingWindowToolManager = new PeakSlidingWindowToolManager(this.seisFrame);
                        }
                        this.seisFrame.initializeInteractionPanel(this.peakSlidingWindowToolManager);
                        return;
                    }
                    if (actionEvent.getSource().equals(this.buttonBearKradolfer)) {
                        if (this.bearKradolferToolManager == null) {
                            this.bearKradolferToolManager = new BearKradolferToolManager(this.seisFrame, "PICKS");
                        }
                        this.seisFrame.initializeInteractionPanel(this.bearKradolferToolManager);
                        return;
                    }
                    if (actionEvent.getSource().equals(this.buttonTestPicker)) {
                        if (this.testPickerToolManager == null) {
                            this.testPickerToolManager = new TestPickerToolManager(this.seisFrame, "PICKS");
                        }
                        this.seisFrame.initializeInteractionPanel(this.testPickerToolManager);
                        return;
                    }
                    if (actionEvent.getSource().equals(this.buttonTestPicker2)) {
                        if (this.testPicker2ToolManager == null) {
                            this.testPicker2ToolManager = new TestPicker2ToolManager(this.seisFrame, "PICKS");
                        }
                        this.seisFrame.initializeInteractionPanel(this.testPicker2ToolManager);
                        return;
                    }
                    if (actionEvent.getSource().equals(this.buttonTestPicker3)) {
                        if (this.testPicker3ToolManager == null) {
                            this.testPicker3ToolManager = new TestPicker3ToolManager(this.seisFrame, "PICKS");
                        }
                        this.seisFrame.initializeInteractionPanel(this.testPicker3ToolManager);
                        return;
                    }
                    if (actionEvent.getSource().equals(this.buttonTestPicker4)) {
                        if (this.testPicker4ToolManager == null) {
                            this.testPicker4ToolManager = new TestPicker4ToolManager(this.seisFrame, "PICKS");
                        }
                        this.seisFrame.initializeInteractionPanel(this.testPicker4ToolManager);
                        return;
                    }
                    if (actionEvent.getSource().equals(this.buttonPeakExtractorToolManager)) {
                        if (this.peakExtractorToolManager == null) {
                            this.peakExtractorToolManager = new PeakExtractorToolManager(this.seisFrame);
                        }
                        this.seisFrame.initializeInteractionPanel(this.peakExtractorToolManager);
                        return;
                    }
                    if (actionEvent.getSource().equals(this.buttonPickCumulative)) {
                        this.variant = 2;
                        this.apply();
                        return;
                    }
                    if (actionEvent.getSource().equals(this.buttonCumulativeDurationToolManager)) {
                        if (this.cumulativeDurationToolManager == null) {
                            this.cumulativeDurationToolManager = new CumulativeDurationToolManager(this.seisFrame);
                        }
                        this.seisFrame.initializeInteractionPanel(this.cumulativeDurationToolManager);
                        return;
                    }
                    if (actionEvent.getSource().equals(this.buttonPickPivotLine)) {
                        this.variant = 3;
                        this.apply();
                        return;
                    }
                    if (actionEvent.getSource().equals(this.buttonToBox)) {
                        this.variant = 4;
                        this.apply();
                        return;
                    }
                    return;
                }
            }
            this.seisFrame.paintGather();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        try {
            if (itemEvent.getSource().equals(this.choiceName)) {
                String string;
                this.seisFrame.getActiveGather().workingPick.name = string = (String)this.choiceName.getSelectedItem();
                if (this.textFieldName != null) {
                    this.textFieldName.setText(string);
                }
                this.seisFrame.getActiveGather().displayPick(-1, 0);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean performPickPhasePopupAction(String string) {
        if (string.equals("set")) {
            this.setPick();
            return true;
        }
        for (int i = 0; i < this.pickPhases.size(); ++i) {
            PickPhase pickPhase = (PickPhase)this.pickPhases.elementAt(i);
            if (!string.equals(pickPhase.label)) continue;
            this.seisFrame.getActiveGather().workingPick.onset = pickPhase.onset;
            this.seisFrame.getActiveGather().workingPick.name = pickPhase.name;
            if (this.textFieldName != null) {
                this.textFieldName.setText(pickPhase.name);
            }
            this.seisFrame.getActiveGather().workingPick.firstMot = pickPhase.firstMot;
            this.seisFrame.getActiveGather().workingPick.quality = pickPhase.quality;
            if (pickPhase.setPickImmediately()) {
                this.setPick();
            }
            return true;
        }
        return false;
    }

    protected JPopupMenu createPickPhasePopup(String string) {
        int n;
        String string2 = string;
        while ((n = string2.indexOf(59)) > 0) {
            this.pickPhases.addElement(new PickPhase(string2.substring(0, n)));
            if (n >= string2.length() - 1) {
                string2 = "";
                break;
            }
            string2 = string2.substring(n + 1);
        }
        if (string2.length() > 0) {
            this.pickPhases.addElement(new PickPhase(string2));
        }
        this.pickPhasePopup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(SeisGramText.SET);
        jMenuItem.setActionCommand("set");
        jMenuItem.addActionListener(this);
        if (!this.seisFrame.isSchool()) {
            this.pickPhasePopup.add(jMenuItem);
            this.pickPhasePopup.addSeparator();
        }
        for (int i = 0; i < this.pickPhases.size(); ++i) {
            String string3 = ((PickPhase)this.pickPhases.elementAt((int)i)).label;
            jMenuItem = new JMenuItem(string3);
            jMenuItem.setActionCommand(string3);
            jMenuItem.addActionListener(this);
            this.pickPhasePopup.add(jMenuItem);
        }
        return this.pickPhasePopup;
    }

    protected void showPickPhasePopup(Component component, int n, int n2) {
        this.pickPhasePopup.show(component, n, n2);
    }

    protected void setPick() {
        try {
            if (this.textFieldName != null) {
                this.seisFrame.getActiveGather().workingPick.name = this.textFieldName.getText();
            }
            if (this.seisFrame.getConfiguration() == 1) {
                if (this.seisFrame.getActiveGather().workingPick.name.equals("P")) {
                    this.seisFrame.getActiveGather().workingPick.setColor(SeisGram2KColors.colorPickSchoolP);
                } else if (this.seisFrame.getActiveGather().workingPick.name.equals("S")) {
                    this.seisFrame.getActiveGather().workingPick.setColor(SeisGram2KColors.colorPickSchoolS);
                }
            }
            this.seisFrame.getActiveGather().setPick();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setNLLocOptions(JToolBar jToolBar) {
        if (this.seisFrame.getConfiguration() == 1) {
            this.setNLLocOptionsSchool(jToolBar);
        } else {
            this.setNLLocOptionsStandard(jToolBar);
        }
    }

    protected void setNLLocOptionsSchool(JToolBar jToolBar) {
        this.buttonPick_P = new AJLJButton(this, this, "P");
        jToolBar.add(this.buttonPick_P);
        this.buttonPick_S = new AJLJButton(this, this, "S");
        jToolBar.add(this.buttonPick_S);
        this.buttonPick_coda = new AJLJButton(this, this, SeisPick.CODA_STRING);
        jToolBar.add(this.buttonPick_coda);
        jToolBar.add(new JLabel(" "));
    }

    protected void setNLLocOptionsStandard(JToolBar jToolBar) {
        this.buttonPick_e = new AJLJButton(this, this, "e");
        this.buttonPick_i = new AJLJButton(this, this, "i");
        this.buttonPick_onset_unk = new AJLJButton(this, this, "?");
        jToolBar.add(new JLabel(" "));
        jToolBar.add(this.buttonPick_e);
        jToolBar.add(this.buttonPick_i);
        jToolBar.add(this.buttonPick_onset_unk);
        jToolBar.add(new JLabel(" "));
        String[] stringArray = this.getPickPhasesLabels(this.pickPhases);
        if (stringArray == null) {
            stringArray = DEFAULT_NAMES;
        }
        this.choiceName = SwingExt.newChoice(this, stringArray);
        this.choiceName.setBackground(Color.lightGray);
        jToolBar.add(this.choiceName);
        this.textFieldName = SwingExt.newJTextField(this, this, "", 10);
        jToolBar.add(this.textFieldName);
        this.buttonPick_c = new AJLJButton(this, this, "c");
        this.buttonPick_d = new AJLJButton(this, this, "d");
        this.buttonPick_fm_unk = new AJLJButton(this, this, "?");
        jToolBar.add(new JLabel(" "));
        jToolBar.add(this.buttonPick_c);
        jToolBar.add(this.buttonPick_d);
        jToolBar.add(this.buttonPick_fm_unk);
        jToolBar.add(new JLabel(" "));
    }

    protected String[] getPickPhasesLabels(Vector vector) {
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("?");
        for (int i = 0; i < vector.size(); ++i) {
            try {
                int n;
                String string = ((PickPhase)vector.elementAt((int)i)).name;
                for (n = 0; n < vector2.size() && !((String)vector2.elementAt(n)).equals(string); ++n) {
                }
                if (n != vector2.size()) continue;
                vector2.addElement(string);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object[] objectArray = new String[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }

    protected void setHypo71Options(JToolBar jToolBar) {
        JPanel jPanel = new JPanel();
        this.buttonPick_e = new AJLJButton(this, this, "e");
        this.buttonPick_i = new AJLJButton(this, this, "i");
        if (!this.seisFrame.isSchool()) {
            jPanel.add(new JLabel(" "));
            jPanel.add(this.buttonPick_e);
            jPanel.add(this.buttonPick_i);
            jPanel.add(new JLabel(" "));
        }
        this.buttonPick_P = new AJLJButton(this, this, "P");
        jPanel.add(this.buttonPick_P);
        this.buttonPick_S = new AJLJButton(this, this, "S");
        jPanel.add(this.buttonPick_S);
        this.buttonPick_coda = new AJLJButton(this, this, SeisPick.CODA_STRING);
        if (!this.seisFrame.isSchool()) {
            jPanel.add(this.buttonPick_coda);
        }
        jPanel.add(new JLabel(" "));
        this.buttonPick_c = new AJLJButton(this, this, "c");
        if (!this.seisFrame.isSchool()) {
            jPanel.add(this.buttonPick_c);
        }
        this.buttonPick_d = new AJLJButton(this, this, "d");
        jPanel.add(this.buttonPick_d);
        jPanel.add(new JLabel(" "));
        this.buttonPick_0 = new AJLJButton(this, this, "0");
        jPanel.add(this.buttonPick_0);
        this.buttonPick_1 = new AJLJButton(this, this, "1");
        jPanel.add(this.buttonPick_1);
        this.buttonPick_2 = new AJLJButton(this, this, "2");
        jPanel.add(this.buttonPick_2);
        this.buttonPick_3 = new AJLJButton(this, this, "3");
        jPanel.add(this.buttonPick_3);
        this.buttonPick_4 = new AJLJButton(this, this, "4");
        jPanel.add(this.buttonPick_4);
        jPanel.add(new JLabel(" "));
        if (!this.seisFrame.isSchool()) {
            jToolBar.add(jPanel);
        }
    }

    public boolean mouseDraggedDisplay(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n < this.seisFrame.getActiveGather().getSeisPanel().ixMin || n > this.seisFrame.getActiveGather().getSeisPanel().ixMax) {
            return true;
        }
        int n3 = this.seisFrame.getActiveGather().timeToIy(this.seisFrame.getActiveGather().ixToTime(n), this.seisFrame.getActiveGather().activeSeismogram);
        this.seisFrame.getActiveGather().getSeisPanel().updatePickCursor(n, n2, n3, false);
        return true;
    }

    public boolean mouseMovedDisplay(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.seisFrame.getActiveGather().getSeisPanel() == mouseEvent.getSource()) {
            this.seisFrame.getActiveGather().highlightNearestPick(n, n2);
        }
        return true;
    }

    public boolean mousePressedDisplay(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n < this.seisFrame.getActiveGather().getSeisPanel().ixMin || n > this.seisFrame.getActiveGather().getSeisPanel().ixMax) {
            return false;
        }
        this.seisFrame.getActiveGather().getSeisPanel().removePickCursor();
        int n3 = n;
        if (this.seisFrame.getActiveGather().getSeisPanel().gather == this.seisFrame.getActiveGather()) {
            n3 = this.seisFrame.getActiveGather().makeNearestPickActive(n, n2);
        }
        if (n3 >= 0) {
            if (this.textFieldName != null) {
                this.textFieldName.setText(this.seisFrame.getActiveGather().workingPick.name);
            }
        } else {
            n3 = n;
        }
        int n4 = this.seisFrame.getActiveGather().timeToIy(this.seisFrame.getActiveGather().ixToTime(n3), this.seisFrame.getActiveGather().activeSeismogram);
        this.seisFrame.getActiveGather().getSeisPanel().newPickCursor(n3, n2, n4);
        this.seisFrame.getActiveGather().getSeisPanel().prevx = n3;
        this.seisFrame.getActiveGather().getSeisPanel().prevy = n2;
        return true;
    }

    public boolean mouseReleasedDisplay(MouseEvent mouseEvent) {
        return true;
    }

    protected void setPickAutoAmpZeroToPeakMax() {
        this.seisFrame.writeProcessingMessage(this.getCommandString());
        this.seisFrame.writeEndProcessingMessage();
        this.seisFrame.getActiveGather().setPickAutoAmpZeroToPeakMax(this.ztpID);
    }

    protected void setPickAutoAmpPeakToPeakMax() {
        this.seisFrame.writeProcessingMessage(this.getCommandString());
        this.seisFrame.writeEndProcessingMessage();
        this.seisFrame.getActiveGather().setPickAutoAmpPeakToPeakMax(this.timeWindowWidth);
    }

    protected void setPickAutoPivotLine() {
        this.seisFrame.writeProcessingMessage(this.getCommandString());
        this.seisFrame.writeEndProcessingMessage();
        this.seisFrame.getActiveGather().setPickAutoPivotLine(this.pivotID, this.linePivotDelay, this.linePivotDistanceLimit, this.linePivotErrorWidth);
    }

    protected void setPickAutoCumulative() {
        this.seisFrame.writeProcessingMessage(this.getCommandString());
        this.seisFrame.writeEndProcessingMessage();
        this.seisFrame.getActiveGather().setPickAutoCumulative(this.cumulativeValue, this.cumulativeWidth);
    }

    protected void setPickToBox() {
        this.seisFrame.writeProcessingMessage(this.getCommandString());
        this.seisFrame.writeEndProcessingMessage();
        this.seisFrame.getActiveGather().setPickToBox(this.boxID1, this.boxID2);
    }

    protected void apply() {
        if (this.variant == 1) {
            this.setPickAutoAmpZeroToPeakMax();
        } else if (this.variant == 0) {
            this.setPickAutoAmpPeakToPeakMax();
        } else if (this.variant == 2) {
            this.setPickAutoCumulative();
        } else if (this.variant == 3) {
            this.setPickAutoPivotLine();
        } else if (this.variant == 4) {
            this.setPickToBox();
        }
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        if (this.peakSlidingWindowToolManager == null) {
            this.peakSlidingWindowToolManager = new PeakSlidingWindowToolManager(this.seisFrame);
        }
        if (this.peakSlidingWindowToolManager != null && this.peakSlidingWindowToolManager.isCommandHandler(string)) {
            return true;
        }
        if (this.shortLongTermAveManager == null) {
            this.shortLongTermAveManager = new ShortLongTermAveToolManager(this.seisFrame, "PICKS");
        }
        if (this.shortLongTermAveManager != null && this.shortLongTermAveManager.isCommandHandler(string)) {
            return true;
        }
        if (this.bearKradolferToolManager == null) {
            this.bearKradolferToolManager = new BearKradolferToolManager(this.seisFrame, "PICKS");
        }
        if (this.bearKradolferToolManager != null && this.bearKradolferToolManager.isCommandHandler(string)) {
            return true;
        }
        if (this.testPickerToolManager == null && (this.seisFrame.checkTestParameter("$rissc$") || this.seisFrame.checkTestParameter("XrisscX"))) {
            this.testPickerToolManager = new TestPickerToolManager(this.seisFrame, "PICKS");
        }
        if (this.testPickerToolManager != null && this.testPickerToolManager.isCommandHandler(string)) {
            return true;
        }
        if (this.testPicker2ToolManager == null && (this.seisFrame.checkTestParameter("$rissc$") || this.seisFrame.checkTestParameter("XrisscX"))) {
            this.testPicker2ToolManager = new TestPicker2ToolManager(this.seisFrame, "PICKS");
        }
        if (this.testPicker2ToolManager != null && this.testPicker2ToolManager.isCommandHandler(string)) {
            return true;
        }
        if (this.testPicker3ToolManager == null && (this.seisFrame.checkTestParameter("$rissc$") || this.seisFrame.checkTestParameter("XrisscX"))) {
            this.testPicker3ToolManager = new TestPicker3ToolManager(this.seisFrame, "PICKS");
        }
        if (this.testPicker3ToolManager != null && this.testPicker3ToolManager.isCommandHandler(string)) {
            return true;
        }
        if (this.testPicker4ToolManager == null && (this.seisFrame.checkTestParameter("$rissc$") || this.seisFrame.checkTestParameter("XrisscX"))) {
            this.testPicker4ToolManager = new TestPicker4ToolManager(this.seisFrame, "PICKS");
        }
        if (this.testPicker4ToolManager != null && this.testPicker4ToolManager.isCommandHandler(string)) {
            return true;
        }
        if (this.peakExtractorToolManager == null) {
            this.peakExtractorToolManager = new PeakExtractorToolManager(this.seisFrame);
        }
        if (this.peakExtractorToolManager != null && this.peakExtractorToolManager.isCommandHandler(string)) {
            return true;
        }
        if (this.cumulativeDurationToolManager == null) {
            this.cumulativeDurationToolManager = new CumulativeDurationToolManager(this.seisFrame);
        }
        return this.cumulativeDurationToolManager != null && this.cumulativeDurationToolManager.isCommandHandler(string);
    }

    public void applyCommand(String string) throws JToolManagerException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        if (this.peakSlidingWindowToolManager != null && this.peakSlidingWindowToolManager.isCommandHandler(string)) {
            this.peakSlidingWindowToolManager.applyCommand(string);
            return;
        }
        if (this.shortLongTermAveManager != null && this.shortLongTermAveManager.isCommandHandler(string)) {
            this.shortLongTermAveManager.applyCommand(string);
            return;
        }
        if (this.bearKradolferToolManager != null && this.bearKradolferToolManager.isCommandHandler(string)) {
            this.bearKradolferToolManager.applyCommand(string);
            return;
        }
        if (this.testPickerToolManager != null && this.testPickerToolManager.isCommandHandler(string)) {
            this.testPickerToolManager.applyCommand(string);
            return;
        }
        if (this.testPicker2ToolManager != null && this.testPicker2ToolManager.isCommandHandler(string)) {
            this.testPicker2ToolManager.applyCommand(string);
            return;
        }
        if (this.testPicker3ToolManager != null && this.testPicker3ToolManager.isCommandHandler(string)) {
            this.testPicker3ToolManager.applyCommand(string);
            return;
        }
        if (this.testPicker4ToolManager != null && this.testPicker4ToolManager.isCommandHandler(string)) {
            this.testPicker4ToolManager.applyCommand(string);
            return;
        }
        if (this.peakExtractorToolManager != null && this.peakExtractorToolManager.isCommandHandler(string)) {
            this.peakExtractorToolManager.applyCommand(string);
            return;
        }
        if (this.cumulativeDurationToolManager != null && this.cumulativeDurationToolManager.isCommandHandler(string)) {
            this.cumulativeDurationToolManager.applyCommand(string);
            return;
        }
        String string2 = " ";
        this.argumentString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            stringTokenizer.nextToken();
            if (this.variant == 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("wi")) {
                        this.timeWindowWidth = Double.valueOf(stringTokenizer.nextToken());
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            } else if (this.variant == 1) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("id")) {
                        this.ztpID = stringTokenizer.nextToken();
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            } else if (this.variant == 2) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("val")) {
                        this.cumulativeValue = Double.valueOf(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("wi")) {
                        this.cumulativeWidth = Double.valueOf(stringTokenizer.nextToken());
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            } else if (this.variant == 3) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("id")) {
                        this.pivotID = stringTokenizer.nextToken();
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("de")) {
                        this.linePivotDelay = Double.valueOf(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("val")) {
                        this.linePivotDistanceLimit = Double.valueOf(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("wi")) {
                        this.linePivotErrorWidth = Double.valueOf(stringTokenizer.nextToken());
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            } else if (this.variant == 4) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("id1")) {
                        this.boxID1 = stringTokenizer.nextToken();
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("id2")) {
                        this.boxID2 = stringTokenizer.nextToken();
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
            throw new JToolManagerException("Parsing or applying command", string, string2);
        }
        catch (JToolManagerException jToolManagerException) {
            jToolManagerException.printStackTrace();
            throw jToolManagerException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new JToolManagerException("Parsing or applying command: " + exception.getMessage(), string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        if (this.variant == 0) {
            string = string + " wi " + (float)this.timeWindowWidth;
        } else if (this.variant == 2) {
            string = string + " val " + (float)this.cumulativeValue + " wi " + (float)this.cumulativeWidth;
        } else if (this.variant == 1) {
            string = string + " id " + this.ztpID;
        } else if (this.variant == 3) {
            string = string + " id " + this.pivotID + " de " + (float)this.linePivotDelay + " val " + (float)this.linePivotDistanceLimit + " wi " + (float)this.linePivotErrorWidth;
        } else if (this.variant == 4) {
            string = string + " id1 " + this.boxID1 + " id2 " + this.boxID2;
        }
        return string;
    }
}

