/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.SwingExt;
import net.alomax.timedom.BaerKradolferPicker;
import net.alomax.timedom.PickData;
import net.alomax.timedom.TimeDomainException;

public class BearKradolferToolManager
extends JToolManager {
    protected String[] typeNames = new String[]{"FORWARD", "BACKWARD"};
    protected String[] resultNames = new String[]{"PICKS", "CHAR_FUNC", "TRIGGERS"};
    protected SeisGram2KFrame seisFrame = null;
    protected BaerKradolferPicker baerKradolferPicker;
    protected AJLJButton buttonApplyBaerKradolferPicker;
    protected JTextField textFieldLongTermWindow;
    protected JTextField textFieldThreshold1;
    protected JTextField textFieldThreshold2;
    protected JTextField textFieldTUpEvent;
    protected JTextField textFieldTDownMax;
    protected JComboBox choiceDirection;
    protected JComboBox choiceResults;
    protected static final int DEFAULT = 0;
    protected String[] commandNames = new String[0];
    protected String[] commandNamesShort = new String[0];
    protected int variant = 0;
    protected String argumentString = "";

    public BearKradolferToolManager(SeisGram2KFrame seisGram2KFrame, String string) {
        String string2;
        long l;
        long l2;
        this.seisFrame = seisGram2KFrame;
        this.updateLabel();
        double d = 20.0;
        double d2 = 10.0;
        double d3 = 20.0;
        double d4 = 1.0;
        double d5 = 0.5;
        double d6 = 0.05;
        try {
            d6 = seisGram2KFrame.getActiveGatherSampleInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        d = 500.0 * d6;
        long l3 = Math.round(d * 1000.0);
        if (l3 > 1L) {
            d = (double)l3 / 1000.0;
        }
        if ((l2 = Math.round((d4 = 20.0 * d6) * 1000.0)) > 1L) {
            d4 = (double)l2 / 1000.0;
        }
        if ((l = Math.round((d5 = 0.5 * d4) * 1000.0)) > 1L) {
            d5 = (double)l / 1000.0;
        }
        this.baerKradolferPicker = new BaerKradolferPicker(SeisGramText.getLocaleString(), d, d2, d3, d4, d5, 1);
        try {
            this.baerKradolferPicker.setResultsType(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string2 = null;
            string2 = seisGram2KFrame.getParameter("timedom.bkpick.ltw");
            if (string2 != null) {
                this.baerKradolferPicker.setLongTermWindow(string2);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string2 = null;
            string2 = seisGram2KFrame.getParameter("timedom.bkpick.thres1");
            if (string2 != null) {
                this.baerKradolferPicker.setThreshold1(string2);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string2 = null;
            string2 = seisGram2KFrame.getParameter("timedom.bkpick.thres2");
            if (string2 != null) {
                this.baerKradolferPicker.setThreshold2(string2);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string2 = null;
            string2 = seisGram2KFrame.getParameter("timedom.bkpick.tupevt");
            if (string2 != null) {
                this.baerKradolferPicker.setTUpEvent(string2);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string2 = null;
            string2 = seisGram2KFrame.getParameter("timedom.bkpick.tdnmax");
            if (string2 != null) {
                this.baerKradolferPicker.setTDownMax(string2);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        try {
            string2 = null;
            string2 = seisGram2KFrame.getParameter("timedom.bkpick.dir");
            if (string2 != null) {
                this.baerKradolferPicker.setDirection(string2);
            }
        }
        catch (TimeDomainException timeDomainException) {
            seisGram2KFrame.writeMessage("ERROR: " + timeDomainException.toString());
        }
        this.commandNames = new String[]{"bkpick"};
        this.commandNamesShort = new String[]{"bkp"};
    }

    public void updateLabel() {
        this.label = SeisGramText.BAER_KRADOLFER_PICKER;
        this.button = new AJLJButton(this.seisFrame, this.seisFrame, this.label + "...");
    }

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonApplyBaerKradolferPicker = new AJLJButton(this, this, SeisGramText.APPLY);
        jToolBar.add(this.buttonApplyBaerKradolferPicker);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.LONG_TERM_WINDOW + ":", 4));
        this.textFieldLongTermWindow = SwingExt.newJTextField(this, this, String.valueOf(this.baerKradolferPicker.longTermWindow), 5);
        jToolBar.add(this.textFieldLongTermWindow);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.THRESHOLD1 + ":", 4));
        this.textFieldThreshold1 = SwingExt.newJTextField(this, this, String.valueOf(this.baerKradolferPicker.threshold1), 5);
        jToolBar.add(this.textFieldThreshold1);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.THRESHOLD2 + ":", 4));
        this.textFieldThreshold2 = SwingExt.newJTextField(this, this, String.valueOf(this.baerKradolferPicker.threshold2), 5);
        jToolBar.add(this.textFieldThreshold2);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.TUPEVENT + ":", 4));
        this.textFieldTUpEvent = SwingExt.newJTextField(this, this, String.valueOf(this.baerKradolferPicker.tUpEvent), 5);
        jToolBar.add(this.textFieldTUpEvent);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.TDOWNMAX + ":", 4));
        this.textFieldTDownMax = SwingExt.newJTextField(this, this, String.valueOf(this.baerKradolferPicker.tDownMax), 5);
        jToolBar.add(this.textFieldTDownMax);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.DIRECTION + ":", 4));
        this.choiceDirection = SwingExt.newChoice(this, this.typeNames);
        this.choiceDirection.setSelectedItem(this.baerKradolferPicker.getDirectionString());
        jToolBar.add(this.choiceDirection);
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.RESULT + ":", 4));
        this.choiceResults = SwingExt.newChoice(this, this.resultNames);
        this.choiceResults.setSelectedItem(this.baerKradolferPicker.getResultsTypeString());
        jToolBar.add(this.choiceResults);
        jToolBar.addSeparator();
        jToolBar.validate();
    }

    public void updateComponents() {
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && !this.seisFrame.getActiveGather().isMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonApplyBaerKradolferPicker)) {
            boolean bl = false;
            try {
                this.baerKradolferPicker.setLongTermWindow(this.textFieldLongTermWindow.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldLongTermWindow.setText(String.valueOf(this.baerKradolferPicker.longTermWindow));
            try {
                this.baerKradolferPicker.setThreshold1(this.textFieldThreshold1.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldThreshold1.setText(String.valueOf(this.baerKradolferPicker.threshold1));
            try {
                this.baerKradolferPicker.setThreshold2(this.textFieldThreshold2.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldThreshold2.setText(String.valueOf(this.baerKradolferPicker.threshold2));
            try {
                this.baerKradolferPicker.setTUpEvent(this.textFieldTUpEvent.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldTUpEvent.setText(String.valueOf(this.baerKradolferPicker.tUpEvent));
            try {
                this.baerKradolferPicker.setTDownMax(this.textFieldTDownMax.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            this.textFieldTDownMax.setText(String.valueOf(this.baerKradolferPicker.tDownMax));
            try {
                this.baerKradolferPicker.setDirection((String)this.choiceDirection.getSelectedItem());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            try {
                this.baerKradolferPicker.setResultsType((String)this.choiceResults.getSelectedItem());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                bl = true;
            }
            if (bl) {
                return;
            }
            try {
                this.baerKradolferPicker.checkSettings();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
                return;
            }
            this.variant = 0;
            try {
                this.apply();
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldLongTermWindow)) {
            try {
                this.baerKradolferPicker.setLongTermWindow(this.textFieldLongTermWindow.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldLongTermWindow.setText(String.valueOf(this.baerKradolferPicker.longTermWindow));
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldThreshold1)) {
            try {
                this.baerKradolferPicker.setThreshold1(this.textFieldThreshold1.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldThreshold1.setText(String.valueOf(this.baerKradolferPicker.threshold1));
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldThreshold2)) {
            try {
                this.baerKradolferPicker.setThreshold2(this.textFieldThreshold2.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldThreshold2.setText(String.valueOf(this.baerKradolferPicker.threshold2));
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldTUpEvent)) {
            try {
                this.baerKradolferPicker.setTUpEvent(this.textFieldTUpEvent.getText());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            this.textFieldTUpEvent.setText(String.valueOf(this.baerKradolferPicker.tUpEvent));
            return;
        }
        if (actionEvent.getSource().equals(this.choiceDirection)) {
            try {
                this.baerKradolferPicker.setDirection((String)this.choiceDirection.getSelectedItem());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            return;
        }
        if (actionEvent.getSource().equals(this.choiceResults)) {
            try {
                this.baerKradolferPicker.setResultsType((String)this.choiceResults.getSelectedItem());
            }
            catch (TimeDomainException timeDomainException) {
                this.seisFrame.writeMessage("ERROR: " + timeDomainException.toString());
            }
            return;
        }
    }

    protected void setPickBaerKradolferPicker() {
        Vector vector = this.baerKradolferPicker.getPickData();
        String string = this.baerKradolferPicker.getDirection() > 0 ? "P" : "Pb";
        for (int i = 0; i < vector.size(); ++i) {
            PickData pickData = (PickData)vector.elementAt(i);
            String string2 = string + i;
            this.seisFrame.getActiveGather().setPickFromPickData(pickData, string2);
        }
        this.seisFrame.writePicks();
    }

    protected void apply() throws TimeDomainException {
        this.baerKradolferPicker.checkSettings();
        this.seisFrame.applyTimeDomainProcess(this.baerKradolferPicker, this.getCommandString());
        if (this.baerKradolferPicker.getResultsType() == 0) {
            this.setPickBaerKradolferPicker();
        }
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        try {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string2.equals(this.commandNames[i]) && !string2.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            return true;
        }
        return false;
    }

    public void applyCommand(String string) throws JToolManagerException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        String string2 = " ";
        this.argumentString = string;
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            stringTokenizer.nextToken();
            if (this.variant >= 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.toLowerCase().startsWith("ltw")) {
                        this.baerKradolferPicker.setLongTermWindow(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("thres1")) {
                        this.baerKradolferPicker.setThreshold1(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("thres2")) {
                        this.baerKradolferPicker.setThreshold2(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("tupevt")) {
                        this.baerKradolferPicker.setTUpEvent(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("tdnmax")) {
                        this.baerKradolferPicker.setTDownMax(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("dir")) {
                        this.baerKradolferPicker.setDirection(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("res")) {
                        this.baerKradolferPicker.setResultsType(stringTokenizer.nextToken());
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JToolManagerException("Parsing or applying command", string, string2);
        }
        catch (TimeDomainException timeDomainException) {
            throw new JToolManagerException("Parsing or applying command: ERROR: " + timeDomainException.toString(), string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant];
        string = string + " ltw " + this.baerKradolferPicker.longTermWindow;
        string = string + " thres1 " + this.baerKradolferPicker.threshold1;
        string = string + " thres2 " + this.baerKradolferPicker.threshold2;
        string = string + " tupevt " + this.baerKradolferPicker.tUpEvent;
        string = string + " tdnmax " + this.baerKradolferPicker.tDownMax;
        string = string + " dir " + this.baerKradolferPicker.getDirectionString();
        string = string + " res " + this.baerKradolferPicker.getResultsTypeString();
        return string;
    }
}

