/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.toolmanager;

import java.awt.event.ActionEvent;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.alomax.freq.BandpassFilter;
import net.alomax.freq.FilterException;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.SeisGramText;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.JToolManager;
import net.alomax.swing.JToolManagerException;
import net.alomax.swing.SwingExt;

public abstract class BandpassFilterToolManager
extends JToolManager {
    protected SeisGram2KFrame seisFrame = null;
    protected BandpassFilter bandpassFilter;
    protected AJLJButton buttonApplyBandpassFilter;
    protected JTextField textFieldLowFreqCorner;
    protected JTextField textFieldHighFreqCorner;
    protected JTextField textFieldNumPoles;
    protected static final int BANDPASS = 0;
    protected static final int HIGHPASS = 1;
    protected static final int LOWPASS = 2;
    protected String[] commandNames = new String[0];
    protected String[] commandNamesShort = new String[0];
    protected String[] typeNames = new String[0];
    protected int variant = 0;
    protected int type = 0;
    protected String argumentString = "";

    public void layoutComponents(JToolBar jToolBar) {
        jToolBar.add(new JLabel(this.label + ":"));
        jToolBar.addSeparator();
        this.buttonApplyBandpassFilter = new AJLJButton(this, this, SeisGramText.APPLY);
        if (this.seisFrame.getConfiguration() != 1) {
            jToolBar.add(this.buttonApplyBandpassFilter);
            jToolBar.addSeparator();
        }
        jToolBar.add(new JLabel(SeisGramText.LOW_FREQ + ":", 4));
        this.textFieldLowFreqCorner = SwingExt.newJTextField(this, this, String.valueOf(this.bandpassFilter.lowFreqCorner), 5);
        jToolBar.add(this.textFieldLowFreqCorner);
        jToolBar.add(new JLabel("Hz", 2));
        jToolBar.addSeparator();
        jToolBar.add(new JLabel(SeisGramText.HIGH_FREQ + ":", 4));
        this.textFieldHighFreqCorner = SwingExt.newJTextField(this, this, String.valueOf(this.bandpassFilter.highFreqCorner), 5);
        jToolBar.add(this.textFieldHighFreqCorner);
        jToolBar.add(new JLabel("Hz", 2));
        jToolBar.addSeparator();
        this.textFieldNumPoles = SwingExt.newJTextField(this, this, String.valueOf(this.bandpassFilter.numPoles), 2);
        if (this.seisFrame.getConfiguration() != 1) {
            jToolBar.add(new JLabel(SeisGramText.NUM_POLES + ":", 4));
            jToolBar.add(this.textFieldNumPoles);
        } else {
            jToolBar.addSeparator();
        }
        if (this.seisFrame.getConfiguration() == 1) {
            jToolBar.add(this.buttonApplyBandpassFilter);
        }
        jToolBar.validate();
    }

    public void updateComponents() {
    }

    public void setAWTStates() {
        this.button.setEnabled(this.seisFrame.getActiveGather() != null && !this.seisFrame.getActiveGather().isMonitor());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.buttonApplyBandpassFilter)) {
            boolean bl = false;
            try {
                this.bandpassFilter.setLowFreqCorner(this.textFieldLowFreqCorner.getText());
                this.bandpassFilter.setHighFreqCorner(this.textFieldHighFreqCorner.getText());
                this.bandpassFilter.setNumPoles(this.textFieldNumPoles.getText());
            }
            catch (FilterException filterException) {
                this.seisFrame.writeMessage("ERROR: " + filterException.toString());
                bl = true;
            }
            this.textFieldLowFreqCorner.setText(String.valueOf(this.bandpassFilter.lowFreqCorner));
            this.textFieldHighFreqCorner.setText(String.valueOf(this.bandpassFilter.highFreqCorner));
            this.textFieldNumPoles.setText(String.valueOf(this.bandpassFilter.numPoles));
            if (bl) {
                return;
            }
            this.variant = 0;
            this.type = 0;
            try {
                this.apply();
            }
            catch (FilterException filterException) {
                this.seisFrame.writeMessage("ERROR: " + filterException.toString());
            }
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldLowFreqCorner)) {
            try {
                this.bandpassFilter.setLowFreqCorner(this.textFieldLowFreqCorner.getText());
            }
            catch (FilterException filterException) {
                this.seisFrame.writeMessage("ERROR: " + filterException.toString());
            }
            this.textFieldLowFreqCorner.setText(String.valueOf(this.bandpassFilter.lowFreqCorner));
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldHighFreqCorner)) {
            try {
                this.bandpassFilter.setHighFreqCorner(this.textFieldHighFreqCorner.getText());
            }
            catch (FilterException filterException) {
                this.seisFrame.writeMessage("ERROR: " + filterException.toString());
            }
            this.textFieldHighFreqCorner.setText(String.valueOf(this.bandpassFilter.highFreqCorner));
            return;
        }
        if (actionEvent.getSource().equals(this.textFieldNumPoles)) {
            try {
                this.bandpassFilter.setNumPoles(this.textFieldNumPoles.getText());
            }
            catch (FilterException filterException) {
                this.seisFrame.writeMessage("ERROR: " + filterException.toString());
            }
            this.textFieldNumPoles.setText(String.valueOf(this.bandpassFilter.numPoles));
            return;
        }
    }

    protected void apply() throws FilterException {
        this.bandpassFilter.checkSettings();
        this.seisFrame.applyFreqProcess(this.bandpassFilter, null, this.getCommandString());
    }

    public boolean isCommandHandler(String string) {
        String string2 = string.trim().toLowerCase();
        String string3 = string.trim().toLowerCase();
        try {
            string3 = string3.substring(0, string3.indexOf(32));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.commandNames.length; ++i) {
            if (!string3.equals(this.commandNames[i]) && !string3.equals(this.commandNamesShort[i])) continue;
            this.variant = i;
            for (int j = 0; j < this.typeNames.length; ++j) {
                if (string2.indexOf(this.typeNames[j]) < 0) continue;
                this.type = j;
                this.argumentString = string2.substring(string2.indexOf(this.typeNames[j]) + this.typeNames[j].length());
                return true;
            }
        }
        return false;
    }

    public void applyCommand(String string) throws JToolManagerException {
        if (!this.isCommandHandler(string)) {
            throw new JToolManagerException("Not command handler: " + string);
        }
        String string2 = " ";
        StringTokenizer stringTokenizer = new StringTokenizer(this.argumentString);
        try {
            if (this.variant >= 0) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (string2.equalsIgnoreCase("n")) {
                        this.bandpassFilter.setNumPoles(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.toLowerCase().startsWith("co")) {
                        if (this.variant == 1) {
                            this.bandpassFilter.setLowFreqCorner(stringTokenizer.nextToken());
                            this.bandpassFilter.setHighFreqCorner(1.0E8);
                            continue;
                        }
                        if (this.variant == 2) {
                            this.bandpassFilter.setLowFreqCorner(1.0E-8);
                            this.bandpassFilter.setHighFreqCorner(stringTokenizer.nextToken());
                            continue;
                        }
                        this.bandpassFilter.setLowFreqCorner(stringTokenizer.nextToken());
                        this.bandpassFilter.setHighFreqCorner(stringTokenizer.nextToken());
                        continue;
                    }
                    throw new JToolManagerException("Parsing or applying command", string, string2);
                }
                this.apply();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new JToolManagerException("Parsing or applying command", string, string2);
        }
        catch (FilterException filterException) {
            throw new JToolManagerException("Parsing or applying command: ERROR: " + filterException.toString(), string, string2);
        }
    }

    public String getCommandString() {
        if (this.variant < 0) {
            return "???";
        }
        String string = this.commandNamesShort[this.variant] + " " + this.typeNames[this.type];
        string = string + " n " + this.bandpassFilter.numPoles;
        string = this.variant == 1 ? string + " co " + this.bandpassFilter.lowFreqCorner : (this.variant == 2 ? string + " co " + this.bandpassFilter.highFreqCorner : string + " co " + this.bandpassFilter.lowFreqCorner + " " + this.bandpassFilter.highFreqCorner);
        return string;
    }
}

