/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import java.util.LinkedHashMap;
import java.util.Vector;
import net.alomax.freq.SimpleAmplificationResponse;
import net.alomax.io.BinaryInputStream;
import net.alomax.io.BinaryOutputStream;
import net.alomax.math.TimeSeriesFloat;
import net.alomax.seis.BasicHypocenter;
import net.alomax.seis.BasicSeismogram;
import net.alomax.seis.SeisData;
import net.alomax.util.PhysicalUnits;
import net.alomax.util.TimeInstant;
import orfeus.srem.BasicReading;
import sdsu.io.ASCIIInputStream;

public class SeisDataSac
extends SeisData {
    static final float F_UNDEF = -12345.0f;
    static final int N_UNDEF = -12345;
    static final int I_UNDEF = -12345;
    static final boolean L_UNDEF = false;
    static final String K_UNDEF = "-12345";
    static final int ITIME = 1;
    static final int IRLIM = 2;
    static final int IAMPH = 3;
    static final int IXY = 4;
    static final int IUNKN = 5;
    static final int IDISP = 6;
    static final int IVEL = 7;
    static final int IACC = 8;
    static final int IB = 9;
    static final int IDAY = 10;
    static final int IO = 11;
    static final int IA = 12;
    static final int IT0 = 13;
    static final int IT1 = 14;
    static final int IT2 = 15;
    static final int IT3 = 16;
    static final int IT4 = 17;
    static final int IT5 = 18;
    static final int IT6 = 19;
    static final int IT7 = 20;
    static final int IT8 = 21;
    static final int IT9 = 22;
    static final int IRADNV = 23;
    static final int ITANNV = 24;
    static final int IRADEV = 25;
    static final int ITANEV = 26;
    static final int INORTH = 27;
    static final int IEAST = 28;
    static final int IHORZA = 29;
    static final int IDOWN = 30;
    static final int IUP = 31;
    static final int ILLLBB = 32;
    static final int IWWSN1 = 33;
    static final int IWWSN2 = 34;
    static final int IHGLP = 35;
    static final int ISRO = 36;
    static final int INUCL = 37;
    static final int IPREN = 38;
    static final int IPOSTN = 39;
    static final int IQUAKE = 40;
    static final int IPREQ = 41;
    static final int IPOSTQ = 42;
    static final int ICHEM = 43;
    static final int IOTHER = 44;
    static final int IGOOD = 45;
    static final int IGLCH = 46;
    static final int IDROP = 47;
    static final int ILOWSN = 48;
    static final int IRLDTA = 49;
    static final int IVOLTS = 50;
    static final int IXYZ = 51;
    static final int IMB = 52;
    static final int IMS = 53;
    static final int IML = 54;
    static final int IMW = 55;
    static final int IMD = 56;
    static final int IMX = 57;
    static final int INEIC = 58;
    static final int IPDE = 59;
    static final int IISC = 60;
    static final int IREB = 61;
    static final int IUSGS = 62;
    static final int IBRK = 63;
    static final int ICALTECH = 64;
    static final int ILLNL = 65;
    static final int IEVLOC = 66;
    static final int IJSOP = 67;
    static final int IUSER = 68;
    static final int IUNKNOWN = 69;
    static final int IQB = 70;
    static final int IQB1 = 71;
    static final int IQB2 = 72;
    static final int IQBX = 73;
    static final int IQMT = 74;
    static final int IEQ = 75;
    static final int IEQ1 = 76;
    static final int IEQ2 = 77;
    static final int IME = 78;
    static final int IEX = 79;
    static final int INU = 80;
    static final int INC = 81;
    static final int IO_ = 82;
    static final int IL = 83;
    static final int IR = 84;
    static final int IT = 85;
    static final int IU = 86;
    int NPTS = -12345;
    float B = -12345.0f;
    float E = -12345.0f;
    int IFTYPE = 1;
    boolean LEVEN = true;
    float DELTA = -12345.0f;
    float ODELTA = -12345.0f;
    int IDEP = 5;
    float SCALE = -12345.0f;
    float DEPMIN = -12345.0f;
    float DEPMAX = -12345.0f;
    float DEPMEN = -12345.0f;
    int NZYEAR = -12345;
    int NZJDAY = -12345;
    int NZHOUR = -12345;
    int NZMIN = -12345;
    int NZSEC = -12345;
    int NZMSEC = -12345;
    String KZDATE = "-12345";
    String KZTIME = "-12345";
    float O = -12345.0f;
    String KO = "-12345";
    float A = -12345.0f;
    String AMARKER = "-12345";
    String KA = "-12345";
    float F = -12345.0f;
    String KF = "-12345";
    float T0 = -12345.0f;
    float T1 = -12345.0f;
    float T2 = -12345.0f;
    float T3 = -12345.0f;
    float T4 = -12345.0f;
    float T5 = -12345.0f;
    float T6 = -12345.0f;
    float T7 = -12345.0f;
    float T8 = -12345.0f;
    float T9 = -12345.0f;
    String KT0 = "-12345";
    String KT1 = "-12345";
    String KT2 = "-12345";
    String KT3 = "-12345";
    String KT4 = "-12345";
    String KT5 = "-12345";
    String KT6 = "-12345";
    String KT7 = "-12345";
    String KT8 = "-12345";
    String KT9 = "-12345";
    int IZTYPE = 9;
    String KINST = "-12345";
    int IINST = -12345;
    float RESP0 = -12345.0f;
    float RESP1 = -12345.0f;
    float RESP2 = -12345.0f;
    float RESP3 = -12345.0f;
    float RESP4 = -12345.0f;
    float RESP5 = -12345.0f;
    float RESP6 = -12345.0f;
    float RESP7 = -12345.0f;
    float RESP8 = -12345.0f;
    float RESP9 = -12345.0f;
    String KNETWK = "-12345";
    String KSTNM = "-12345";
    int ISTREG = -12345;
    float STLA = -12345.0f;
    float STLO = -12345.0f;
    float STEL = -12345.0f;
    float STDP = -12345.0f;
    float CMPAZ = -12345.0f;
    float XMINIMUM = -12345.0f;
    float XMAXIMUM = -12345.0f;
    float YMINIMUM = -12345.0f;
    float YMAXIMUM = -12345.0f;
    float CMPINC = -12345.0f;
    String KCMPNM = "-12345";
    String KSTCMP = "-12345";
    boolean LPSPOL = true;
    float ADJTM = -12345.0f;
    String KEVNM = "-12345";
    int IEVREG = -12345;
    float EVLA = -12345.0f;
    float EVLO = -12345.0f;
    float EVEL = -12345.0f;
    float EVDP = -12345.0f;
    float MAG = -12345.0f;
    int IEVTYP = -12345;
    String KHOLE = "-12345";
    float DIST = -12345.0f;
    float AZ = -12345.0f;
    float BAZ = -12345.0f;
    float GCARC = -12345.0f;
    boolean LCALDA = true;
    int IQUAL = -12345;
    int ISYNTH = -12345;
    int IMAGTYP = -12345;
    int IMAGSRC = -12345;
    String KDATRD = "-12345";
    float USER0 = -12345.0f;
    float USER1 = -12345.0f;
    float USER2 = -12345.0f;
    float USER3 = -12345.0f;
    float USER4 = -12345.0f;
    float USER5 = -12345.0f;
    float USER6 = -12345.0f;
    float USER7 = -12345.0f;
    float USER8 = -12345.0f;
    float USER9 = -12345.0f;
    String KUSER0 = "-12345";
    String KUSER1 = "-12345";
    String KUSER2 = "-12345";
    boolean LOVROK = false;
    int NVHDR = 6;
    float FUNUSED = -12345.0f;
    int IUNUSED = -12345;
    boolean LUNUSED = false;
    float FINTERNAL = -12345.0f;
    int IINTERNAL = -12345;
    float[] sample = null;
    float ampMin = -12345.0f;
    float ampMax = -12345.0f;
    double unitsToNanometersScale = 1.0;

    public void read(BinaryInputStream binaryInputStream) throws Exception {
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[16];
        this.DELTA = binaryInputStream.readFloatB();
        this.DEPMIN = binaryInputStream.readFloatB();
        this.DEPMAX = binaryInputStream.readFloatB();
        this.SCALE = binaryInputStream.readFloatB();
        this.ODELTA = binaryInputStream.readFloatB();
        this.B = binaryInputStream.readFloatB();
        this.E = binaryInputStream.readFloatB();
        this.O = binaryInputStream.readFloatB();
        this.A = binaryInputStream.readFloatB();
        this.FINTERNAL = binaryInputStream.readFloatB();
        this.T0 = binaryInputStream.readFloatB();
        this.T1 = binaryInputStream.readFloatB();
        this.T2 = binaryInputStream.readFloatB();
        this.T3 = binaryInputStream.readFloatB();
        this.T4 = binaryInputStream.readFloatB();
        this.T5 = binaryInputStream.readFloatB();
        this.T6 = binaryInputStream.readFloatB();
        this.T7 = binaryInputStream.readFloatB();
        this.T8 = binaryInputStream.readFloatB();
        this.T9 = binaryInputStream.readFloatB();
        this.F = binaryInputStream.readFloatB();
        this.RESP0 = binaryInputStream.readFloatB();
        this.RESP1 = binaryInputStream.readFloatB();
        this.RESP2 = binaryInputStream.readFloatB();
        this.RESP3 = binaryInputStream.readFloatB();
        this.RESP4 = binaryInputStream.readFloatB();
        this.RESP5 = binaryInputStream.readFloatB();
        this.RESP6 = binaryInputStream.readFloatB();
        this.RESP7 = binaryInputStream.readFloatB();
        this.RESP8 = binaryInputStream.readFloatB();
        this.RESP9 = binaryInputStream.readFloatB();
        this.STLA = binaryInputStream.readFloatB();
        this.STLO = binaryInputStream.readFloatB();
        this.STEL = binaryInputStream.readFloatB();
        this.STDP = binaryInputStream.readFloatB();
        this.EVLA = binaryInputStream.readFloatB();
        this.EVLO = binaryInputStream.readFloatB();
        this.EVEL = binaryInputStream.readFloatB();
        this.EVDP = binaryInputStream.readFloatB();
        this.MAG = binaryInputStream.readFloatB();
        this.USER0 = binaryInputStream.readFloatB();
        this.USER1 = binaryInputStream.readFloatB();
        this.USER2 = binaryInputStream.readFloatB();
        this.USER3 = binaryInputStream.readFloatB();
        this.USER4 = binaryInputStream.readFloatB();
        this.USER5 = binaryInputStream.readFloatB();
        this.USER6 = binaryInputStream.readFloatB();
        this.USER7 = binaryInputStream.readFloatB();
        this.USER8 = binaryInputStream.readFloatB();
        this.USER9 = binaryInputStream.readFloatB();
        this.DIST = binaryInputStream.readFloatB();
        this.AZ = binaryInputStream.readFloatB();
        this.BAZ = binaryInputStream.readFloatB();
        this.GCARC = binaryInputStream.readFloatB();
        this.FINTERNAL = binaryInputStream.readFloatB();
        this.FINTERNAL = binaryInputStream.readFloatB();
        this.DEPMEN = binaryInputStream.readFloatB();
        this.CMPAZ = binaryInputStream.readFloatB();
        this.CMPINC = binaryInputStream.readFloatB();
        this.XMINIMUM = binaryInputStream.readFloatB();
        this.XMAXIMUM = binaryInputStream.readFloatB();
        this.YMINIMUM = binaryInputStream.readFloatB();
        this.YMAXIMUM = binaryInputStream.readFloatB();
        this.ADJTM = binaryInputStream.readFloatB();
        this.FUNUSED = binaryInputStream.readFloatB();
        this.FUNUSED = binaryInputStream.readFloatB();
        this.FUNUSED = binaryInputStream.readFloatB();
        this.FUNUSED = binaryInputStream.readFloatB();
        this.FUNUSED = binaryInputStream.readFloatB();
        this.FUNUSED = binaryInputStream.readFloatB();
        this.NZYEAR = binaryInputStream.readIntB();
        this.NZJDAY = binaryInputStream.readIntB();
        this.NZHOUR = binaryInputStream.readIntB();
        this.NZMIN = binaryInputStream.readIntB();
        this.NZSEC = binaryInputStream.readIntB();
        this.NZMSEC = binaryInputStream.readIntB();
        this.NVHDR = binaryInputStream.readIntB();
        this.IINTERNAL = binaryInputStream.readIntB();
        this.IINTERNAL = binaryInputStream.readIntB();
        this.NPTS = binaryInputStream.readIntB();
        this.IINTERNAL = binaryInputStream.readIntB();
        this.IINTERNAL = binaryInputStream.readIntB();
        this.IUNUSED = binaryInputStream.readIntB();
        this.IUNUSED = binaryInputStream.readIntB();
        this.IUNUSED = binaryInputStream.readIntB();
        this.IFTYPE = binaryInputStream.readIntB();
        this.IDEP = binaryInputStream.readIntB();
        this.IZTYPE = binaryInputStream.readIntB();
        this.IUNUSED = binaryInputStream.readIntB();
        this.IINST = binaryInputStream.readIntB();
        this.ISTREG = binaryInputStream.readIntB();
        this.IEVREG = binaryInputStream.readIntB();
        this.IEVTYP = binaryInputStream.readIntB();
        this.IQUAL = binaryInputStream.readIntB();
        this.ISYNTH = binaryInputStream.readIntB();
        this.IMAGTYP = binaryInputStream.readIntB();
        this.IMAGSRC = binaryInputStream.readIntB();
        this.IUNUSED = binaryInputStream.readIntB();
        this.IUNUSED = binaryInputStream.readIntB();
        this.IUNUSED = binaryInputStream.readIntB();
        this.IUNUSED = binaryInputStream.readIntB();
        this.IUNUSED = binaryInputStream.readIntB();
        this.IUNUSED = binaryInputStream.readIntB();
        this.IUNUSED = binaryInputStream.readIntB();
        this.IUNUSED = binaryInputStream.readIntB();
        this.LEVEN = binaryInputStream.readIntB() == 1;
        this.LPSPOL = binaryInputStream.readIntB() == 1;
        this.LOVROK = binaryInputStream.readIntB() == 1;
        this.LCALDA = binaryInputStream.readIntB() == 1;
        this.LUNUSED = binaryInputStream.readIntB() == 1;
        binaryInputStream.read(byArray, 0, 8);
        this.KSTNM = new String(byArray).trim();
        binaryInputStream.read(byArray2, 0, 16);
        this.KEVNM = new String(byArray2).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KHOLE = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KO = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KA = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KT0 = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KT1 = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KT2 = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KT3 = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KT4 = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KT5 = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KT6 = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KT7 = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KT8 = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KT9 = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KF = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KUSER0 = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KUSER1 = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KUSER2 = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KCMPNM = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KNETWK = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KDATRD = new String(byArray).trim();
        binaryInputStream.read(byArray, 0, 8);
        this.KINST = new String(byArray).trim();
        this.sample = new float[this.NPTS];
        for (int i = 0; i < this.NPTS; ++i) {
            this.sample[i] = binaryInputStream.readFloatB();
        }
    }

    public static int canRead(BinaryInputStream binaryInputStream) {
        try {
            int n;
            int n2;
            int n3 = 70;
            float f = binaryInputStream.readFloatB();
            if ((double)f <= 0.0) {
                return -1;
            }
            --n3;
            float f2 = binaryInputStream.readFloatB();
            --n3;
            float f3 = binaryInputStream.readFloatB();
            --n3;
            float f4 = binaryInputStream.readFloatB();
            --n3;
            float f5 = binaryInputStream.readFloatB();
            --n3;
            float f6 = binaryInputStream.readFloatB();
            if ((double)f6 > 0.0 && (double)f5 > 0.0 && (double)(f6 - f5) <= 0.0) {
                return -1;
            }
            --n3;
            for (n2 = 0; n2 < n3; ++n2) {
                binaryInputStream.readFloatB();
            }
            n2 = 9;
            for (n = 0; n < n2; ++n) {
                binaryInputStream.readIntB();
            }
            n = binaryInputStream.readIntB();
            if (n < 0 || n > 10000000) {
                return -1;
            }
            if ((double)f6 > 0.0 && (double)f5 > 0.0) {
                float f7 = f6 - f5;
                float f8 = (float)n * f;
                if ((double)f7 < 0.5 * (double)f8) {
                    return -1;
                }
                if ((double)f7 > 1.5 * (double)f8) {
                    return -1;
                }
            }
            return 1;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public void read(ASCIIInputStream aSCIIInputStream) throws Exception {
        this.DELTA = aSCIIInputStream.readFloat();
        this.DEPMIN = aSCIIInputStream.readFloat();
        this.DEPMAX = aSCIIInputStream.readFloat();
        this.SCALE = aSCIIInputStream.readFloat();
        this.ODELTA = aSCIIInputStream.readFloat();
        aSCIIInputStream.flushLine();
        this.B = aSCIIInputStream.readFloat();
        this.E = aSCIIInputStream.readFloat();
        this.O = aSCIIInputStream.readFloat();
        this.A = aSCIIInputStream.readFloat();
        this.FINTERNAL = aSCIIInputStream.readFloat();
        aSCIIInputStream.flushLine();
        this.T0 = aSCIIInputStream.readFloat();
        this.T1 = aSCIIInputStream.readFloat();
        this.T2 = aSCIIInputStream.readFloat();
        this.T3 = aSCIIInputStream.readFloat();
        this.T4 = aSCIIInputStream.readFloat();
        aSCIIInputStream.flushLine();
        this.T5 = aSCIIInputStream.readFloat();
        this.T6 = aSCIIInputStream.readFloat();
        this.T7 = aSCIIInputStream.readFloat();
        this.T8 = aSCIIInputStream.readFloat();
        this.T9 = aSCIIInputStream.readFloat();
        aSCIIInputStream.flushLine();
        this.F = aSCIIInputStream.readFloat();
        this.RESP0 = aSCIIInputStream.readFloat();
        this.RESP1 = aSCIIInputStream.readFloat();
        this.RESP2 = aSCIIInputStream.readFloat();
        this.RESP3 = aSCIIInputStream.readFloat();
        aSCIIInputStream.flushLine();
        this.RESP4 = aSCIIInputStream.readFloat();
        this.RESP5 = aSCIIInputStream.readFloat();
        this.RESP6 = aSCIIInputStream.readFloat();
        this.RESP7 = aSCIIInputStream.readFloat();
        this.RESP8 = aSCIIInputStream.readFloat();
        aSCIIInputStream.flushLine();
        this.RESP9 = aSCIIInputStream.readFloat();
        this.STLA = aSCIIInputStream.readFloat();
        this.STLO = aSCIIInputStream.readFloat();
        this.STEL = aSCIIInputStream.readFloat();
        this.STDP = aSCIIInputStream.readFloat();
        aSCIIInputStream.flushLine();
        this.EVLA = aSCIIInputStream.readFloat();
        this.EVLO = aSCIIInputStream.readFloat();
        this.EVEL = aSCIIInputStream.readFloat();
        this.EVDP = aSCIIInputStream.readFloat();
        this.MAG = aSCIIInputStream.readFloat();
        aSCIIInputStream.flushLine();
        this.USER0 = aSCIIInputStream.readFloat();
        this.USER1 = aSCIIInputStream.readFloat();
        this.USER2 = aSCIIInputStream.readFloat();
        this.USER3 = aSCIIInputStream.readFloat();
        this.USER4 = aSCIIInputStream.readFloat();
        aSCIIInputStream.flushLine();
        this.USER5 = aSCIIInputStream.readFloat();
        this.USER6 = aSCIIInputStream.readFloat();
        this.USER7 = aSCIIInputStream.readFloat();
        this.USER8 = aSCIIInputStream.readFloat();
        this.USER9 = aSCIIInputStream.readFloat();
        aSCIIInputStream.flushLine();
        this.DIST = aSCIIInputStream.readFloat();
        this.AZ = aSCIIInputStream.readFloat();
        this.BAZ = aSCIIInputStream.readFloat();
        this.GCARC = aSCIIInputStream.readFloat();
        this.FINTERNAL = aSCIIInputStream.readFloat();
        aSCIIInputStream.flushLine();
        this.FINTERNAL = aSCIIInputStream.readFloat();
        this.DEPMEN = aSCIIInputStream.readFloat();
        this.CMPAZ = aSCIIInputStream.readFloat();
        this.CMPINC = aSCIIInputStream.readFloat();
        this.XMINIMUM = aSCIIInputStream.readFloat();
        aSCIIInputStream.flushLine();
        this.XMAXIMUM = aSCIIInputStream.readFloat();
        this.YMINIMUM = aSCIIInputStream.readFloat();
        this.YMAXIMUM = aSCIIInputStream.readFloat();
        this.ADJTM = aSCIIInputStream.readFloat();
        this.FUNUSED = aSCIIInputStream.readFloat();
        aSCIIInputStream.flushLine();
        this.FUNUSED = aSCIIInputStream.readFloat();
        this.FUNUSED = aSCIIInputStream.readFloat();
        this.FUNUSED = aSCIIInputStream.readFloat();
        this.FUNUSED = aSCIIInputStream.readFloat();
        this.FUNUSED = aSCIIInputStream.readFloat();
        aSCIIInputStream.flushLine();
        this.NZYEAR = aSCIIInputStream.readInt();
        this.NZJDAY = aSCIIInputStream.readInt();
        this.NZHOUR = aSCIIInputStream.readInt();
        this.NZMIN = aSCIIInputStream.readInt();
        this.NZSEC = aSCIIInputStream.readInt();
        aSCIIInputStream.flushLine();
        this.NZMSEC = aSCIIInputStream.readInt();
        this.NVHDR = aSCIIInputStream.readInt();
        this.IINTERNAL = aSCIIInputStream.readInt();
        this.IINTERNAL = aSCIIInputStream.readInt();
        this.NPTS = aSCIIInputStream.readInt();
        aSCIIInputStream.flushLine();
        this.IINTERNAL = aSCIIInputStream.readInt();
        this.IINTERNAL = aSCIIInputStream.readInt();
        this.IUNUSED = aSCIIInputStream.readInt();
        this.IUNUSED = aSCIIInputStream.readInt();
        this.IUNUSED = aSCIIInputStream.readInt();
        aSCIIInputStream.flushLine();
        this.IFTYPE = aSCIIInputStream.readInt();
        this.IDEP = aSCIIInputStream.readInt();
        this.IZTYPE = aSCIIInputStream.readInt();
        this.IUNUSED = aSCIIInputStream.readInt();
        this.IINST = aSCIIInputStream.readInt();
        aSCIIInputStream.flushLine();
        this.ISTREG = aSCIIInputStream.readInt();
        this.IEVREG = aSCIIInputStream.readInt();
        this.IEVTYP = aSCIIInputStream.readInt();
        this.IQUAL = aSCIIInputStream.readInt();
        this.ISYNTH = aSCIIInputStream.readInt();
        aSCIIInputStream.flushLine();
        this.IMAGTYP = aSCIIInputStream.readInt();
        this.IMAGSRC = aSCIIInputStream.readInt();
        this.IUNUSED = aSCIIInputStream.readInt();
        this.IUNUSED = aSCIIInputStream.readInt();
        this.IUNUSED = aSCIIInputStream.readInt();
        aSCIIInputStream.flushLine();
        this.IUNUSED = aSCIIInputStream.readInt();
        this.IUNUSED = aSCIIInputStream.readInt();
        this.IUNUSED = aSCIIInputStream.readInt();
        this.IUNUSED = aSCIIInputStream.readInt();
        this.IUNUSED = aSCIIInputStream.readInt();
        aSCIIInputStream.flushLine();
        this.LEVEN = aSCIIInputStream.readInt() == 1;
        this.LPSPOL = aSCIIInputStream.readInt() == 1;
        this.LOVROK = aSCIIInputStream.readInt() == 1;
        this.LCALDA = aSCIIInputStream.readInt() == 1;
        this.LUNUSED = aSCIIInputStream.readInt() == 1;
        aSCIIInputStream.flushLine();
        this.KSTNM = aSCIIInputStream.readWord();
        this.KEVNM = aSCIIInputStream.readWord();
        aSCIIInputStream.flushLine();
        this.KHOLE = aSCIIInputStream.readWord();
        this.KO = aSCIIInputStream.readWord();
        this.KA = aSCIIInputStream.readWord();
        aSCIIInputStream.flushLine();
        this.KT0 = aSCIIInputStream.readWord();
        this.KT1 = aSCIIInputStream.readWord();
        this.KT2 = aSCIIInputStream.readWord();
        aSCIIInputStream.flushLine();
        this.KT3 = aSCIIInputStream.readWord();
        this.KT4 = aSCIIInputStream.readWord();
        this.KT5 = aSCIIInputStream.readWord();
        aSCIIInputStream.flushLine();
        this.KT6 = aSCIIInputStream.readWord();
        this.KT7 = aSCIIInputStream.readWord();
        this.KT8 = aSCIIInputStream.readWord();
        aSCIIInputStream.flushLine();
        this.KT9 = aSCIIInputStream.readWord();
        this.KF = aSCIIInputStream.readWord();
        this.KUSER0 = aSCIIInputStream.readWord();
        aSCIIInputStream.flushLine();
        this.KUSER1 = aSCIIInputStream.readWord();
        this.KUSER2 = aSCIIInputStream.readWord();
        this.KCMPNM = aSCIIInputStream.readWord();
        aSCIIInputStream.flushLine();
        this.KNETWK = aSCIIInputStream.readWord();
        this.KDATRD = aSCIIInputStream.readWord();
        this.KINST = aSCIIInputStream.readWord();
        aSCIIInputStream.flushLine();
        this.sample = new float[this.NPTS];
        for (int i = 0; i < this.NPTS && !aSCIIInputStream.eof(); ++i) {
            this.sample[i] = aSCIIInputStream.readFloat();
        }
        aSCIIInputStream.flushLine();
    }

    public static int canRead(ASCIIInputStream aSCIIInputStream) {
        try {
            int n;
            int n2;
            int n3 = 70;
            float f = aSCIIInputStream.readFloat();
            if ((double)f <= 0.0) {
                return -1;
            }
            --n3;
            float f2 = aSCIIInputStream.readFloat();
            --n3;
            float f3 = aSCIIInputStream.readFloat();
            --n3;
            float f4 = aSCIIInputStream.readFloat();
            --n3;
            float f5 = aSCIIInputStream.readFloat();
            --n3;
            float f6 = aSCIIInputStream.readFloat();
            if ((double)f6 > 0.0 && (double)f5 > 0.0 && (double)(f6 - f5) <= 0.0) {
                return -1;
            }
            --n3;
            for (n2 = 0; n2 < n3; ++n2) {
                aSCIIInputStream.readFloat();
            }
            n2 = 9;
            for (n = 0; n < n2; ++n) {
                aSCIIInputStream.readInt();
            }
            n = aSCIIInputStream.readInt();
            if (n < 0 || n > 10000000) {
                return -1;
            }
            if ((double)f6 > 0.0 && (double)f5 > 0.0) {
                float f7 = f6 - f5;
                float f8 = (float)n * f;
                if ((double)f7 < 0.5 * (double)f8) {
                    return -1;
                }
                if ((double)f7 > 1.5 * (double)f8) {
                    return -1;
                }
            }
            return 1;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public void setSeismogramFields() {
        double d;
        SeisDataSac seisDataSac = this;
        String string = "counts";
        switch (this.IDEP) {
            case 6: {
                string = "nm";
                break;
            }
            case 7: {
                string = PhysicalUnits.timeDerivative("nm");
                break;
            }
            case 8: {
                string = PhysicalUnits.timeDerivative(PhysicalUnits.timeDerivative("nm"));
                break;
            }
            case 50: {
                string = "volts";
            }
        }
        float f = seisDataSac.DELTA;
        this.timeSeries = new TimeSeriesFloat(seisDataSac.sample, f, 0.0, string, "sec");
        this.timeMin = seisDataSac.B;
        int n = seisDataSac.NZYEAR;
        int n2 = seisDataSac.NZJDAY;
        int n3 = seisDataSac.NZHOUR;
        int n4 = seisDataSac.NZMIN;
        double d2 = seisDataSac.NZSEC;
        if (seisDataSac.NZMSEC != -12345) {
            d2 += (double)seisDataSac.NZMSEC / 1000.0;
        }
        while (d2 < 0.0) {
            d2 += 60.0;
            --n4;
        }
        while (n4 < 0) {
            n4 += 60;
            --n3;
        }
        while (n3 < 0) {
            n3 += 24;
            --n2;
        }
        this.iyear = n;
        this.ijday = n2;
        this.ihour = n3;
        this.imin = n4;
        this.sec = d2;
        if (seisDataSac.KNETWK.compareTo(K_UNDEF) != 0) {
            this.channel.network = seisDataSac.KNETWK.replace(' ', '_');
        }
        if (seisDataSac.KSTNM.compareTo(K_UNDEF) != 0) {
            this.channel.staName = seisDataSac.KSTNM.replace(' ', '_');
        }
        if (seisDataSac.KINST.compareTo(K_UNDEF) != 0) {
            this.channel.instName = seisDataSac.KINST.replace(' ', '_');
        }
        if (seisDataSac.KCMPNM.compareTo(K_UNDEF) != 0) {
            this.channel.chanName = seisDataSac.KCMPNM.replace(' ', '_');
        }
        if (seisDataSac.KHOLE.compareTo(K_UNDEF) != 0) {
            this.channel.locName = seisDataSac.KHOLE.replace(' ', '_');
        }
        if (seisDataSac.KEVNM.indexOf(K_UNDEF) < 0) {
            this.evtName = seisDataSac.KEVNM.replace(' ', '_');
        }
        double d3 = seisDataSac.CMPAZ == -12345.0f ? Double.MAX_VALUE : (double)seisDataSac.CMPAZ;
        double d4 = d = seisDataSac.CMPINC == -12345.0f ? Double.MAX_VALUE : (double)seisDataSac.CMPINC;
        if (seisDataSac.KCMPNM.length() > 2) {
            if (seisDataSac.KCMPNM.substring(2, 3).toUpperCase().compareTo("Z") == 0) {
                if (d <= 1.0E-5 || d >= 179.99999) {
                    d3 = 0.0;
                    if (!(d >= 179.99999) || !(d <= 180.00001)) {
                        d = 0.0;
                    }
                } else {
                    System.out.println("WARNING: unusual inclination for " + seisDataSac.KCMPNM + " component: " + d);
                }
            } else if (seisDataSac.KCMPNM.substring(2, 3).toUpperCase().compareTo("N") == 0) {
                if (d3 <= 1.0E-5 || d3 >= 359.99999) {
                    d3 = 0.0;
                    d = 90.0;
                } else {
                    System.out.println("WARNING: unusual azimuth for " + seisDataSac.KCMPNM + " component: " + d3);
                }
            } else if (seisDataSac.KCMPNM.substring(2, 3).toUpperCase().compareTo("E") == 0) {
                if (d3 <= 1.0E-5 || d3 >= 359.99999 || d3 >= 89.99999 && d3 <= 90.00001) {
                    d3 = 90.0;
                    d = 90.0;
                } else {
                    System.out.println("WARNING: unusual azimuth for " + seisDataSac.KCMPNM + " component: " + d3);
                }
            }
        }
        this.channel.azimuth = d3;
        this.channel.inclination = d;
        if (seisDataSac.STLA != -12345.0f) {
            this.channel.staPosition.latitude = seisDataSac.STLA;
        }
        if (seisDataSac.STLO != -12345.0f) {
            this.channel.staPosition.longitude = seisDataSac.STLO;
        }
        if (seisDataSac.STEL != -12345.0f) {
            this.channel.staPosition.elevation = (double)seisDataSac.STEL / 1000.0;
        }
        if (seisDataSac.STDP != -12345.0f) {
            this.channel.staPosition.depth = (double)seisDataSac.STDP / 1000.0;
        }
        if (seisDataSac.O != -12345.0f) {
            TimeInstant timeInstant = new TimeInstant(this.iyear, this.ijday, this.ihour, this.imin, this.sec);
            try {
                this.hypocenter.otime = new TimeInstant(timeInstant.getMillisecondTime() + (double)seisDataSac.O * 1000.0);
            }
            catch (Exception exception) {
                this.hypocenter.otime = BasicHypocenter.UNDEF_OTIME;
            }
        }
        if (seisDataSac.EVLA != -12345.0f) {
            this.hypocenter.position.latitude = seisDataSac.EVLA;
        }
        if (seisDataSac.EVLO != -12345.0f) {
            this.hypocenter.position.longitude = seisDataSac.EVLO;
        }
        if (seisDataSac.EVEL != -12345.0f) {
            this.hypocenter.position.elevation = (double)seisDataSac.EVEL / 1000.0;
        }
        if (seisDataSac.EVDP != -12345.0f) {
            this.hypocenter.position.depth = (double)seisDataSac.EVDP / 1000.0;
        }
        if (seisDataSac.MAG != -12345.0f) {
            this.hypocenter.mag = seisDataSac.MAG;
            if (seisDataSac.IMAGTYP != -12345) {
                if (seisDataSac.IMAGTYP == 52) {
                    this.hypocenter.mb = seisDataSac.MAG;
                } else if (seisDataSac.IMAGTYP == 53) {
                    this.hypocenter.ms = seisDataSac.MAG;
                } else if (seisDataSac.IMAGTYP == 54) {
                    this.hypocenter.ml = seisDataSac.MAG;
                } else if (seisDataSac.IMAGTYP == 55) {
                    this.hypocenter.mw = seisDataSac.MAG;
                } else if (seisDataSac.IMAGTYP == 56) {
                    this.hypocenter.mag = seisDataSac.MAG;
                }
            }
        }
        if (seisDataSac.DIST != -12345.0f) {
            this.dist = seisDataSac.DIST;
        }
        if (seisDataSac.GCARC != -12345.0f) {
            this.gcarc = seisDataSac.GCARC;
        }
        if (seisDataSac.AZ != -12345.0f) {
            this.az = seisDataSac.AZ;
        }
        if (seisDataSac.BAZ != -12345.0f) {
            this.baz = seisDataSac.BAZ;
        }
    }

    public void getSeismogramFields(BasicSeismogram basicSeismogram) {
        double d;
        SeisDataSac seisDataSac = this;
        seisDataSac.sample = basicSeismogram.timeSeries.getSampleAsFloat();
        seisDataSac.NPTS = seisDataSac.sample.length;
        seisDataSac.DELTA = (float)basicSeismogram.timeSeries.sampleInt;
        seisDataSac.IDEP = 5;
        System.out.println("unitsToNanometersScale : " + this.unitsToNanometersScale);
        this.unitsToNanometersScale = 1.0;
        this.unitsToNanometersScale = PhysicalUnits.scaleFactor(basicSeismogram.timeSeries.ampUnits, "nm");
        if (d > 0.0) {
            seisDataSac.IDEP = 6;
        } else {
            double d2;
            this.unitsToNanometersScale = PhysicalUnits.scaleFactor(PhysicalUnits.timeIntegral(basicSeismogram.timeSeries.ampUnits), "nm");
            if (d2 > 0.0) {
                seisDataSac.IDEP = 7;
            } else {
                double d3;
                this.unitsToNanometersScale = PhysicalUnits.scaleFactor(PhysicalUnits.timeIntegral(PhysicalUnits.timeIntegral(basicSeismogram.timeSeries.ampUnits)), "nm");
                if (d3 > 0.0) {
                    seisDataSac.IDEP = 8;
                    System.out.println("unitsToNanometersScale : " + this.unitsToNanometersScale);
                } else if (basicSeismogram.timeSeries.ampUnits.equalsIgnoreCase("volts")) {
                    this.unitsToNanometersScale = 1.0;
                    seisDataSac.IDEP = 50;
                } else {
                    this.unitsToNanometersScale = 1.0;
                    seisDataSac.IDEP = 5;
                }
            }
        }
        System.out.println("unitsToNanometersScale : " + this.unitsToNanometersScale);
        seisDataSac.B = (float)basicSeismogram.timeMin;
        seisDataSac.E = (float)(basicSeismogram.timeMin + (double)(seisDataSac.sample.length - 1) * basicSeismogram.timeSeries.sampleInt);
        seisDataSac.DEPMIN = (float)basicSeismogram.timeSeries.ampMin;
        seisDataSac.DEPMAX = (float)basicSeismogram.timeSeries.ampMax;
        seisDataSac.NZYEAR = basicSeismogram.iyear;
        seisDataSac.NZJDAY = basicSeismogram.ijday;
        seisDataSac.NZHOUR = basicSeismogram.ihour;
        seisDataSac.NZMIN = basicSeismogram.imin;
        seisDataSac.NZSEC = (int)basicSeismogram.sec;
        seisDataSac.NZMSEC = (int)(0.5 + 1000.0 * (basicSeismogram.sec - (double)seisDataSac.NZSEC));
        double d4 = basicSeismogram.sec - (double)seisDataSac.NZSEC - (double)seisDataSac.NZMSEC / 1000.0;
        seisDataSac.B = (float)((double)seisDataSac.B + d4);
        seisDataSac.KNETWK = basicSeismogram.channel.network;
        if (seisDataSac.KNETWK.equals(BasicSeismogram.UNDEF_STRING)) {
            seisDataSac.KNETWK = K_UNDEF;
        }
        seisDataSac.KSTNM = basicSeismogram.channel.staName;
        if (seisDataSac.KSTNM.equals(BasicSeismogram.UNDEF_STRING)) {
            seisDataSac.KSTNM = K_UNDEF;
        }
        seisDataSac.KINST = basicSeismogram.channel.instName;
        if (seisDataSac.KINST.equals(BasicSeismogram.UNDEF_STRING)) {
            seisDataSac.KINST = K_UNDEF;
        }
        seisDataSac.KCMPNM = basicSeismogram.channel.chanName;
        if (seisDataSac.KCMPNM.equals(BasicSeismogram.UNDEF_STRING)) {
            seisDataSac.KCMPNM = K_UNDEF;
        }
        seisDataSac.KHOLE = basicSeismogram.channel.locName;
        if (seisDataSac.KHOLE.equals(BasicSeismogram.UNDEF_STRING)) {
            seisDataSac.KHOLE = K_UNDEF;
        }
        seisDataSac.KEVNM = basicSeismogram.evtName;
        if (seisDataSac.KEVNM.equals(BasicSeismogram.UNDEF_STRING)) {
            seisDataSac.KEVNM = K_UNDEF;
        }
        seisDataSac.CMPAZ = (float)basicSeismogram.channel.azimuth;
        seisDataSac.CMPINC = (float)basicSeismogram.channel.inclination;
        if (basicSeismogram.channel.staPosition.latitude != Double.MAX_VALUE) {
            seisDataSac.STLA = (float)basicSeismogram.channel.staPosition.latitude;
        }
        if (basicSeismogram.channel.staPosition.longitude != Double.MAX_VALUE) {
            seisDataSac.STLO = (float)basicSeismogram.channel.staPosition.longitude;
        }
        if (basicSeismogram.channel.staPosition.elevation != Double.MAX_VALUE) {
            seisDataSac.STEL = (float)(basicSeismogram.channel.staPosition.elevation * 1000.0);
        }
        if (basicSeismogram.channel.staPosition.depth != Double.MAX_VALUE) {
            seisDataSac.STDP = (float)(basicSeismogram.channel.staPosition.depth * 1000.0);
        }
        if (basicSeismogram.hypocenter != null && basicSeismogram.hypocenter.otime != BasicHypocenter.UNDEF_OTIME) {
            TimeInstant timeInstant = new TimeInstant(basicSeismogram.iyear, basicSeismogram.ijday, basicSeismogram.ihour, basicSeismogram.imin, basicSeismogram.sec);
            try {
                seisDataSac.O = (float)((basicSeismogram.hypocenter.otime.getMillisecondTime() - timeInstant.getMillisecondTime()) / 1000.0);
            }
            catch (Exception exception) {
                seisDataSac.O = -12345.0f;
            }
        } else {
            seisDataSac.O = -12345.0f;
        }
        if (basicSeismogram.hypocenter.position.latitude != Double.MAX_VALUE) {
            seisDataSac.EVLA = (float)basicSeismogram.hypocenter.position.latitude;
        }
        if (basicSeismogram.hypocenter.position.longitude != Double.MAX_VALUE) {
            seisDataSac.EVLO = (float)basicSeismogram.hypocenter.position.longitude;
        }
        if (basicSeismogram.hypocenter.position.elevation != Double.MAX_VALUE) {
            seisDataSac.EVEL = (float)(basicSeismogram.hypocenter.position.elevation * 1000.0);
        }
        if (basicSeismogram.hypocenter.position.depth != Double.MAX_VALUE) {
            seisDataSac.EVDP = (float)(basicSeismogram.hypocenter.position.depth * 1000.0);
        }
        if (basicSeismogram.hypocenter.mb != -9.9) {
            seisDataSac.IMAGTYP = 52;
            seisDataSac.MAG = (float)basicSeismogram.hypocenter.mb;
        } else if (basicSeismogram.hypocenter.ms != -9.9) {
            seisDataSac.IMAGTYP = 53;
            seisDataSac.MAG = (float)basicSeismogram.hypocenter.ms;
        } else if (basicSeismogram.hypocenter.ml != -9.9) {
            seisDataSac.IMAGTYP = 54;
            seisDataSac.MAG = (float)basicSeismogram.hypocenter.ml;
        } else if (basicSeismogram.hypocenter.mw != -9.9) {
            seisDataSac.IMAGTYP = 55;
            seisDataSac.MAG = (float)basicSeismogram.hypocenter.mw;
        } else if (basicSeismogram.hypocenter.md != -9.9) {
            seisDataSac.IMAGTYP = 56;
            seisDataSac.MAG = (float)basicSeismogram.hypocenter.md;
        } else if (basicSeismogram.hypocenter.mag != -9.9) {
            seisDataSac.IMAGTYP = 57;
            seisDataSac.MAG = (float)basicSeismogram.hypocenter.mag;
        }
        if (basicSeismogram.dist != Double.MAX_VALUE) {
            seisDataSac.DIST = (float)basicSeismogram.dist;
        }
        if (basicSeismogram.gcarc != Double.MAX_VALUE) {
            seisDataSac.GCARC = (float)basicSeismogram.gcarc;
        }
        if (basicSeismogram.az != Double.MAX_VALUE) {
            seisDataSac.AZ = (float)basicSeismogram.az;
        }
        if (basicSeismogram.dist != Double.MAX_VALUE) {
            seisDataSac.baz = (float)basicSeismogram.baz;
        }
    }

    public LinkedHashMap getHeaderFields() {
        if (this.properties != null) {
            return this.properties;
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("DELTA", "" + this.DELTA);
        linkedHashMap.put("DEPMIN", "" + this.DEPMIN);
        linkedHashMap.put("DEPMAX", "" + this.DEPMAX);
        linkedHashMap.put("SCALE", "" + this.SCALE);
        linkedHashMap.put("ODELTA", "" + this.ODELTA);
        linkedHashMap.put("B", "" + this.B);
        linkedHashMap.put("E", "" + this.E);
        linkedHashMap.put("O", "" + this.O);
        linkedHashMap.put("A", "" + this.A);
        linkedHashMap.put("FINTERNAL", "" + this.FINTERNAL);
        linkedHashMap.put("T0", "" + this.T0);
        linkedHashMap.put("T1", "" + this.T1);
        linkedHashMap.put("T2", "" + this.T2);
        linkedHashMap.put("T3", "" + this.T3);
        linkedHashMap.put("T4", "" + this.T4);
        linkedHashMap.put("T5", "" + this.T5);
        linkedHashMap.put("T6", "" + this.T6);
        linkedHashMap.put("T7", "" + this.T7);
        linkedHashMap.put("T8", "" + this.T8);
        linkedHashMap.put("T9", "" + this.T9);
        linkedHashMap.put("F", "" + this.F);
        linkedHashMap.put("RESP0", "" + this.RESP0);
        linkedHashMap.put("RESP1", "" + this.RESP1);
        linkedHashMap.put("RESP2", "" + this.RESP2);
        linkedHashMap.put("RESP3", "" + this.RESP3);
        linkedHashMap.put("RESP4", "" + this.RESP4);
        linkedHashMap.put("RESP5", "" + this.RESP5);
        linkedHashMap.put("RESP6", "" + this.RESP6);
        linkedHashMap.put("RESP7", "" + this.RESP7);
        linkedHashMap.put("RESP8", "" + this.RESP8);
        linkedHashMap.put("RESP9", "" + this.RESP9);
        linkedHashMap.put("STLA", "" + this.STLA);
        linkedHashMap.put("STLO", "" + this.STLO);
        linkedHashMap.put("STEL", "" + this.STEL);
        linkedHashMap.put("STDP", "" + this.STDP);
        linkedHashMap.put("EVLA", "" + this.EVLA);
        linkedHashMap.put("EVLO", "" + this.EVLO);
        linkedHashMap.put("EVEL", "" + this.EVEL);
        linkedHashMap.put("EVDP", "" + this.EVDP);
        linkedHashMap.put("MAG", "" + this.MAG);
        linkedHashMap.put("USER0", "" + this.USER0);
        linkedHashMap.put("USER1", "" + this.USER1);
        linkedHashMap.put("USER2", "" + this.USER2);
        linkedHashMap.put("USER3", "" + this.USER3);
        linkedHashMap.put("USER4", "" + this.USER4);
        linkedHashMap.put("USER5", "" + this.USER5);
        linkedHashMap.put("USER6", "" + this.USER6);
        linkedHashMap.put("USER7", "" + this.USER7);
        linkedHashMap.put("USER8", "" + this.USER8);
        linkedHashMap.put("USER9", "" + this.USER9);
        linkedHashMap.put("DIST", "" + this.DIST);
        linkedHashMap.put("AZ", "" + this.AZ);
        linkedHashMap.put("BAZ", "" + this.BAZ);
        linkedHashMap.put("GCARC", "" + this.GCARC);
        linkedHashMap.put("FINTERNAL", "" + this.FINTERNAL);
        linkedHashMap.put("FINTERNAL", "" + this.FINTERNAL);
        linkedHashMap.put("DEPMEN", "" + this.DEPMEN);
        linkedHashMap.put("CMPAZ", "" + this.CMPAZ);
        linkedHashMap.put("CMPINC", "" + this.CMPINC);
        linkedHashMap.put("XMINIMUM", "" + this.XMINIMUM);
        linkedHashMap.put("XMAXIMUM", "" + this.XMAXIMUM);
        linkedHashMap.put("YMINIMUM", "" + this.YMINIMUM);
        linkedHashMap.put("YMAXIMUM", "" + this.YMAXIMUM);
        linkedHashMap.put("ADJTM", "" + this.ADJTM);
        linkedHashMap.put("FUNUSED", "" + this.FUNUSED);
        linkedHashMap.put("FUNUSED", "" + this.FUNUSED);
        linkedHashMap.put("FUNUSED", "" + this.FUNUSED);
        linkedHashMap.put("FUNUSED", "" + this.FUNUSED);
        linkedHashMap.put("FUNUSED", "" + this.FUNUSED);
        linkedHashMap.put("FUNUSED", "" + this.FUNUSED);
        linkedHashMap.put("NZYEAR", "" + this.NZYEAR);
        linkedHashMap.put("NZJDAY", "" + this.NZJDAY);
        linkedHashMap.put("NZHOUR", "" + this.NZHOUR);
        linkedHashMap.put("NZMIN", "" + this.NZMIN);
        linkedHashMap.put("NZSEC", "" + this.NZSEC);
        linkedHashMap.put("NZMSEC", "" + this.NZMSEC);
        linkedHashMap.put("NVHDR", "" + this.NVHDR);
        linkedHashMap.put("IINTERNAL", "" + this.IINTERNAL);
        linkedHashMap.put("IINTERNAL", "" + this.IINTERNAL);
        linkedHashMap.put("NPTS", "" + this.NPTS);
        linkedHashMap.put("IINTERNAL", "" + this.IINTERNAL);
        linkedHashMap.put("IINTERNAL", "" + this.IINTERNAL);
        linkedHashMap.put("IUNUSED", "" + this.IUNUSED);
        linkedHashMap.put("IUNUSED", "" + this.IUNUSED);
        linkedHashMap.put("IUNUSED", "" + this.IUNUSED);
        linkedHashMap.put("IFTYPE", "" + this.IFTYPE);
        linkedHashMap.put("IDEP", "" + this.IDEP);
        linkedHashMap.put("IZTYPE", "" + this.IZTYPE);
        linkedHashMap.put("IUNUSED", "" + this.IUNUSED);
        linkedHashMap.put("IINST", "" + this.IINST);
        linkedHashMap.put("ISTREG", "" + this.ISTREG);
        linkedHashMap.put("IEVREG", "" + this.IEVREG);
        linkedHashMap.put("IEVTYP", "" + this.IEVTYP);
        linkedHashMap.put("IQUAL", "" + this.IQUAL);
        linkedHashMap.put("ISYNTH", "" + this.ISYNTH);
        linkedHashMap.put("IMAGTYP", "" + this.IMAGTYP);
        linkedHashMap.put("IMAGSRC", "" + this.IMAGSRC);
        linkedHashMap.put("IUNUSED", "" + this.IUNUSED);
        linkedHashMap.put("IUNUSED", "" + this.IUNUSED);
        linkedHashMap.put("IUNUSED", "" + this.IUNUSED);
        linkedHashMap.put("IUNUSED", "" + this.IUNUSED);
        linkedHashMap.put("IUNUSED", "" + this.IUNUSED);
        linkedHashMap.put("IUNUSED", "" + this.IUNUSED);
        linkedHashMap.put("IUNUSED", "" + this.IUNUSED);
        linkedHashMap.put("IUNUSED", "" + this.IUNUSED);
        linkedHashMap.put("LEVEN", "" + this.LEVEN);
        linkedHashMap.put("LPSPOL", "" + this.LPSPOL);
        linkedHashMap.put("LOVROK", "" + this.LOVROK);
        linkedHashMap.put("LCALDA", "" + this.LCALDA);
        linkedHashMap.put("LUNUSED", "" + this.LUNUSED);
        linkedHashMap.put("KSTNM", "" + this.KSTNM);
        linkedHashMap.put("KEVNM", "" + this.KEVNM);
        linkedHashMap.put("KHOLE", "" + this.KHOLE);
        linkedHashMap.put("KO", "" + this.KO);
        linkedHashMap.put("KA", "" + this.KA);
        linkedHashMap.put("KT0", "" + this.KT0);
        linkedHashMap.put("KT1", "" + this.KT1);
        linkedHashMap.put("KT2", "" + this.KT2);
        linkedHashMap.put("KT3", "" + this.KT3);
        linkedHashMap.put("KT4", "" + this.KT4);
        linkedHashMap.put("KT5", "" + this.KT5);
        linkedHashMap.put("KT6", "" + this.KT6);
        linkedHashMap.put("KT7", "" + this.KT7);
        linkedHashMap.put("KT8", "" + this.KT8);
        linkedHashMap.put("KT9", "" + this.KT9);
        linkedHashMap.put("KF", "" + this.KF);
        linkedHashMap.put("KUSER0", "" + this.KUSER0);
        linkedHashMap.put("KUSER1", "" + this.KUSER1);
        linkedHashMap.put("KUSER2", "" + this.KUSER2);
        linkedHashMap.put("KCMPNM", "" + this.KCMPNM);
        linkedHashMap.put("KNETWK", "" + this.KNETWK);
        linkedHashMap.put("KDATRD", "" + this.KDATRD);
        linkedHashMap.put("KINST", "" + this.KINST);
        LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
        for (String string : linkedHashMap.keySet()) {
            String string2 = (String)linkedHashMap.get(string);
            if (string.startsWith("K") && string2.equals(K_UNDEF)) {
                linkedHashMap2.put(string, BasicSeismogram.UNDEF_STRING);
                continue;
            }
            linkedHashMap2.put(string, string2);
        }
        return linkedHashMap2;
    }

    public void write(BinaryOutputStream binaryOutputStream) throws Exception {
        binaryOutputStream.writeFloatB(this.DELTA);
        binaryOutputStream.writeFloatB(this.DEPMIN);
        binaryOutputStream.writeFloatB(this.DEPMAX);
        binaryOutputStream.writeFloatB(this.SCALE);
        binaryOutputStream.writeFloatB(this.ODELTA);
        binaryOutputStream.writeFloatB(this.B);
        binaryOutputStream.writeFloatB(this.E);
        binaryOutputStream.writeFloatB(this.O);
        binaryOutputStream.writeFloatB(this.A);
        binaryOutputStream.writeFloatB(this.FINTERNAL);
        binaryOutputStream.writeFloatB(this.T0);
        binaryOutputStream.writeFloatB(this.T1);
        binaryOutputStream.writeFloatB(this.T2);
        binaryOutputStream.writeFloatB(this.T3);
        binaryOutputStream.writeFloatB(this.T4);
        binaryOutputStream.writeFloatB(this.T5);
        binaryOutputStream.writeFloatB(this.T6);
        binaryOutputStream.writeFloatB(this.T7);
        binaryOutputStream.writeFloatB(this.T8);
        binaryOutputStream.writeFloatB(this.T9);
        binaryOutputStream.writeFloatB(this.F);
        binaryOutputStream.writeFloatB(this.RESP0);
        binaryOutputStream.writeFloatB(this.RESP1);
        binaryOutputStream.writeFloatB(this.RESP2);
        binaryOutputStream.writeFloatB(this.RESP3);
        binaryOutputStream.writeFloatB(this.RESP4);
        binaryOutputStream.writeFloatB(this.RESP5);
        binaryOutputStream.writeFloatB(this.RESP6);
        binaryOutputStream.writeFloatB(this.RESP7);
        binaryOutputStream.writeFloatB(this.RESP8);
        binaryOutputStream.writeFloatB(this.RESP9);
        binaryOutputStream.writeFloatB(this.STLA);
        binaryOutputStream.writeFloatB(this.STLO);
        binaryOutputStream.writeFloatB(this.STEL);
        binaryOutputStream.writeFloatB(this.STDP);
        binaryOutputStream.writeFloatB(this.EVLA);
        binaryOutputStream.writeFloatB(this.EVLO);
        binaryOutputStream.writeFloatB(this.EVEL);
        binaryOutputStream.writeFloatB(this.EVDP);
        binaryOutputStream.writeFloatB(this.MAG);
        binaryOutputStream.writeFloatB(this.USER0);
        binaryOutputStream.writeFloatB(this.USER1);
        binaryOutputStream.writeFloatB(this.USER2);
        binaryOutputStream.writeFloatB(this.USER3);
        binaryOutputStream.writeFloatB(this.USER4);
        binaryOutputStream.writeFloatB(this.USER5);
        binaryOutputStream.writeFloatB(this.USER6);
        binaryOutputStream.writeFloatB(this.USER7);
        binaryOutputStream.writeFloatB(this.USER8);
        binaryOutputStream.writeFloatB(this.USER9);
        binaryOutputStream.writeFloatB(this.DIST);
        binaryOutputStream.writeFloatB(this.AZ);
        binaryOutputStream.writeFloatB(this.BAZ);
        binaryOutputStream.writeFloatB(this.GCARC);
        binaryOutputStream.writeFloatB(this.FINTERNAL);
        binaryOutputStream.writeFloatB(this.FINTERNAL);
        binaryOutputStream.writeFloatB(this.DEPMEN);
        binaryOutputStream.writeFloatB(this.CMPAZ);
        binaryOutputStream.writeFloatB(this.CMPINC);
        binaryOutputStream.writeFloatB(this.XMINIMUM);
        binaryOutputStream.writeFloatB(this.XMAXIMUM);
        binaryOutputStream.writeFloatB(this.YMINIMUM);
        binaryOutputStream.writeFloatB(this.YMAXIMUM);
        binaryOutputStream.writeFloatB(this.ADJTM);
        binaryOutputStream.writeFloatB(this.FUNUSED);
        binaryOutputStream.writeFloatB(this.FUNUSED);
        binaryOutputStream.writeFloatB(this.FUNUSED);
        binaryOutputStream.writeFloatB(this.FUNUSED);
        binaryOutputStream.writeFloatB(this.FUNUSED);
        binaryOutputStream.writeFloatB(this.FUNUSED);
        binaryOutputStream.writeIntB(this.NZYEAR);
        binaryOutputStream.writeIntB(this.NZJDAY);
        binaryOutputStream.writeIntB(this.NZHOUR);
        binaryOutputStream.writeIntB(this.NZMIN);
        binaryOutputStream.writeIntB(this.NZSEC);
        binaryOutputStream.writeIntB(this.NZMSEC);
        binaryOutputStream.writeIntB(this.NVHDR);
        binaryOutputStream.writeIntB(this.IINTERNAL);
        binaryOutputStream.writeIntB(this.IINTERNAL);
        binaryOutputStream.writeIntB(this.NPTS);
        binaryOutputStream.writeIntB(this.IINTERNAL);
        binaryOutputStream.writeIntB(this.IINTERNAL);
        binaryOutputStream.writeIntB(this.IUNUSED);
        binaryOutputStream.writeIntB(this.IUNUSED);
        binaryOutputStream.writeIntB(this.IUNUSED);
        binaryOutputStream.writeIntB(this.IFTYPE);
        binaryOutputStream.writeIntB(this.IDEP);
        binaryOutputStream.writeIntB(this.IZTYPE);
        binaryOutputStream.writeIntB(this.IUNUSED);
        binaryOutputStream.writeIntB(this.IINST);
        binaryOutputStream.writeIntB(this.ISTREG);
        binaryOutputStream.writeIntB(this.IEVREG);
        binaryOutputStream.writeIntB(this.IEVTYP);
        binaryOutputStream.writeIntB(this.IQUAL);
        binaryOutputStream.writeIntB(this.ISYNTH);
        binaryOutputStream.writeIntB(this.IMAGTYP);
        binaryOutputStream.writeIntB(this.IMAGSRC);
        binaryOutputStream.writeIntB(this.IUNUSED);
        binaryOutputStream.writeIntB(this.IUNUSED);
        binaryOutputStream.writeIntB(this.IUNUSED);
        binaryOutputStream.writeIntB(this.IUNUSED);
        binaryOutputStream.writeIntB(this.IUNUSED);
        binaryOutputStream.writeIntB(this.IUNUSED);
        binaryOutputStream.writeIntB(this.IUNUSED);
        binaryOutputStream.writeIntB(this.IUNUSED);
        binaryOutputStream.writeIntB(this.LEVEN ? 1 : 0);
        binaryOutputStream.writeIntB(this.LPSPOL ? 1 : 0);
        binaryOutputStream.writeIntB(this.LOVROK ? 1 : 0);
        binaryOutputStream.writeIntB(this.LCALDA ? 1 : 0);
        binaryOutputStream.writeIntB(this.LUNUSED ? 1 : 0);
        String string = "        ";
        binaryOutputStream.writeBytes(this.KSTNM.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KEVNM.concat(string).concat(string).substring(0, 16));
        binaryOutputStream.writeBytes(this.KHOLE.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KO.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KA.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KT0.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KT1.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KT2.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KT3.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KT4.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KT5.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KT6.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KT7.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KT8.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KT9.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KF.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KUSER0.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KUSER1.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KUSER2.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KCMPNM.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KNETWK.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KDATRD.concat(string).substring(0, 8));
        binaryOutputStream.writeBytes(this.KINST.concat(string).substring(0, 8));
        for (int i = 0; i < this.sample.length; ++i) {
            binaryOutputStream.writeFloatB((float)this.unitsToNanometersScale * this.sample[i]);
        }
        System.out.println("write unitsToNanometersScale : " + this.unitsToNanometersScale);
    }

    public void getReadings(Vector vector) {
        int n;
        double d = this.NZSEC;
        if (this.NZMSEC != -12345) {
            d += (double)this.NZMSEC / 1000.0;
        }
        TimeInstant timeInstant = new TimeInstant(this.NZYEAR, this.NZJDAY, this.NZHOUR, this.NZMIN, d);
        float[] fArray = new float[11];
        float f = Float.MAX_VALUE;
        int n2 = -1;
        String[] stringArray = new String[11];
        for (n = 0; n < 11; ++n) {
            fArray[n] = -12345.0f;
            stringArray[n] = K_UNDEF;
        }
        for (n = 1; n < 11 && n < vector.size() + 1; ++n) {
            BasicReading basicReading = (BasicReading)vector.elementAt(vector.size() - n);
            try {
                TimeInstant timeInstant2 = new TimeInstant(basicReading.iyear, basicReading.imonth, basicReading.idate, basicReading.ihour, basicReading.imin, basicReading.sec);
                fArray[n] = (float)((timeInstant2.getMillisecondTime() - timeInstant.getMillisecondTime()) / 1000.0);
            }
            catch (Exception exception) {
                fArray[n] = -12345.0f;
            }
            stringArray[n] = basicReading.name.replace('?', ' ').trim();
            if (stringArray[n].trim().length() < 1) {
                stringArray[n] = K_UNDEF;
            }
            if (fArray[n] < f) {
                f = fArray[n];
                n2 = n;
            }
            System.out.println("1-" + n + ": " + stringArray[n] + " " + fArray[n] + " indexPickTimeMin " + n2);
        }
        if (n2 > 0 && stringArray[n2].compareTo("P") == 0) {
            fArray[0] = fArray[n2];
            stringArray[0] = stringArray[n2];
            for (n = n2; n < 10; ++n) {
                fArray[n] = fArray[n + 1];
                stringArray[n] = stringArray[n + 1];
            }
            fArray[10] = -12345.0f;
            stringArray[10] = K_UNDEF;
        }
        block18: for (n = 0; n < 11 && n < vector.size() + 1; ++n) {
            System.out.println("2-" + n + ": " + stringArray[n] + " " + fArray[n]);
            switch (n) {
                case 0: {
                    this.A = fArray[n];
                    this.KA = stringArray[n];
                    continue block18;
                }
                case 1: {
                    this.T0 = fArray[n];
                    this.KT0 = stringArray[n];
                    continue block18;
                }
                case 2: {
                    this.T1 = fArray[n];
                    this.KT1 = stringArray[n];
                    continue block18;
                }
                case 3: {
                    this.T2 = fArray[n];
                    this.KT2 = stringArray[n];
                    continue block18;
                }
                case 4: {
                    this.T3 = fArray[n];
                    this.KT3 = stringArray[n];
                    continue block18;
                }
                case 5: {
                    this.T4 = fArray[n];
                    this.KT4 = stringArray[n];
                    continue block18;
                }
                case 6: {
                    this.T5 = fArray[n];
                    this.KT5 = stringArray[n];
                    continue block18;
                }
                case 7: {
                    this.T6 = fArray[n];
                    this.KT6 = stringArray[n];
                    continue block18;
                }
                case 8: {
                    this.T7 = fArray[n];
                    this.KT7 = stringArray[n];
                    continue block18;
                }
                case 9: {
                    this.T8 = fArray[n];
                    this.KT8 = stringArray[n];
                    continue block18;
                }
                case 10: {
                    this.T9 = fArray[n];
                    this.KT9 = stringArray[n];
                }
            }
        }
    }

    public Vector setReadings() {
        Vector<BasicReading> vector = new Vector<BasicReading>();
        BasicReading basicReading = this.getBasicReading(this.A, this.KA);
        if (basicReading != null) {
            vector.addElement(basicReading);
        }
        float[] fArray = new float[]{this.T0, this.T1, this.T2, this.T3, this.T4, this.T5, this.T6, this.T7, this.T8, this.T9};
        String[] stringArray = new String[]{this.KT0, this.KT1, this.KT2, this.KT3, this.KT4, this.KT5, this.KT6, this.KT7, this.KT8, this.KT9};
        for (int i = 0; i < fArray.length; ++i) {
            basicReading = this.getBasicReading(fArray[i], stringArray[i]);
            if (basicReading == null) continue;
            vector.addElement(basicReading);
        }
        if (this.F != -12345.0f) {
            String string = this.KF;
            if (string.compareTo(K_UNDEF) == 0) {
                string = BasicReading.CODA_STRING;
            }
            if ((basicReading = this.getBasicReading(this.F, string)) != null) {
                vector.addElement(basicReading);
            }
        }
        if (vector.size() > 0) {
            return vector;
        }
        return null;
    }

    public BasicReading getBasicReading(float f, String string) {
        if (f != -12345.0f) {
            BasicReading basicReading = new BasicReading();
            TimeInstant timeInstant = new TimeInstant(this.iyear, this.ijday, this.ihour, this.imin, this.sec);
            TimeInstant timeInstant2 = BasicHypocenter.UNDEF_OTIME;
            try {
                timeInstant2 = new TimeInstant(timeInstant.getMillisecondTime() + (double)f * 1000.0);
            }
            catch (Exception exception) {
                timeInstant2 = BasicHypocenter.UNDEF_OTIME;
            }
            basicReading.iyear = timeInstant2.getYear();
            basicReading.imonth = timeInstant2.getMonth();
            basicReading.idate = timeInstant2.getDate();
            basicReading.ihour = timeInstant2.getHours();
            basicReading.imin = timeInstant2.getMinutes();
            basicReading.sec = timeInstant2.getSeconds();
            if (string.compareTo(K_UNDEF) != 0) {
                basicReading.name = string;
                basicReading.name = basicReading.name.replace(' ', '?');
            }
            if (this.KNETWK.compareTo(K_UNDEF) != 0) {
                basicReading.network = this.KNETWK.replace(' ', '_');
            }
            if (this.KSTNM.compareTo(K_UNDEF) != 0) {
                basicReading.staName = this.KSTNM.replace(' ', '_');
            }
            if (this.KINST.compareTo(K_UNDEF) != 0) {
                basicReading.instName = this.KINST.replace(' ', '_');
            }
            if (this.KCMPNM.compareTo(K_UNDEF) != 0) {
                basicReading.compName = this.KCMPNM.replace(' ', '_');
            }
            basicReading.azimuth = this.channel.azimuth != Double.MAX_VALUE ? this.channel.azimuth : (double)this.CMPAZ;
            basicReading.inclination = this.channel.inclination != Double.MAX_VALUE ? this.channel.inclination : (double)this.CMPINC;
            basicReading.uncertainty = 0.0;
            return basicReading;
        }
        return null;
    }

    public SimpleAmplificationResponse getSimpleAmplificationResponse() {
        if (this.RESP0 != -12345.0f) {
            SimpleAmplificationResponse simpleAmplificationResponse = new SimpleAmplificationResponse(this.RESP0);
            simpleAmplificationResponse.setAfterUnits(this.timeSeries.ampUnits);
            return simpleAmplificationResponse;
        }
        return null;
    }

    public void setSimpleAmplificationResponse(SimpleAmplificationResponse simpleAmplificationResponse) {
        if (simpleAmplificationResponse != null) {
            this.RESP0 = (float)simpleAmplificationResponse.getGain();
        }
    }
}

