/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import java.util.Vector;
import net.alomax.geog.DistanceAzimuth;
import net.alomax.geog.SphericalTrig;
import net.alomax.math.TimeSeriesFloat;
import net.alomax.seis.BasicHypocenter;
import net.alomax.seis.BasicSeismogram;
import net.alomax.seis.SeisData;
import net.alomax.util.StringExt;
import net.alomax.util.TimeInstant;
import orfeus.srem.BasicReading;
import sdsu.io.ASCIIInputStream;

public class SeisDataFVGN
extends SeisData {
    String station;
    String comp;
    int samp;
    int numData;
    String startDate = null;
    String startTime = null;
    float scale = Float.MAX_VALUE;
    float maxAmp = Float.MAX_VALUE;
    float s_x = Float.MAX_VALUE;
    float s_y = Float.MAX_VALUE;
    float s_z = Float.MAX_VALUE;
    String eventDate = null;
    String eventTime = null;
    float e_x = Float.MAX_VALUE;
    float e_y = Float.MAX_VALUE;
    float e_z = Float.MAX_VALUE;
    float e_ML = Float.MAX_VALUE;
    String pickDate = null;
    String pickTime = null;
    String pickIdent = null;
    float[] sample;
    String dataUnits;
    String headerLine = null;

    public void read(ASCIIInputStream aSCIIInputStream) throws Exception {
        block6: {
            String string;
            this.headerLine = string = aSCIIInputStream.readLine();
            String[] stringArray = StringExt.parse(string, " ");
            int n = 0;
            try {
                this.station = stringArray[n += 2];
                this.comp = stringArray[n += 2];
                this.samp = Integer.valueOf(stringArray[n += 2]);
                this.numData = Integer.valueOf(stringArray[n += 2]);
                this.startDate = stringArray[n += 2];
                this.startTime = stringArray[++n];
                this.scale = Float.valueOf(stringArray[n += 2]).floatValue();
                this.maxAmp = Float.valueOf(stringArray[n += 2]).floatValue();
                this.s_x = Float.valueOf(stringArray[n += 2]).floatValue();
                this.s_y = Float.valueOf(stringArray[n += 2]).floatValue();
                this.s_z = Float.valueOf(stringArray[n += 2]).floatValue();
                this.eventDate = stringArray[n += 2];
                this.eventTime = stringArray[++n];
                this.e_x = Float.valueOf(stringArray[n += 2]).floatValue();
                this.e_y = Float.valueOf(stringArray[n += 2]).floatValue();
                this.e_z = Float.valueOf(stringArray[n += 2]).floatValue();
                this.e_ML = Float.valueOf(stringArray[n += 2]).floatValue();
                this.pickDate = stringArray[n += 2];
                this.pickTime = stringArray[++n];
                this.pickIdent = stringArray[++n];
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("ERROR: reading header line: " + string);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (n >= 16) break block6;
                System.out.println("ERROR: reading header line: " + string);
            }
        }
        this.sample = new float[this.numData];
        for (int i = 0; i < this.numData && !aSCIIInputStream.eof(); ++i) {
            this.sample[i] = aSCIIInputStream.readFloat() * this.scale;
        }
        this.dataUnits = "counts";
    }

    public static int canRead(ASCIIInputStream aSCIIInputStream) {
        try {
            String string = aSCIIInputStream.readWord();
            if (string.toUpperCase().indexOf("#") < 0) {
                return -1;
            }
            string = aSCIIInputStream.readWord();
            if (string.toUpperCase().indexOf("STATION") < 0) {
                return -1;
            }
            return 1;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public void getSeismogramFields(BasicSeismogram basicSeismogram) {
    }

    public void setSeismogramFields() {
        int n;
        int n2;
        SeisDataFVGN seisDataFVGN = this;
        this.timeSeries = new TimeSeriesFloat(seisDataFVGN.sample, (double)seisDataFVGN.samp / 1000.0, 0.0, this.dataUnits, "sec");
        this.timeMin = 0.0;
        try {
            String[] stringArray = StringExt.parse(this.startDate, "-");
            int n3 = Integer.parseInt(stringArray[0]);
            int n4 = Integer.parseInt(stringArray[1]);
            int n5 = Integer.parseInt(stringArray[2]);
            stringArray = StringExt.parse(this.startTime, ":");
            int n6 = Integer.parseInt(stringArray[0]);
            n2 = Integer.parseInt(stringArray[1]);
            double d = Double.valueOf(stringArray[2]);
            TimeInstant timeInstant = new TimeInstant(n3, n4, n5);
            n = timeInstant.getDoY();
            this.iyear = n3;
            this.ijday = n;
            this.ihour = n6;
            this.imin = n2;
            this.sec = d;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("ERROR: parsing header values.");
        }
        this.channel.staName = seisDataFVGN.station;
        this.channel.instName = BasicSeismogram.UNDEF_STRING;
        this.evtName = seisDataFVGN.eventDate + " " + seisDataFVGN.eventTime;
        double d = 0.0;
        double d2 = 0.0;
        if (seisDataFVGN.comp.indexOf("Z") != -1) {
            d = 0.0;
            d2 = 0.0;
        } else if (seisDataFVGN.comp.indexOf("E") != -1) {
            d = 90.0;
            d2 = 90.0;
        } else if (seisDataFVGN.comp.indexOf("N") != -1) {
            d = 0.0;
            d2 = 90.0;
        }
        this.channel.azimuth = d;
        this.channel.inclination = d2;
        if (seisDataFVGN.s_y != Float.MAX_VALUE) {
            this.channel.staPosition.latitude = seisDataFVGN.s_y;
        }
        if (seisDataFVGN.s_x != Float.MAX_VALUE) {
            this.channel.staPosition.longitude = seisDataFVGN.s_x;
        }
        this.channel.staPosition.depth = 0.0;
        if (seisDataFVGN.s_z != Float.MAX_VALUE) {
            this.channel.staPosition.elevation = seisDataFVGN.s_z;
        }
        if (this.eventDate != null && this.eventTime != null) {
            try {
                String[] stringArray = StringExt.parse(this.eventDate, "-");
                n2 = Integer.parseInt(stringArray[0]);
                int n7 = Integer.parseInt(stringArray[1]);
                int n8 = Integer.parseInt(stringArray[2]);
                stringArray = StringExt.parse(this.eventTime, ":");
                int n9 = Integer.parseInt(stringArray[0]);
                n = Integer.parseInt(stringArray[1]);
                double d3 = Double.valueOf(stringArray[2]);
                TimeInstant timeInstant = new TimeInstant(n2, n7, n8, n9, n, d3);
                try {
                    this.hypocenter.otime = new TimeInstant(timeInstant.getMillisecondTime());
                }
                catch (Exception exception) {
                    this.hypocenter.otime = BasicHypocenter.UNDEF_OTIME;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("ERROR: parsing header values.");
            }
        }
        if (seisDataFVGN.e_y != Float.MAX_VALUE && seisDataFVGN.e_x != Float.MAX_VALUE && seisDataFVGN.e_z != Float.MAX_VALUE) {
            this.hypocenter.position.latitude = seisDataFVGN.e_y;
            this.hypocenter.position.longitude = seisDataFVGN.e_x;
            this.hypocenter.position.depth = 0.0;
            this.hypocenter.position.elevation = seisDataFVGN.e_z;
            DistanceAzimuth distanceAzimuth = SphericalTrig.distAz(this.hypocenter.position, this.channel.staPosition);
            this.dist = distanceAzimuth.toKilometers().distance;
            this.gcarc = distanceAzimuth.toDegrees().distance;
            this.az = distanceAzimuth.azimuth;
            distanceAzimuth = SphericalTrig.distAz(this.channel.staPosition, this.hypocenter.position);
            double d4 = distanceAzimuth.azimuth + 180.0;
            if (d4 >= 360.0) {
                d4 -= 360.0;
            }
            this.baz = d4;
        }
        if (seisDataFVGN.e_ML != Float.MAX_VALUE) {
            this.hypocenter.ml = seisDataFVGN.e_ML;
        }
    }

    public String getHeaderFieldsAsString() {
        String string = System.getProperty("line.separator");
        String string2 = "# [FVGN Data Format]" + string;
        string2 = string2 + this.headerLine + string;
        return string2;
    }

    public Vector getReadings() {
        Vector<BasicReading> vector = new Vector<BasicReading>();
        BasicReading basicReading = this.getBasicReading(this.pickDate, this.pickTime, this.pickIdent);
        if (basicReading != null) {
            vector.addElement(basicReading);
        }
        if (vector.size() > 0) {
            return vector;
        }
        return null;
    }

    public BasicReading getBasicReading(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        BasicReading basicReading = new BasicReading();
        String[] stringArray = StringExt.parse(string, "-");
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        stringArray = StringExt.parse(string2, ":");
        int n4 = Integer.parseInt(stringArray[0]);
        int n5 = Integer.parseInt(stringArray[1]);
        double d = Double.valueOf(stringArray[2]);
        basicReading.iyear = n;
        basicReading.imonth = n2;
        basicReading.idate = n3;
        basicReading.ihour = n4;
        basicReading.imin = n5;
        basicReading.sec = d;
        try {
            String string4 = string3.substring(0, 1);
            if (!string4.equals("_")) {
                basicReading.onset = string4;
            }
            if (!(string4 = string3.substring(1, 2)).equals("_")) {
                basicReading.name = string4;
            }
            if (!(string4 = string3.substring(2, 3)).equals("_")) {
                basicReading.firstMot = string4;
            }
            if (!(string4 = string3.substring(3, 4)).equals("_")) {
                basicReading.quality = Integer.valueOf(string4);
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        basicReading.staName = this.station;
        basicReading.azimuth = this.channel.azimuth;
        basicReading.inclination = this.channel.inclination;
        basicReading.uncertainty = 0.0;
        return basicReading;
    }
}

