/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import java.util.LinkedHashMap;
import java.util.Vector;
import net.alomax.freq.SimpleAmplificationResponse;
import net.alomax.io.ASCIIOutputStream;
import net.alomax.io.BinaryInputStream;
import net.alomax.io.BinaryOutputStream;
import net.alomax.math.TimeSeries;
import net.alomax.seis.BasicChannel;
import net.alomax.seis.BasicHypocenter;
import net.alomax.seis.BasicSeismogram;
import net.alomax.seis.SeisDataASCII;
import net.alomax.seis.SeisException;
import net.alomax.util.NumberExt;
import net.alomax.util.StringExt;
import sdsu.io.ASCIIInputStream;

public abstract class SeisData
extends BasicSeismogram {
    public LinkedHashMap properties = null;

    public SeisData() {
    }

    public SeisData(TimeSeries timeSeries, BasicChannel basicChannel, String string, BasicHypocenter basicHypocenter, double d, double d2, double d3, double d4, int n, int n2, int n3, int n4, double d5, double d6) {
        super(timeSeries, basicChannel, string, basicHypocenter, d, d2, d3, d4, n, n2, n3, n4, d5, d6);
    }

    public abstract void setSeismogramFields();

    public abstract void getSeismogramFields(BasicSeismogram var1);

    public static int canRead(BinaryInputStream binaryInputStream) {
        return 0;
    }

    public static int canRead(ASCIIInputStream aSCIIInputStream) {
        return 0;
    }

    public void read(BinaryInputStream binaryInputStream) throws Exception {
        throw new SeisException("SeisData: read BinaryInputStream not implemented for this datatype");
    }

    public void read(ASCIIInputStream aSCIIInputStream) throws Exception {
        throw new SeisException("SeisData: read ASCIIInputStream not implemented for this datatype");
    }

    public LinkedHashMap getHeaderFields() {
        return this.properties;
    }

    public Vector setReadings() {
        return null;
    }

    public void getReadings(Vector vector) {
    }

    public SimpleAmplificationResponse getSimpleAmplificationResponse() {
        return null;
    }

    public void setSimpleAmplificationResponse(SimpleAmplificationResponse simpleAmplificationResponse) {
    }

    public void write(BinaryOutputStream binaryOutputStream) throws Exception {
        throw new SeisException("SeisData: write BinaryOutputStream not implemented for this datatype");
    }

    public void write(ASCIIOutputStream aSCIIOutputStream) throws Exception {
        throw new SeisException("SeisData: write ASCIIFileOutputStream not implemented for this datatype");
    }

    public static float[] getFloatArray(int n) throws Exception {
        float[] fArray;
        if (n < 1 || n > Integer.MAX_VALUE) {
            throw new SeisException("SeisData: InvalidDataArraySizeException");
        }
        try {
            fArray = new float[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new SeisException("SeisData: OutOfMemoryError ArraySize = " + n);
        }
        return fArray;
    }

    public boolean checkFields(boolean bl, boolean bl2) {
        boolean bl3 = true;
        char c = '$';
        int n = 0;
        double d = 0.0;
        this.channel.network = StringExt.checkPrintable(this.channel.network, bl, c, bl2, "network");
        this.channel.staName = StringExt.checkPrintable(this.channel.staName, bl, c, bl2, "staName");
        this.channel.instName = StringExt.checkPrintable(this.channel.instName, bl, c, bl2, "instName");
        this.channel.chanName = StringExt.checkPrintable(this.channel.chanName, bl, c, bl2, "chanName");
        this.channel.locName = StringExt.checkPrintable(this.channel.locName, bl, c, bl2, "locName");
        this.channel.compName = StringExt.checkPrintable(this.channel.compName, bl, c, bl2, "compName");
        this.evtName = StringExt.checkPrintable(this.evtName, bl, c, bl2, "evtName");
        this.iyear = NumberExt.checkRange(this.iyear, -9999, 9999, bl, n, bl2, "iyear");
        this.ijday = NumberExt.checkRange(this.ijday, 0, 366, bl, n, bl2, "ijday");
        this.ihour = NumberExt.checkRange(this.ihour, 0, 24, bl, n, bl2, "ihour");
        this.imin = NumberExt.checkRange(this.imin, 0, 60, bl, n, bl2, "imin");
        this.sec = NumberExt.checkRange(this.sec, -0.0, 60.0, bl, d, bl2, "sec");
        this.timeMin = NumberExt.checkRange(this.timeMin, -1.7976931348623157E308, Double.MAX_VALUE, bl, d, bl2, "timeMin");
        this.timeSeries.lagTime = NumberExt.checkRange(this.timeSeries.lagTime, -180.0, 180.0, bl, 0.0, bl2, "timeSeries.lagTime");
        this.timeSeries.ampUnits = StringExt.checkPrintable(this.timeSeries.ampUnits, bl, c, bl2, "timeSeries.ampUnits");
        this.timeSeries.timeUnits = StringExt.checkPrintable(this.timeSeries.timeUnits, bl, c, bl2, "timeSeries.timeUnits");
        int n2 = 1;
        int n3 = Integer.MAX_VALUE;
        NumberExt.checkRange(this.timeSeries.sampleLength(), n2, n3, false, 1, bl2, "timeSeries.sampleLength()");
        boolean bl4 = NumberExt.inRange(this.timeSeries.sampleLength(), n2, n3);
        if (!bl4 && bl2) {
            System.out.println(this.getClass().getName() + ": " + "ERROR: invalid time series length: " + this.timeSeries.sampleLength());
        }
        bl3 = bl3 && bl4;
        double d2 = Double.MIN_VALUE;
        double d3 = Double.MAX_VALUE;
        this.timeSeries.sampleInt = NumberExt.checkRange(this.timeSeries.sampleInt, d2, d3, false, 1.0, bl2, "timeSeries.sampleInt");
        bl4 = NumberExt.inRange(this.timeSeries.sampleInt, d2, d3);
        if (!bl4 && bl2) {
            System.out.println(this.getClass().getName() + ": " + "ERROR: invalid time series sampling interval: " + this.timeSeries.sampleInt);
        }
        bl3 = bl3 && bl4;
        return bl3;
    }

    public void mergeMetaDataSG2KASCII(ASCIIInputStream aSCIIInputStream) throws Exception {
        SeisDataASCII seisDataASCII = new SeisDataASCII();
        ((SeisData)seisDataASCII).read(aSCIIInputStream);
        this.mergeMetaData(seisDataASCII);
    }
}

