/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seis;

import java.io.Serializable;
import net.alomax.freq.FrequencyDomainProcess;
import net.alomax.geog.DistanceAzimuth;
import net.alomax.geog.Position;
import net.alomax.geog.SphericalTrig;
import net.alomax.math.Cmplx;
import net.alomax.math.RangeDouble;
import net.alomax.math.RangeInteger;
import net.alomax.math.TimeSeries;
import net.alomax.math.TimeSeriesFloat;
import net.alomax.seis.BasicChannel;
import net.alomax.seis.BasicHypocenter;
import net.alomax.seis.BasicItem;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainProcess;
import net.alomax.util.TimeInstant;

public class BasicSeismogram
extends BasicItem
implements Serializable {
    public static final double INVALID_AMPLITUDE = Double.MAX_VALUE;
    public TimeSeries timeSeries = new TimeSeriesFloat();
    public BasicChannel channel = new BasicChannel();
    public String evtName = UNDEF_STRING;
    public BasicHypocenter hypocenter = new BasicHypocenter();
    public double gcarc = Double.MAX_VALUE;
    public double dist = Double.MAX_VALUE;
    public double az = Double.MAX_VALUE;
    public double baz = Double.MAX_VALUE;
    public int iyear = Integer.MAX_VALUE;
    public int ijday = Integer.MAX_VALUE;
    public int ihour = Integer.MAX_VALUE;
    public int imin = Integer.MAX_VALUE;
    public double sec = Double.MAX_VALUE;
    public double timeMin = 0.0;

    public BasicSeismogram() {
    }

    public BasicSeismogram(TimeSeries timeSeries, BasicChannel basicChannel, String string, BasicHypocenter basicHypocenter, double d, double d2, double d3, double d4, int n, int n2, int n3, int n4, double d5, double d6) {
        if (timeSeries != null) {
            this.timeSeries = timeSeries;
        }
        if (basicChannel != null) {
            this.channel = basicChannel;
        }
        if (string != null) {
            this.evtName = string;
        }
        if (basicHypocenter != null) {
            this.hypocenter = basicHypocenter;
        }
        if (d != Double.MAX_VALUE) {
            this.gcarc = d;
        }
        if (d2 != Double.MAX_VALUE) {
            this.dist = d2;
        }
        if (d3 != Double.MAX_VALUE) {
            this.az = d3;
        }
        if (d4 != Double.MAX_VALUE) {
            this.baz = d4;
        }
        if (n != Integer.MAX_VALUE) {
            this.iyear = n;
        }
        if (n2 != Integer.MAX_VALUE) {
            this.ijday = n2;
        }
        if (n3 != Integer.MAX_VALUE) {
            this.ihour = n3;
        }
        if (n4 != Integer.MAX_VALUE) {
            this.imin = n4;
        }
        if (d5 != Double.MAX_VALUE) {
            this.sec = d5;
        }
        if (d6 != Double.MAX_VALUE) {
            this.timeMin = d6;
        }
    }

    public void mergeMetaData(BasicSeismogram basicSeismogram) {
        if (basicSeismogram.timeSeries != null) {
            this.timeSeries = basicSeismogram.timeSeries;
        }
        if (basicSeismogram.channel != null) {
            this.channel = basicSeismogram.channel;
        }
        if (basicSeismogram.evtName != null) {
            this.evtName = basicSeismogram.evtName;
        }
        if (basicSeismogram.hypocenter != null) {
            this.hypocenter = basicSeismogram.hypocenter;
        }
        if (basicSeismogram.gcarc != Double.MAX_VALUE) {
            this.gcarc = basicSeismogram.gcarc;
        }
        if (basicSeismogram.dist != Double.MAX_VALUE) {
            this.dist = basicSeismogram.dist;
        }
        if (basicSeismogram.az != Double.MAX_VALUE) {
            this.az = basicSeismogram.az;
        }
        if (basicSeismogram.baz != Double.MAX_VALUE) {
            this.baz = basicSeismogram.baz;
        }
        if (basicSeismogram.iyear != Integer.MAX_VALUE) {
            this.iyear = basicSeismogram.iyear;
        }
        if (basicSeismogram.ijday != Integer.MAX_VALUE) {
            this.ijday = basicSeismogram.ijday;
        }
        if (basicSeismogram.ihour != Integer.MAX_VALUE) {
            this.ihour = basicSeismogram.ihour;
        }
        if (basicSeismogram.imin != Integer.MAX_VALUE) {
            this.imin = basicSeismogram.imin;
        }
        if (basicSeismogram.sec != Double.MAX_VALUE) {
            this.sec = basicSeismogram.sec;
        }
        if (basicSeismogram.timeMin != Double.MAX_VALUE) {
            this.timeMin = basicSeismogram.timeMin;
        }
    }

    public double getTimeMin() {
        return this.timeMin;
    }

    public double getTimeMax() {
        return this.timeAtSample(this.timeSeries.sampleLength() - 1);
    }

    public long getDataMemorySize() {
        if (this.timeSeries == null) {
            return 0L;
        }
        return this.timeSeries.getDataMemorySize();
    }

    public void setHypocenter(BasicHypocenter basicHypocenter) {
        if (basicHypocenter != null) {
            this.hypocenter = basicHypocenter;
        }
    }

    public BasicHypocenter getHypocenter() {
        return this.hypocenter;
    }

    public void setChannel(BasicChannel basicChannel) {
        if (basicChannel != null) {
            this.channel = basicChannel;
        }
    }

    public BasicChannel getChannel() {
        return this.channel;
    }

    public void calcDistAz() {
        if (this.channel == null) {
            return;
        }
        if (this.hypocenter == null) {
            return;
        }
        Position position = this.hypocenter.position;
        if (position == null) {
            return;
        }
        DistanceAzimuth distanceAzimuth = SphericalTrig.distAz(position, this.channel.staPosition);
        this.gcarc = distanceAzimuth.toDegrees().distance;
        this.dist = distanceAzimuth.toKilometers().distance;
        this.az = distanceAzimuth.azimuth;
        distanceAzimuth = SphericalTrig.distAz(this.channel.staPosition, position);
        this.baz = distanceAzimuth.toDegrees().azimuth;
    }

    public TimeInstant getHypocenterOtime() {
        if (this.hypocenter.otime.equals(BasicHypocenter.UNDEF_OTIME)) {
            return null;
        }
        return this.hypocenter.otime;
    }

    public String getTimeUnits() {
        return this.timeSeries.timeUnits;
    }

    public double getAmpMin() {
        return this.timeSeries.ampMin;
    }

    public double getAmpMax() {
        return this.timeSeries.ampMax;
    }

    public double getRmsAmplitude() {
        return this.timeSeries.calculateRmsAmplitude();
    }

    public double getVariance() {
        return this.timeSeries.calculateVariance();
    }

    public int indexOfAmpZeroToPeakMax() {
        return this.timeSeries.indexOfAmpZeroToPeakMax();
    }

    public RangeInteger indicesOfAmpPeakToPeakMax(double d) {
        return this.timeSeries.indicesOfAmpPeakToPeakMax(d);
    }

    public int indexOfCumulative(double d) {
        return this.timeSeries.indexOfCumulative(d);
    }

    public int[] indexOfPivotLimit(double d, double d2, double d3, double d4) {
        return this.timeSeries.indexOfPivotLimit(this.sampAtTime(d), d2, d3, d4);
    }

    public String getAmpUnits() {
        return this.timeSeries.ampUnits;
    }

    public final double timeAtSample(double d) {
        double d2 = this.timeMin + d * this.timeSeries.sampleInt;
        return d2;
    }

    public final double timeAtSample(int n) {
        double d = this.timeMin + (double)n * this.timeSeries.sampleInt;
        return d;
    }

    public final int sampAtTime(double d) {
        int n = this.sampAtTimeNoVerify(d);
        if (n < 0) {
            return 0;
        }
        if (n > this.timeSeries.sampleLength() - 1) {
            return this.timeSeries.sampleLength() - 1;
        }
        return n;
    }

    public final int sampAtTimeNoVerify(double d) {
        double d2 = (d - this.timeMin) / this.timeSeries.sampleInt;
        int n = Math.round((float)d2);
        return n;
    }

    public final double doubleSampAtTimeNoVerify(double d) {
        double d2 = (d - this.timeMin) / this.timeSeries.sampleInt;
        return d2;
    }

    public final double ampAtTime(double d) {
        double d2 = (d - this.timeMin) / this.timeSeries.sampleInt;
        int n = (int)d2;
        if (n < 0 || n >= this.timeSeries.sampleLength() - 1) {
            return Double.MAX_VALUE;
        }
        double d3 = d2 - (double)n;
        double d4 = this.timeSeries.sampleAt(n);
        double d5 = this.timeSeries.sampleAt(n + 1);
        return d4 + (d5 - d4) * d3;
    }

    public RangeDouble calculateAmplitudeRange(int n, int n2, boolean bl) {
        return this.timeSeries.calculateAmplitudeRange(n, n2, bl);
    }

    public void invertPolarity() {
        this.timeSeries.invertPolarity();
    }

    public void removeTrend() {
        this.timeSeries.removeTrend();
    }

    public void removeMean() {
        this.timeSeries.removeMean();
    }

    public void removeMean(int n) {
        this.timeSeries.removeMean(n);
    }

    public void removeMean(double d, double d2) {
        int n = this.sampAtTime(d);
        int n2 = this.sampAtTime(d2);
        this.timeSeries.removeMean(n, n2);
    }

    public void unDoRemoveMean() {
        this.timeSeries.unDoRemoveMean();
    }

    public void cutInMemory(double d, double d2) {
        int n = this.sampAtTime(d);
        int n2 = this.sampAtTime(d2);
        this.timeSeries.cutInMemory(n, n2);
        this.timeMin += this.timeAtSample(n) - this.timeMin;
    }

    public double signalToNoiseRatio(double d, double d2, double d3, double d4) {
        double d5 = this.timeSeries.calculateRmsAmplitude(this.sampAtTime(d), this.sampAtTime(d2));
        double d6 = this.timeSeries.calculateRmsAmplitude(this.sampAtTime(d3), this.sampAtTime(d4));
        if (d5 < Double.MIN_VALUE && d6 > Double.MIN_VALUE) {
            return Double.POSITIVE_INFINITY;
        }
        if (d5 < Double.MIN_VALUE && d6 < Double.MIN_VALUE) {
            return 0.0;
        }
        return d6 * d6 / (d5 * d5);
    }

    public double signalToNoiseAmplitudeRatio(double d, double d2, double d3, double d4) {
        RangeDouble rangeDouble = this.calculateAmplitudeRange(this.sampAtTime(d), this.sampAtTime(d2), false);
        RangeDouble rangeDouble2 = this.calculateAmplitudeRange(this.sampAtTime(d3), this.sampAtTime(d4), false);
        double d5 = rangeDouble.max - rangeDouble.min;
        double d6 = rangeDouble2.max - rangeDouble2.min;
        if (d5 < Double.MIN_VALUE && d6 > Double.MIN_VALUE) {
            return Double.POSITIVE_INFINITY;
        }
        if (d5 < Double.MIN_VALUE && d6 < Double.MIN_VALUE) {
            return 0.0;
        }
        return d6 / d5;
    }

    public void test() {
        this.timeSeries.test();
    }

    public void integrate(float f) {
        this.timeSeries.integrate(f);
    }

    public void integrateMaxOfPosNeg(boolean bl) {
        this.timeSeries.integrateMaxOfPosNeg(bl);
    }

    public void differentiate(float f) {
        this.timeSeries.differentiate(f);
    }

    public void multiply(double d) {
        this.timeSeries.multiply(d);
    }

    public void sqrt() {
        this.timeSeries.sqrt();
    }

    public void norm() {
        this.timeSeries.norm();
    }

    public void chop() {
        this.timeSeries.chop();
    }

    public void multiplyLinear(double d, double d2) {
        this.timeSeries.multiplyLinear(d, d2);
    }

    public Cmplx[] getFFT(double d, int n) {
        return this.timeSeries.getFFT(d, n);
    }

    public void applyFreqProcess(FrequencyDomainProcess frequencyDomainProcess, double d, Object[] objectArray, boolean bl) {
        this.timeSeries.applyFreqProcess(frequencyDomainProcess, d, objectArray, bl);
    }

    public void applyTimeDomainProcess(TimeDomainProcess timeDomainProcess) throws TimeDomainException {
        this.timeSeries.applyTimeDomainProcess(timeDomainProcess);
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        String string2 = "";
        if (this.channel != null) {
            string2 = string2 + this.channel.toString();
        }
        string2 = string2 + "iyear = " + this.iyear + string + "ijday = " + this.ijday + string + "ihour = " + this.ihour + string + "imin = " + this.imin + string + "sec = " + this.sec + string + "timeMin = " + this.timeMin + string + this.timeSeries.toString();
        string2 = string2 + "evtName = " + this.evtName + string;
        if (this.hypocenter != null) {
            string2 = string2 + this.hypocenter.toString();
        }
        string2 = string2 + "gcarc = " + this.gcarc + string + "dist = " + this.dist + string + "az = " + this.az + string + "baz = " + this.baz + string;
        return string2;
    }
}

